/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageHandler;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.BaseBusConnection;
import com.intellij.util.messages.impl.MessageBusImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J\u001a\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0012\u0010\u0012\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0016J \u0010\u0013\u001a\u00020\t\"\b\b\u0000\u0010\u0014*\u00020\u00112\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00140\u000fH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/util/messages/impl/MessageBusConnectionImpl;", "Lcom/intellij/util/messages/impl/BaseBusConnection;", "Lcom/intellij/util/messages/MessageBusConnection;", "bus", "Lcom/intellij/util/messages/impl/MessageBusImpl;", "(Lcom/intellij/util/messages/impl/MessageBusImpl;)V", "defaultHandler", "Lcom/intellij/util/messages/MessageHandler;", "deliverImmediately", "", "disconnect", "dispose", "isMyHandler", "", "topic", "Lcom/intellij/util/messages/Topic;", "handler", "", "setDefaultHandler", "subscribe", "L", "intellij.platform.core"})
@ApiStatus.Internal
public final class MessageBusConnectionImpl
extends BaseBusConnection
implements MessageBusConnection {
    @Nullable
    private MessageHandler defaultHandler;

    public MessageBusConnectionImpl(@NotNull MessageBusImpl bus) {
        Intrinsics.checkNotNullParameter(bus, "bus");
        super(bus, null);
    }

    @Override
    public <L> void subscribe(@NotNull Topic<L> topic) {
        Intrinsics.checkNotNullParameter(topic, "topic");
        MessageHandler messageHandler = this.defaultHandler;
        if (messageHandler == null) {
            throw new IllegalStateException("Connection must have default handler installed prior to any anonymous subscriptions. Target topic: " + topic);
        }
        MessageHandler defaultHandler = messageHandler;
        if (!(!topic.getListenerClass().isInstance(defaultHandler))) {
            boolean bl2 = false;
            String string2 = "Can't subscribe to the topic '" + topic + "'. Default handler has incompatible type - expected: '" + topic.getListenerClass() + "', actual: '" + defaultHandler.getClass() + '\'';
            throw new IllegalStateException(string2.toString());
        }
        this.subscribe(topic, (Object)defaultHandler);
    }

    @Override
    public void setDefaultHandler(@Nullable MessageHandler handler) {
        this.defaultHandler = handler;
    }

    @Override
    public void dispose() {
        MessageBusImpl messageBusImpl = this.bus;
        if (messageBusImpl == null) {
            return;
        }
        MessageBusImpl bus = messageBusImpl;
        this.bus = null;
        this.defaultHandler = null;
        Object[] objectArray = this.subscriptions.getAndSet(ArrayUtilRt.EMPTY_OBJECT_ARRAY);
        Intrinsics.checkNotNullExpressionValue(objectArray, "getAndSet(...)");
        bus.notifyConnectionTerminated$intellij_platform_core(objectArray);
    }

    @Override
    public void disconnect() {
        Disposer.dispose(this);
    }

    @Override
    public void deliverImmediately() {
        MessageBusImpl bus = this.bus;
        if (bus == null) {
            MessageBusImpl.LOG.error("Bus is already disposed");
        } else {
            bus.deliverImmediately$intellij_platform_core(this);
        }
    }

    public final boolean isMyHandler(@NotNull Topic<?> topic, @NotNull Object handler) {
        Intrinsics.checkNotNullParameter(topic, "topic");
        Intrinsics.checkNotNullParameter(handler, "handler");
        if (this.defaultHandler == handler) {
            return true;
        }
        Object[] topicAndHandlerPairs = (Object[])this.subscriptions.get();
        int n2 = topicAndHandlerPairs.length;
        for (int i2 = 0; i2 < n2; i2 += 2) {
            if (topic != topicAndHandlerPairs[i2] || handler != topicAndHandlerPairs[i2 + 1]) continue;
            return true;
        }
        return false;
    }
}

