/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.serialization.MutableAccessor;
import com.intellij.util.xmlb.DomAdapter;
import com.intellij.util.xmlb.JdomAdapter;
import com.intellij.util.xmlb.JsonDomKt;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.NestedBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.List;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JDOMElementBinding
implements MultiNodeBinding,
NestedBinding {
    private final String tagName;
    private final MutableAccessor accessor;

    JDOMElementBinding(@NotNull MutableAccessor accessor) {
        if (accessor == null) {
            JDOMElementBinding.$$$reportNull$$$0(0);
        }
        this.accessor = accessor;
        Tag tag = this.accessor.getAnnotation(Tag.class);
        String tagName = tag == null ? null : tag.value();
        this.tagName = tagName == null || tagName.isEmpty() ? this.accessor.getName() : tagName;
    }

    @Override
    @NotNull
    public JsonElement deserializeToJson(@NotNull Element element) {
        if (element == null) {
            JDOMElementBinding.$$$reportNull$$$0(1);
        }
        JsonElement jsonElement = JsonDomKt.jdomToJson(element);
        if (jsonElement == null) {
            JDOMElementBinding.$$$reportNull$$$0(2);
        }
        return jsonElement;
    }

    @Override
    @NotNull
    public MutableAccessor getAccessor() {
        MutableAccessor mutableAccessor = this.accessor;
        if (mutableAccessor == null) {
            JDOMElementBinding.$$$reportNull$$$0(3);
        }
        return mutableAccessor;
    }

    @Override
    @Nullable
    public JsonElement toJson(@NotNull Object bean, @Nullable SerializationFilter filter2) {
        Object value;
        if (bean == null) {
            JDOMElementBinding.$$$reportNull$$$0(4);
        }
        if ((value = this.accessor.read(bean)) == null) {
            return null;
        }
        if (value instanceof Element) {
            Element element = (Element)value;
            if (!element.getName().equals(this.tagName)) {
                element = ((Element)value).clone().setName(this.tagName);
            }
            return JsonDomKt.jdomToJson(element);
        }
        if (value instanceof Element[]) {
            Element[] elements = (Element[])value;
            if (elements.length == 0) {
                return null;
            }
            ArrayList<JsonElement> result2 = new ArrayList<JsonElement>();
            for (Element element : elements) {
                result2.add(JsonDomKt.jdomToJson(element.getName().equals(this.tagName) ? element : element.clone().setName(this.tagName)));
            }
            return new JsonArray(result2);
        }
        return null;
    }

    @Override
    public void setFromJson(@NotNull Object bean, @NotNull JsonElement element) {
        if (bean == null) {
            JDOMElementBinding.$$$reportNull$$$0(5);
        }
        if (element == null) {
            JDOMElementBinding.$$$reportNull$$$0(6);
        }
        if (element instanceof JsonObject) {
            this.accessor.set(bean, JsonDomKt.jsonDomToXml((JsonObject)element));
        } else if (element instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)element;
            ArrayList<Element> result2 = new ArrayList<Element>(jsonArray.getSize());
            for (JsonElement o2 : jsonArray) {
                result2.add(JsonDomKt.jsonDomToXml((JsonObject)o2));
            }
            this.accessor.set(bean, result2.toArray(new Element[0]));
        }
    }

    @Override
    public void serialize(@NotNull Object bean, @NotNull Element parent, @Nullable SerializationFilter filter2) {
        Object value;
        if (bean == null) {
            JDOMElementBinding.$$$reportNull$$$0(7);
        }
        if (parent == null) {
            JDOMElementBinding.$$$reportNull$$$0(8);
        }
        if ((value = this.accessor.read(bean)) == null) {
            return;
        }
        if (value instanceof Element) {
            parent.addContent(((Element)value).clone().setName(this.tagName));
        } else if (value instanceof Element[]) {
            Element[] elements = (Element[])value;
            if (elements.length != 0) {
                ArrayList<Element> result2 = new ArrayList<Element>(elements.length);
                for (Element element : elements) {
                    result2.add(element.clone().setName(this.tagName));
                }
                parent.addContent(result2);
            }
        } else {
            throw new XmlSerializationException("org.jdom.Element expected but " + value + " found");
        }
    }

    @Override
    public boolean isSurroundWithTag() {
        return false;
    }

    @Override
    @NotNull
    public <T> Object deserializeList(@Nullable Object currentValue, @NotNull List<? extends T> elements, @NotNull DomAdapter<T> adapter) {
        if (elements == null) {
            JDOMElementBinding.$$$reportNull$$$0(9);
        }
        if (adapter == null) {
            JDOMElementBinding.$$$reportNull$$$0(10);
        }
        assert (currentValue != null);
        if (adapter != JdomAdapter.INSTANCE) {
            throw new UnsupportedOperationException("XmlElement is not supported by JDOMElementBinding");
        }
        if (this.accessor.getValueClass().isArray()) {
            this.accessor.set(currentValue, elements.toArray(new Element[0]));
        } else {
            this.accessor.set(currentValue, elements.get(0));
        }
        Object object = currentValue;
        if (object == null) {
            JDOMElementBinding.$$$reportNull$$$0(11);
        }
        return object;
    }

    @Override
    @NotNull
    public JsonElement doDeserializeListToJson(@NotNull List<? extends Element> elements) {
        if (elements == null) {
            JDOMElementBinding.$$$reportNull$$$0(12);
        }
        ArrayList<JsonElement> result2 = new ArrayList<JsonElement>(elements.size());
        for (Element element : elements) {
            result2.add(JsonDomKt.jdomToJson(element));
        }
        return new JsonArray(result2);
    }

    @Override
    public boolean isMulti() {
        return this.accessor.getValueClass().isArray();
    }

    @Override
    @NotNull
    public <T> Object deserialize(@Nullable Object context2, @NotNull T element, @NotNull DomAdapter<T> adapter) {
        if (element == null) {
            JDOMElementBinding.$$$reportNull$$$0(13);
        }
        if (adapter == null) {
            JDOMElementBinding.$$$reportNull$$$0(14);
        }
        assert (context2 != null);
        this.accessor.set(context2, element);
        Object object = context2;
        if (object == null) {
            JDOMElementBinding.$$$reportNull$$$0(15);
        }
        return object;
    }

    @Override
    public <T> boolean isBoundTo(@NotNull T element, @NotNull DomAdapter<T> adapter) {
        if (element == null) {
            JDOMElementBinding.$$$reportNull$$$0(16);
        }
        if (adapter == null) {
            JDOMElementBinding.$$$reportNull$$$0(17);
        }
        return adapter.getName(element).equals(this.tagName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 15: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 15: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 1: 
            case 6: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xmlb/JDOMElementBinding";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 10: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapter";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xmlb/JDOMElementBinding";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeToJson";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeList";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "deserializeToJson";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 15: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toJson";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setFromJson";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deserializeList";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doDeserializeListToJson";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isBoundTo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 15: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

