/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM.tlb.imp;

import com.sun.jna.platform.win32.COM.ITypeInfo;
import com.sun.jna.platform.win32.COM.TypeInfoUtil;
import com.sun.jna.platform.win32.COM.TypeLibUtil;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbAbstractMethod;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbBase;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbFunctionDispId;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbFunctionVTable;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbPropertyGet;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbPropertyPut;
import com.sun.jna.platform.win32.OaIdl;

public class TlbCoClass
extends TlbBase {
    public TlbCoClass(int index2, String packagename, TypeLibUtil typeLibUtil, String bindingMode) {
        super(index2, typeLibUtil, null);
        TypeInfoUtil typeInfoUtil = typeLibUtil.getTypeInfoUtil(index2);
        TypeLibUtil.TypeLibDoc typeLibDoc = this.typeLibUtil.getDocumentation(index2);
        String docString = typeLibDoc.getDocString();
        if (typeLibDoc.getName().length() > 0) {
            this.name = typeLibDoc.getName();
        }
        this.logInfo("Type of kind 'CoClass' found: " + this.name);
        this.createPackageName(packagename);
        this.createClassName(this.name);
        this.setFilename(this.name);
        String guidStr = this.typeLibUtil.getLibAttr().guid.toGuidString();
        int majorVerNum = this.typeLibUtil.getLibAttr().wMajorVerNum.intValue();
        int minorVerNum = this.typeLibUtil.getLibAttr().wMinorVerNum.intValue();
        String version = majorVerNum + "." + minorVerNum;
        String clsid = typeInfoUtil.getTypeAttr().guid.toGuidString();
        this.createJavaDocHeader(guidStr, version, docString);
        this.createCLSID(clsid);
        this.createCLSIDName(this.name);
        OaIdl.TYPEATTR typeAttr = typeInfoUtil.getTypeAttr();
        int cImplTypes = typeAttr.cImplTypes.intValue();
        String interfaces2 = "";
        for (int i2 = 0; i2 < cImplTypes; ++i2) {
            OaIdl.HREFTYPE refTypeOfImplType = typeInfoUtil.getRefTypeOfImplType(i2);
            ITypeInfo refTypeInfo = typeInfoUtil.getRefTypeInfo(refTypeOfImplType);
            TypeInfoUtil refTypeInfoUtil = new TypeInfoUtil(refTypeInfo);
            this.createFunctions(refTypeInfoUtil, bindingMode);
            TypeInfoUtil.TypeInfoDoc documentation = refTypeInfoUtil.getDocumentation(new OaIdl.MEMBERID(-1));
            interfaces2 = interfaces2 + documentation.getName();
            if (i2 >= cImplTypes - 1) continue;
            interfaces2 = interfaces2 + ", ";
        }
        this.createInterfaces(interfaces2);
        this.createContent(this.content);
    }

    protected void createFunctions(TypeInfoUtil typeInfoUtil, String bindingMode) {
        OaIdl.TYPEATTR typeAttr = typeInfoUtil.getTypeAttr();
        int cFuncs = typeAttr.cFuncs.intValue();
        for (int i2 = 0; i2 < cFuncs; ++i2) {
            OaIdl.FUNCDESC funcDesc = typeInfoUtil.getFuncDesc(i2);
            TlbAbstractMethod method = null;
            if (funcDesc.invkind.value == OaIdl.INVOKEKIND.INVOKE_FUNC.value) {
                method = this.isVTableMode() ? new TlbFunctionVTable(i2, this.index, this.typeLibUtil, funcDesc, typeInfoUtil) : new TlbFunctionDispId(i2, this.index, this.typeLibUtil, funcDesc, typeInfoUtil);
            } else if (funcDesc.invkind.value == OaIdl.INVOKEKIND.INVOKE_PROPERTYGET.value) {
                method = new TlbPropertyGet(i2, this.index, this.typeLibUtil, funcDesc, typeInfoUtil);
            } else if (funcDesc.invkind.value == OaIdl.INVOKEKIND.INVOKE_PROPERTYPUT.value) {
                method = new TlbPropertyPut(i2, this.index, this.typeLibUtil, funcDesc, typeInfoUtil);
            } else if (funcDesc.invkind.value == OaIdl.INVOKEKIND.INVOKE_PROPERTYPUTREF.value) {
                method = new TlbPropertyPut(i2, this.index, this.typeLibUtil, funcDesc, typeInfoUtil);
            }
            if (!this.isReservedMethod(method.getMethodName())) {
                this.content = this.content + method.getClassBuffer();
                if (i2 < cFuncs - 1) {
                    this.content = this.content + "\n";
                }
            }
            typeInfoUtil.ReleaseFuncDesc(funcDesc);
        }
    }

    protected void createJavaDocHeader(String guid, String version, String helpstring) {
        this.replaceVariable("uuid", guid);
        this.replaceVariable("version", version);
        this.replaceVariable("helpstring", helpstring);
    }

    protected void createCLSIDName(String clsidName) {
        this.replaceVariable("clsidname", clsidName.toUpperCase());
    }

    protected void createCLSID(String clsid) {
        this.replaceVariable("clsid", clsid);
    }

    protected void createInterfaces(String interfaces2) {
        this.replaceVariable("interfaces", interfaces2);
    }

    @Override
    protected String getClassTemplate() {
        return "com/sun/jna/platform/win32/COM/tlb/imp/TlbCoClass.template";
    }
}

