/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.reflect;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.istack.SAXException2;
import com.sun.xml.bind.WhiteSpaceProcessor;
import com.sun.xml.bind.api.AccessorException;
import com.sun.xml.bind.v2.model.core.ID;
import com.sun.xml.bind.v2.model.impl.RuntimeModelBuilder;
import com.sun.xml.bind.v2.model.runtime.RuntimeNonElementRef;
import com.sun.xml.bind.v2.model.runtime.RuntimePropertyInfo;
import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.bind.v2.runtime.Name;
import com.sun.xml.bind.v2.runtime.Transducer;
import com.sun.xml.bind.v2.runtime.XMLSerializer;
import com.sun.xml.bind.v2.runtime.reflect.Accessor;
import com.sun.xml.bind.v2.runtime.reflect.DefaultTransducedAccessor;
import com.sun.xml.bind.v2.runtime.reflect.ListTransducedAccessorImpl;
import com.sun.xml.bind.v2.runtime.reflect.Lister;
import com.sun.xml.bind.v2.runtime.reflect.Messages;
import com.sun.xml.bind.v2.runtime.reflect.Utils;
import com.sun.xml.bind.v2.runtime.unmarshaller.LocatorEx;
import com.sun.xml.bind.v2.runtime.unmarshaller.Patcher;
import com.sun.xml.bind.v2.runtime.unmarshaller.UnmarshallingContext;
import java.io.IOException;
import java.util.concurrent.Callable;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

public abstract class TransducedAccessor<BeanT> {
    public boolean useNamespace() {
        return false;
    }

    public void declareNamespace(BeanT o2, XMLSerializer w2) throws AccessorException, SAXException {
    }

    @Nullable
    public abstract CharSequence print(@NotNull BeanT var1) throws AccessorException, SAXException;

    public abstract void parse(BeanT var1, CharSequence var2) throws AccessorException, SAXException;

    public abstract boolean hasValue(BeanT var1) throws AccessorException;

    public static <T> TransducedAccessor<T> get(JAXBContextImpl context2, RuntimeNonElementRef ref) {
        Transducer xducer = RuntimeModelBuilder.createTransducer(ref);
        RuntimePropertyInfo prop = ref.getSource();
        if (prop.isCollection()) {
            return new ListTransducedAccessorImpl(xducer, prop.getAccessor(), Lister.create(Utils.REFLECTION_NAVIGATOR.erasure(prop.getRawType()), prop.id(), prop.getAdapter()));
        }
        if (prop.id() == ID.IDREF) {
            return new IDREFTransducedAccessorImpl(prop.getAccessor());
        }
        if (xducer.useNamespace()) {
            return new CompositeContextDependentTransducedAccessorImpl(context2, xducer, prop.getAccessor());
        }
        return new CompositeTransducedAccessorImpl(context2, xducer, prop.getAccessor());
    }

    public abstract void writeLeafElement(XMLSerializer var1, Name var2, BeanT var3, String var4) throws SAXException, AccessorException, IOException, XMLStreamException;

    public abstract void writeText(XMLSerializer var1, BeanT var2, String var3) throws AccessorException, SAXException, IOException, XMLStreamException;

    private static final class IDREFTransducedAccessorImpl<BeanT, TargetT>
    extends DefaultTransducedAccessor<BeanT> {
        private final Accessor<BeanT, TargetT> acc;
        private final Class<TargetT> targetType;

        public IDREFTransducedAccessorImpl(Accessor<BeanT, TargetT> acc) {
            this.acc = acc;
            this.targetType = acc.getValueType();
        }

        @Override
        public String print(BeanT bean) throws AccessorException, SAXException {
            TargetT target = this.acc.get(bean);
            if (target == null) {
                return null;
            }
            XMLSerializer w2 = XMLSerializer.getInstance();
            try {
                String id2 = w2.grammar.getBeanInfo(target, true).getId(target, w2);
                if (id2 == null) {
                    w2.errorMissingId(target);
                }
                return id2;
            }
            catch (JAXBException e2) {
                w2.reportError(null, e2);
                return null;
            }
        }

        private void assign(BeanT bean, TargetT t2, UnmarshallingContext context2) throws AccessorException {
            if (!this.targetType.isInstance(t2)) {
                context2.handleError(Messages.UNASSIGNABLE_TYPE.format(this.targetType, t2.getClass()));
            } else {
                this.acc.set(bean, t2);
            }
        }

        @Override
        public void parse(final BeanT bean, CharSequence lexical) throws AccessorException, SAXException {
            Object t2;
            final String idref = WhiteSpaceProcessor.trim(lexical).toString();
            final UnmarshallingContext context2 = UnmarshallingContext.getInstance();
            final Callable callable = context2.getObjectFromId(idref, this.acc.valueType);
            if (callable == null) {
                context2.errorUnresolvedIDREF(bean, idref, context2.getLocator());
                return;
            }
            try {
                t2 = callable.call();
            }
            catch (SAXException e2) {
                throw e2;
            }
            catch (RuntimeException e3) {
                throw e3;
            }
            catch (Exception e4) {
                throw new SAXException2(e4);
            }
            if (t2 != null) {
                this.assign(bean, t2, context2);
            } else {
                final LocatorEx.Snapshot loc = new LocatorEx.Snapshot(context2.getLocator());
                context2.addPatcher(new Patcher(){

                    @Override
                    public void run() throws SAXException {
                        try {
                            Object t2 = callable.call();
                            if (t2 == null) {
                                context2.errorUnresolvedIDREF(bean, idref, loc);
                            } else {
                                IDREFTransducedAccessorImpl.this.assign(bean, t2, context2);
                            }
                        }
                        catch (AccessorException e2) {
                            context2.handleError(e2);
                        }
                        catch (SAXException e3) {
                            throw e3;
                        }
                        catch (RuntimeException e4) {
                            throw e4;
                        }
                        catch (Exception e5) {
                            throw new SAXException2(e5);
                        }
                    }
                });
            }
        }

        @Override
        public boolean hasValue(BeanT bean) throws AccessorException {
            return this.acc.get(bean) != null;
        }
    }

    public static class CompositeTransducedAccessorImpl<BeanT, ValueT>
    extends TransducedAccessor<BeanT> {
        protected final Transducer<ValueT> xducer;
        protected final Accessor<BeanT, ValueT> acc;

        public CompositeTransducedAccessorImpl(JAXBContextImpl context2, Transducer<ValueT> xducer, Accessor<BeanT, ValueT> acc) {
            this.xducer = xducer;
            this.acc = acc.optimize(context2);
        }

        @Override
        public CharSequence print(BeanT bean) throws AccessorException {
            ValueT o2 = this.acc.get(bean);
            if (o2 == null) {
                return null;
            }
            return this.xducer.print(o2);
        }

        @Override
        public void parse(BeanT bean, CharSequence lexical) throws AccessorException, SAXException {
            this.acc.set(bean, this.xducer.parse(lexical));
        }

        @Override
        public boolean hasValue(BeanT bean) throws AccessorException {
            return this.acc.getUnadapted(bean) != null;
        }

        @Override
        public void writeLeafElement(XMLSerializer w2, Name tagName, BeanT o2, String fieldName) throws SAXException, AccessorException, IOException, XMLStreamException {
            this.xducer.writeLeafElement(w2, tagName, this.acc.get(o2), fieldName);
        }

        @Override
        public void writeText(XMLSerializer w2, BeanT o2, String fieldName) throws AccessorException, SAXException, IOException, XMLStreamException {
            this.xducer.writeText(w2, this.acc.get(o2), fieldName);
        }
    }

    static class CompositeContextDependentTransducedAccessorImpl<BeanT, ValueT>
    extends CompositeTransducedAccessorImpl<BeanT, ValueT> {
        public CompositeContextDependentTransducedAccessorImpl(JAXBContextImpl context2, Transducer<ValueT> xducer, Accessor<BeanT, ValueT> acc) {
            super(context2, xducer, acc);
            assert (xducer.useNamespace());
        }

        @Override
        public boolean useNamespace() {
            return true;
        }

        @Override
        public void declareNamespace(BeanT bean, XMLSerializer w2) throws AccessorException {
            Object o2 = this.acc.get(bean);
            if (o2 != null) {
                this.xducer.declareNamespace(o2, w2);
            }
        }

        @Override
        public void writeLeafElement(XMLSerializer w2, Name tagName, BeanT o2, String fieldName) throws SAXException, AccessorException, IOException, XMLStreamException {
            w2.startElement(tagName, null);
            this.declareNamespace(o2, w2);
            w2.endNamespaceDecls(null);
            w2.endAttributes();
            this.xducer.writeText(w2, this.acc.get(o2), fieldName);
            w2.endElement();
        }
    }
}

