/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.unmarshaller;

import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.bind.v2.runtime.unmarshaller.Loader;
import com.sun.xml.bind.v2.runtime.unmarshaller.TagName;
import com.sun.xml.bind.v2.runtime.unmarshaller.UnmarshallingContext;
import javax.xml.bind.annotation.DomHandler;
import javax.xml.transform.Result;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.SAXException;

public class DomLoader<ResultT extends Result>
extends Loader {
    private final DomHandler<?, ResultT> dom;

    public DomLoader(DomHandler<?, ResultT> dom) {
        super(true);
        this.dom = dom;
    }

    @Override
    public void startElement(UnmarshallingContext.State state, TagName ea) throws SAXException {
        UnmarshallingContext context2 = state.getContext();
        if (state.getTarget() == null) {
            state.setTarget(new State(context2));
        }
        State s2 = (State)state.getTarget();
        try {
            s2.declarePrefixes(context2, context2.getNewlyDeclaredPrefixes());
            s2.handler.startElement(ea.uri, ea.local, ea.getQname(), ea.atts);
        }
        catch (SAXException e2) {
            context2.handleError(e2);
            throw e2;
        }
    }

    @Override
    public void childElement(UnmarshallingContext.State state, TagName ea) throws SAXException {
        state.setLoader(this);
        State s2 = (State)state.getPrev().getTarget();
        ++s2.depth;
        state.setTarget(s2);
    }

    @Override
    public void text(UnmarshallingContext.State state, CharSequence text) throws SAXException {
        if (text.length() == 0) {
            return;
        }
        try {
            State s2 = (State)state.getTarget();
            s2.handler.characters(text.toString().toCharArray(), 0, text.length());
        }
        catch (SAXException e2) {
            state.getContext().handleError(e2);
            throw e2;
        }
    }

    @Override
    public void leaveElement(UnmarshallingContext.State state, TagName ea) throws SAXException {
        State s2 = (State)state.getTarget();
        UnmarshallingContext context2 = state.getContext();
        try {
            s2.handler.endElement(ea.uri, ea.local, ea.getQname());
            s2.undeclarePrefixes(context2.getNewlyDeclaredPrefixes());
        }
        catch (SAXException e2) {
            context2.handleError(e2);
            throw e2;
        }
        if (--s2.depth == 0) {
            try {
                s2.undeclarePrefixes(context2.getAllDeclaredPrefixes());
                s2.handler.endDocument();
            }
            catch (SAXException e3) {
                context2.handleError(e3);
                throw e3;
            }
            state.setTarget(s2.getElement());
        }
    }

    private final class State {
        private TransformerHandler handler = null;
        private final ResultT result;
        int depth = 1;

        public State(UnmarshallingContext context2) throws SAXException {
            this.handler = JAXBContextImpl.createTransformerHandler(context2.getJAXBContext().disableSecurityProcessing);
            this.result = DomLoader.this.dom.createUnmarshaller(context2);
            this.handler.setResult((Result)this.result);
            try {
                this.handler.setDocumentLocator(context2.getLocator());
                this.handler.startDocument();
                this.declarePrefixes(context2, context2.getAllDeclaredPrefixes());
            }
            catch (SAXException e2) {
                context2.handleError(e2);
                throw e2;
            }
        }

        public Object getElement() {
            return DomLoader.this.dom.getElement(this.result);
        }

        private void declarePrefixes(UnmarshallingContext context2, String[] prefixes) throws SAXException {
            for (int i2 = prefixes.length - 1; i2 >= 0; --i2) {
                String nsUri = context2.getNamespaceURI(prefixes[i2]);
                if (nsUri == null) {
                    throw new IllegalStateException("prefix '" + prefixes[i2] + "' isn't bound");
                }
                this.handler.startPrefixMapping(prefixes[i2], nsUri);
            }
        }

        private void undeclarePrefixes(String[] prefixes) throws SAXException {
            for (int i2 = prefixes.length - 1; i2 >= 0; --i2) {
                this.handler.endPrefixMapping(prefixes[i2]);
            }
        }
    }
}

