/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.algorithm;

import com.sun.xml.fastinfoset.CommonResourceBundle;
import com.sun.xml.fastinfoset.algorithm.BuiltInEncodingAlgorithm;
import com.sun.xml.fastinfoset.algorithm.IEEE754FloatingPointEncodingAlgorithm;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jvnet.fastinfoset.EncodingAlgorithmException;

public class FloatEncodingAlgorithm
extends IEEE754FloatingPointEncodingAlgorithm {
    @Override
    public final int getPrimtiveLengthFromOctetLength(int octetLength) throws EncodingAlgorithmException {
        if (octetLength % 4 != 0) {
            throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.lengthNotMultipleOfFloat", new Object[]{4}));
        }
        return octetLength / 4;
    }

    @Override
    public int getOctetLengthFromPrimitiveLength(int primitiveLength) {
        return primitiveLength * 4;
    }

    @Override
    public final Object decodeFromBytes(byte[] b2, int start, int length) throws EncodingAlgorithmException {
        float[] data = new float[this.getPrimtiveLengthFromOctetLength(length)];
        this.decodeFromBytesToFloatArray(data, 0, b2, start, length);
        return data;
    }

    @Override
    public final Object decodeFromInputStream(InputStream s2) throws IOException {
        return this.decodeFromInputStreamToFloatArray(s2);
    }

    @Override
    public void encodeToOutputStream(Object data, OutputStream s2) throws IOException {
        if (!(data instanceof float[])) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.dataNotFloat"));
        }
        float[] fdata = (float[])data;
        this.encodeToOutputStreamFromFloatArray(fdata, s2);
    }

    @Override
    public final Object convertFromCharacters(char[] ch, int start, int length) {
        final CharBuffer cb = CharBuffer.wrap(ch, start, length);
        final ArrayList floatList = new ArrayList();
        this.matchWhiteSpaceDelimnatedWords(cb, new BuiltInEncodingAlgorithm.WordListener(){

            @Override
            public void word(int start, int end) {
                String fStringValue = cb.subSequence(start, end).toString();
                floatList.add(Float.valueOf(fStringValue));
            }
        });
        return this.generateArrayFromList(floatList);
    }

    @Override
    public final void convertToCharacters(Object data, StringBuffer s2) {
        if (!(data instanceof float[])) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.dataNotFloat"));
        }
        float[] fdata = (float[])data;
        this.convertToCharactersFromFloatArray(fdata, s2);
    }

    public final void decodeFromBytesToFloatArray(float[] data, int fstart, byte[] b2, int start, int length) {
        int size = length / 4;
        for (int i2 = 0; i2 < size; ++i2) {
            int bits = (b2[start++] & 0xFF) << 24 | (b2[start++] & 0xFF) << 16 | (b2[start++] & 0xFF) << 8 | b2[start++] & 0xFF;
            data[fstart++] = Float.intBitsToFloat(bits);
        }
    }

    public final float[] decodeFromInputStreamToFloatArray(InputStream s2) throws IOException {
        ArrayList<Float> floatList = new ArrayList<Float>();
        byte[] b2 = new byte[4];
        while (true) {
            int n2;
            if ((n2 = s2.read(b2)) != 4) {
                if (n2 == -1) break;
                while (n2 != 4) {
                    int m4 = s2.read(b2, n2, 4 - n2);
                    if (m4 == -1) {
                        throw new EOFException();
                    }
                    n2 += m4;
                }
            }
            int bits = (b2[0] & 0xFF) << 24 | (b2[1] & 0xFF) << 16 | (b2[2] & 0xFF) << 8 | b2[3] & 0xFF;
            floatList.add(Float.valueOf(Float.intBitsToFloat(bits)));
        }
        return this.generateArrayFromList(floatList);
    }

    public final void encodeToOutputStreamFromFloatArray(float[] fdata, OutputStream s2) throws IOException {
        for (int i2 = 0; i2 < fdata.length; ++i2) {
            int bits = Float.floatToIntBits(fdata[i2]);
            s2.write(bits >>> 24 & 0xFF);
            s2.write(bits >>> 16 & 0xFF);
            s2.write(bits >>> 8 & 0xFF);
            s2.write(bits & 0xFF);
        }
    }

    @Override
    public final void encodeToBytes(Object array2, int astart, int alength, byte[] b2, int start) {
        this.encodeToBytesFromFloatArray((float[])array2, astart, alength, b2, start);
    }

    public final void encodeToBytesFromFloatArray(float[] fdata, int fstart, int flength, byte[] b2, int start) {
        int fend = fstart + flength;
        for (int i2 = fstart; i2 < fend; ++i2) {
            int bits = Float.floatToIntBits(fdata[i2]);
            b2[start++] = (byte)(bits >>> 24 & 0xFF);
            b2[start++] = (byte)(bits >>> 16 & 0xFF);
            b2[start++] = (byte)(bits >>> 8 & 0xFF);
            b2[start++] = (byte)(bits & 0xFF);
        }
    }

    public final void convertToCharactersFromFloatArray(float[] fdata, StringBuffer s2) {
        int end = fdata.length - 1;
        for (int i2 = 0; i2 <= end; ++i2) {
            s2.append(Float.toString(fdata[i2]));
            if (i2 == end) continue;
            s2.append(' ');
        }
    }

    public final float[] generateArrayFromList(List array2) {
        float[] fdata = new float[array2.size()];
        for (int i2 = 0; i2 < fdata.length; ++i2) {
            fdata[i2] = ((Float)array2.get(i2)).floatValue();
        }
        return fdata;
    }
}

