/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.stax.factory;

import com.sun.xml.fastinfoset.CommonResourceBundle;
import com.sun.xml.fastinfoset.stax.StAXDocumentSerializer;
import com.sun.xml.fastinfoset.stax.StAXManager;
import com.sun.xml.fastinfoset.stax.events.StAXEventWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;

public class StAXOutputFactory
extends XMLOutputFactory {
    private StAXManager _manager = new StAXManager(2);

    @Override
    public XMLEventWriter createXMLEventWriter(Result result2) throws XMLStreamException {
        return new StAXEventWriter(this.createXMLStreamWriter(result2));
    }

    @Override
    public XMLEventWriter createXMLEventWriter(Writer writer) throws XMLStreamException {
        return new StAXEventWriter(this.createXMLStreamWriter(writer));
    }

    @Override
    public XMLEventWriter createXMLEventWriter(OutputStream outputStream) throws XMLStreamException {
        return new StAXEventWriter(this.createXMLStreamWriter(outputStream));
    }

    @Override
    public XMLEventWriter createXMLEventWriter(OutputStream outputStream, String encoding) throws XMLStreamException {
        return new StAXEventWriter(this.createXMLStreamWriter(outputStream, encoding));
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(Result result2) throws XMLStreamException {
        if (result2 instanceof StreamResult) {
            StreamResult streamResult = (StreamResult)result2;
            if (streamResult.getWriter() != null) {
                return this.createXMLStreamWriter(streamResult.getWriter());
            }
            if (streamResult.getOutputStream() != null) {
                return this.createXMLStreamWriter(streamResult.getOutputStream());
            }
            if (streamResult.getSystemId() != null) {
                FileWriter writer = null;
                boolean isError = true;
                try {
                    writer = new FileWriter(new File(streamResult.getSystemId()));
                    XMLStreamWriter streamWriter = this.createXMLStreamWriter(writer);
                    isError = false;
                    XMLStreamWriter xMLStreamWriter = streamWriter;
                    return xMLStreamWriter;
                }
                catch (IOException ie) {
                    throw new XMLStreamException(ie);
                }
                finally {
                    if (isError && writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        } else {
            FileWriter writer = null;
            boolean isError = true;
            try {
                writer = new FileWriter(new File(result2.getSystemId()));
                XMLStreamWriter streamWriter = this.createXMLStreamWriter(writer);
                isError = false;
                XMLStreamWriter xMLStreamWriter = streamWriter;
                return xMLStreamWriter;
            }
            catch (IOException ie) {
                throw new XMLStreamException(ie);
            }
            finally {
                if (isError && writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(Writer writer) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream) throws XMLStreamException {
        return new StAXDocumentSerializer(outputStream, new StAXManager(this._manager));
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream, String encoding) throws XMLStreamException {
        StAXDocumentSerializer serializer2 = new StAXDocumentSerializer(outputStream, new StAXManager(this._manager));
        serializer2.setEncoding(encoding);
        return serializer2;
    }

    @Override
    public Object getProperty(String name2) throws IllegalArgumentException {
        if (name2 == null) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.propertyNotSupported", new Object[]{null}));
        }
        if (this._manager.containsProperty(name2)) {
            return this._manager.getProperty(name2);
        }
        throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.propertyNotSupported", new Object[]{name2}));
    }

    @Override
    public boolean isPropertySupported(String name2) {
        if (name2 == null) {
            return false;
        }
        return this._manager.containsProperty(name2);
    }

    @Override
    public void setProperty(String name2, Object value) throws IllegalArgumentException {
        this._manager.setProperty(name2, value);
    }
}

