/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.TFloatHashingStrategy;
import gnu.trove.TFloatProcedure;
import gnu.trove.TPrimitiveHash;

public abstract class TFloatHash
extends TPrimitiveHash
implements TFloatHashingStrategy {
    protected transient float[] _set;
    protected final TFloatHashingStrategy _hashingStrategy;

    public TFloatHash() {
        this._hashingStrategy = this;
    }

    public TFloatHash(int initialCapacity) {
        super(initialCapacity);
        this._hashingStrategy = this;
    }

    public TFloatHash(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = this;
    }

    public TFloatHash(TFloatHashingStrategy strategy) {
        this._hashingStrategy = strategy;
    }

    public TFloatHash(int initialCapacity, TFloatHashingStrategy strategy) {
        super(initialCapacity);
        this._hashingStrategy = strategy;
    }

    public TFloatHash(int initialCapacity, float loadFactor, TFloatHashingStrategy strategy) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = strategy;
    }

    public Object clone() {
        TFloatHash h2 = (TFloatHash)super.clone();
        h2._set = this._set == null ? null : (float[])this._set.clone();
        return h2;
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = initialCapacity == -1 ? null : new float[capacity];
        return capacity;
    }

    public boolean contains(float val) {
        return this.index(val) >= 0;
    }

    public boolean forEach(TFloatProcedure procedure) {
        byte[] states = this._states;
        float[] set = this._set;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || procedure.execute(set[i2])) continue;
                return false;
            }
        }
        return true;
    }

    protected void removeAt(int index2) {
        this._set[index2] = 0.0f;
        super.removeAt(index2);
    }

    protected int index(float val) {
        byte[] states = this._states;
        if (states == null) {
            return -1;
        }
        float[] set = this._set;
        int length = states.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index2 = hash % length;
        if (states[index2] != 0 && (states[index2] == 2 || set[index2] != val)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index2 -= probe) >= 0) continue;
                index2 += length;
            } while (states[index2] != 0 && (states[index2] == 2 || set[index2] != val));
        }
        return states[index2] == 0 ? -1 : index2;
    }

    protected int insertionIndex(float val) {
        if (this._set == null) {
            this.setUp(6);
        }
        byte[] states = this._states;
        float[] set = this._set;
        int length = states.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index2 = hash % length;
        if (states[index2] == 0) {
            return index2;
        }
        if (states[index2] == 1 && set[index2] == val) {
            return -index2 - 1;
        }
        int probe = 1 + hash % (length - 2);
        do {
            if ((index2 -= probe) >= 0) continue;
            index2 += length;
        } while (states[index2] == 1 && set[index2] != val);
        if (states[index2] == 2) {
            int firstRemoved = index2;
            while (states[index2] != 0 && (states[index2] == 2 || set[index2] != val)) {
                if ((index2 -= probe) >= 0) continue;
                index2 += length;
            }
            return states[index2] == 1 ? -index2 - 1 : firstRemoved;
        }
        return states[index2] == 1 ? -index2 - 1 : index2;
    }

    public final int computeHashCode(float val) {
        return HashFunctions.hash(val);
    }
}

