/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TFloatHash;
import gnu.trove.TFloatHashingStrategy;
import gnu.trove.TFloatIntIterator;
import gnu.trove.TFloatIntProcedure;
import gnu.trove.TFloatProcedure;
import gnu.trove.TIntFunction;
import gnu.trove.TIntProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TFloatIntHashMap
extends TFloatHash {
    protected transient int[] _values;

    public TFloatIntHashMap() {
    }

    public TFloatIntHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TFloatIntHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TFloatIntHashMap(TFloatHashingStrategy strategy) {
        super(strategy);
    }

    public TFloatIntHashMap(int initialCapacity, TFloatHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TFloatIntHashMap(int initialCapacity, float loadFactor, TFloatHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public Object clone() {
        TFloatIntHashMap m4 = (TFloatIntHashMap)super.clone();
        m4._values = this._values == null ? null : (int[])this._values.clone();
        return m4;
    }

    public TFloatIntIterator iterator() {
        return new TFloatIntIterator(this);
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = initialCapacity == -1 ? null : new int[capacity];
        return capacity;
    }

    public int put(float key, int value) {
        int previous = 0;
        int index2 = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index2 < 0) {
            index2 = -index2 - 1;
            previous = this._values[index2];
            isNewMapping = false;
        }
        byte previousState = this._states[index2];
        this._set[index2] = key;
        this._states[index2] = 1;
        this._values[index2] = value;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return previous;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        float[] oldKeys = this._set;
        int[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new float[newCapacity];
        this._values = new int[newCapacity];
        this._states = new byte[newCapacity];
        int i2 = oldCapacity;
        while (i2-- > 0) {
            if (oldStates[i2] != 1) continue;
            float o2 = oldKeys[i2];
            int index2 = this.insertionIndex(o2);
            this._set[index2] = o2;
            this._values[index2] = oldVals[i2];
            this._states[index2] = 1;
        }
    }

    public int get(float key) {
        int index2 = this.index(key);
        return index2 < 0 ? 0 : this._values[index2];
    }

    public void clear() {
        super.clear();
        float[] keys2 = this._set;
        int[] vals = this._values;
        if (vals == null) {
            return;
        }
        byte[] states = this._states;
        int i2 = keys2.length;
        while (i2-- > 0) {
            keys2[i2] = 0.0f;
            vals[i2] = 0;
            states[i2] = 0;
        }
    }

    public int remove(float key) {
        int prev = 0;
        int index2 = this.index(key);
        if (index2 >= 0) {
            prev = this._values[index2];
            this.removeAt(index2);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TFloatIntHashMap)) {
            return false;
        }
        TFloatIntHashMap that = (TFloatIntHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p2 = new HashProcedure();
        this.forEachEntry(p2);
        return p2.getHashCode();
    }

    protected void removeAt(int index2) {
        this._values[index2] = 0;
        super.removeAt(index2);
    }

    public int[] getValues() {
        int[] vals = new int[this.size()];
        int[] v2 = this._values;
        byte[] states = this._states;
        if (states != null) {
            int i2 = states.length;
            int j2 = 0;
            while (i2-- > 0) {
                if (states[i2] != 1) continue;
                vals[j2++] = v2[i2];
            }
        }
        return vals;
    }

    public float[] keys() {
        float[] keys2 = new float[this.size()];
        float[] k2 = this._set;
        byte[] states = this._states;
        if (states != null) {
            int i2 = states.length;
            int j2 = 0;
            while (i2-- > 0) {
                if (states[i2] != 1) continue;
                keys2[j2++] = k2[i2];
            }
        }
        return keys2;
    }

    public boolean containsValue(int val) {
        byte[] states = this._states;
        int[] vals = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || val != vals[i2]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(float key) {
        return this.contains(key);
    }

    public boolean forEachKey(TFloatProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TIntProcedure procedure) {
        byte[] states = this._states;
        int[] values2 = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || procedure.execute(values2[i2])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean forEachEntry(TFloatIntProcedure procedure) {
        byte[] states = this._states;
        float[] keys2 = this._set;
        int[] values2 = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || procedure.execute(keys2[i2], values2[i2])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean retainEntries(TFloatIntProcedure procedure) {
        boolean modified = false;
        byte[] states = this._states;
        float[] keys2 = this._set;
        int[] values2 = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || procedure.execute(keys2[i2], values2[i2])) continue;
                this.removeAt(i2);
                modified = true;
            }
        }
        return modified;
    }

    public void transformValues(TIntFunction function) {
        byte[] states = this._states;
        int[] values2 = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1) continue;
                values2[i2] = function.execute(values2[i2]);
            }
        }
    }

    public boolean increment(float key) {
        return this.adjustValue(key, 1);
    }

    public boolean adjustValue(float key, int amount) {
        int index2 = this.index(key);
        if (index2 < 0) {
            return false;
        }
        int n2 = index2;
        this._values[n2] = this._values[n2] + amount;
        return true;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            float key = stream.readFloat();
            int val = stream.readInt();
            this.put(key, val);
        }
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEachEntry(new TFloatIntProcedure(){

            public boolean execute(float key, int value) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(key);
                sb.append('=');
                sb.append(value);
                return true;
            }
        });
        sb.append('}');
        sb.insert(0, '{');
        return sb.toString();
    }

    private static final class EqProcedure
    implements TFloatIntProcedure {
        private final TFloatIntHashMap _otherMap;

        EqProcedure(TFloatIntHashMap otherMap) {
            this._otherMap = otherMap;
        }

        public final boolean execute(float key, int value) {
            int index2 = this._otherMap.index(key);
            return index2 >= 0 && EqProcedure.eq(value, this._otherMap.get(key));
        }

        private static boolean eq(int v1, int v2) {
            return v1 == v2;
        }
    }

    private final class HashProcedure
    implements TFloatIntProcedure {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(float key, int value) {
            this.h += TFloatIntHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }
}

