/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.SerializationProcedure;
import gnu.trove.TLongHash;
import gnu.trove.TLongHashingStrategy;
import gnu.trove.TLongIterator;
import gnu.trove.TLongProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;

public class TLongHashSet
extends TLongHash {
    public TLongHashSet() {
    }

    public TLongHashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public TLongHashSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TLongHashSet(long[] array2) {
        this(array2.length);
        this.addAll(array2);
    }

    public TLongHashSet(TLongHashingStrategy strategy) {
        super(strategy);
    }

    public TLongHashSet(int initialCapacity, TLongHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TLongHashSet(int initialCapacity, float loadFactor, TLongHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public TLongHashSet(long[] array2, TLongHashingStrategy strategy) {
        this(array2.length, strategy);
        this.addAll(array2);
    }

    public TLongIterator iterator() {
        return new TLongIterator(this);
    }

    public boolean add(long val) {
        int index2 = this.insertionIndex(val);
        if (index2 < 0) {
            return false;
        }
        byte previousState = this._states[index2];
        this._set[index2] = val;
        this._states[index2] = 1;
        this.postInsertHook(previousState == 0);
        return true;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        long[] oldSet = this._set;
        byte[] oldStates = this._states;
        this._set = new long[newCapacity];
        this._states = new byte[newCapacity];
        int i2 = oldCapacity;
        while (i2-- > 0) {
            if (oldStates[i2] != 1) continue;
            long o2 = oldSet[i2];
            int index2 = this.insertionIndex(o2);
            this._set[index2] = o2;
            this._states[index2] = 1;
        }
    }

    public long[] toArray() {
        long[] result2 = new long[this.size()];
        long[] set = this._set;
        byte[] states = this._states;
        if (states != null) {
            int i2 = states.length;
            int j2 = 0;
            while (i2-- > 0) {
                if (states[i2] != 1) continue;
                result2[j2++] = set[i2];
            }
        }
        return result2;
    }

    public void clear() {
        super.clear();
        long[] set = this._set;
        byte[] states = this._states;
        if (states != null) {
            int i2 = set.length;
            while (i2-- > 0) {
                set[i2] = 0L;
                states[i2] = 0;
            }
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof TLongHashSet)) {
            return false;
        }
        final TLongHashSet that = (TLongHashSet)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEach(new TLongProcedure(){

            public final boolean execute(long value) {
                return that.contains(value);
            }
        });
    }

    public int hashCode() {
        HashProcedure p2 = new HashProcedure();
        this.forEach(p2);
        return p2.getHashCode();
    }

    public boolean remove(long val) {
        int index2 = this.index(val);
        if (index2 >= 0) {
            this.removeAt(index2);
            return true;
        }
        return false;
    }

    public boolean containsAll(long[] array2) {
        int i2 = array2.length;
        while (i2-- > 0) {
            if (this.contains(array2[i2])) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(long[] array2) {
        boolean changed = false;
        int i2 = array2.length;
        while (i2-- > 0) {
            if (!this.add(array2[i2])) continue;
            changed = true;
        }
        return changed;
    }

    public boolean removeAll(long[] array2) {
        boolean changed = false;
        int i2 = array2.length;
        while (i2-- > 0) {
            if (!this.remove(array2[i2])) continue;
            changed = true;
        }
        return changed;
    }

    public boolean retainAll(long[] array2) {
        Arrays.sort(array2);
        long[] set = this._set;
        byte[] states = this._states;
        boolean changed = false;
        if (set != null) {
            int i2 = set.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || Arrays.binarySearch(array2, set[i2]) >= 0) continue;
                this.remove(set[i2]);
                changed = true;
            }
        }
        return changed;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEach(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            long val = stream.readLong();
            this.add(val);
        }
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEach(new TLongProcedure(){

            public boolean execute(long value) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(value);
                return true;
            }
        });
        sb.append(']');
        sb.insert(0, '[');
        return sb.toString();
    }

    private final class HashProcedure
    implements TLongProcedure {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(long key) {
            this.h += TLongHashSet.this._hashingStrategy.computeHashCode(key);
            return true;
        }
    }
}

