/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TByteByteHashMap;
import gnu.trove.TByteByteIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TByteByteHashMapDecorator
extends AbstractMap<Byte, Byte> {
    protected final TByteByteHashMap _map;

    public TByteByteHashMapDecorator(TByteByteHashMap map2) {
        this._map = map2;
    }

    @Override
    public Byte put(Byte key, Byte value) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value)));
    }

    @Override
    public boolean equals(Object other) {
        if (this._map.equals(other)) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (that.size() != this._map.size()) {
                return false;
            }
            Iterator it = that.entrySet().iterator();
            int i2 = that.size();
            while (i2-- > 0) {
                Map.Entry e2 = it.next();
                Object key = e2.getKey();
                Object val = e2.getValue();
                if (key instanceof Byte && val instanceof Byte) {
                    byte k2 = this.unwrapKey(key);
                    byte v2 = this.unwrapValue(val);
                    if (this._map.containsKey(k2) && v2 == this._map.get(k2)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Byte get(Object object) {
        return this.get((Byte)object);
    }

    public Byte get(Byte key) {
        byte k2 = this.unwrapKey(key);
        byte v2 = this._map.get(k2);
        if (v2 == 0) {
            return this._map.containsKey(k2) ? this.wrapValue(v2) : null;
        }
        return this.wrapValue(v2);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    public Byte remove(Byte key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    @Override
    public Byte remove(Object object) {
        return this.remove((Byte)object);
    }

    @Override
    public Set<Map.Entry<Byte, Byte>> entrySet() {
        return new AbstractSet<Map.Entry<Byte, Byte>>(){

            @Override
            public int size() {
                return TByteByteHashMapDecorator.this._map.size();
            }

            @Override
            public boolean isEmpty() {
                return TByteByteHashMapDecorator.this.isEmpty();
            }

            @Override
            public boolean contains(Object o2) {
                if (o2 instanceof Map.Entry) {
                    Object k2 = ((Map.Entry)o2).getKey();
                    Object v2 = ((Map.Entry)o2).getValue();
                    return TByteByteHashMapDecorator.this.containsKey(k2) && TByteByteHashMapDecorator.this.get(k2).equals(v2);
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<Byte, Byte>> iterator() {
                return new Iterator<Map.Entry<Byte, Byte>>(){
                    private final TByteByteIterator it;
                    {
                        this.it = TByteByteHashMapDecorator.this._map.iterator();
                    }

                    @Override
                    public Map.Entry<Byte, Byte> next() {
                        this.it.advance();
                        final Byte key = TByteByteHashMapDecorator.this.wrapKey(this.it.key());
                        final Byte v2 = TByteByteHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry<Byte, Byte>(){
                            private Byte val;
                            {
                                this.val = v2;
                            }

                            @Override
                            public boolean equals(Object o2) {
                                return o2 instanceof Map.Entry && ((Map.Entry)o2).getKey().equals(key) && ((Map.Entry)o2).getValue().equals(this.val);
                            }

                            @Override
                            public Byte getKey() {
                                return key;
                            }

                            @Override
                            public Byte getValue() {
                                return this.val;
                            }

                            @Override
                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            @Override
                            public Byte setValue(Byte value) {
                                this.val = value;
                                return TByteByteHashMapDecorator.this.put(key, value);
                            }
                        };
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public boolean add(Map.Entry<Byte, Byte> o2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<Byte, Byte>> c2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                TByteByteHashMapDecorator.this.clear();
            }
        };
    }

    @Override
    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends Byte, ? extends Byte> map2) {
        Iterator<Map.Entry<? extends Byte, ? extends Byte>> it = map2.entrySet().iterator();
        int i2 = map2.size();
        while (i2-- > 0) {
            Map.Entry<? extends Byte, ? extends Byte> e2 = it.next();
            this.put(e2.getKey(), e2.getValue());
        }
    }

    protected Byte wrapKey(byte k2) {
        return new Byte(k2);
    }

    protected byte unwrapKey(Object key) {
        return (Byte)key;
    }

    protected Byte wrapValue(byte k2) {
        return new Byte(k2);
    }

    protected byte unwrapValue(Object value) {
        return (Byte)value;
    }
}

