/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TFloatFloatHashMap;
import gnu.trove.TFloatFloatIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TFloatFloatHashMapDecorator
extends AbstractMap<Float, Float> {
    protected final TFloatFloatHashMap _map;

    public TFloatFloatHashMapDecorator(TFloatFloatHashMap map2) {
        this._map = map2;
    }

    @Override
    public Float put(Float key, Float value) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value)));
    }

    @Override
    public boolean equals(Object other) {
        if (this._map.equals(other)) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (that.size() != this._map.size()) {
                return false;
            }
            Iterator it = that.entrySet().iterator();
            int i2 = that.size();
            while (i2-- > 0) {
                Map.Entry e2 = it.next();
                Object key = e2.getKey();
                Object val = e2.getValue();
                if (key instanceof Float && val instanceof Float) {
                    float k2 = this.unwrapKey(key);
                    float v2 = this.unwrapValue(val);
                    if (this._map.containsKey(k2) && v2 == this._map.get(k2)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Float get(Object object) {
        return this.get((Float)object);
    }

    public Float get(Float key) {
        float k2 = this.unwrapKey(key);
        float v2 = this._map.get(k2);
        if (v2 == 0.0f) {
            return this._map.containsKey(k2) ? this.wrapValue(v2) : null;
        }
        return this.wrapValue(v2);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    public Float remove(Float key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    @Override
    public Float remove(Object object) {
        return this.remove((Float)object);
    }

    @Override
    public Set<Map.Entry<Float, Float>> entrySet() {
        return new AbstractSet<Map.Entry<Float, Float>>(){

            @Override
            public int size() {
                return TFloatFloatHashMapDecorator.this._map.size();
            }

            @Override
            public boolean isEmpty() {
                return TFloatFloatHashMapDecorator.this.isEmpty();
            }

            @Override
            public boolean contains(Object o2) {
                if (o2 instanceof Map.Entry) {
                    Object k2 = ((Map.Entry)o2).getKey();
                    Object v2 = ((Map.Entry)o2).getValue();
                    return TFloatFloatHashMapDecorator.this.containsKey(k2) && TFloatFloatHashMapDecorator.this.get(k2).equals(v2);
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<Float, Float>> iterator() {
                return new Iterator<Map.Entry<Float, Float>>(){
                    private final TFloatFloatIterator it;
                    {
                        this.it = TFloatFloatHashMapDecorator.this._map.iterator();
                    }

                    @Override
                    public Map.Entry<Float, Float> next() {
                        this.it.advance();
                        final Float key = TFloatFloatHashMapDecorator.this.wrapKey(this.it.key());
                        final Float v2 = TFloatFloatHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry<Float, Float>(){
                            private Float val;
                            {
                                this.val = v2;
                            }

                            @Override
                            public boolean equals(Object o2) {
                                return o2 instanceof Map.Entry && ((Map.Entry)o2).getKey().equals(key) && ((Map.Entry)o2).getValue().equals(this.val);
                            }

                            @Override
                            public Float getKey() {
                                return key;
                            }

                            @Override
                            public Float getValue() {
                                return this.val;
                            }

                            @Override
                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            @Override
                            public Float setValue(Float value) {
                                this.val = value;
                                return TFloatFloatHashMapDecorator.this.put(key, value);
                            }
                        };
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public boolean add(Map.Entry<Float, Float> o2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<Float, Float>> c2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                TFloatFloatHashMapDecorator.this.clear();
            }
        };
    }

    @Override
    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends Float, ? extends Float> map2) {
        Iterator<Map.Entry<? extends Float, ? extends Float>> it = map2.entrySet().iterator();
        int i2 = map2.size();
        while (i2-- > 0) {
            Map.Entry<? extends Float, ? extends Float> e2 = it.next();
            this.put(e2.getKey(), e2.getValue());
        }
    }

    protected Float wrapKey(float k2) {
        return new Float(k2);
    }

    protected float unwrapKey(Object key) {
        return ((Float)key).floatValue();
    }

    protected Float wrapValue(float k2) {
        return new Float(k2);
    }

    protected float unwrapValue(Object value) {
        return ((Float)value).floatValue();
    }
}

