/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.internal;

import io.opentelemetry.api.internal.Contract;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class StringUtils {
    @Contract(value="null -> true")
    public static boolean isNullOrEmpty(@Nullable String string2) {
        return string2 == null || string2.isEmpty();
    }

    public static String padLeft(String value, int minLength) {
        return StringUtils.padStart(value, minLength, '0');
    }

    private static String padStart(String string2, int minLength, char padChar) {
        Objects.requireNonNull(string2);
        if (string2.length() >= minLength) {
            return string2;
        }
        StringBuilder sb = new StringBuilder(minLength);
        for (int i2 = string2.length(); i2 < minLength; ++i2) {
            sb.append(padChar);
        }
        sb.append(string2);
        return sb.toString();
    }

    public static boolean isPrintableString(String str) {
        for (int i2 = 0; i2 < str.length(); ++i2) {
            if (StringUtils.isPrintableChar(str.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private static boolean isPrintableChar(char ch) {
        return ch >= ' ' && ch <= '~';
    }

    private StringUtils() {
    }
}

