/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extension.incubator.logs;

import io.opentelemetry.extension.incubator.logs.AnyValue;
import io.opentelemetry.extension.incubator.logs.AnyValueType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

final class AnyValueArray
implements AnyValue<List<AnyValue<?>>> {
    private final List<AnyValue<?>> value;

    private AnyValueArray(List<AnyValue<?>> value) {
        this.value = value;
    }

    static AnyValue<List<AnyValue<?>>> create(AnyValue<?> ... value) {
        Objects.requireNonNull(value, "value must not be null");
        ArrayList list2 = new ArrayList(value.length);
        list2.addAll(Arrays.asList(value));
        return new AnyValueArray(Collections.unmodifiableList(list2));
    }

    @Override
    public AnyValueType getType() {
        return AnyValueType.ARRAY;
    }

    @Override
    public List<AnyValue<?>> getValue() {
        return this.value;
    }

    @Override
    public String asString() {
        return this.value.stream().map(AnyValue::asString).collect(Collectors.joining(", ", "[", "]"));
    }

    public String toString() {
        return "AnyValueArray{" + this.asString() + "}";
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        return o2 instanceof AnyValue && Objects.equals(this.value, ((AnyValue)o2).getValue());
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

