/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extension.incubator.logs;

import io.opentelemetry.extension.incubator.logs.AnyValue;
import io.opentelemetry.extension.incubator.logs.AnyValueType;
import java.util.Objects;

final class AnyValueDouble
implements AnyValue<Double> {
    private final double value;

    private AnyValueDouble(double value) {
        this.value = value;
    }

    static AnyValue<Double> create(double value) {
        return new AnyValueDouble(value);
    }

    @Override
    public AnyValueType getType() {
        return AnyValueType.DOUBLE;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public String asString() {
        return String.valueOf(this.value);
    }

    public String toString() {
        return "AnyValueDouble{" + this.asString() + "}";
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        return o2 instanceof AnyValue && Objects.equals(this.value, ((AnyValue)o2).getValue());
    }

    public int hashCode() {
        return Double.hashCode(this.value);
    }
}

