/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extension.incubator.logs;

import io.opentelemetry.extension.incubator.logs.AnyValue;
import io.opentelemetry.extension.incubator.logs.AnyValueType;
import io.opentelemetry.extension.incubator.logs.KeyAnyValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

final class KeyAnyValueList
implements AnyValue<List<KeyAnyValue>> {
    private final List<KeyAnyValue> value;

    private KeyAnyValueList(List<KeyAnyValue> value) {
        this.value = value;
    }

    static AnyValue<List<KeyAnyValue>> create(KeyAnyValue ... value) {
        Objects.requireNonNull(value, "value must not be null");
        ArrayList<KeyAnyValue> list2 = new ArrayList<KeyAnyValue>(value.length);
        list2.addAll(Arrays.asList(value));
        return new KeyAnyValueList(Collections.unmodifiableList(list2));
    }

    static AnyValue<List<KeyAnyValue>> createFromMap(Map<String, AnyValue<?>> value) {
        Objects.requireNonNull(value, "value must not be null");
        KeyAnyValue[] array2 = (KeyAnyValue[])value.entrySet().stream().map(entry -> KeyAnyValue.of((String)entry.getKey(), (AnyValue)entry.getValue())).toArray(KeyAnyValue[]::new);
        return KeyAnyValueList.create(array2);
    }

    @Override
    public AnyValueType getType() {
        return AnyValueType.KEY_VALUE_LIST;
    }

    @Override
    public List<KeyAnyValue> getValue() {
        return this.value;
    }

    @Override
    public String asString() {
        return this.value.stream().map(item -> item.getKey() + "=" + item.getAnyValue().asString()).collect(Collectors.joining(", ", "[", "]"));
    }

    public String toString() {
        return "KeyAnyValueList{" + this.asString() + "}";
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        return o2 instanceof AnyValue && Objects.equals(this.value, ((AnyValue)o2).getValue());
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

