/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs.export;

import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.LogRecordProcessor;
import io.opentelemetry.sdk.logs.ReadWriteLogRecord;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SimpleLogRecordProcessor
implements LogRecordProcessor {
    private static final Logger logger = Logger.getLogger(SimpleLogRecordProcessor.class.getName());
    private final LogRecordExporter logRecordExporter;
    private final Set<CompletableResultCode> pendingExports = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    public static LogRecordProcessor create(LogRecordExporter exporter) {
        Objects.requireNonNull(exporter, "exporter");
        return new SimpleLogRecordProcessor(exporter);
    }

    private SimpleLogRecordProcessor(LogRecordExporter logRecordExporter) {
        this.logRecordExporter = Objects.requireNonNull(logRecordExporter, "logRecordExporter");
    }

    @Override
    public void onEmit(Context context2, ReadWriteLogRecord logRecord) {
        try {
            List<LogRecordData> logs = Collections.singletonList(logRecord.toLogRecordData());
            CompletableResultCode result2 = this.logRecordExporter.export(logs);
            this.pendingExports.add(result2);
            result2.whenComplete(() -> {
                this.pendingExports.remove(result2);
                if (!result2.isSuccess()) {
                    logger.log(Level.FINE, "Exporter failed");
                }
            });
        }
        catch (RuntimeException e2) {
            logger.log(Level.WARNING, "Exporter threw an Exception", e2);
        }
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.isShutdown.getAndSet(true)) {
            return CompletableResultCode.ofSuccess();
        }
        CompletableResultCode result2 = new CompletableResultCode();
        CompletableResultCode flushResult = this.forceFlush();
        flushResult.whenComplete(() -> {
            CompletableResultCode shutdownResult = this.logRecordExporter.shutdown();
            shutdownResult.whenComplete(() -> {
                if (!flushResult.isSuccess() || !shutdownResult.isSuccess()) {
                    result2.fail();
                } else {
                    result2.succeed();
                }
            });
        });
        return result2;
    }

    @Override
    public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofAll(this.pendingExports);
    }

    public String toString() {
        return "SimpleLogRecordProcessor{logRecordExporter=" + this.logRecordExporter + '}';
    }
}

