/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.sdk.metrics.internal.aggregator.AdaptingIntegerArray;

final class AdaptingCircularBufferCounter {
    private static final int NULL_INDEX = Integer.MIN_VALUE;
    private int endIndex = Integer.MIN_VALUE;
    private int startIndex = Integer.MIN_VALUE;
    private int baseIndex = Integer.MIN_VALUE;
    private final AdaptingIntegerArray backing;

    AdaptingCircularBufferCounter(int maxSize) {
        this.backing = new AdaptingIntegerArray(maxSize);
    }

    AdaptingCircularBufferCounter(AdaptingCircularBufferCounter toCopy) {
        this.backing = toCopy.backing.copy();
        this.startIndex = toCopy.getIndexStart();
        this.endIndex = toCopy.getIndexEnd();
        this.baseIndex = toCopy.baseIndex;
    }

    int getIndexStart() {
        return this.startIndex;
    }

    int getIndexEnd() {
        return this.endIndex;
    }

    boolean increment(int index2, long delta) {
        if (this.baseIndex == Integer.MIN_VALUE) {
            this.startIndex = index2;
            this.endIndex = index2;
            this.baseIndex = index2;
            this.backing.increment(0, delta);
            return true;
        }
        if (index2 > this.endIndex) {
            if ((long)index2 - (long)this.startIndex + 1L > (long)this.backing.length()) {
                return false;
            }
            this.endIndex = index2;
        } else if (index2 < this.startIndex) {
            if ((long)this.endIndex - (long)index2 + 1L > (long)this.backing.length()) {
                return false;
            }
            this.startIndex = index2;
        }
        int realIdx = this.toBufferIndex(index2);
        this.backing.increment(realIdx, delta);
        return true;
    }

    long get(int index2) {
        if (index2 < this.startIndex || index2 > this.endIndex) {
            return 0L;
        }
        return this.backing.get(this.toBufferIndex(index2));
    }

    boolean isEmpty() {
        return this.baseIndex == Integer.MIN_VALUE;
    }

    int getMaxSize() {
        return this.backing.length();
    }

    void clear() {
        this.backing.clear();
        this.baseIndex = Integer.MIN_VALUE;
        this.endIndex = Integer.MIN_VALUE;
        this.startIndex = Integer.MIN_VALUE;
    }

    private int toBufferIndex(int index2) {
        int result2 = index2 - this.baseIndex;
        if (result2 >= this.backing.length()) {
            result2 -= this.backing.length();
        } else if (result2 < 0) {
            result2 += this.backing.length();
        }
        return result2;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder("{");
        for (int i2 = this.startIndex; i2 <= this.endIndex && this.startIndex != Integer.MIN_VALUE; ++i2) {
            if (i2 != this.startIndex) {
                result2.append(',');
            }
            result2.append(i2).append('=').append(this.get(i2));
        }
        return result2.append("}").toString();
    }
}

