/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.PointData;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AggregatorHandle<T extends PointData, U extends ExemplarData> {
    private final ExemplarReservoir<U> exemplarReservoir;
    private volatile boolean valuesRecorded = false;

    protected AggregatorHandle(ExemplarReservoir<U> exemplarReservoir) {
        this.exemplarReservoir = exemplarReservoir;
    }

    public final T aggregateThenMaybeReset(long startEpochNanos, long epochNanos, Attributes attributes, boolean reset) {
        if (reset) {
            this.valuesRecorded = false;
        }
        return this.doAggregateThenMaybeReset(startEpochNanos, epochNanos, attributes, this.exemplarReservoir.collectAndReset(attributes), reset);
    }

    protected abstract T doAggregateThenMaybeReset(long var1, long var3, Attributes var5, List<U> var6, boolean var7);

    public final void recordLong(long value, Attributes attributes, Context context2) {
        this.exemplarReservoir.offerLongMeasurement(value, attributes, context2);
        this.recordLong(value);
    }

    public final void recordLong(long value) {
        this.doRecordLong(value);
        this.valuesRecorded = true;
    }

    protected void doRecordLong(long value) {
        throw new UnsupportedOperationException("This aggregator does not support recording long values.");
    }

    public final void recordDouble(double value, Attributes attributes, Context context2) {
        this.exemplarReservoir.offerDoubleMeasurement(value, attributes, context2);
        this.recordDouble(value);
    }

    public final void recordDouble(double value) {
        this.doRecordDouble(value);
        this.valuesRecorded = true;
    }

    protected void doRecordDouble(double value) {
        throw new UnsupportedOperationException("This aggregator does not support recording double values.");
    }

    public boolean hasRecordedValues() {
        return this.valuesRecorded;
    }
}

