/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.sdk.internal.PrimitiveLongList;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramBuckets;
import io.opentelemetry.sdk.metrics.internal.aggregator.AdaptingCircularBufferCounter;
import io.opentelemetry.sdk.metrics.internal.aggregator.Base2ExponentialHistogramIndexer;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

final class DoubleBase2ExponentialHistogramBuckets
implements ExponentialHistogramBuckets {
    private AdaptingCircularBufferCounter counts;
    private int scale;
    private Base2ExponentialHistogramIndexer base2ExponentialHistogramIndexer;
    private long totalCount;

    DoubleBase2ExponentialHistogramBuckets(int scale, int maxBuckets) {
        this.counts = new AdaptingCircularBufferCounter(maxBuckets);
        this.scale = scale;
        this.base2ExponentialHistogramIndexer = Base2ExponentialHistogramIndexer.get(this.scale);
        this.totalCount = 0L;
    }

    DoubleBase2ExponentialHistogramBuckets(DoubleBase2ExponentialHistogramBuckets buckets) {
        this.counts = new AdaptingCircularBufferCounter(buckets.counts);
        this.scale = buckets.scale;
        this.base2ExponentialHistogramIndexer = buckets.base2ExponentialHistogramIndexer;
        this.totalCount = buckets.totalCount;
    }

    DoubleBase2ExponentialHistogramBuckets copy() {
        return new DoubleBase2ExponentialHistogramBuckets(this);
    }

    void clear(int scale) {
        this.totalCount = 0L;
        this.scale = scale;
        this.base2ExponentialHistogramIndexer = Base2ExponentialHistogramIndexer.get(this.scale);
        this.counts.clear();
    }

    boolean record(double value) {
        if (value == 0.0) {
            throw new IllegalStateException("Illegal attempted recording of zero at bucket level.");
        }
        int index2 = this.base2ExponentialHistogramIndexer.computeIndex(value);
        boolean recordingSuccessful = this.counts.increment(index2, 1L);
        if (recordingSuccessful) {
            ++this.totalCount;
        }
        return recordingSuccessful;
    }

    @Override
    public int getOffset() {
        if (this.counts.isEmpty()) {
            return 0;
        }
        return this.counts.getIndexStart();
    }

    @Override
    public List<Long> getBucketCounts() {
        if (this.counts.isEmpty()) {
            return Collections.emptyList();
        }
        int length = this.counts.getIndexEnd() - this.counts.getIndexStart() + 1;
        long[] countsArr = new long[length];
        for (int i2 = 0; i2 < length; ++i2) {
            countsArr[i2] = this.counts.get(i2 + this.counts.getIndexStart());
        }
        return PrimitiveLongList.wrap(countsArr);
    }

    @Override
    public long getTotalCount() {
        return this.totalCount;
    }

    void downscale(int by) {
        if (by == 0) {
            return;
        }
        if (by < 0) {
            throw new IllegalStateException("Cannot downscale by negative amount. Was given " + by + ".");
        }
        if (!this.counts.isEmpty()) {
            AdaptingCircularBufferCounter newCounts = new AdaptingCircularBufferCounter(this.counts);
            newCounts.clear();
            for (int i2 = this.counts.getIndexStart(); i2 <= this.counts.getIndexEnd(); ++i2) {
                long count2 = this.counts.get(i2);
                if (count2 <= 0L || newCounts.increment(i2 >> by, count2)) continue;
                throw new IllegalStateException("Failed to create new downscaled buckets.");
            }
            this.counts = newCounts;
        }
        this.scale -= by;
        this.base2ExponentialHistogramIndexer = Base2ExponentialHistogramIndexer.get(this.scale);
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    int getScaleReduction(double value) {
        long index2 = this.base2ExponentialHistogramIndexer.computeIndex(value);
        long newStart = Math.min(index2, (long)this.counts.getIndexStart());
        long newEnd = Math.max(index2, (long)this.counts.getIndexEnd());
        return this.getScaleReduction(newStart, newEnd);
    }

    int getScaleReduction(long newStart, long newEnd) {
        int scaleReduction = 0;
        while (newEnd - newStart + 1L > (long)this.counts.getMaxSize()) {
            newStart >>= 1;
            newEnd >>= 1;
            ++scaleReduction;
        }
        return scaleReduction;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof DoubleBase2ExponentialHistogramBuckets)) {
            return false;
        }
        DoubleBase2ExponentialHistogramBuckets other = (DoubleBase2ExponentialHistogramBuckets)obj;
        return this.scale == other.scale && this.sameBucketCounts(other);
    }

    private boolean sameBucketCounts(DoubleBase2ExponentialHistogramBuckets other) {
        if (this.totalCount != other.totalCount) {
            return false;
        }
        int min2 = Math.min(this.counts.getIndexStart(), other.counts.getIndexStart());
        if (min2 == Integer.MIN_VALUE) {
            min2 = Math.max(this.counts.getIndexStart(), other.counts.getIndexStart());
        }
        int max = Math.max(this.counts.getIndexEnd(), other.counts.getIndexEnd());
        for (int idx = min2; idx <= max; ++idx) {
            if (this.counts.get(idx) == other.counts.get(idx)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 1;
        hash *= 1000003;
        for (int idx = this.counts.getIndexStart(); idx <= this.counts.getIndexEnd(); ++idx) {
            long count2 = this.counts.get(idx);
            if (count2 == 0L) continue;
            hash ^= idx;
            hash *= 1000003;
            hash = (int)((long)hash ^ count2);
            hash *= 1000003;
        }
        return hash ^= this.scale;
    }

    public String toString() {
        return "DoubleExponentialHistogramBuckets{scale: " + this.scale + ", offset: " + this.getOffset() + ", counts: " + this.counts + " }";
    }
}

