/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.concurrent;

import io.opentelemetry.sdk.metrics.internal.concurrent.LongAdder;
import java.util.concurrent.atomic.AtomicLong;

final class AtomicLongLongAdder
implements LongAdder {
    private final AtomicLong atomicLong = new AtomicLong();

    AtomicLongLongAdder() {
    }

    @Override
    public void add(long x2) {
        long next;
        long current2;
        while (!this.atomicLong.compareAndSet(current2 = this.atomicLong.get(), next = current2 + x2)) {
        }
    }

    @Override
    public long sum() {
        return this.atomicLong.get();
    }

    @Override
    public void reset() {
        this.atomicLong.set(0L);
    }

    @Override
    public long sumThenReset() {
        long prev;
        while (!this.atomicLong.compareAndSet(prev = this.atomicLong.get(), 0L)) {
        }
        return prev;
    }

    public String toString() {
        return Long.toString(this.sum());
    }
}

