/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.debug;

import io.opentelemetry.sdk.metrics.internal.debug.SourceInfo;

final class StackTraceSourceInfo
implements SourceInfo {
    private final StackTraceElement[] stackTraceElements;

    StackTraceSourceInfo(StackTraceElement[] stackTraceElements) {
        this.stackTraceElements = stackTraceElements;
    }

    @Override
    public String shortDebugString() {
        if (this.stackTraceElements.length > 0) {
            for (StackTraceElement e2 : this.stackTraceElements) {
                if (!StackTraceSourceInfo.isInterestingStackTrace(e2)) continue;
                return String.format("%s:%d", e2.getFileName(), e2.getLineNumber());
            }
        }
        return "unknown source";
    }

    @Override
    public String multiLineDebugString() {
        if (this.stackTraceElements.length > 0) {
            StringBuilder result2 = new StringBuilder();
            for (StackTraceElement e2 : this.stackTraceElements) {
                if (!StackTraceSourceInfo.isInterestingStackTrace(e2)) continue;
                result2.append("\tat ").append(e2).append("\n");
            }
            return result2.toString();
        }
        return "\tat unknown source";
    }

    private static boolean isInterestingStackTrace(StackTraceElement e2) {
        return !e2.getClassName().startsWith("io.opentelemetry.sdk.metrics") && !e2.getClassName().startsWith("java.lang");
    }
}

