/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.exemplar;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import java.util.List;

class FilteredExemplarReservoir<T extends ExemplarData>
implements ExemplarReservoir<T> {
    private final ExemplarFilter filter;
    private final ExemplarReservoir<T> reservoir;

    FilteredExemplarReservoir(ExemplarFilter filter2, ExemplarReservoir<T> reservoir) {
        this.filter = filter2;
        this.reservoir = reservoir;
    }

    @Override
    public void offerDoubleMeasurement(double value, Attributes attributes, Context context2) {
        if (this.filter.shouldSampleMeasurement(value, attributes, context2)) {
            this.reservoir.offerDoubleMeasurement(value, attributes, context2);
        }
    }

    @Override
    public void offerLongMeasurement(long value, Attributes attributes, Context context2) {
        if (this.filter.shouldSampleMeasurement(value, attributes, context2)) {
            this.reservoir.offerLongMeasurement(value, attributes, context2);
        }
    }

    @Override
    public List<T> collectAndReset(Attributes pointAttributes) {
        return this.reservoir.collectAndReset(pointAttributes);
    }
}

