/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.atomic.AtomicInteger;

public final class IntArrays {
    public static final int[] EMPTY_ARRAY = new int[0];
    public static final int[] DEFAULT_EMPTY_ARRAY = new int[0];
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<int[]> HASH_STRATEGY = new a(0);

    private IntArrays() {
    }

    /*
     * WARNING - void declaration
     */
    public static int[] forceCapacity(int[] array2, int length, int preserve) {
        void var2_3;
        int[] nArray;
        int[] nArray2 = new int[length];
        System.arraycopy(nArray, 0, nArray2, 0, (int)var2_3);
        return nArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] ensureCapacity(int[] array2, int length) {
        int[] nArray;
        void var1_1;
        return IntArrays.ensureCapacity(array2, (int)var1_1, nArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static int[] ensureCapacity(int[] array2, int length, int preserve) {
        int[] nArray;
        if (length > array2.length) {
            void var2_2;
            void var1_1;
            return IntArrays.forceCapacity(array2, (int)var1_1, (int)var2_2);
        }
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] grow(int[] array2, int length) {
        int[] nArray;
        void var1_1;
        return IntArrays.grow(array2, (int)var1_1, nArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static int[] grow(int[] array2, int length, int preserve) {
        int[] nArray;
        if (length > array2.length) {
            void var2_3;
            void var1_1;
            int[] nArray2 = new int[(int)Math.max(Math.min((long)array2.length + (long)(array2.length >> 1), 0x7FFFFFF7L), (long)var1_1)];
            System.arraycopy(array2, 0, nArray2, 0, (int)var2_3);
            return nArray2;
        }
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] trim(int[] array2, int length) {
        void var1_1;
        int[] nArray;
        if (length >= array2.length) {
            return array2;
        }
        int[] nArray2 = length == 0 ? EMPTY_ARRAY : new int[length];
        System.arraycopy(nArray, 0, nArray2, 0, (int)var1_1);
        return nArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] setLength(int[] array2, int length) {
        void var1_1;
        int[] nArray;
        if (length == array2.length) {
            return array2;
        }
        if (length < array2.length) {
            return IntArrays.trim(array2, length);
        }
        return IntArrays.ensureCapacity(nArray, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int[] copy(int[] array2, int offset, int length) {
        void var2_2;
        void var1_1;
        int[] nArray;
        IntArrays.ensureOffsetLength(array2, offset, length);
        int[] nArray2 = length == 0 ? EMPTY_ARRAY : new int[length];
        System.arraycopy(nArray, (int)var1_1, nArray2, 0, (int)var2_2);
        return nArray2;
    }

    public static int[] copy(int[] array2) {
        return (int[])array2.clone();
    }

    @Deprecated
    public static void fill(int[] array2, int value) {
        int n2 = array2.length;
        while (n2-- != 0) {
            array2[n2] = value;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static void fill(int[] array2, int from2, int to, int value) {
        IntArrays.ensureFromTo(array2, from2, to);
        if (from2 == 0) {
            while (to-- != 0) {
                array2[to] = value;
            }
        } else {
            void var1_1;
            while (var1_1 < to) {
                array2[var1_1] = value;
                ++var1_1;
            }
        }
    }

    @Deprecated
    public static boolean equals(int[] a1, int[] a2) {
        int n2 = a1.length;
        if (n2 != a2.length) {
            return false;
        }
        while (n2-- != 0) {
            if (a1[n2] == a2[n2]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static void ensureFromTo(int[] a2, int from2, int to) {
        void var2_2;
        void var1_1;
        Arrays.ensureFromTo(a2.length, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void ensureOffsetLength(int[] a2, int offset, int length) {
        void var2_2;
        void var1_1;
        Arrays.ensureOffsetLength(a2.length, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void ensureSameLength(int[] a2, int[] b2) {
        if (a2.length != b2.length) {
            void var1_1;
            int[] nArray;
            throw new IllegalArgumentException("Array size mismatch: " + nArray.length + " != " + ((void)var1_1).length);
        }
    }

    private static ForkJoinPool a() {
        ForkJoinPool forkJoinPool = ForkJoinTask.getPool();
        if (forkJoinPool == null) {
            return ForkJoinPool.commonPool();
        }
        return forkJoinPool;
    }

    public static void swap(int[] x2, int a2, int b2) {
        int n2 = x2[a2];
        x2[var1_1] = x2[b2];
        var0[var2_2] = n2;
    }

    public static void swap(int[] x2, int a2, int b2, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            IntArrays.swap(x2, a2, b2);
            ++n3;
            ++a2;
            ++b2;
        }
    }

    private static int b(int[] nArray, int n2, int n3, int n4, IntComparator intComparator) {
        int n5 = intComparator.compare(nArray[n2], nArray[n3]);
        int n6 = intComparator.compare(nArray[n2], nArray[n4]);
        int n7 = intComparator.compare(nArray[n3], nArray[n4]);
        if (n5 < 0) {
            if (n7 < 0) {
                return n3;
            }
            if (n6 < 0) {
                return n4;
            }
            return n2;
        }
        if (n7 > 0) {
            return n3;
        }
        if (n6 > 0) {
            return n4;
        }
        return n2;
    }

    public static void quickSort(int[] x2, int from2, int to, IntComparator comp) {
        while (true) {
            int n2;
            int n3;
            int n4;
            if ((n4 = to - from2) < 16) {
                while (from2 < to - 1) {
                    n4 = from2;
                    for (n3 = from2 + 1; n3 < to; ++n3) {
                        if (comp.compare(x2[n3], x2[n4]) >= 0) continue;
                        n4 = n3;
                    }
                    if (n4 != from2) {
                        n3 = x2[from2];
                        x2[from2] = x2[n4];
                        x2[n4] = n3;
                    }
                    ++from2;
                }
                return;
            }
            n3 = from2 + n4 / 2;
            int n5 = from2;
            int n6 = to - 1;
            if (n4 > 128) {
                int n7 = from2;
                n5 = IntArrays.b(x2, n7, n7 + (n4 /= 8), from2 + 2 * n4, comp);
                int n8 = n3;
                n3 = IntArrays.b(x2, n3 - n4, n8, n8 + n4, comp);
                n6 = IntArrays.b(x2, n6 - 2 * n4, n6 - n4, n6, comp);
            }
            n3 = IntArrays.b(x2, n5, n3, n6, comp);
            n4 = x2[n3];
            n3 = from2;
            n5 = from2;
            int n9 = n6 = to - 1;
            while (true) {
                if (n5 <= n6 && (n2 = comp.compare(x2[n5], n4)) <= 0) {
                    if (n2 == 0) {
                        IntArrays.swap(x2, n3++, n5);
                    }
                    ++n5;
                    continue;
                }
                while (n6 >= n5 && (n2 = comp.compare(x2[n6], n4)) >= 0) {
                    if (n2 == 0) {
                        IntArrays.swap(x2, n6, n9--);
                    }
                    --n6;
                }
                if (n5 > n6) break;
                IntArrays.swap(x2, n5++, n6--);
            }
            n2 = Math.min(n3 - from2, n5 - n3);
            IntArrays.swap(x2, from2, n5 - n2, n2);
            n2 = Math.min(n9 - n6, to - n9 - 1);
            IntArrays.swap(x2, n5, to - n2, n2);
            n2 = n5 - n3;
            if (n2 > 1) {
                int n10 = from2;
                IntArrays.quickSort(x2, n10, n10 + n2, comp);
            }
            if ((n2 = n9 - n6) <= 1) break;
            from2 = to - n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void quickSort(int[] x2, IntComparator comp) {
        void var1_1;
        int[] nArray;
        IntArrays.quickSort(x2, 0, nArray.length, (IntComparator)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void parallelQuickSort(int[] x2, int from2, int to, IntComparator comp) {
        void var3_3;
        void var2_2;
        void var1_1;
        int[] nArray;
        ForkJoinPool forkJoinPool = IntArrays.a();
        if (to - from2 < 8192 || forkJoinPool.getParallelism() == 1) {
            IntArrays.quickSort(x2, from2, to, comp);
            return;
        }
        forkJoinPool.invoke(new d(nArray, (int)var1_1, (int)var2_2, (IntComparator)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static void parallelQuickSort(int[] x2, IntComparator comp) {
        void var1_1;
        int[] nArray;
        IntArrays.parallelQuickSort(x2, 0, nArray.length, (IntComparator)var1_1);
    }

    private static int b(int[] nArray, int n2, int n3, int n4) {
        int n5 = Integer.compare(nArray[n2], nArray[n3]);
        int n6 = Integer.compare(nArray[n2], nArray[n4]);
        int n7 = Integer.compare(nArray[n3], nArray[n4]);
        if (n5 < 0) {
            if (n7 < 0) {
                return n3;
            }
            if (n6 < 0) {
                return n4;
            }
            return n2;
        }
        if (n7 > 0) {
            return n3;
        }
        if (n6 > 0) {
            return n4;
        }
        return n2;
    }

    public static void quickSort(int[] x2, int from2, int to) {
        while (true) {
            int n2;
            int n3;
            int n4;
            if ((n4 = to - from2) < 16) {
                while (from2 < to - 1) {
                    n4 = from2;
                    for (n3 = from2 + 1; n3 < to; ++n3) {
                        if (x2[n3] >= x2[n4]) continue;
                        n4 = n3;
                    }
                    if (n4 != from2) {
                        n3 = x2[from2];
                        x2[from2] = x2[n4];
                        x2[n4] = n3;
                    }
                    ++from2;
                }
                return;
            }
            n3 = from2 + n4 / 2;
            int n5 = from2;
            int n6 = to - 1;
            if (n4 > 128) {
                int n7 = from2;
                n5 = IntArrays.b(x2, n7, n7 + (n4 /= 8), from2 + 2 * n4);
                int n8 = n3;
                n3 = IntArrays.b(x2, n3 - n4, n8, n8 + n4);
                n6 = IntArrays.b(x2, n6 - 2 * n4, n6 - n4, n6);
            }
            n3 = IntArrays.b(x2, n5, n3, n6);
            n4 = x2[n3];
            n3 = from2;
            n5 = from2;
            int n9 = n6 = to - 1;
            while (true) {
                if (n5 <= n6 && (n2 = Integer.compare(x2[n5], n4)) <= 0) {
                    if (n2 == 0) {
                        IntArrays.swap(x2, n3++, n5);
                    }
                    ++n5;
                    continue;
                }
                while (n6 >= n5 && (n2 = Integer.compare(x2[n6], n4)) >= 0) {
                    if (n2 == 0) {
                        IntArrays.swap(x2, n6, n9--);
                    }
                    --n6;
                }
                if (n5 > n6) break;
                IntArrays.swap(x2, n5++, n6--);
            }
            n2 = Math.min(n3 - from2, n5 - n3);
            IntArrays.swap(x2, from2, n5 - n2, n2);
            n2 = Math.min(n9 - n6, to - n9 - 1);
            IntArrays.swap(x2, n5, to - n2, n2);
            n2 = n5 - n3;
            if (n2 > 1) {
                int n10 = from2;
                IntArrays.quickSort(x2, n10, n10 + n2);
            }
            if ((n2 = n9 - n6) <= 1) break;
            from2 = to - n2;
        }
    }

    public static void quickSort(int[] x2) {
        int[] nArray;
        IntArrays.quickSort(x2, 0, nArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void parallelQuickSort(int[] x2, int from2, int to) {
        void var2_2;
        void var1_1;
        int[] nArray;
        ForkJoinPool forkJoinPool = IntArrays.a();
        if (to - from2 < 8192 || forkJoinPool.getParallelism() == 1) {
            IntArrays.quickSort(x2, from2, to);
            return;
        }
        forkJoinPool.invoke(new b(nArray, (int)var1_1, (int)var2_2));
    }

    public static void parallelQuickSort(int[] x2) {
        int[] nArray;
        IntArrays.parallelQuickSort(x2, 0, nArray.length);
    }

    private static int d(int[] nArray, int[] nArray2, int n2, int n3, int n4) {
        int n5 = nArray2[nArray[n2]];
        int n6 = nArray2[nArray[n3]];
        int n7 = nArray2[nArray[n4]];
        int n8 = Integer.compare(n5, n6);
        n5 = Integer.compare(n5, n7);
        n7 = Integer.compare(n6, n7);
        if (n8 < 0) {
            if (n7 < 0) {
                return n3;
            }
            if (n5 < 0) {
                return n4;
            }
            return n2;
        }
        if (n7 > 0) {
            return n3;
        }
        if (n5 > 0) {
            return n4;
        }
        return n2;
    }

    public static void quickSortIndirect(int[] perm, int[] x2, int from2, int to) {
        while (true) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            if ((n6 = to - from2) < 16) {
                n6 = from2;
                while (++n6 < to) {
                    n5 = perm[n6];
                    n4 = n6;
                    n3 = perm[n4 - 1];
                    while (x2[n5] < x2[n3]) {
                        perm[n4] = n3;
                        if (from2 == n4 - 1) {
                            --n4;
                            break;
                        }
                        n3 = perm[--n4 - 1];
                    }
                    perm[n4] = n5;
                }
                return;
            }
            n5 = from2 + n6 / 2;
            n4 = from2;
            n3 = to - 1;
            if (n6 > 128) {
                int n7 = from2;
                n4 = IntArrays.d(perm, x2, n7, n7 + (n6 /= 8), from2 + 2 * n6);
                int n8 = n5;
                n5 = IntArrays.d(perm, x2, n5 - n6, n8, n8 + n6);
                n3 = IntArrays.d(perm, x2, n3 - 2 * n6, n3 - n6, n3);
            }
            n5 = IntArrays.d(perm, x2, n4, n5, n3);
            n6 = x2[perm[n5]];
            n5 = from2;
            n4 = from2;
            int n9 = n3 = to - 1;
            while (true) {
                if (n4 <= n3 && (n2 = Integer.compare(x2[perm[n4]], n6)) <= 0) {
                    if (n2 == 0) {
                        IntArrays.swap(perm, n5++, n4);
                    }
                    ++n4;
                    continue;
                }
                while (n3 >= n4 && (n2 = Integer.compare(x2[perm[n3]], n6)) >= 0) {
                    if (n2 == 0) {
                        IntArrays.swap(perm, n3, n9--);
                    }
                    --n3;
                }
                if (n4 > n3) break;
                IntArrays.swap(perm, n4++, n3--);
            }
            n2 = Math.min(n5 - from2, n4 - n5);
            IntArrays.swap(perm, from2, n4 - n2, n2);
            n2 = Math.min(n9 - n3, to - n9 - 1);
            IntArrays.swap(perm, n4, to - n2, n2);
            n2 = n4 - n5;
            if (n2 > 1) {
                int n10 = from2;
                IntArrays.quickSortIndirect(perm, x2, n10, n10 + n2);
            }
            if ((n2 = n9 - n3) <= 1) break;
            from2 = to - n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void quickSortIndirect(int[] perm, int[] x2) {
        void var1_1;
        IntArrays.quickSortIndirect(perm, x2, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    public static void parallelQuickSortIndirect(int[] perm, int[] x2, int from2, int to) {
        void var3_3;
        void var2_2;
        void var1_1;
        int[] nArray;
        ForkJoinPool forkJoinPool = IntArrays.a();
        if (to - from2 < 8192 || forkJoinPool.getParallelism() == 1) {
            IntArrays.quickSortIndirect(perm, x2, from2, to);
            return;
        }
        forkJoinPool.invoke(new e(nArray, (int[])var1_1, (int)var2_2, (int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static void parallelQuickSortIndirect(int[] perm, int[] x2) {
        void var1_1;
        IntArrays.parallelQuickSortIndirect(perm, x2, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    public static void stabilize(int[] perm, int[] x2, int from2, int to) {
        void var2_2;
        int n2 = from2;
        ++var2_2;
        while (var2_2 < to) {
            if (x2[perm[var2_2]] != x2[perm[n2]]) {
                if (var2_2 - n2 > true) {
                    IntArrays.parallelQuickSort(perm, n2, (int)var2_2);
                }
                n2 = var2_2;
            }
            ++var2_2;
        }
        if (to - n2 > 1) {
            void var3_3;
            int[] nArray;
            IntArrays.parallelQuickSort(nArray, n2, (int)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void stabilize(int[] perm, int[] x2) {
        int[] nArray;
        void var1_1;
        IntArrays.stabilize(perm, (int[])var1_1, 0, nArray.length);
    }

    private static int e(int[] nArray, int[] nArray2, int n2, int n3, int n4) {
        int n5;
        int n6 = Integer.compare(nArray[n2], nArray[n3]);
        int n7 = n6 == 0 ? Integer.compare(nArray2[n2], nArray2[n3]) : n6;
        n6 = Integer.compare(nArray[n2], nArray[n4]);
        int n8 = n6 == 0 ? Integer.compare(nArray2[n2], nArray2[n4]) : n6;
        n6 = Integer.compare(nArray[n3], nArray[n4]);
        int n9 = n5 = n6 == 0 ? Integer.compare(nArray2[n3], nArray2[n4]) : n6;
        if (n7 < 0) {
            if (n5 < 0) {
                return n3;
            }
            if (n8 < 0) {
                return n4;
            }
            return n2;
        }
        if (n5 > 0) {
            return n3;
        }
        if (n8 > 0) {
            return n4;
        }
        return n2;
    }

    private static void b(int[] nArray, int[] nArray2, int n2, int n3) {
        int n4 = nArray[n2];
        int n5 = nArray2[n2];
        nArray[n2] = nArray[n3];
        nArray2[n2] = nArray2[n3];
        nArray[n3] = n4;
        nArray2[n3] = n5;
    }

    private static void f(int[] nArray, int[] nArray2, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            IntArrays.b(nArray, nArray2, n2, n3);
            ++n5;
            ++n2;
            ++n3;
        }
    }

    public static void quickSort(int[] x2, int[] y2, int from2, int to) {
        while (true) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            if ((n6 = to - from2) < 16) {
                while (from2 < to - 1) {
                    n6 = from2;
                    for (n5 = from2 + 1; n5 < to; ++n5) {
                        n4 = Integer.compare(x2[n5], x2[n6]);
                        if (n4 >= 0 && (n4 != 0 || y2[n5] >= y2[n6])) continue;
                        n6 = n5;
                    }
                    if (n6 != from2) {
                        n5 = x2[from2];
                        x2[from2] = x2[n6];
                        x2[n6] = n5;
                        n5 = y2[from2];
                        y2[from2] = y2[n6];
                        y2[n6] = n5;
                    }
                    ++from2;
                }
                return;
            }
            n4 = from2 + n6 / 2;
            n5 = from2;
            int n7 = to - 1;
            if (n6 > 128) {
                int n8 = from2;
                n5 = IntArrays.e(x2, y2, n8, n8 + (n6 /= 8), from2 + 2 * n6);
                int n9 = n4;
                n4 = IntArrays.e(x2, y2, n4 - n6, n9, n9 + n6);
                n7 = IntArrays.e(x2, y2, n7 - 2 * n6, n7 - n6, n7);
            }
            n4 = IntArrays.e(x2, y2, n5, n4, n7);
            n6 = x2[n4];
            n4 = y2[n4];
            n5 = from2;
            n7 = from2;
            int n10 = n3 = to - 1;
            while (true) {
                if (n7 <= n3 && (n2 = (n2 = Integer.compare(x2[n7], n6)) == 0 ? Integer.compare(y2[n7], n4) : n2) <= 0) {
                    if (n2 == 0) {
                        IntArrays.b(x2, y2, n5++, n7);
                    }
                    ++n7;
                    continue;
                }
                while (n3 >= n7 && (n2 = (n2 = Integer.compare(x2[n3], n6)) == 0 ? Integer.compare(y2[n3], n4) : n2) >= 0) {
                    if (n2 == 0) {
                        IntArrays.b(x2, y2, n3, n10--);
                    }
                    --n3;
                }
                if (n7 > n3) break;
                IntArrays.b(x2, y2, n7++, n3--);
            }
            n2 = Math.min(n5 - from2, n7 - n5);
            IntArrays.f(x2, y2, from2, n7 - n2, n2);
            n2 = Math.min(n10 - n3, to - n10 - 1);
            IntArrays.f(x2, y2, n7, to - n2, n2);
            n2 = n7 - n5;
            if (n2 > 1) {
                int n11 = from2;
                IntArrays.quickSort(x2, y2, n11, n11 + n2);
            }
            if ((n2 = n10 - n3) <= 1) break;
            from2 = to - n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void quickSort(int[] x2, int[] y2) {
        int[] nArray;
        void var1_1;
        IntArrays.ensureSameLength(x2, y2);
        IntArrays.quickSort(x2, (int[])var1_1, 0, nArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void parallelQuickSort(int[] x2, int[] y2, int from2, int to) {
        void var3_3;
        void var2_2;
        void var1_1;
        int[] nArray;
        ForkJoinPool forkJoinPool = IntArrays.a();
        if (to - from2 < 8192 || forkJoinPool.getParallelism() == 1) {
            IntArrays.quickSort(x2, y2, from2, to);
            return;
        }
        forkJoinPool.invoke(new c(nArray, (int[])var1_1, (int)var2_2, (int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static void parallelQuickSort(int[] x2, int[] y2) {
        int[] nArray;
        void var1_1;
        IntArrays.ensureSameLength(x2, y2);
        IntArrays.parallelQuickSort(x2, (int[])var1_1, 0, nArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void unstableSort(int[] a2, int from2, int to) {
        void var2_2;
        void var1_1;
        int[] nArray;
        if (to - from2 >= 2000) {
            IntArrays.radixSort(a2, from2, to);
            return;
        }
        IntArrays.quickSort(nArray, (int)var1_1, (int)var2_2);
    }

    public static void unstableSort(int[] a2) {
        int[] nArray;
        IntArrays.unstableSort(a2, 0, nArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void unstableSort(int[] a2, int from2, int to, IntComparator comp) {
        void var3_3;
        void var2_2;
        void var1_1;
        IntArrays.quickSort(a2, (int)var1_1, (int)var2_2, (IntComparator)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static void unstableSort(int[] a2, IntComparator comp) {
        void var1_1;
        int[] nArray;
        IntArrays.unstableSort(a2, 0, nArray.length, (IntComparator)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void mergeSort(int[] a2, int from2, int to, int[] supp22) {
        int[] supp22;
        int n2 = to - from2;
        if (n2 < 16) {
            int supp22 = from2;
            while (++supp22 < to) {
                n2 = a2[supp22];
                int n3 = supp22;
                int n4 = a2[n3 - 1];
                while (n2 < n4) {
                    a2[n3] = n4;
                    if (from2 == n3 - 1) {
                        --n3;
                        break;
                    }
                    n4 = a2[--n3 - 1];
                }
                a2[n3] = n2;
            }
            return;
        }
        if (supp22 == null) {
            supp22 = java.util.Arrays.copyOf(a2, to);
        }
        int n5 = from2 + to >>> 1;
        IntArrays.mergeSort(supp22, from2, n5, a2);
        IntArrays.mergeSort(supp22, n5, to, a2);
        if (supp22[n5 - 1] <= supp22[n5]) {
            System.arraycopy(supp22, from2, a2, from2, n2);
            return;
        }
        int n6 = n5;
        for (n2 = from2; n2 < to; ++n2) {
            void var1_1;
            a2[n2] = n6 >= to || var1_1 < n5 && supp22[var1_1] <= supp22[n6] ? supp22[++var1_1] : supp22[n6++];
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void mergeSort(int[] a2, int from2, int to) {
        void var2_2;
        void var1_1;
        IntArrays.mergeSort(a2, (int)var1_1, (int)var2_2, null);
    }

    public static void mergeSort(int[] a2) {
        int[] nArray;
        IntArrays.mergeSort(a2, 0, nArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void mergeSort(int[] a2, int from2, int to, IntComparator comp, int[] supp22) {
        int[] supp22;
        int n2 = to - from2;
        if (n2 < 16) {
            int supp22 = from2;
            while (++supp22 < to) {
                n2 = a2[supp22];
                int n3 = supp22;
                int n4 = a2[n3 - 1];
                while (comp.compare(n2, n4) < 0) {
                    a2[n3] = n4;
                    if (from2 == n3 - 1) {
                        --n3;
                        break;
                    }
                    n4 = a2[--n3 - 1];
                }
                a2[n3] = n2;
            }
            return;
        }
        if (supp22 == null) {
            supp22 = java.util.Arrays.copyOf(a2, to);
        }
        int n5 = from2 + to >>> 1;
        IntArrays.mergeSort(supp22, from2, n5, comp, a2);
        IntArrays.mergeSort(supp22, n5, to, comp, a2);
        if (comp.compare(supp22[n5 - 1], supp22[n5]) <= 0) {
            System.arraycopy(supp22, from2, a2, from2, n2);
            return;
        }
        int n6 = n5;
        for (n2 = from2; n2 < to; ++n2) {
            void var1_1;
            a2[n2] = n6 >= to || var1_1 < n5 && comp.compare(supp22[var1_1], supp22[n6]) <= 0 ? supp22[++var1_1] : supp22[n6++];
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void mergeSort(int[] a2, int from2, int to, IntComparator comp) {
        void var3_3;
        void var2_2;
        void var1_1;
        IntArrays.mergeSort(a2, (int)var1_1, (int)var2_2, (IntComparator)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void mergeSort(int[] a2, IntComparator comp) {
        void var1_1;
        int[] nArray;
        IntArrays.mergeSort(a2, 0, nArray.length, (IntComparator)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void stableSort(int[] a2, int from2, int to) {
        void var2_2;
        void var1_1;
        IntArrays.unstableSort(a2, (int)var1_1, (int)var2_2);
    }

    public static void stableSort(int[] a2) {
        int[] nArray;
        IntArrays.stableSort(a2, 0, nArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void stableSort(int[] a2, int from2, int to, IntComparator comp) {
        void var3_3;
        void var2_2;
        void var1_1;
        IntArrays.mergeSort(a2, (int)var1_1, (int)var2_2, (IntComparator)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static void stableSort(int[] a2, IntComparator comp) {
        void var1_1;
        int[] nArray;
        IntArrays.stableSort(a2, 0, nArray.length, (IntComparator)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int binarySearch(int[] a2, int from2, int to, int key) {
        void var1_1;
        --to;
        while (from2 <= to) {
            int n2 = from2 + to >>> 1;
            int n3 = a2[n2];
            if (n3 < key) {
                from2 = n2 + 1;
                continue;
            }
            if (n3 > key) {
                to = n2 - 1;
                continue;
            }
            return n2;
        }
        return (int)(-(var1_1 + true));
    }

    /*
     * WARNING - void declaration
     */
    public static int binarySearch(int[] a2, int key) {
        void var1_1;
        int[] nArray;
        return IntArrays.binarySearch(a2, 0, nArray.length, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int binarySearch(int[] a2, int from2, int to, int key, IntComparator c2) {
        void var1_1;
        --to;
        while (from2 <= to) {
            int n2 = from2 + to >>> 1;
            int n3 = a2[n2];
            if ((n3 = c2.compare(n3, key)) < 0) {
                from2 = n2 + 1;
                continue;
            }
            if (n3 > 0) {
                to = n2 - 1;
                continue;
            }
            return n2;
        }
        return (int)(-(var1_1 + true));
    }

    /*
     * WARNING - void declaration
     */
    public static int binarySearch(int[] a2, int key, IntComparator c2) {
        void var2_2;
        void var1_1;
        int[] nArray;
        return IntArrays.binarySearch(a2, 0, nArray.length, (int)var1_1, (IntComparator)var2_2);
    }

    public static void radixSort(int[] a2) {
        int[] nArray;
        IntArrays.radixSort(a2, 0, nArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void radixSort(int[] a2, int from2, int to) {
        void var1_1;
        void var2_3;
        if (to - from2 < 1024) {
            IntArrays.quickSort(a2, from2, to);
            return;
        }
        int n2 = 0;
        int[] nArray = new int[766];
        int[] nArray2 = new int[766];
        int[] nArray3 = new int[766];
        nArray[0] = from2;
        nArray2[0] = var2_3 - var1_1;
        ++n2;
        nArray3[0] = 0;
        int[] nArray4 = new int[256];
        int[] nArray5 = new int[256];
        while (n2 > 0) {
            int n3;
            int n4 = nArray[--n2];
            int n5 = nArray2[n2];
            int n6 = nArray3[n2];
            int n7 = n6 % 4 == 0 ? 128 : 0;
            int n8 = 3 - n6 % 4 << 3;
            int n9 = n4 + n5;
            while (n9-- != n4) {
                int n10 = a2[n9] >>> n8 & 0xFF ^ n7;
                nArray4[n10] = nArray4[n10] + 1;
            }
            n9 = -1;
            int n11 = n4;
            for (n3 = 0; n3 < 256; ++n3) {
                if (nArray4[n3] != 0) {
                    n9 = n3;
                }
                nArray5[n3] = n11 += nArray4[n3];
            }
            n3 = n4 + n5 - nArray4[n9];
            for (n11 = n4; n11 <= n3; n11 += nArray4[n4]) {
                n9 = a2[n11];
                n4 = n9 >>> n8 & 0xFF ^ n7;
                if (n11 < n3) {
                    while (true) {
                        int n12 = n4;
                        int n13 = nArray5[n12] - 1;
                        nArray5[n12] = n13;
                        n5 = n13;
                        if (n13 <= n11) break;
                        n4 = n9;
                        n9 = a2[n5];
                        a2[n5] = n4;
                        n4 = n9 >>> n8 & 0xFF ^ n7;
                    }
                    a2[n11] = n9;
                }
                if (n6 < 3 && nArray4[n4] > 1) {
                    if (nArray4[n4] < 1024) {
                        int n14 = n11;
                        IntArrays.quickSort(a2, n14, n14 + nArray4[n4]);
                    } else {
                        nArray[n2] = n11;
                        nArray2[n2] = nArray4[n4];
                        nArray3[n2++] = n6 + 1;
                    }
                }
                nArray4[n4] = 0;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void parallelRadixSort(int[] a2, int from2, int to) {
        void var1_2;
        int n2;
        Object object = IntArrays.a();
        if (to - from2 < 1024 || ((ForkJoinPool)object).getParallelism() == 1) {
            IntArrays.quickSort(a2, from2, to);
            return;
        }
        LinkedBlockingQueue<Segment> linkedBlockingQueue = new LinkedBlockingQueue<Segment>();
        linkedBlockingQueue.add(new Segment(from2, (int)(n2 - var1_2), 0));
        AtomicInteger atomicInteger = new AtomicInteger(1);
        n2 = ((ForkJoinPool)object).getParallelism();
        object = new ExecutorCompletionService((Executor)object);
        int n3 = n2;
        while (n3-- != 0) {
            ((ExecutorCompletionService)object).submit(() -> {
                int[] nArray2 = new int[256];
                int[] nArray3 = new int[256];
                while (true) {
                    int n3;
                    Segment segment;
                    int n4;
                    if (atomicInteger.get() == 0) {
                        n4 = n2;
                        while (n4-- != 0) {
                            linkedBlockingQueue.add(POISON_PILL);
                        }
                    }
                    if ((segment = (Segment)linkedBlockingQueue.take()) == POISON_PILL) {
                        return null;
                    }
                    int n5 = segment.a;
                    int n6 = segment.b;
                    n4 = segment.c;
                    int n7 = n4 % 4 == 0 ? 128 : 0;
                    int n8 = 3 - n4 % 4 << 3;
                    int n9 = n5 + n6;
                    while (n9-- != n5) {
                        int n10 = a2[n9] >>> n8 & 0xFF ^ n7;
                        nArray2[n10] = nArray2[n10] + 1;
                    }
                    n9 = -1;
                    int n11 = n5;
                    for (n3 = 0; n3 < 256; ++n3) {
                        if (nArray2[n3] != 0) {
                            n9 = n3;
                        }
                        nArray3[n3] = n11 += nArray2[n3];
                    }
                    n3 = n5 + n6 - nArray2[n9];
                    for (n11 = n5; n11 <= n3; n11 += nArray2[n5]) {
                        n9 = a2[n11];
                        n5 = n9 >>> n8 & 0xFF ^ n7;
                        if (n11 < n3) {
                            while (true) {
                                int n12 = n5;
                                int n13 = nArray3[n12] - 1;
                                nArray3[n12] = n13;
                                n6 = n13;
                                if (n13 <= n11) break;
                                n5 = n9;
                                n9 = a2[n6];
                                nArray[n6] = n5;
                                n5 = n9 >>> n8 & 0xFF ^ n7;
                            }
                            nArray[n11] = n9;
                        }
                        if (n4 < 3 && nArray2[n5] > 1) {
                            if (nArray2[n5] < 1024) {
                                int n14 = n11;
                                IntArrays.quickSort(a2, n14, n14 + nArray2[n5]);
                            } else {
                                atomicInteger.incrementAndGet();
                                linkedBlockingQueue.add(new Segment(n11, nArray2[n5], n4 + 1));
                            }
                        }
                        nArray2[n5] = 0;
                    }
                    atomicInteger.decrementAndGet();
                }
            });
        }
        Throwable throwable = null;
        int n4 = n2;
        while (n4-- != 0) {
            try {
                ((ExecutorCompletionService)object).take().get();
            }
            catch (Exception exception) {
                throwable = exception.getCause();
            }
        }
        if (throwable != null) {
            throw throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException(throwable);
        }
    }

    public static void parallelRadixSort(int[] a2) {
        int[] nArray;
        IntArrays.parallelRadixSort(a2, 0, nArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void radixSortIndirect(int[] perm, int[] a2, boolean stable) {
        void var2_2;
        int[] nArray;
        void var1_1;
        IntArrays.radixSortIndirect(perm, (int[])var1_1, 0, nArray.length, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void radixSortIndirect(int[] perm, int[] a2, int from2, int to, boolean stable) {
        int[] nArray;
        void var2_2;
        void var3_4;
        if (to - from2 < 1024) {
            IntArrays.quickSortIndirect(perm, a2, from2, to);
            if (stable) {
                IntArrays.stabilize(perm, a2, from2, to);
            }
            return;
        }
        int n2 = 0;
        int[] nArray2 = new int[766];
        int[] nArray3 = new int[766];
        int[] nArray4 = new int[766];
        nArray2[0] = from2;
        nArray3[0] = var3_4 - var2_2;
        ++n2;
        nArray4[0] = 0;
        int[] nArray5 = new int[256];
        int[] nArray6 = new int[256];
        int[] nArray7 = nArray = stable ? new int[perm.length] : null;
        while (n2 > 0) {
            int n3;
            int n4;
            int n5 = nArray2[--n2];
            int n6 = nArray3[n2];
            int n7 = nArray4[n2];
            int n8 = n7 % 4 == 0 ? 128 : 0;
            int n9 = 3 - n7 % 4 << 3;
            int n10 = n5 + n6;
            while (n10-- != n5) {
                int n11 = a2[perm[n10]] >>> n9 & 0xFF ^ n8;
                nArray5[n11] = nArray5[n11] + 1;
            }
            n10 = -1;
            int n12 = n4 = stable ? 0 : n5;
            for (n3 = 0; n3 < 256; ++n3) {
                if (nArray5[n3] != 0) {
                    n10 = n3;
                }
                nArray6[n3] = n4 += nArray5[n3];
            }
            if (stable) {
                n3 = n5 + n6;
                while (n3-- != n5) {
                    int n13 = a2[perm[n3]] >>> n9 & 0xFF ^ n8;
                    int n14 = nArray6[n13] - 1;
                    nArray6[n13] = n14;
                    nArray[n14] = perm[n3];
                }
                System.arraycopy(nArray, 0, perm, n5, n6);
                n4 = n5;
                for (n3 = 0; n3 <= n10; ++n3) {
                    if (n7 < 3 && nArray5[n3] > 1) {
                        if (nArray5[n3] < 1024) {
                            int n15 = n4;
                            IntArrays.quickSortIndirect(perm, a2, n15, n15 + nArray5[n3]);
                            if (stable) {
                                int n16 = n4;
                                IntArrays.stabilize(perm, a2, n16, n16 + nArray5[n3]);
                            }
                        } else {
                            nArray2[n2] = n4;
                            nArray3[n2] = nArray5[n3];
                            nArray4[n2++] = n7 + 1;
                        }
                    }
                    n4 += nArray5[n3];
                }
                java.util.Arrays.fill(nArray5, 0);
                continue;
            }
            n3 = n5 + n6 - nArray5[n10];
            for (n4 = n5; n4 <= n3; n4 += nArray5[n5]) {
                n10 = perm[n4];
                n5 = a2[n10] >>> n9 & 0xFF ^ n8;
                if (n4 < n3) {
                    while (true) {
                        int n17 = n5;
                        int n18 = nArray6[n17] - 1;
                        nArray6[n17] = n18;
                        n6 = n18;
                        if (n18 <= n4) break;
                        n5 = n10;
                        n10 = perm[n6];
                        perm[n6] = n5;
                        n5 = a2[n10] >>> n9 & 0xFF ^ n8;
                    }
                    perm[n4] = n10;
                }
                if (n7 < 3 && nArray5[n5] > 1) {
                    if (nArray5[n5] < 1024) {
                        int n19 = n4;
                        IntArrays.quickSortIndirect(perm, a2, n19, n19 + nArray5[n5]);
                        if (stable) {
                            int n20 = n4;
                            IntArrays.stabilize(perm, a2, n20, n20 + nArray5[n5]);
                        }
                    } else {
                        nArray2[n2] = n4;
                        nArray3[n2] = nArray5[n5];
                        nArray4[n2++] = n7 + 1;
                    }
                }
                nArray5[n5] = 0;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void parallelRadixSortIndirect(int[] perm, int[] a2, int from2, int to, boolean stable) {
        void var2_3;
        int n2;
        Object object = IntArrays.a();
        if (to - from2 < 1024 || ((ForkJoinPool)object).getParallelism() == 1) {
            IntArrays.radixSortIndirect(perm, a2, from2, to, stable);
            return;
        }
        LinkedBlockingQueue<Segment> linkedBlockingQueue = new LinkedBlockingQueue<Segment>();
        linkedBlockingQueue.add(new Segment(from2, (int)(n2 - var2_3), 0));
        AtomicInteger atomicInteger = new AtomicInteger(1);
        n2 = ((ForkJoinPool)object).getParallelism();
        object = new ExecutorCompletionService((Executor)object);
        int[] nArray = stable ? new int[perm.length] : null;
        int n3 = n2;
        while (n3-- != 0) {
            ((ExecutorCompletionService)object).submit(() -> {
                int[] nArray4 = new int[256];
                int[] nArray5 = new int[256];
                while (true) {
                    int n3;
                    Segment segment;
                    int n4;
                    if (atomicInteger.get() == 0) {
                        n4 = n2;
                        while (n4-- != 0) {
                            linkedBlockingQueue.add(POISON_PILL);
                        }
                    }
                    if ((segment = (Segment)linkedBlockingQueue.take()) == POISON_PILL) {
                        return null;
                    }
                    int n5 = segment.a;
                    int n6 = segment.b;
                    n4 = segment.c;
                    int n7 = n4 % 4 == 0 ? 128 : 0;
                    int n8 = 3 - n4 % 4 << 3;
                    int n9 = n5 + n6;
                    while (n9-- != n5) {
                        int n10 = a2[perm[n9]] >>> n8 & 0xFF ^ n7;
                        nArray4[n10] = nArray4[n10] + 1;
                    }
                    n9 = -1;
                    int n11 = n5;
                    for (n3 = 0; n3 < 256; ++n3) {
                        if (nArray4[n3] != 0) {
                            n9 = n3;
                        }
                        nArray5[n3] = n11 += nArray4[n3];
                    }
                    if (stable) {
                        n3 = n5 + n6;
                        while (n3-- != n5) {
                            int n12 = a2[perm[n3]] >>> n8 & 0xFF ^ n7;
                            int n13 = nArray5[n12] - 1;
                            nArray5[n12] = n13;
                            nArray3[n13] = perm[n3];
                        }
                        System.arraycopy(nArray, n5, perm, n5, n6);
                        n11 = n5;
                        for (n3 = 0; n3 <= n9; ++n3) {
                            if (n4 < 3 && nArray4[n3] > 1) {
                                if (nArray4[n3] < 1024) {
                                    int n14 = n11;
                                    IntArrays.radixSortIndirect(perm, a2, n14, n14 + nArray4[n3], stable);
                                } else {
                                    atomicInteger.incrementAndGet();
                                    linkedBlockingQueue.add(new Segment(n11, nArray4[n3], n4 + 1));
                                }
                            }
                            n11 += nArray4[n3];
                        }
                        java.util.Arrays.fill(nArray4, 0);
                    } else {
                        n3 = n5 + n6 - nArray4[n9];
                        for (n11 = n5; n11 <= n3; n11 += nArray4[n5]) {
                            n9 = perm[n11];
                            n5 = a2[n9] >>> n8 & 0xFF ^ n7;
                            if (n11 < n3) {
                                while (true) {
                                    int n15 = n5;
                                    int n16 = nArray5[n15] - 1;
                                    nArray5[n15] = n16;
                                    n6 = n16;
                                    if (n16 <= n11) break;
                                    n5 = n9;
                                    n9 = perm[n6];
                                    nArray2[n6] = n5;
                                    n5 = a2[n9] >>> n8 & 0xFF ^ n7;
                                }
                                nArray2[n11] = n9;
                            }
                            if (n4 < 3 && nArray4[n5] > 1) {
                                if (nArray4[n5] < 1024) {
                                    int n17 = n11;
                                    IntArrays.radixSortIndirect(perm, a2, n17, n17 + nArray4[n5], stable);
                                } else {
                                    atomicInteger.incrementAndGet();
                                    linkedBlockingQueue.add(new Segment(n11, nArray4[n5], n4 + 1));
                                }
                            }
                            nArray4[n5] = 0;
                        }
                    }
                    atomicInteger.decrementAndGet();
                }
            });
        }
        Throwable throwable = null;
        int n4 = n2;
        while (n4-- != 0) {
            try {
                ((ExecutorCompletionService)object).take().get();
            }
            catch (Exception exception) {
                throwable = exception.getCause();
            }
        }
        if (throwable != null) {
            throw throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException(throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void parallelRadixSortIndirect(int[] perm, int[] a2, boolean stable) {
        void var2_2;
        void var1_1;
        IntArrays.parallelRadixSortIndirect(perm, a2, 0, ((void)var1_1).length, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void radixSort(int[] a2, int[] b2) {
        int[] nArray;
        void var1_1;
        IntArrays.ensureSameLength(a2, b2);
        IntArrays.radixSort(a2, (int[])var1_1, 0, nArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void radixSort(int[] a2, int[] b2, int from2, int to) {
        void var2_2;
        void var3_4;
        if (to - from2 < 1024) {
            IntArrays.quickSort(a2, b2, from2, to);
            return;
        }
        int n2 = 0;
        int[] nArray = new int[1786];
        int[] nArray2 = new int[1786];
        int[] nArray3 = new int[1786];
        nArray[0] = from2;
        nArray2[0] = var3_4 - var2_2;
        ++n2;
        nArray3[0] = 0;
        int[] nArray4 = new int[256];
        int[] nArray5 = new int[256];
        while (n2 > 0) {
            int n3;
            int n4 = nArray[--n2];
            int n5 = nArray2[n2];
            int n6 = nArray3[n2];
            int n7 = n6 % 4 == 0 ? 128 : 0;
            int[] nArray6 = n6 < 4 ? a2 : b2;
            int n8 = 3 - n6 % 4 << 3;
            int n9 = n4 + n5;
            while (n9-- != n4) {
                int n10 = nArray6[n9] >>> n8 & 0xFF ^ n7;
                nArray4[n10] = nArray4[n10] + 1;
            }
            n9 = -1;
            int n11 = n4;
            for (n3 = 0; n3 < 256; ++n3) {
                if (nArray4[n3] != 0) {
                    n9 = n3;
                }
                nArray5[n3] = n11 += nArray4[n3];
            }
            n3 = n4 + n5 - nArray4[n9];
            for (n11 = n4; n11 <= n3; n11 += nArray4[n4]) {
                n9 = a2[n11];
                int n12 = b2[n11];
                n4 = nArray6[n11] >>> n8 & 0xFF ^ n7;
                if (n11 < n3) {
                    while (true) {
                        int n13 = n4;
                        int n14 = nArray5[n13] - 1;
                        nArray5[n13] = n14;
                        n5 = n14;
                        if (n14 <= n11) break;
                        n4 = nArray6[n5] >>> n8 & 0xFF ^ n7;
                        int n15 = n9;
                        n9 = a2[n5];
                        a2[n5] = n15;
                        n15 = n12;
                        n12 = b2[n5];
                        b2[n5] = n15;
                    }
                    a2[n11] = n9;
                    b2[n11] = n12;
                }
                if (n6 < 7 && nArray4[n4] > 1) {
                    if (nArray4[n4] < 1024) {
                        int n16 = n11;
                        IntArrays.quickSort(a2, b2, n16, n16 + nArray4[n4]);
                    } else {
                        nArray[n2] = n11;
                        nArray2[n2] = nArray4[n4];
                        nArray3[n2++] = n6 + 1;
                    }
                }
                nArray4[n4] = 0;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void parallelRadixSort(int[] a2, int[] b2, int from2, int to) {
        void var2_3;
        int n2;
        Object object = IntArrays.a();
        if (to - from2 < 1024 || ((ForkJoinPool)object).getParallelism() == 1) {
            IntArrays.quickSort(a2, b2, from2, to);
            return;
        }
        if (a2.length != b2.length) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        LinkedBlockingQueue<Segment> linkedBlockingQueue = new LinkedBlockingQueue<Segment>();
        linkedBlockingQueue.add(new Segment(from2, (int)(n2 - var2_3), 0));
        AtomicInteger atomicInteger = new AtomicInteger(1);
        n2 = ((ForkJoinPool)object).getParallelism();
        object = new ExecutorCompletionService((Executor)object);
        int n3 = n2;
        while (n3-- != 0) {
            ((ExecutorCompletionService)object).submit(() -> {
                int[] nArray3 = new int[256];
                int[] nArray4 = new int[256];
                while (true) {
                    int n3;
                    Segment segment;
                    int n4;
                    if (atomicInteger.get() == 0) {
                        n4 = n2;
                        while (n4-- != 0) {
                            linkedBlockingQueue.add(POISON_PILL);
                        }
                    }
                    if ((segment = (Segment)linkedBlockingQueue.take()) == POISON_PILL) {
                        return null;
                    }
                    int n5 = segment.a;
                    int n6 = segment.b;
                    n4 = segment.c;
                    int n7 = n4 % 4 == 0 ? 128 : 0;
                    int[] nArray5 = n4 < 4 ? a2 : b2;
                    int n8 = 3 - n4 % 4 << 3;
                    int n9 = n5 + n6;
                    while (n9-- != n5) {
                        int n10 = nArray5[n9] >>> n8 & 0xFF ^ n7;
                        nArray3[n10] = nArray3[n10] + 1;
                    }
                    n9 = -1;
                    int n11 = n5;
                    for (n3 = 0; n3 < 256; ++n3) {
                        if (nArray3[n3] != 0) {
                            n9 = n3;
                        }
                        nArray4[n3] = n11 += nArray3[n3];
                    }
                    n3 = n5 + n6 - nArray3[n9];
                    for (n11 = n5; n11 <= n3; n11 += nArray3[n5]) {
                        n9 = a2[n11];
                        int n12 = b2[n11];
                        n5 = nArray5[n11] >>> n8 & 0xFF ^ n7;
                        if (n11 < n3) {
                            while (true) {
                                int n13 = n5;
                                int n14 = nArray4[n13] - 1;
                                nArray4[n13] = n14;
                                n6 = n14;
                                if (n14 <= n11) break;
                                n5 = nArray5[n6] >>> n8 & 0xFF ^ n7;
                                int n15 = n9;
                                int n16 = n12;
                                n9 = a2[n6];
                                n12 = b2[n6];
                                nArray[n6] = n15;
                                nArray2[n6] = n16;
                            }
                            nArray[n11] = n9;
                            nArray2[n11] = n12;
                        }
                        if (n4 < 7 && nArray3[n5] > 1) {
                            if (nArray3[n5] < 1024) {
                                int n17 = n11;
                                IntArrays.quickSort(a2, b2, n17, n17 + nArray3[n5]);
                            } else {
                                atomicInteger.incrementAndGet();
                                linkedBlockingQueue.add(new Segment(n11, nArray3[n5], n4 + 1));
                            }
                        }
                        nArray3[n5] = 0;
                    }
                    atomicInteger.decrementAndGet();
                }
            });
        }
        Throwable throwable = null;
        int n4 = n2;
        while (n4-- != 0) {
            try {
                ((ExecutorCompletionService)object).take().get();
            }
            catch (Exception exception) {
                throwable = exception.getCause();
            }
        }
        if (throwable != null) {
            throw throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException(throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void parallelRadixSort(int[] a2, int[] b2) {
        int[] nArray;
        void var1_1;
        IntArrays.ensureSameLength(a2, b2);
        IntArrays.parallelRadixSort(a2, (int[])var1_1, 0, nArray.length);
    }

    private static void a(int[] nArray, int[] nArray2, int[] nArray3, int n2, int n3) {
        int n4 = n2;
        while (++n4 < n3) {
            int n5 = nArray[n4];
            int n6 = n4;
            int n7 = nArray[n6 - 1];
            while (nArray2[n5] < nArray2[n7] || nArray2[n5] == nArray2[n7] && nArray3[n5] < nArray3[n7]) {
                nArray[n6] = n7;
                if (n2 == n6 - 1) {
                    --n6;
                    break;
                }
                n7 = nArray[--n6 - 1];
            }
            nArray[n6] = n5;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void radixSortIndirect(int[] perm, int[] a2, int[] b2, boolean stable) {
        void var3_3;
        void var1_1;
        void var2_2;
        int[] nArray;
        IntArrays.ensureSameLength(a2, b2);
        IntArrays.radixSortIndirect(nArray, a2, (int[])var2_2, 0, ((void)var1_1).length, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static void radixSortIndirect(int[] perm, int[] a2, int[] b2, int from2, int to, boolean stable) {
        int[] nArray;
        void var3_3;
        if (to - from2 < 64) {
            IntArrays.a(perm, a2, b2, from2, to);
            return;
        }
        int n2 = 0;
        int[] nArray2 = new int[1786];
        int[] nArray3 = new int[1786];
        int[] nArray4 = new int[1786];
        nArray2[0] = from2;
        nArray3[0] = to - var3_3;
        ++n2;
        nArray4[0] = 0;
        int[] nArray5 = new int[256];
        int[] nArray6 = new int[256];
        int[] nArray7 = nArray = stable ? new int[perm.length] : null;
        while (n2 > 0) {
            int n3;
            int n4;
            int n5 = nArray2[--n2];
            int n6 = nArray3[n2];
            int n7 = nArray4[n2];
            int n8 = n7 % 4 == 0 ? 128 : 0;
            int[] nArray8 = n7 < 4 ? a2 : b2;
            int n9 = 3 - n7 % 4 << 3;
            int n10 = n5 + n6;
            while (n10-- != n5) {
                int n11 = nArray8[perm[n10]] >>> n9 & 0xFF ^ n8;
                nArray5[n11] = nArray5[n11] + 1;
            }
            n10 = -1;
            int n12 = n4 = stable ? 0 : n5;
            for (n3 = 0; n3 < 256; ++n3) {
                if (nArray5[n3] != 0) {
                    n10 = n3;
                }
                nArray6[n3] = n4 += nArray5[n3];
            }
            if (stable) {
                n3 = n5 + n6;
                while (n3-- != n5) {
                    int n13 = nArray8[perm[n3]] >>> n9 & 0xFF ^ n8;
                    int n14 = nArray6[n13] - 1;
                    nArray6[n13] = n14;
                    nArray[n14] = perm[n3];
                }
                System.arraycopy(nArray, 0, perm, n5, n6);
                n4 = n5;
                for (n3 = 0; n3 < 256; ++n3) {
                    if (n7 < 7 && nArray5[n3] > 1) {
                        if (nArray5[n3] < 64) {
                            int n15 = n4;
                            IntArrays.a(perm, a2, b2, n15, n15 + nArray5[n3]);
                        } else {
                            nArray2[n2] = n4;
                            nArray3[n2] = nArray5[n3];
                            nArray4[n2++] = n7 + 1;
                        }
                    }
                    n4 += nArray5[n3];
                }
                java.util.Arrays.fill(nArray5, 0);
                continue;
            }
            n3 = n5 + n6 - nArray5[n10];
            for (n4 = n5; n4 <= n3; n4 += nArray5[n5]) {
                n10 = perm[n4];
                n5 = nArray8[n10] >>> n9 & 0xFF ^ n8;
                if (n4 < n3) {
                    while (true) {
                        int n16 = n5;
                        int n17 = nArray6[n16] - 1;
                        nArray6[n16] = n17;
                        n6 = n17;
                        if (n17 <= n4) break;
                        n5 = n10;
                        n10 = perm[n6];
                        perm[n6] = n5;
                        n5 = nArray8[n10] >>> n9 & 0xFF ^ n8;
                    }
                    perm[n4] = n10;
                }
                if (n7 < 7 && nArray5[n5] > 1) {
                    if (nArray5[n5] < 64) {
                        int n18 = n4;
                        IntArrays.a(perm, a2, b2, n18, n18 + nArray5[n5]);
                    } else {
                        nArray2[n2] = n4;
                        nArray3[n2] = nArray5[n5];
                        nArray4[n2++] = n7 + 1;
                    }
                }
                nArray5[n5] = 0;
            }
        }
    }

    private static void a(int[][] nArray, int n2, int n3, int n4) {
        int n5 = nArray.length;
        n4 /= 4;
        while (n2 < n3 - 1) {
            int n6;
            int n7;
            int n8 = n2;
            block1: for (n7 = n2 + 1; n7 < n3; ++n7) {
                for (n6 = n4; n6 < n5; ++n6) {
                    if (nArray[n6][n7] < nArray[n6][n8]) {
                        n8 = n7;
                        continue block1;
                    }
                    if (nArray[n6][n7] > nArray[n6][n8]) continue block1;
                }
            }
            if (n8 != n2) {
                n7 = n5;
                while (n7-- != 0) {
                    n6 = nArray[n7][n2];
                    nArray[n7][n2] = nArray[n7][n8];
                    nArray[n7][n8] = n6;
                }
            }
            ++n2;
        }
    }

    public static void radixSort(int[][] a2) {
        int[][] nArray;
        IntArrays.radixSort(a2, 0, nArray[0].length);
    }

    /*
     * WARNING - void declaration
     */
    public static void radixSort(int[][] a2, int from2, int to) {
        void var1_1;
        void var2_3;
        if (to - from2 < 64) {
            IntArrays.a(a2, from2, to, 0);
            return;
        }
        int n2 = a2.length;
        int n3 = 4 * n2 - 1;
        int n4 = n2;
        int n5 = a2[0].length;
        while (n4-- != 0) {
            if (a2[n4].length == n5) continue;
            throw new IllegalArgumentException("The array of index " + n4 + " has not the same length of the array of index 0.");
        }
        n4 = 255 * ((n2 << 2) - 1) + 1;
        n5 = 0;
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        int[] nArray3 = new int[n4];
        nArray[0] = from2;
        nArray2[0] = var2_3 - var1_1;
        ++n5;
        nArray3[0] = 0;
        int[] nArray4 = new int[256];
        int[] nArray5 = new int[256];
        int[] nArray6 = new int[n2];
        while (n5 > 0) {
            int n6;
            int n7 = nArray[--n5];
            int n8 = nArray2[n5];
            int n9 = nArray3[n5];
            int n10 = n9 % 4 == 0 ? 128 : 0;
            int[] nArray7 = a2[n9 / 4];
            int n11 = 3 - n9 % 4 << 3;
            int n12 = n7 + n8;
            while (n12-- != n7) {
                int n13 = nArray7[n12] >>> n11 & 0xFF ^ n10;
                nArray4[n13] = nArray4[n13] + 1;
            }
            n12 = -1;
            int n14 = n7;
            for (n6 = 0; n6 < 256; ++n6) {
                if (nArray4[n6] != 0) {
                    n12 = n6;
                }
                nArray5[n6] = n14 += nArray4[n6];
            }
            n6 = n7 + n8 - nArray4[n12];
            for (n14 = n7; n14 <= n6; n14 += nArray4[n7]) {
                n12 = n2;
                while (n12-- != 0) {
                    nArray6[n12] = a2[n12][n14];
                }
                n7 = nArray7[n14] >>> n11 & 0xFF ^ n10;
                if (n14 < n6) {
                    block6: while (true) {
                        int n15 = n7;
                        int n16 = nArray5[n15] - 1;
                        nArray5[n15] = n16;
                        n8 = n16;
                        if (n16 <= n14) break;
                        n7 = nArray7[n8] >>> n11 & 0xFF ^ n10;
                        n12 = n2;
                        while (true) {
                            if (n12-- == 0) continue block6;
                            int n17 = nArray6[n12];
                            nArray6[n12] = a2[n12][n8];
                            a2[n12][n8] = n17;
                        }
                        break;
                    }
                    n12 = n2;
                    while (n12-- != 0) {
                        a2[n12][n14] = nArray6[n12];
                    }
                }
                if (n9 < n3 && nArray4[n7] > 1) {
                    if (nArray4[n7] < 64) {
                        int n18 = n14;
                        IntArrays.a(a2, n18, n18 + nArray4[n7], n9 + 1);
                    } else {
                        nArray[n5] = n14;
                        nArray2[n5] = nArray4[n7];
                        nArray3[n5++] = n9 + 1;
                    }
                }
                nArray4[n7] = 0;
            }
        }
    }

    public static int[] shuffle(int[] a2, int from2, int to, Random random2) {
        int[] nArray;
        int n2 = to - from2;
        while (n2-- != 0) {
            int n3 = random2.nextInt(n2 + 1);
            int n4 = a2[from2 + n2];
            a2[from2 + n2] = a2[from2 + n3];
            a2[from2 + n3] = n4;
        }
        return nArray;
    }

    public static int[] shuffle(int[] a2, Random random2) {
        int[] nArray;
        int n2 = a2.length;
        while (n2-- != 0) {
            int n3 = random2.nextInt(n2 + 1);
            int n4 = a2[n2];
            a2[n2] = a2[n3];
            a2[n3] = n4;
        }
        return nArray;
    }

    public static int[] reverse(int[] a2) {
        int[] nArray;
        int n2 = a2.length;
        int n3 = n2 / 2;
        while (n3-- != 0) {
            int n4 = a2[n2 - n3 - 1];
            a2[n2 - n3 - 1] = a2[n3];
            a2[n3] = n4;
        }
        return nArray;
    }

    public static int[] reverse(int[] a2, int from2, int to) {
        int[] nArray;
        int n2 = to - from2;
        int n3 = n2 / 2;
        while (n3-- != 0) {
            int n4 = a2[from2 + n2 - n3 - 1];
            a2[from2 + n2 - n3 - 1] = a2[from2 + n3];
            a2[from2 + n3] = n4;
        }
        return nArray;
    }

    protected static final class d
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int a;
        private final int b;
        private final int[] c;
        private final IntComparator d;

        public d(int[] nArray, int n2, int n3, IntComparator intComparator) {
            this.a = n2;
            this.b = n3;
            this.c = nArray;
            this.d = intComparator;
        }

        @Override
        protected final void compute() {
            int n2;
            int[] nArray = this.c;
            int n3 = this.b - this.a;
            if (n3 < 8192) {
                IntArrays.quickSort(nArray, this.a, this.b, this.d);
                return;
            }
            int n4 = this.a + n3 / 2;
            int n5 = this.a;
            int n6 = this.b - 1;
            int n7 = n5;
            n5 = IntArrays.b(nArray, n7, n7 + (n3 /= 8), n5 + 2 * n3, this.d);
            int n8 = n4;
            n4 = IntArrays.b(nArray, n4 - n3, n8, n8 + n3, this.d);
            n6 = IntArrays.b(nArray, n6 - 2 * n3, n6 - n3, n6, this.d);
            n4 = IntArrays.b(nArray, n5, n4, n6, this.d);
            n3 = nArray[n4];
            n5 = n4 = this.a;
            int n9 = n6 = this.b - 1;
            while (true) {
                if (n5 <= n6 && (n2 = this.d.compare(nArray[n5], n3)) <= 0) {
                    if (n2 == 0) {
                        IntArrays.swap(nArray, n4++, n5);
                    }
                    ++n5;
                    continue;
                }
                while (n6 >= n5 && (n2 = this.d.compare(nArray[n6], n3)) >= 0) {
                    if (n2 == 0) {
                        IntArrays.swap(nArray, n6, n9--);
                    }
                    --n6;
                }
                if (n5 > n6) break;
                IntArrays.swap(nArray, n5++, n6--);
            }
            n3 = Math.min(n4 - this.a, n5 - n4);
            IntArrays.swap(nArray, this.a, n5 - n3, n3);
            n3 = Math.min(n9 - n6, this.b - n9 - 1);
            IntArrays.swap(nArray, n5, this.b - n3, n3);
            n3 = n5 - n4;
            n2 = n9 - n6;
            if (n3 > 1 && n2 > 1) {
                it.unimi.dsi.fastutil.ints.IntArrays$d.invokeAll(new d(nArray, this.a, this.a + n3, this.d), new d(nArray, this.b - n2, this.b, this.d));
                return;
            }
            if (n3 > 1) {
                it.unimi.dsi.fastutil.ints.IntArrays$d.invokeAll(new d(nArray, this.a, this.a + n3, this.d));
                return;
            }
            it.unimi.dsi.fastutil.ints.IntArrays$d.invokeAll(new d(nArray, this.b - n2, this.b, this.d));
        }
    }

    protected static final class b
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int a;
        private final int b;
        private final int[] c;

        public b(int[] nArray, int n2, int n3) {
            this.a = n2;
            this.b = n3;
            this.c = nArray;
        }

        @Override
        protected final void compute() {
            int n2;
            int[] nArray = this.c;
            int n3 = this.b - this.a;
            if (n3 < 8192) {
                IntArrays.quickSort(nArray, this.a, this.b);
                return;
            }
            int n4 = this.a + n3 / 2;
            int n5 = this.a;
            int n6 = this.b - 1;
            int n7 = n5;
            n5 = IntArrays.b(nArray, n7, n7 + (n3 /= 8), n5 + 2 * n3);
            int n8 = n4;
            n4 = IntArrays.b(nArray, n4 - n3, n8, n8 + n3);
            n6 = IntArrays.b(nArray, n6 - 2 * n3, n6 - n3, n6);
            n4 = IntArrays.b(nArray, n5, n4, n6);
            n3 = nArray[n4];
            n5 = n4 = this.a;
            int n9 = n6 = this.b - 1;
            while (true) {
                if (n5 <= n6 && (n2 = Integer.compare(nArray[n5], n3)) <= 0) {
                    if (n2 == 0) {
                        IntArrays.swap(nArray, n4++, n5);
                    }
                    ++n5;
                    continue;
                }
                while (n6 >= n5 && (n2 = Integer.compare(nArray[n6], n3)) >= 0) {
                    if (n2 == 0) {
                        IntArrays.swap(nArray, n6, n9--);
                    }
                    --n6;
                }
                if (n5 > n6) break;
                IntArrays.swap(nArray, n5++, n6--);
            }
            n3 = Math.min(n4 - this.a, n5 - n4);
            IntArrays.swap(nArray, this.a, n5 - n3, n3);
            n3 = Math.min(n9 - n6, this.b - n9 - 1);
            IntArrays.swap(nArray, n5, this.b - n3, n3);
            n3 = n5 - n4;
            n2 = n9 - n6;
            if (n3 > 1 && n2 > 1) {
                it.unimi.dsi.fastutil.ints.IntArrays$b.invokeAll(new b(nArray, this.a, this.a + n3), new b(nArray, this.b - n2, this.b));
                return;
            }
            if (n3 > 1) {
                it.unimi.dsi.fastutil.ints.IntArrays$b.invokeAll(new b(nArray, this.a, this.a + n3));
                return;
            }
            it.unimi.dsi.fastutil.ints.IntArrays$b.invokeAll(new b(nArray, this.b - n2, this.b));
        }
    }

    protected static final class e
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int a;
        private final int b;
        private final int[] c;
        private final int[] d;

        public e(int[] nArray, int[] nArray2, int n2, int n3) {
            this.a = n2;
            this.b = n3;
            this.d = nArray2;
            this.c = nArray;
        }

        @Override
        protected final void compute() {
            int n2;
            int[] nArray = this.d;
            int n3 = this.b - this.a;
            if (n3 < 8192) {
                IntArrays.quickSortIndirect(this.c, nArray, this.a, this.b);
                return;
            }
            int n4 = this.a + n3 / 2;
            int n5 = this.a;
            int n6 = this.b - 1;
            int n7 = n5;
            n5 = IntArrays.d(this.c, nArray, n7, n7 + (n3 /= 8), n5 + 2 * n3);
            int n8 = n4;
            n4 = IntArrays.d(this.c, nArray, n4 - n3, n8, n8 + n3);
            n6 = IntArrays.d(this.c, nArray, n6 - 2 * n3, n6 - n3, n6);
            n4 = IntArrays.d(this.c, nArray, n5, n4, n6);
            n3 = nArray[this.c[n4]];
            n5 = n4 = this.a;
            int n9 = n6 = this.b - 1;
            while (true) {
                if (n5 <= n6 && (n2 = Integer.compare(nArray[this.c[n5]], n3)) <= 0) {
                    if (n2 == 0) {
                        IntArrays.swap(this.c, n4++, n5);
                    }
                    ++n5;
                    continue;
                }
                while (n6 >= n5 && (n2 = Integer.compare(nArray[this.c[n6]], n3)) >= 0) {
                    if (n2 == 0) {
                        IntArrays.swap(this.c, n6, n9--);
                    }
                    --n6;
                }
                if (n5 > n6) break;
                IntArrays.swap(this.c, n5++, n6--);
            }
            n3 = Math.min(n4 - this.a, n5 - n4);
            IntArrays.swap(this.c, this.a, n5 - n3, n3);
            n3 = Math.min(n9 - n6, this.b - n9 - 1);
            IntArrays.swap(this.c, n5, this.b - n3, n3);
            n3 = n5 - n4;
            n2 = n9 - n6;
            if (n3 > 1 && n2 > 1) {
                e.invokeAll(new e(this.c, nArray, this.a, this.a + n3), new e(this.c, nArray, this.b - n2, this.b));
                return;
            }
            if (n3 > 1) {
                e.invokeAll(new e(this.c, nArray, this.a, this.a + n3));
                return;
            }
            e.invokeAll(new e(this.c, nArray, this.b - n2, this.b));
        }
    }

    protected static final class c
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int a;
        private final int b;
        private final int[] c;
        private final int[] d;

        public c(int[] nArray, int[] nArray2, int n2, int n3) {
            this.a = n2;
            this.b = n3;
            this.c = nArray;
            this.d = nArray2;
        }

        @Override
        protected final void compute() {
            int n2;
            int n3;
            int[] nArray = this.c;
            int[] nArray2 = this.d;
            int n4 = this.b - this.a;
            if (n4 < 8192) {
                IntArrays.quickSort(nArray, nArray2, this.a, this.b);
                return;
            }
            int n5 = this.a + n4 / 2;
            int n6 = this.a;
            int n7 = this.b - 1;
            int n8 = n6;
            n6 = IntArrays.e(nArray, nArray2, n8, n8 + (n4 /= 8), n6 + 2 * n4);
            int n9 = n5;
            n5 = IntArrays.e(nArray, nArray2, n5 - n4, n9, n9 + n4);
            n7 = IntArrays.e(nArray, nArray2, n7 - 2 * n4, n7 - n4, n7);
            n5 = IntArrays.e(nArray, nArray2, n6, n5, n7);
            n4 = nArray[n5];
            n5 = nArray2[n5];
            n7 = n6 = this.a;
            int n10 = n3 = this.b - 1;
            while (true) {
                if (n7 <= n3 && (n2 = (n2 = Integer.compare(nArray[n7], n4)) == 0 ? Integer.compare(nArray2[n7], n5) : n2) <= 0) {
                    if (n2 == 0) {
                        IntArrays.b(nArray, nArray2, n6++, n7);
                    }
                    ++n7;
                    continue;
                }
                while (n3 >= n7 && (n2 = (n2 = Integer.compare(nArray[n3], n4)) == 0 ? Integer.compare(nArray2[n3], n5) : n2) >= 0) {
                    if (n2 == 0) {
                        IntArrays.b(nArray, nArray2, n3, n10--);
                    }
                    --n3;
                }
                if (n7 > n3) break;
                IntArrays.b(nArray, nArray2, n7++, n3--);
            }
            n4 = Math.min(n6 - this.a, n7 - n6);
            IntArrays.f(nArray, nArray2, this.a, n7 - n4, n4);
            n4 = Math.min(n10 - n3, this.b - n10 - 1);
            IntArrays.f(nArray, nArray2, n7, this.b - n4, n4);
            n4 = n7 - n6;
            n2 = n10 - n3;
            if (n4 > 1 && n2 > 1) {
                it.unimi.dsi.fastutil.ints.IntArrays$c.invokeAll(new c(nArray, nArray2, this.a, this.a + n4), new c(nArray, nArray2, this.b - n2, this.b));
                return;
            }
            if (n4 > 1) {
                it.unimi.dsi.fastutil.ints.IntArrays$c.invokeAll(new c(nArray, nArray2, this.a, this.a + n4));
                return;
            }
            it.unimi.dsi.fastutil.ints.IntArrays$c.invokeAll(new c(nArray, nArray2, this.b - n2, this.b));
        }
    }

    protected static final class Segment {
        protected final int a;
        protected final int b;
        protected final int c;

        /*
         * WARNING - void declaration
         */
        protected Segment(int offset, int length, int level) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.a = var1_1;
            this.b = var2_2;
            this.c = var3_3;
        }

        public final String toString() {
            return "Segment [offset=" + this.a + ", length=" + this.b + ", level=" + this.c + "]";
        }
    }

    private static final class a
    implements Hash.Strategy<int[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private a() {
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

