/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lkotlinx/serialization/internal/InternalHexConverter;", "", "()V", "hexCode", "", "hexToInt", "", "ch", "", "parseHexBinary", "", "s", "printHexBinary", "data", "lowerCase", "", "toHexString", "n", "kotlinx-serialization-core"})
@SourceDebugExtension(value={"SMAP\nPlatform.common.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Platform.common.kt\nkotlinx/serialization/internal/InternalHexConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n1#2:183\n*E\n"})
public final class InternalHexConverter {
    @NotNull
    public static final InternalHexConverter INSTANCE = new InternalHexConverter();
    @NotNull
    private static final String hexCode = "0123456789ABCDEF";

    private InternalHexConverter() {
    }

    @NotNull
    public final byte[] parseHexBinary(@NotNull String s2) {
        Intrinsics.checkNotNullParameter(s2, "s");
        int len = s2.length();
        if (!(len % 2 == 0)) {
            boolean $i$a$-require-InternalHexConverter$parseHexBinary$32 = false;
            String $i$a$-require-InternalHexConverter$parseHexBinary$32 = "HexBinary string must be even length";
            throw new IllegalArgumentException($i$a$-require-InternalHexConverter$parseHexBinary$32.toString());
        }
        byte[] bytes2 = new byte[len / 2];
        for (int i2 = 0; i2 < len; i2 += 2) {
            int h2 = this.hexToInt(s2.charAt(i2));
            int l2 = this.hexToInt(s2.charAt(i2 + 1));
            if (!(h2 != -1 && l2 != -1)) {
                boolean bl2 = false;
                String string2 = "Invalid hex chars: " + s2.charAt(i2) + s2.charAt(i2 + 1);
                throw new IllegalArgumentException(string2.toString());
            }
            bytes2[i2 / 2] = (byte)((h2 << 4) + l2);
        }
        return bytes2;
    }

    private final int hexToInt(char ch) {
        int n2;
        block1: {
            char c2;
            block0: {
                c2 = ch;
                boolean bl2 = '0' <= c2 ? c2 < ':' : false;
                if (!bl2) break block0;
                n2 = ch - 48;
                break block1;
            }
            n2 = ('A' <= c2 ? c2 < 'G' : false) ? ch - 65 + 10 : (('a' <= c2 ? c2 < 'g' : false) ? ch - 97 + 10 : -1);
        }
        return n2;
    }

    @NotNull
    public final String printHexBinary(@NotNull byte[] data, boolean lowerCase) {
        String string2;
        Intrinsics.checkNotNullParameter(data, "data");
        StringBuilder r2 = new StringBuilder(data.length * 2);
        for (byte b2 : data) {
            r2.append(hexCode.charAt(b2 >> 4 & 0xF));
            r2.append(hexCode.charAt(b2 & 0xF));
        }
        if (lowerCase) {
            String string3 = r2.toString();
            Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
            String string4 = string3.toLowerCase(Locale.ROOT);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
        } else {
            String string5 = r2.toString();
            string2 = string5;
            Intrinsics.checkNotNullExpressionValue(string5, "toString(...)");
        }
        return string2;
    }

    public static /* synthetic */ String printHexBinary$default(InternalHexConverter internalHexConverter, byte[] byArray, boolean bl2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl2 = false;
        }
        return internalHexConverter.printHexBinary(byArray, bl2);
    }

    @NotNull
    public final String toHexString(int n2) {
        byte[] arr = new byte[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            arr[i2] = (byte)(n2 >> 24 - i2 * 8);
        }
        Object object = new char[]{'0'};
        Object it = object = (Object)StringsKt.trimStart(this.printHexBinary(arr, true), object);
        boolean bl2 = false;
        Object object2 = (char[])(((CharSequence)it).length() > 0 ? object : null);
        if (object2 == null) {
            object2 = "0";
        }
        return object2;
    }
}

