/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.Spliterator;
import java.util.function.Consumer;

final class CombinationSpliterator
implements Spliterator<int[]> {
    private long pos;
    private int[] value;
    private final long fence;
    private final int n;

    public CombinationSpliterator(int n2, long pos, long fence, int[] value) {
        this.n = n2;
        this.pos = pos;
        this.fence = fence;
        this.value = value;
    }

    @Override
    public void forEachRemaining(Consumer<? super int[]> action2) {
        long rest = this.pos - this.fence;
        this.pos = this.fence;
        while (rest > 0L) {
            action2.accept((int[])this.value.clone());
            if (--rest <= 0L) continue;
            CombinationSpliterator.step(this.value, this.n);
        }
    }

    @Override
    public Spliterator<int[]> trySplit() {
        if (this.pos - this.fence < 2L) {
            return null;
        }
        long newPos = this.fence + this.pos >>> 1;
        CombinationSpliterator result2 = new CombinationSpliterator(this.n, this.pos, newPos, this.value);
        this.value = CombinationSpliterator.jump(newPos - 1L, this.value.length, this.n);
        this.pos = newPos;
        return result2;
    }

    @Override
    public long estimateSize() {
        return this.pos - this.fence;
    }

    @Override
    public int characteristics() {
        return 17745;
    }

    static void step(int[] value, int n2) {
        int k2;
        int i2 = k2 = value.length;
        while (--i2 >= 0) {
            int n3 = i2;
            value[n3] = value[n3] + 1;
            if (value[n3] < n2) break;
            --n2;
        }
        while (++i2 < k2) {
            value[i2] = value[i2 - 1] + 1;
        }
    }

    static int[] jump(long newPos, int k2, int n2) {
        int[] newValue = new int[k2];
        int curK = k2 - 1;
        long bound = 0L;
        for (int i2 = 0; i2 < k2; ++i2) {
            long cnk = 1L;
            int curN = curK;
            while (newPos >= bound + cnk) {
                bound += cnk;
                cnk = cnk * (long)(++curN) / (long)(curN - curK);
            }
            --curK;
            newValue[i2] = n2 - curN - 1;
        }
        return newValue;
    }

    static long gcd(long a2, long b2) {
        while (b2 != 0L) {
            long t2 = a2 % b2;
            a2 = b2;
            b2 = t2;
        }
        return a2;
    }

    static long cnk(int n2, int k2) {
        long size = 1L;
        int rest = n2;
        long div = 1L;
        while (div <= (long)k2) {
            long t2;
            long gcd;
            if ((size /= (gcd = CombinationSpliterator.gcd(size, div))) > Long.MAX_VALUE / (t2 = (long)rest / (div / gcd))) {
                throw new UnsupportedOperationException("Number of combinations exceed Long.MAX_VALUE: unsupported");
            }
            size *= t2;
            ++div;
            --rest;
        }
        return size;
    }

    @Override
    public boolean tryAdvance(Consumer<? super int[]> action2) {
        if (this.pos <= this.fence) {
            return false;
        }
        action2.accept((int[])this.value.clone());
        if (--this.pos > this.fence) {
            CombinationSpliterator.step(this.value, this.n);
        }
        return true;
    }
}

