/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.nio.DoubleBuffer;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.DoubleSummaryStatistics;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BiConsumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.BaseStreamEx;
import one.util.streamex.ConstSpliterator;
import one.util.streamex.DoubleCollector;
import one.util.streamex.EmitterSpliterator;
import one.util.streamex.EntryStream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.Internals;
import one.util.streamex.LongStreamEx;
import one.util.streamex.PairSpliterator;
import one.util.streamex.PrefixOps;
import one.util.streamex.RangeBasedSpliterator;
import one.util.streamex.StreamContext;
import one.util.streamex.StreamEx;
import one.util.streamex.TakeDrop;
import one.util.streamex.UnknownSizeSpliterator;
import one.util.streamex.VerSpec;

public final class DoubleStreamEx
extends BaseStreamEx<Double, DoubleStream, Spliterator.OfDouble, DoubleStreamEx>
implements DoubleStream {
    DoubleStreamEx(DoubleStream stream, StreamContext context2) {
        super(stream, context2);
    }

    DoubleStreamEx(Spliterator.OfDouble spliterator, StreamContext context2) {
        super(spliterator, context2);
    }

    @Override
    DoubleStream createStream() {
        return StreamSupport.doubleStream((Spliterator.OfDouble)this.spliterator, this.isParallel());
    }

    private static DoubleStreamEx seq(DoubleStream stream) {
        return new DoubleStreamEx(stream, StreamContext.SEQUENTIAL);
    }

    DoubleStreamEx delegate(Spliterator.OfDouble spliterator) {
        return new DoubleStreamEx(spliterator, this.context);
    }

    @Override
    public DoubleStreamEx unordered() {
        return (DoubleStreamEx)super.unordered();
    }

    @Override
    public DoubleStreamEx onClose(Runnable closeHandler) {
        return (DoubleStreamEx)super.onClose(closeHandler);
    }

    @Override
    public DoubleStreamEx filter(DoublePredicate predicate) {
        return new DoubleStreamEx(((DoubleStream)this.stream()).filter(predicate), this.context);
    }

    public DoubleStreamEx remove(DoublePredicate predicate) {
        return this.filter(predicate.negate());
    }

    public DoubleStreamEx greater(double value) {
        return this.filter(val -> val > value);
    }

    public DoubleStreamEx less(double value) {
        return this.filter(val -> val < value);
    }

    public DoubleStreamEx atLeast(double value) {
        return this.filter(val -> val >= value);
    }

    public DoubleStreamEx atMost(double value) {
        return this.filter(val -> val <= value);
    }

    @Override
    public DoubleStreamEx map(DoubleUnaryOperator mapper) {
        return new DoubleStreamEx(((DoubleStream)this.stream()).map(mapper), this.context);
    }

    public DoubleStreamEx mapFirst(DoubleUnaryOperator mapper) {
        return this.delegate(new PairSpliterator.PSOfDouble((a2, b2) -> b2, mapper, (Spliterator.OfDouble)this.spliterator(), 1));
    }

    public DoubleStreamEx mapLast(DoubleUnaryOperator mapper) {
        return this.delegate(new PairSpliterator.PSOfDouble((a2, b2) -> a2, mapper, (Spliterator.OfDouble)this.spliterator(), 2));
    }

    public <U> StreamEx<U> mapToObj(DoubleFunction<? extends U> mapper) {
        return new StreamEx<U>(((DoubleStream)this.stream()).mapToObj(mapper), this.context);
    }

    @Override
    public IntStreamEx mapToInt(DoubleToIntFunction mapper) {
        return new IntStreamEx(((DoubleStream)this.stream()).mapToInt(mapper), this.context);
    }

    @Override
    public LongStreamEx mapToLong(DoubleToLongFunction mapper) {
        return new LongStreamEx(((DoubleStream)this.stream()).mapToLong(mapper), this.context);
    }

    public <K, V> EntryStream<K, V> mapToEntry(DoubleFunction<? extends K> keyMapper, DoubleFunction<? extends V> valueMapper) {
        return new EntryStream(((DoubleStream)this.stream()).mapToObj((double t2) -> new AbstractMap.SimpleImmutableEntry(keyMapper.apply(t2), valueMapper.apply(t2))), this.context);
    }

    @Override
    public DoubleStreamEx flatMap(DoubleFunction<? extends DoubleStream> mapper) {
        return new DoubleStreamEx(((DoubleStream)this.stream()).flatMap(mapper), this.context);
    }

    public IntStreamEx flatMapToInt(DoubleFunction<? extends IntStream> mapper) {
        return new IntStreamEx(((DoubleStream)this.stream()).mapToObj(mapper).flatMapToInt(Function.identity()), this.context);
    }

    public LongStreamEx flatMapToLong(DoubleFunction<? extends LongStream> mapper) {
        return new LongStreamEx(((DoubleStream)this.stream()).mapToObj(mapper).flatMapToLong(Function.identity()), this.context);
    }

    public <R> StreamEx<R> flatMapToObj(DoubleFunction<? extends Stream<R>> mapper) {
        return new StreamEx(((DoubleStream)this.stream()).mapToObj(mapper).flatMap(Function.identity()), this.context);
    }

    public DoubleStreamEx intersperse(int delimiter) {
        return new DoubleStreamEx(((DoubleStream)this.stream()).flatMap((double s2) -> DoubleStreamEx.of(delimiter, s2)).skip(1L), this.context);
    }

    @Override
    public DoubleStreamEx distinct() {
        return new DoubleStreamEx(((DoubleStream)this.stream()).distinct(), this.context);
    }

    @Override
    public DoubleStreamEx sorted() {
        return new DoubleStreamEx(((DoubleStream)this.stream()).sorted(), this.context);
    }

    public DoubleStreamEx sorted(Comparator<Double> comparator) {
        return new DoubleStreamEx(((DoubleStream)this.stream()).boxed().sorted(comparator).mapToDouble(Double::doubleValue), this.context);
    }

    public DoubleStreamEx reverseSorted() {
        return new DoubleStreamEx(((DoubleStream)this.stream()).mapToLong(d2 -> {
            long l2 = Double.doubleToRawLongBits(d2);
            return (l2 ^ ((l2 >>> 63) - 1L | Long.MIN_VALUE)) + 0xFFFFFFFFFFFFFL;
        }).sorted().mapToDouble(l2 -> Double.longBitsToDouble((l2 -= 0xFFFFFFFFFFFFFL) ^ (-(l2 >>> 63) | Long.MIN_VALUE))), this.context);
    }

    public <V extends Comparable<? super V>> DoubleStreamEx sortedBy(DoubleFunction<V> keyExtractor) {
        return this.sorted(Comparator.comparing(keyExtractor::apply));
    }

    public DoubleStreamEx sortedByInt(DoubleToIntFunction keyExtractor) {
        return this.sorted(Comparator.comparingInt(keyExtractor::applyAsInt));
    }

    public DoubleStreamEx sortedByLong(DoubleToLongFunction keyExtractor) {
        return this.sorted(Comparator.comparingLong(keyExtractor::applyAsLong));
    }

    public DoubleStreamEx sortedByDouble(DoubleUnaryOperator keyExtractor) {
        return this.sorted(Comparator.comparingDouble(keyExtractor::applyAsDouble));
    }

    @Override
    public DoubleStreamEx peek(DoubleConsumer action2) {
        return new DoubleStreamEx(((DoubleStream)this.stream()).peek(action2), this.context);
    }

    public DoubleStreamEx peekFirst(DoubleConsumer action2) {
        return this.mapFirst(x2 -> {
            action2.accept(x2);
            return x2;
        });
    }

    public DoubleStreamEx peekLast(DoubleConsumer action2) {
        return this.mapLast(x2 -> {
            action2.accept(x2);
            return x2;
        });
    }

    @Override
    public DoubleStreamEx limit(long maxSize) {
        return new DoubleStreamEx(((DoubleStream)this.stream()).limit(maxSize), this.context);
    }

    @Override
    public DoubleStreamEx skip(long n2) {
        return new DoubleStreamEx(((DoubleStream)this.stream()).skip(n2), this.context);
    }

    @Override
    public void forEach(DoubleConsumer action2) {
        if (this.spliterator != null && !this.isParallel()) {
            ((Spliterator.OfDouble)this.spliterator()).forEachRemaining(action2);
        } else if (this.context.fjp != null) {
            this.context.terminate(() -> {
                ((DoubleStream)this.stream()).forEach(action2);
                return null;
            });
        } else {
            ((DoubleStream)this.stream()).forEach(action2);
        }
    }

    @Override
    public void forEachOrdered(DoubleConsumer action2) {
        if (this.spliterator != null && !this.isParallel()) {
            ((Spliterator.OfDouble)this.spliterator()).forEachRemaining(action2);
        } else if (this.context.fjp != null) {
            this.context.terminate(() -> {
                ((DoubleStream)this.stream()).forEachOrdered(action2);
                return null;
            });
        } else {
            ((DoubleStream)this.stream()).forEachOrdered(action2);
        }
    }

    @Override
    public double[] toArray() {
        if (this.context.fjp != null) {
            return this.context.terminate(((DoubleStream)this.stream())::toArray);
        }
        return ((DoubleStream)this.stream()).toArray();
    }

    public float[] toFloatArray() {
        Internals.FloatBuffer buf;
        if (this.isParallel()) {
            return this.collect(DoubleCollector.toFloatArray());
        }
        Spliterator.OfDouble spliterator = (Spliterator.OfDouble)this.spliterator();
        int size = Internals.intSize(spliterator);
        if (size >= 0) {
            buf = new Internals.FloatBuffer(size);
            spliterator.forEachRemaining(buf::addUnsafe);
        } else {
            buf = new Internals.FloatBuffer();
            spliterator.forEachRemaining(buf::add);
        }
        return buf.toArray();
    }

    @Override
    public double reduce(double identity, DoubleBinaryOperator op) {
        if (this.context.fjp != null) {
            return this.context.terminate(() -> ((DoubleStream)this.stream()).reduce(identity, op));
        }
        return ((DoubleStream)this.stream()).reduce(identity, op);
    }

    @Override
    public OptionalDouble reduce(DoubleBinaryOperator op) {
        if (this.context.fjp != null) {
            return this.context.terminate(op, ((DoubleStream)this.stream())::reduce);
        }
        return ((DoubleStream)this.stream()).reduce(op);
    }

    public OptionalDouble foldLeft(DoubleBinaryOperator accumulator2) {
        Internals.PrimitiveBox b2 = new Internals.PrimitiveBox();
        this.forEachOrdered(t2 -> {
            if (b2.b) {
                b2.d = accumulator2.applyAsDouble(b2.d, t2);
            } else {
                b2.d = t2;
                b2.b = true;
            }
        });
        return b2.asDouble();
    }

    public double foldLeft(double seed, DoubleBinaryOperator accumulator2) {
        double[] box = new double[]{seed};
        this.forEachOrdered(t2 -> {
            box[0] = accumulator2.applyAsDouble(box[0], t2);
        });
        return box[0];
    }

    public double[] scanLeft(DoubleBinaryOperator accumulator2) {
        Spliterator.OfDouble spliterator = (Spliterator.OfDouble)this.spliterator();
        int size = Internals.intSize(spliterator);
        Internals.DoubleBuffer buf = new Internals.DoubleBuffer(size == -1 ? 128 : size);
        this.delegate(spliterator).forEachOrdered(i2 -> buf.add(buf.size == 0 ? i2 : accumulator2.applyAsDouble(buf.data[buf.size - 1], i2)));
        return buf.toArray();
    }

    public double[] scanLeft(double seed, DoubleBinaryOperator accumulator2) {
        return this.prepend(seed).scanLeft(accumulator2);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjDoubleConsumer<R> accumulator2, BiConsumer<R, R> combiner) {
        if (this.context.fjp != null) {
            return (R)this.context.terminate(() -> ((DoubleStream)this.stream()).collect(supplier, accumulator2, combiner));
        }
        return ((DoubleStream)this.stream()).collect(supplier, accumulator2, combiner);
    }

    public <A, R> R collect(DoubleCollector<A, R> collector2) {
        if (collector2.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return (R)this.collect(collector2.supplier(), collector2.doubleAccumulator(), collector2.merger());
        }
        return collector2.finisher().apply(this.collect(collector2.supplier(), collector2.doubleAccumulator(), collector2.merger()));
    }

    @Override
    public double sum() {
        if (this.context.fjp != null) {
            return this.context.terminate(((DoubleStream)this.stream())::sum);
        }
        return ((DoubleStream)this.stream()).sum();
    }

    @Override
    public OptionalDouble min() {
        return this.reduce(Math::min);
    }

    public OptionalDouble min(Comparator<Double> comparator) {
        return this.reduce((a2, b2) -> comparator.compare(a2, b2) > 0 ? b2 : a2);
    }

    public <V extends Comparable<? super V>> OptionalDouble minBy(DoubleFunction<V> keyExtractor) {
        Internals.ObjDoubleBox result2 = this.collect(() -> new Internals.ObjDoubleBox<Object>(null, 0.0), (box, i2) -> {
            Comparable val = Objects.requireNonNull((Comparable)keyExtractor.apply(i2));
            if (box.a == null || ((Comparable)box.a).compareTo(val) > 0) {
                box.a = val;
                box.b = i2;
            }
        }, (box1, box2) -> {
            if (box2.a != null && (box1.a == null || ((Comparable)box1.a).compareTo(box2.a) > 0)) {
                box1.a = box2.a;
                box1.b = box2.b;
            }
        });
        return result2.a == null ? OptionalDouble.empty() : OptionalDouble.of(result2.b);
    }

    public OptionalDouble minByInt(DoubleToIntFunction keyExtractor) {
        return this.collect(Internals.PrimitiveBox::new, (box, d2) -> {
            int key = keyExtractor.applyAsInt(d2);
            if (!box.b || box.i > key) {
                box.b = true;
                box.i = key;
                box.d = d2;
            }
        }, Internals.PrimitiveBox.MIN_INT).asDouble();
    }

    public OptionalDouble minByLong(DoubleToLongFunction keyExtractor) {
        return this.collect(Internals.PrimitiveBox::new, (box, d2) -> {
            long key = keyExtractor.applyAsLong(d2);
            if (!box.b || box.l > key) {
                box.b = true;
                box.l = key;
                box.d = d2;
            }
        }, Internals.PrimitiveBox.MIN_LONG).asDouble();
    }

    public OptionalDouble minByDouble(DoubleUnaryOperator keyExtractor) {
        double[] result2 = this.collect(() -> new double[3], (acc, d2) -> {
            double key = keyExtractor.applyAsDouble(d2);
            if (acc[2] == 0.0 || Double.compare(acc[1], key) > 0) {
                acc[0] = d2;
                acc[1] = key;
                acc[2] = 1.0;
            }
        }, (acc1, acc2) -> {
            if (acc2[2] == 1.0 && (acc1[2] == 0.0 || Double.compare(acc1[1], acc2[1]) > 0)) {
                System.arraycopy(acc2, 0, acc1, 0, 3);
            }
        });
        return result2[2] == 1.0 ? OptionalDouble.of(result2[0]) : OptionalDouble.empty();
    }

    @Override
    public OptionalDouble max() {
        return this.reduce(Math::max);
    }

    public OptionalDouble max(Comparator<Double> comparator) {
        return this.reduce((a2, b2) -> comparator.compare(a2, b2) >= 0 ? a2 : b2);
    }

    public <V extends Comparable<? super V>> OptionalDouble maxBy(DoubleFunction<V> keyExtractor) {
        Internals.ObjDoubleBox result2 = this.collect(() -> new Internals.ObjDoubleBox<Object>(null, 0.0), (box, i2) -> {
            Comparable val = Objects.requireNonNull((Comparable)keyExtractor.apply(i2));
            if (box.a == null || ((Comparable)box.a).compareTo(val) < 0) {
                box.a = val;
                box.b = i2;
            }
        }, (box1, box2) -> {
            if (box2.a != null && (box1.a == null || ((Comparable)box1.a).compareTo(box2.a) < 0)) {
                box1.a = box2.a;
                box1.b = box2.b;
            }
        });
        return result2.a == null ? OptionalDouble.empty() : OptionalDouble.of(result2.b);
    }

    public OptionalDouble maxByInt(DoubleToIntFunction keyExtractor) {
        return this.collect(Internals.PrimitiveBox::new, (box, d2) -> {
            int key = keyExtractor.applyAsInt(d2);
            if (!box.b || box.i < key) {
                box.b = true;
                box.i = key;
                box.d = d2;
            }
        }, Internals.PrimitiveBox.MAX_INT).asDouble();
    }

    public OptionalDouble maxByLong(DoubleToLongFunction keyExtractor) {
        return this.collect(Internals.PrimitiveBox::new, (box, d2) -> {
            long key = keyExtractor.applyAsLong(d2);
            if (!box.b || box.l < key) {
                box.b = true;
                box.l = key;
                box.d = d2;
            }
        }, Internals.PrimitiveBox.MAX_LONG).asDouble();
    }

    public OptionalDouble maxByDouble(DoubleUnaryOperator keyExtractor) {
        double[] result2 = this.collect(() -> new double[3], (acc, d2) -> {
            double key = keyExtractor.applyAsDouble(d2);
            if (acc[2] == 0.0 || Double.compare(acc[1], key) < 0) {
                acc[0] = d2;
                acc[1] = key;
                acc[2] = 1.0;
            }
        }, (acc1, acc2) -> {
            if (acc2[2] == 1.0 && (acc1[2] == 0.0 || Double.compare(acc1[1], acc2[1]) < 0)) {
                System.arraycopy(acc2, 0, acc1, 0, 3);
            }
        });
        return result2[2] == 1.0 ? OptionalDouble.of(result2[0]) : OptionalDouble.empty();
    }

    @Override
    public long count() {
        if (this.context.fjp != null) {
            return this.context.terminate(((DoubleStream)this.stream())::count);
        }
        return ((DoubleStream)this.stream()).count();
    }

    public long count(DoublePredicate predicate) {
        return this.filter(predicate).count();
    }

    @Override
    public OptionalDouble average() {
        if (this.context.fjp != null) {
            return this.context.terminate(((DoubleStream)this.stream())::average);
        }
        return ((DoubleStream)this.stream()).average();
    }

    @Override
    public DoubleSummaryStatistics summaryStatistics() {
        return this.collect(DoubleSummaryStatistics::new, DoubleSummaryStatistics::accept, DoubleSummaryStatistics::combine);
    }

    @Override
    public boolean anyMatch(DoublePredicate predicate) {
        if (this.context.fjp != null) {
            return this.context.terminate(predicate, ((DoubleStream)this.stream())::anyMatch);
        }
        return ((DoubleStream)this.stream()).anyMatch(predicate);
    }

    @Override
    public boolean allMatch(DoublePredicate predicate) {
        if (this.context.fjp != null) {
            return this.context.terminate(predicate, ((DoubleStream)this.stream())::allMatch);
        }
        return ((DoubleStream)this.stream()).allMatch(predicate);
    }

    @Override
    public boolean noneMatch(DoublePredicate predicate) {
        return !this.anyMatch(predicate);
    }

    @Override
    public OptionalDouble findFirst() {
        if (this.context.fjp != null) {
            return this.context.terminate(((DoubleStream)this.stream())::findFirst);
        }
        return ((DoubleStream)this.stream()).findFirst();
    }

    public OptionalDouble findFirst(DoublePredicate predicate) {
        return this.filter(predicate).findFirst();
    }

    @Override
    public OptionalDouble findAny() {
        if (this.context.fjp != null) {
            return this.context.terminate(((DoubleStream)this.stream())::findAny);
        }
        return ((DoubleStream)this.stream()).findAny();
    }

    public OptionalDouble findAny(DoublePredicate predicate) {
        return this.filter(predicate).findAny();
    }

    public OptionalLong indexOf(DoublePredicate predicate) {
        return ((AbstractStreamEx)this.boxed()).indexOf(predicate::test);
    }

    public StreamEx<Double> boxed() {
        return new StreamEx<Double>(((DoubleStream)this.stream()).boxed(), this.context);
    }

    @Override
    public DoubleStreamEx sequential() {
        return (DoubleStreamEx)super.sequential();
    }

    @Override
    public DoubleStreamEx parallel() {
        return (DoubleStreamEx)super.parallel();
    }

    @Override
    public DoubleStreamEx parallel(ForkJoinPool fjp) {
        return (DoubleStreamEx)super.parallel(fjp);
    }

    @Override
    public PrimitiveIterator.OfDouble iterator() {
        return Spliterators.iterator((Spliterator.OfDouble)this.spliterator());
    }

    public DoubleStreamEx append(double ... values2) {
        if (values2.length == 0) {
            return this;
        }
        return new DoubleStreamEx(DoubleStream.concat((DoubleStream)this.stream(), DoubleStream.of(values2)), this.context);
    }

    public DoubleStreamEx append(DoubleStream other) {
        return new DoubleStreamEx(DoubleStream.concat((DoubleStream)this.stream(), other), this.context.combine(other));
    }

    public DoubleStreamEx prepend(double ... values2) {
        if (values2.length == 0) {
            return this;
        }
        return new DoubleStreamEx(DoubleStream.concat(DoubleStream.of(values2), (DoubleStream)this.stream()), this.context);
    }

    public DoubleStreamEx prepend(DoubleStream other) {
        return new DoubleStreamEx(DoubleStream.concat(other, (DoubleStream)this.stream()), this.context.combine(other));
    }

    public DoubleStreamEx pairMap(DoubleBinaryOperator mapper) {
        return this.delegate(new PairSpliterator.PSOfDouble(mapper, null, (Spliterator.OfDouble)this.spliterator(), 0));
    }

    public String joining(CharSequence delimiter) {
        return this.collect(DoubleCollector.joining(delimiter));
    }

    public String joining(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return this.collect(DoubleCollector.joining(delimiter, prefix, suffix));
    }

    @Override
    public DoubleStreamEx takeWhile(DoublePredicate predicate) {
        return VerSpec.VER_SPEC.callWhile(this, Objects.requireNonNull(predicate), false);
    }

    public DoubleStreamEx takeWhileInclusive(DoublePredicate predicate) {
        Objects.requireNonNull(predicate);
        return this.delegate(new TakeDrop.TDOfDouble((Spliterator.OfDouble)this.spliterator(), false, true, predicate));
    }

    @Override
    public DoubleStreamEx dropWhile(DoublePredicate predicate) {
        return VerSpec.VER_SPEC.callWhile(this, Objects.requireNonNull(predicate), true);
    }

    public DoubleStreamEx prefix(DoubleBinaryOperator op) {
        return this.delegate(new PrefixOps.OfDouble((Spliterator.OfDouble)this.spliterator(), op));
    }

    @Override
    public <U> U chain(Function<? super DoubleStreamEx, U> mapper) {
        return mapper.apply(this);
    }

    public static DoubleStreamEx empty() {
        return DoubleStreamEx.of(Spliterators.emptyDoubleSpliterator());
    }

    public static DoubleStreamEx of(double element) {
        return DoubleStreamEx.of(new ConstSpliterator.OfDouble(element, 1L, true));
    }

    public static DoubleStreamEx of(double ... elements) {
        return DoubleStreamEx.of(Arrays.spliterator(elements));
    }

    public static DoubleStreamEx of(double[] array2, int startInclusive, int endExclusive) {
        return DoubleStreamEx.of(Arrays.spliterator(array2, startInclusive, endExclusive));
    }

    public static DoubleStreamEx of(Double[] array2) {
        return DoubleStreamEx.seq(Arrays.stream(array2).mapToDouble(Double::doubleValue));
    }

    public static DoubleStreamEx of(DoubleBuffer buf) {
        return IntStreamEx.range(buf.position(), buf.limit()).mapToDouble(buf::get);
    }

    public static DoubleStreamEx of(float ... elements) {
        return DoubleStreamEx.of(elements, 0, elements.length);
    }

    public static DoubleStreamEx of(float[] array2, int startInclusive, int endExclusive) {
        Internals.rangeCheck(array2.length, startInclusive, endExclusive);
        return DoubleStreamEx.of(new RangeBasedSpliterator.OfFloat(startInclusive, endExclusive, array2));
    }

    public static DoubleStreamEx of(DoubleStream stream) {
        return stream instanceof DoubleStreamEx ? (DoubleStreamEx)stream : new DoubleStreamEx(stream, StreamContext.of(stream));
    }

    public static DoubleStreamEx of(Spliterator.OfDouble spliterator) {
        return new DoubleStreamEx(spliterator, StreamContext.SEQUENTIAL);
    }

    public static DoubleStreamEx of(PrimitiveIterator.OfDouble iterator2) {
        return DoubleStreamEx.of(new UnknownSizeSpliterator.USOfDouble(iterator2));
    }

    public static DoubleStreamEx of(OptionalDouble optional) {
        return optional.isPresent() ? DoubleStreamEx.of(optional.getAsDouble()) : DoubleStreamEx.empty();
    }

    public static DoubleStreamEx of(Collection<Double> collection) {
        return DoubleStreamEx.seq(collection.stream().mapToDouble(Double::doubleValue));
    }

    public static DoubleStreamEx of(Random random2) {
        return DoubleStreamEx.seq(random2.doubles());
    }

    public static DoubleStreamEx of(Random random2, long streamSize) {
        return DoubleStreamEx.seq(random2.doubles(streamSize));
    }

    public static DoubleStreamEx of(Random random2, double randomNumberOrigin, double randomNumberBound) {
        return DoubleStreamEx.seq(random2.doubles(randomNumberOrigin, randomNumberBound));
    }

    public static DoubleStreamEx of(Random random2, long streamSize, double randomNumberOrigin, double randomNumberBound) {
        return DoubleStreamEx.seq(random2.doubles(streamSize, randomNumberOrigin, randomNumberBound));
    }

    public static DoubleStreamEx iterate(double seed, DoubleUnaryOperator f2) {
        return DoubleStreamEx.iterate(seed, x2 -> true, f2);
    }

    public static DoubleStreamEx iterate(final double seed, final DoublePredicate predicate, final DoubleUnaryOperator f2) {
        Objects.requireNonNull(f2);
        Objects.requireNonNull(predicate);
        Spliterators.AbstractDoubleSpliterator spliterator = new Spliterators.AbstractDoubleSpliterator(Long.MAX_VALUE, 1296){
            double prev;
            boolean started;
            boolean finished;

            @Override
            public boolean tryAdvance(DoubleConsumer action2) {
                double t2;
                Objects.requireNonNull(action2);
                if (this.finished) {
                    return false;
                }
                if (this.started) {
                    t2 = f2.applyAsDouble(this.prev);
                } else {
                    t2 = seed;
                    this.started = true;
                }
                if (!predicate.test(t2)) {
                    this.finished = true;
                    return false;
                }
                this.prev = t2;
                action2.accept(this.prev);
                return true;
            }

            @Override
            public void forEachRemaining(DoubleConsumer action2) {
                double t2;
                Objects.requireNonNull(action2);
                if (this.finished) {
                    return;
                }
                this.finished = true;
                double d2 = t2 = this.started ? f2.applyAsDouble(this.prev) : seed;
                while (predicate.test(t2)) {
                    action2.accept(t2);
                    t2 = f2.applyAsDouble(t2);
                }
            }
        };
        return DoubleStreamEx.of(spliterator);
    }

    public static DoubleStreamEx generate(DoubleSupplier s2) {
        return DoubleStreamEx.seq(DoubleStream.generate(s2));
    }

    public static DoubleStreamEx produce(Predicate<DoubleConsumer> producer) {
        Internals.Box box = new Internals.Box();
        box.a = action2 -> producer.test(action2) ? (DoubleEmitter)box.a : null;
        return box.a.stream();
    }

    public static DoubleStreamEx constant(double value, long length) {
        return DoubleStreamEx.of(new ConstSpliterator.OfDouble(value, length, false));
    }

    public static DoubleStreamEx zip(double[] first2, double[] second2, DoubleBinaryOperator mapper) {
        return DoubleStreamEx.of(new RangeBasedSpliterator.ZipDouble(0, Internals.checkLength(first2.length, second2.length), mapper, first2, second2));
    }

    @FunctionalInterface
    public static interface DoubleEmitter {
        public DoubleEmitter next(DoubleConsumer var1);

        default public Spliterator.OfDouble spliterator() {
            return new EmitterSpliterator.OfDouble(this);
        }

        default public DoubleStreamEx stream() {
            return DoubleStreamEx.of(this.spliterator());
        }
    }
}

