/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.Spliterator;
import java.util.function.Consumer;
import one.util.streamex.Internals;

final class PermutationSpliterator
implements Spliterator<int[]> {
    private static final long[] factorials = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};
    private final int[] value;
    private long remainingSize;
    private final long fence;

    public PermutationSpliterator(int length) {
        Internals.checkNonNegative("Length", length);
        if (length >= factorials.length) {
            throw new IllegalArgumentException("Length " + length + " is bigger than " + factorials.length + ": not supported");
        }
        this.value = new int[length];
        for (int i2 = 0; i2 < length; ++i2) {
            this.value[i2] = i2;
        }
        this.fence = this.remainingSize = factorials[length];
    }

    private PermutationSpliterator(int[] startValue, long fence, long remainingSize) {
        this.value = startValue;
        this.fence = fence;
        this.remainingSize = remainingSize;
    }

    @Override
    public boolean tryAdvance(Consumer<? super int[]> action2) {
        if (this.remainingSize == 0L) {
            return false;
        }
        int[] value = this.value;
        action2.accept((int[])value.clone());
        if (--this.remainingSize > 0L) {
            PermutationSpliterator.step(value);
        }
        return true;
    }

    @Override
    public void forEachRemaining(Consumer<? super int[]> action2) {
        long rs = this.remainingSize;
        if (rs == 0L) {
            return;
        }
        this.remainingSize = 0L;
        int[] value = this.value;
        action2.accept((int[])value.clone());
        while (--rs > 0L) {
            PermutationSpliterator.step(value);
            action2.accept((int[])value.clone());
        }
    }

    private static void step(int[] value) {
        int r2 = value.length - 1;
        int k2 = r2 - 1;
        while (value[k2] > value[k2 + 1]) {
            --k2;
        }
        int vk = value[k2];
        int l2 = r2;
        while (vk > value[l2]) {
            --l2;
        }
        value[k2] = value[l2];
        value[l2] = vk;
        ++k2;
        while (k2 < r2) {
            int tmp = value[k2];
            value[k2] = value[r2];
            value[r2] = tmp;
            ++k2;
            --r2;
        }
    }

    @Override
    public Spliterator<int[]> trySplit() {
        long newPos;
        if (this.remainingSize <= 1L) {
            return null;
        }
        int[] newValue = (int[])this.value.clone();
        int used = -1;
        long newRemainingSize = this.remainingSize / 2L;
        long s2 = newPos = this.fence - (this.remainingSize -= newRemainingSize);
        for (int i2 = 0; i2 < this.value.length; ++i2) {
            long f2 = factorials[this.value.length - i2 - 1];
            int rem = (int)(s2 / f2);
            s2 %= f2;
            int idx = -1;
            while (rem >= 0) {
                idx = Integer.numberOfTrailingZeros(used >> idx + 1) + idx + 1;
                --rem;
            }
            used &= ~(1 << idx);
            this.value[i2] = idx;
        }
        return new PermutationSpliterator(newValue, newPos, newRemainingSize);
    }

    @Override
    public long estimateSize() {
        return this.remainingSize;
    }

    @Override
    public int characteristics() {
        return 17745;
    }
}

