/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200;

import org.apache.commons.compress.harmony.unpack200.IMatcher;

public final class SegmentUtils {
    public static int countArgs(String descriptor2) {
        return SegmentUtils.countArgs(descriptor2, 1);
    }

    protected static int countArgs(String descriptor2, int widthOfLongsAndDoubles) {
        int bra = descriptor2.indexOf(40);
        int ket = descriptor2.indexOf(41);
        if (bra == -1 || ket == -1 || ket < bra) {
            throw new IllegalArgumentException("No arguments");
        }
        boolean inType = false;
        boolean consumingNextType = false;
        int count2 = 0;
        for (int i2 = bra + 1; i2 < ket; ++i2) {
            char charAt = descriptor2.charAt(i2);
            if (inType && charAt == ';') {
                inType = false;
                consumingNextType = false;
                continue;
            }
            if (!inType && charAt == 'L') {
                inType = true;
                ++count2;
                continue;
            }
            if (charAt == '[') {
                consumingNextType = true;
                continue;
            }
            if (inType) continue;
            if (consumingNextType) {
                ++count2;
                consumingNextType = false;
                continue;
            }
            if (charAt == 'D' || charAt == 'J') {
                count2 += widthOfLongsAndDoubles;
                continue;
            }
            ++count2;
        }
        return count2;
    }

    public static int countBit16(int[] flags) {
        int count2 = 0;
        for (int flag2 : flags) {
            if ((flag2 & 0x10000) == 0) continue;
            ++count2;
        }
        return count2;
    }

    public static int countBit16(long[] flags) {
        int count2 = 0;
        for (long flag2 : flags) {
            if ((flag2 & 0x10000L) == 0L) continue;
            ++count2;
        }
        return count2;
    }

    public static int countBit16(long[][] flags) {
        int count2 = 0;
        long[][] lArray = flags;
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            long[] flag2;
            for (long element : flag2 = lArray[i2]) {
                if ((element & 0x10000L) == 0L) continue;
                ++count2;
            }
        }
        return count2;
    }

    public static int countInvokeInterfaceArgs(String descriptor2) {
        return SegmentUtils.countArgs(descriptor2, 2);
    }

    public static int countMatches(long[] flags, IMatcher matcher) {
        int count2 = 0;
        for (long flag2 : flags) {
            if (!matcher.matches(flag2)) continue;
            ++count2;
        }
        return count2;
    }

    public static int countMatches(long[][] flags, IMatcher matcher) {
        int count2 = 0;
        for (long[] flag2 : flags) {
            count2 += SegmentUtils.countMatches(flag2, matcher);
        }
        return count2;
    }
}

