/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.bytecode.forms;

import org.apache.commons.compress.harmony.unpack200.bytecode.ByteCode;
import org.apache.commons.compress.harmony.unpack200.bytecode.CodeAttribute;
import org.apache.commons.compress.harmony.unpack200.bytecode.forms.VariableInstructionForm;

public abstract class SwitchForm
extends VariableInstructionForm {
    public SwitchForm(int opcode, String name2) {
        super(opcode, name2);
    }

    @Override
    public void fixUpByteCodeTargets(ByteCode byteCode, CodeAttribute codeAttribute) {
        int[] originalTargets = byteCode.getByteCodeTargets();
        int numberOfLabels = originalTargets.length;
        int[] replacementTargets = new int[numberOfLabels];
        int sourceIndex = byteCode.getByteCodeIndex();
        int sourceValue = codeAttribute.byteCodeOffsets.get(sourceIndex);
        for (int index2 = 0; index2 < numberOfLabels; ++index2) {
            int absoluteInstructionTargetIndex = sourceIndex + originalTargets[index2];
            int targetValue = codeAttribute.byteCodeOffsets.get(absoluteInstructionTargetIndex);
            replacementTargets[index2] = targetValue - sourceValue;
        }
        int[] rewriteArray = byteCode.getRewrite();
        for (int index3 = 0; index3 < numberOfLabels; ++index3) {
            this.setRewrite4Bytes(replacementTargets[index3], rewriteArray);
        }
    }
}

