/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text.perl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.apache.oro.text.PatternCache;
import org.apache.oro.text.PatternCacheLRU;
import org.apache.oro.text.perl.MalformedPerl5PatternException;
import org.apache.oro.text.perl.ParsedSubstitutionEntry;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;
import org.apache.oro.util.Cache;
import org.apache.oro.util.CacheLRU;

public final class Perl5Util
implements MatchResult {
    private static final String __matchExpression = "m?(\\W)(.*)\\1([imsx]*)";
    private PatternCache __patternCache;
    private Cache __expressionCache;
    private Perl5Matcher __matcher;
    private Pattern __matchPattern;
    private MatchResult __lastMatch;
    private ArrayList __splitList = new ArrayList();
    private Object __originalInput;
    private int __inputBeginOffset;
    private int __inputEndOffset;
    private static final String __nullString = "";
    public static final int SPLIT_ALL = 0;

    public Perl5Util(PatternCache patternCache) {
        this.__matcher = new Perl5Matcher();
        this.__patternCache = patternCache;
        this.__expressionCache = new CacheLRU(patternCache.capacity());
        this.__compilePatterns();
    }

    public Perl5Util() {
        this(new PatternCacheLRU());
    }

    private void __compilePatterns() {
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        try {
            this.__matchPattern = perl5Compiler.compile(__matchExpression, 16);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new RuntimeException(malformedPatternException.getMessage());
        }
    }

    private Pattern __parseMatchExpression(String string2) throws MalformedPerl5PatternException {
        Object object = this.__expressionCache.getElement(string2);
        try {
            if (object != null) {
                return (Pattern)object;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (!this.__matcher.matches(string2, this.__matchPattern)) {
            throw new MalformedPerl5PatternException("Invalid expression: " + string2);
        }
        MatchResult matchResult = this.__matcher.getMatch();
        String string3 = matchResult.group(2);
        int n2 = 0;
        String string4 = matchResult.group(3);
        if (string4 != null) {
            int n3 = string4.length();
            block8: while (n3-- > 0) {
                switch (string4.charAt(n3)) {
                    case 'i': {
                        n2 |= 1;
                        continue block8;
                    }
                    case 'm': {
                        n2 |= 8;
                        continue block8;
                    }
                    case 's': {
                        n2 |= 0x10;
                        continue block8;
                    }
                    case 'x': {
                        n2 |= 0x20;
                        continue block8;
                    }
                }
                throw new MalformedPerl5PatternException("Invalid options: " + string4);
            }
        }
        Pattern pattern = this.__patternCache.getPattern(string3, n2);
        this.__expressionCache.addElement(string2, pattern);
        return pattern;
    }

    public synchronized boolean match(String string2, char[] cArray) throws MalformedPerl5PatternException {
        this.__parseMatchExpression(string2);
        boolean bl2 = this.__matcher.contains(cArray, this.__parseMatchExpression(string2));
        if (bl2) {
            this.__lastMatch = this.__matcher.getMatch();
            this.__originalInput = cArray;
            this.__inputBeginOffset = 0;
            this.__inputEndOffset = cArray.length;
        }
        return bl2;
    }

    public synchronized boolean match(String string2, String string3) throws MalformedPerl5PatternException {
        return this.match(string2, string3.toCharArray());
    }

    public synchronized boolean match(String string2, PatternMatcherInput patternMatcherInput) throws MalformedPerl5PatternException {
        boolean bl2 = this.__matcher.contains(patternMatcherInput, this.__parseMatchExpression(string2));
        if (bl2) {
            this.__lastMatch = this.__matcher.getMatch();
            this.__originalInput = patternMatcherInput.getInput();
            this.__inputBeginOffset = patternMatcherInput.getBeginOffset();
            this.__inputEndOffset = patternMatcherInput.getEndOffset();
        }
        return bl2;
    }

    public synchronized MatchResult getMatch() {
        return this.__lastMatch;
    }

    public synchronized int substitute(StringBuffer stringBuffer, String string2, String string3) throws MalformedPerl5PatternException {
        int n2;
        char[] cArray;
        block23: {
            Object object = this.__expressionCache.getElement(string2);
            if (object != null) {
                ParsedSubstitutionEntry parsedSubstitutionEntry;
                try {
                    parsedSubstitutionEntry = (ParsedSubstitutionEntry)object;
                }
                catch (ClassCastException classCastException) {
                    break block23;
                }
                int n3 = Util.substitute(stringBuffer, (PatternMatcher)this.__matcher, parsedSubstitutionEntry._pattern, (Substitution)parsedSubstitutionEntry._substitution, string3, parsedSubstitutionEntry._numSubstitutions);
                this.__lastMatch = this.__matcher.getMatch();
                return n3;
            }
        }
        if ((cArray = string2.toCharArray()).length < 4 || cArray[0] != 's' || Character.isLetterOrDigit(cArray[1]) || cArray[1] == '-') {
            throw new MalformedPerl5PatternException("Invalid expression: " + string2);
        }
        char c2 = cArray[1];
        int n4 = 2;
        int n5 = -1;
        int n6 = -1;
        boolean bl2 = false;
        for (n2 = n4; n2 < cArray.length; ++n2) {
            if (cArray[n2] == '\\') {
                bl2 = !bl2;
                continue;
            }
            if (cArray[n2] == c2 && !bl2) {
                n6 = n2;
                break;
            }
            if (!bl2) continue;
            bl2 = !bl2;
        }
        if (n6 == -1 || n6 == cArray.length - 1) {
            throw new MalformedPerl5PatternException("Invalid expression: " + string2);
        }
        bl2 = false;
        boolean bl3 = true;
        StringBuffer stringBuffer2 = new StringBuffer(cArray.length - n6);
        for (n2 = n6 + 1; n2 < cArray.length; ++n2) {
            if (cArray[n2] == '\\') {
                boolean bl4 = bl2 = !bl2;
                if (bl2 && n2 + 1 < cArray.length && cArray[n2 + 1] == c2 && string2.lastIndexOf(c2, cArray.length - 1) != n2 + 1) {
                    bl3 = false;
                    continue;
                }
            } else {
                if (cArray[n2] == c2 && bl3) {
                    n5 = n2;
                    break;
                }
                bl2 = false;
                bl3 = true;
            }
            stringBuffer2.append(cArray[n2]);
        }
        if (n5 == -1) {
            throw new MalformedPerl5PatternException("Invalid expression: " + string2);
        }
        int n7 = 0;
        int n8 = 1;
        int n9 = c2 != '\'' ? 0 : -1;
        block12: for (n2 = n5 + 1; n2 < cArray.length; ++n2) {
            switch (cArray[n2]) {
                case 'i': {
                    n7 |= 1;
                    continue block12;
                }
                case 'm': {
                    n7 |= 8;
                    continue block12;
                }
                case 's': {
                    n7 |= 0x10;
                    continue block12;
                }
                case 'x': {
                    n7 |= 0x20;
                    continue block12;
                }
                case 'g': {
                    n8 = -1;
                    continue block12;
                }
                case 'o': {
                    n9 = 1;
                    continue block12;
                }
                default: {
                    throw new MalformedPerl5PatternException("Invalid option: " + cArray[n2]);
                }
            }
        }
        Pattern pattern = this.__patternCache.getPattern(new String(cArray, n4, n6 - n4), n7);
        Perl5Substitution perl5Substitution = new Perl5Substitution(stringBuffer2.toString(), n9);
        ParsedSubstitutionEntry parsedSubstitutionEntry = new ParsedSubstitutionEntry(pattern, perl5Substitution, n8);
        this.__expressionCache.addElement(string2, parsedSubstitutionEntry);
        int n10 = Util.substitute(stringBuffer, (PatternMatcher)this.__matcher, pattern, (Substitution)perl5Substitution, string3, n8);
        this.__lastMatch = this.__matcher.getMatch();
        return n10;
    }

    public synchronized String substitute(String string2, String string3) throws MalformedPerl5PatternException {
        StringBuffer stringBuffer = new StringBuffer();
        this.substitute(stringBuffer, string2, string3);
        return stringBuffer.toString();
    }

    public synchronized void split(Collection collection, String string2, String string3, int n2) throws MalformedPerl5PatternException {
        String string4;
        MatchResult matchResult = null;
        Pattern pattern = this.__parseMatchExpression(string2);
        PatternMatcherInput patternMatcherInput = new PatternMatcherInput(string3);
        int n3 = 0;
        while (--n2 != 0 && this.__matcher.contains(patternMatcherInput, pattern)) {
            matchResult = this.__matcher.getMatch();
            this.__splitList.add(string3.substring(n3, matchResult.beginOffset(0)));
            int n4 = matchResult.groups();
            if (n4 > 1) {
                for (int i2 = 1; i2 < n4; ++i2) {
                    String string5 = matchResult.group(i2);
                    if (string5 == null || string5.length() <= 0) continue;
                    this.__splitList.add(string5);
                }
            }
            n3 = matchResult.endOffset(0);
        }
        this.__splitList.add(string3.substring(n3, string3.length()));
        for (int i3 = this.__splitList.size() - 1; i3 >= 0 && (string4 = (String)this.__splitList.get(i3)).length() == 0; --i3) {
            this.__splitList.remove(i3);
        }
        collection.addAll(this.__splitList);
        this.__splitList.clear();
        this.__lastMatch = matchResult;
    }

    public synchronized void split(Collection collection, String string2, String string3) throws MalformedPerl5PatternException {
        this.split(collection, string2, string3, 0);
    }

    public synchronized void split(Collection collection, String string2) throws MalformedPerl5PatternException {
        this.split(collection, "/\\s+/", string2);
    }

    public synchronized Vector split(String string2, String string3, int n2) throws MalformedPerl5PatternException {
        Vector vector = new Vector(20);
        this.split(vector, string2, string3, n2);
        return vector;
    }

    public synchronized Vector split(String string2, String string3) throws MalformedPerl5PatternException {
        return this.split(string2, string3, 0);
    }

    public synchronized Vector split(String string2) throws MalformedPerl5PatternException {
        return this.split("/\\s+/", string2);
    }

    public synchronized int length() {
        return this.__lastMatch.length();
    }

    public synchronized int groups() {
        return this.__lastMatch.groups();
    }

    public synchronized String group(int n2) {
        return this.__lastMatch.group(n2);
    }

    public synchronized int begin(int n2) {
        return this.__lastMatch.begin(n2);
    }

    public synchronized int end(int n2) {
        return this.__lastMatch.end(n2);
    }

    public synchronized int beginOffset(int n2) {
        return this.__lastMatch.beginOffset(n2);
    }

    public synchronized int endOffset(int n2) {
        return this.__lastMatch.endOffset(n2);
    }

    public synchronized String toString() {
        if (this.__lastMatch == null) {
            return null;
        }
        return ((Object)this.__lastMatch).toString();
    }

    public synchronized String preMatch() {
        if (this.__originalInput == null) {
            return __nullString;
        }
        int n2 = this.__lastMatch.beginOffset(0);
        if (n2 <= 0) {
            return __nullString;
        }
        if (this.__originalInput instanceof char[]) {
            char[] cArray = (char[])this.__originalInput;
            if (n2 > cArray.length) {
                n2 = cArray.length;
            }
            return new String(cArray, this.__inputBeginOffset, n2);
        }
        if (this.__originalInput instanceof String) {
            String string2 = (String)this.__originalInput;
            if (n2 > string2.length()) {
                n2 = string2.length();
            }
            return string2.substring(this.__inputBeginOffset, n2);
        }
        return __nullString;
    }

    public synchronized String postMatch() {
        if (this.__originalInput == null) {
            return __nullString;
        }
        int n2 = this.__lastMatch.endOffset(0);
        if (n2 < 0) {
            return __nullString;
        }
        if (this.__originalInput instanceof char[]) {
            char[] cArray = (char[])this.__originalInput;
            if (n2 >= cArray.length) {
                return __nullString;
            }
            return new String(cArray, n2, this.__inputEndOffset - n2);
        }
        if (this.__originalInput instanceof String) {
            String string2 = (String)this.__originalInput;
            if (n2 >= string2.length()) {
                return __nullString;
            }
            return string2.substring(n2, this.__inputEndOffset);
        }
        return __nullString;
    }

    public synchronized char[] preMatchCharArray() {
        char[] cArray = null;
        if (this.__originalInput == null) {
            return null;
        }
        int n2 = this.__lastMatch.beginOffset(0);
        if (n2 <= 0) {
            return null;
        }
        if (this.__originalInput instanceof char[]) {
            char[] cArray2 = (char[])this.__originalInput;
            if (n2 >= cArray2.length) {
                n2 = cArray2.length;
            }
            cArray = new char[n2 - this.__inputBeginOffset];
            System.arraycopy(cArray2, this.__inputBeginOffset, cArray, 0, cArray.length);
        } else if (this.__originalInput instanceof String) {
            String string2 = (String)this.__originalInput;
            if (n2 >= string2.length()) {
                n2 = string2.length();
            }
            cArray = new char[n2 - this.__inputBeginOffset];
            string2.getChars(this.__inputBeginOffset, n2, cArray, 0);
        }
        return cArray;
    }

    public synchronized char[] postMatchCharArray() {
        char[] cArray = null;
        if (this.__originalInput == null) {
            return null;
        }
        int n2 = this.__lastMatch.endOffset(0);
        if (n2 < 0) {
            return null;
        }
        if (this.__originalInput instanceof char[]) {
            char[] cArray2 = (char[])this.__originalInput;
            if (n2 >= cArray2.length) {
                return null;
            }
            int n3 = this.__inputEndOffset - n2;
            cArray = new char[n3];
            System.arraycopy(cArray2, n2, cArray, 0, n3);
        } else if (this.__originalInput instanceof String) {
            String string2 = (String)this.__originalInput;
            if (n2 >= this.__inputEndOffset) {
                return null;
            }
            cArray = new char[this.__inputEndOffset - n2];
            string2.getChars(n2, this.__inputEndOffset, cArray, 0);
        }
        return cArray;
    }
}

