/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.ri.evt;

import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.evt.NotationDeclaration2;
import org.codehaus.stax2.ri.evt.BaseEventImpl;

public class NotationDeclarationEventImpl
extends BaseEventImpl
implements NotationDeclaration2 {
    final String mName;
    final String mPublicId;
    final String mSystemId;

    public NotationDeclarationEventImpl(Location loc, String name2, String pubId, String sysId) {
        super(loc);
        this.mName = name2;
        this.mPublicId = pubId;
        this.mSystemId = sysId;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public String getPublicId() {
        return this.mPublicId;
    }

    @Override
    public String getSystemId() {
        return this.mSystemId;
    }

    @Override
    public String getBaseURI() {
        return "";
    }

    @Override
    public int getEventType() {
        return 14;
    }

    @Override
    public void writeAsEncodedUnicode(Writer w2) throws XMLStreamException {
        try {
            w2.write("<!NOTATION ");
            w2.write(this.mName);
            if (this.mPublicId != null) {
                w2.write("PUBLIC \"");
                w2.write(this.mPublicId);
                w2.write(34);
            } else {
                w2.write("SYSTEM");
            }
            if (this.mSystemId != null) {
                w2.write(" \"");
                w2.write(this.mSystemId);
                w2.write(34);
            }
            w2.write(62);
        }
        catch (IOException ie) {
            this.throwFromIOE(ie);
        }
    }

    @Override
    public void writeUsing(XMLStreamWriter2 w2) throws XMLStreamException {
        throw new XMLStreamException("Can not write notation declarations using an XMLStreamWriter");
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (o2 == null) {
            return false;
        }
        if (!(o2 instanceof NotationDeclaration2)) {
            return false;
        }
        NotationDeclaration2 other = (NotationDeclaration2)o2;
        return NotationDeclarationEventImpl.stringsWithNullsEqual(this.getName(), other.getName()) && NotationDeclarationEventImpl.stringsWithNullsEqual(this.getPublicId(), other.getPublicId()) && NotationDeclarationEventImpl.stringsWithNullsEqual(this.getSystemId(), other.getSystemId()) && NotationDeclarationEventImpl.stringsWithNullsEqual(this.getBaseURI(), other.getBaseURI());
    }

    @Override
    public int hashCode() {
        int hash = 0;
        if (this.mName != null) {
            hash ^= this.mName.hashCode();
        }
        if (this.mPublicId != null) {
            hash ^= this.mPublicId.hashCode();
        }
        if (this.mSystemId != null) {
            hash ^= this.mSystemId.hashCode();
        }
        return hash;
    }
}

