/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.xom;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Comment;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import org.jaxen.BaseXPath;
import org.jaxen.DefaultNavigator;
import org.jaxen.FunctionCallException;
import org.jaxen.JaxenConstants;
import org.jaxen.UnsupportedAxisException;
import org.jaxen.XPath;
import org.jaxen.saxpath.SAXPathException;
import org.jaxen.util.SingleObjectIterator;

public class DocumentNavigator
extends DefaultNavigator {
    private static final long serialVersionUID = 3159311338575942877L;

    public boolean isAttribute(Object o2) {
        return o2 instanceof Attribute;
    }

    public boolean isComment(Object o2) {
        return o2 instanceof Comment;
    }

    public boolean isDocument(Object o2) {
        return o2 instanceof Document;
    }

    public boolean isElement(Object o2) {
        return o2 instanceof Element;
    }

    public boolean isNamespace(Object o2) {
        return o2 instanceof XPathNamespace;
    }

    public boolean isProcessingInstruction(Object o2) {
        return o2 instanceof ProcessingInstruction;
    }

    public boolean isText(Object o2) {
        return o2 instanceof Text;
    }

    public String getAttributeName(Object o2) {
        return this.isAttribute(o2) ? ((Attribute)o2).getLocalName() : null;
    }

    public String getAttributeNamespaceUri(Object o2) {
        return this.isAttribute(o2) ? ((Attribute)o2).getNamespaceURI() : null;
    }

    public String getAttributeQName(Object o2) {
        return this.isAttribute(o2) ? ((Attribute)o2).getQualifiedName() : null;
    }

    public String getAttributeStringValue(Object o2) {
        return this.isAttribute(o2) ? ((Attribute)o2).getValue() : null;
    }

    public String getCommentStringValue(Object o2) {
        return this.isComment(o2) ? ((Comment)o2).getValue() : null;
    }

    public String getElementName(Object o2) {
        return this.isElement(o2) ? ((Element)o2).getLocalName() : null;
    }

    public String getElementNamespaceUri(Object o2) {
        return this.isElement(o2) ? ((Element)o2).getNamespaceURI() : null;
    }

    public String getElementQName(Object o2) {
        return this.isElement(o2) ? ((Element)o2).getQualifiedName() : null;
    }

    public String getElementStringValue(Object o2) {
        return o2 instanceof Node ? ((Node)o2).getValue() : null;
    }

    public String getNamespacePrefix(Object o2) {
        if (this.isElement(o2)) {
            return ((Element)o2).getNamespacePrefix();
        }
        if (this.isAttribute(o2)) {
            return ((Attribute)o2).getNamespacePrefix();
        }
        if (o2 instanceof XPathNamespace) {
            return ((XPathNamespace)o2).getNamespacePrefix();
        }
        return null;
    }

    public String getNamespaceStringValue(Object o2) {
        if (this.isElement(o2)) {
            return ((Element)o2).getNamespaceURI();
        }
        if (this.isAttribute(o2)) {
            return ((Attribute)o2).getNamespaceURI();
        }
        if (o2 instanceof XPathNamespace) {
            return ((XPathNamespace)o2).getNamespaceURI();
        }
        return null;
    }

    public String getTextStringValue(Object o2) {
        return o2 instanceof Text ? ((Text)o2).getValue() : null;
    }

    public Object getDocument(String s2) throws FunctionCallException {
        try {
            return new Builder(new NodeFactory()).build(s2);
        }
        catch (Exception pe) {
            throw new FunctionCallException(pe);
        }
    }

    public Object getDocumentNode(Object o2) {
        ParentNode parent = null;
        if (o2 instanceof ParentNode) {
            parent = (ParentNode)o2;
        } else if (o2 instanceof Node) {
            parent = ((Node)o2).getParent();
        }
        return parent.getDocument();
    }

    public Iterator getAttributeAxisIterator(Object o2) {
        if (this.isElement(o2)) {
            return new IndexIterator(o2, 0, ((Element)o2).getAttributeCount()){

                public Object get(Object o2, int i2) {
                    return ((Element)o2).getAttribute(i2);
                }
            };
        }
        return JaxenConstants.EMPTY_ITERATOR;
    }

    public Iterator getChildAxisIterator(Object o2) {
        if (this.isElement(o2) || o2 instanceof Document) {
            return new IndexIterator(o2, 0, ((ParentNode)o2).getChildCount()){

                public Object get(Object o2, int i2) {
                    return ((ParentNode)o2).getChild(i2);
                }
            };
        }
        return JaxenConstants.EMPTY_ITERATOR;
    }

    public Iterator getParentAxisIterator(Object o2) {
        ParentNode parent = null;
        if (o2 instanceof Node) {
            parent = ((Node)o2).getParent();
        } else if (this.isNamespace(o2)) {
            parent = ((XPathNamespace)o2).getElement();
        }
        return parent != null ? new SingleObjectIterator(parent) : null;
    }

    public Object getParentNode(Object o2) {
        return o2 instanceof Node ? ((Node)o2).getParent() : null;
    }

    public Iterator getPrecedingAxisIterator(Object o2) throws UnsupportedAxisException {
        return super.getPrecedingAxisIterator(o2);
    }

    public Iterator getPrecedingSiblingAxisIterator(Object o2) throws UnsupportedAxisException {
        return super.getPrecedingSiblingAxisIterator(o2);
    }

    public String getProcessingInstructionData(Object o2) {
        return o2 instanceof ProcessingInstruction ? ((ProcessingInstruction)o2).getValue() : null;
    }

    public String getProcessingInstructionTarget(Object o2) {
        return o2 instanceof ProcessingInstruction ? ((ProcessingInstruction)o2).getTarget() : null;
    }

    public String translateNamespacePrefixToUri(String s2, Object o2) {
        Element element = null;
        if (o2 instanceof Element) {
            element = (Element)o2;
        } else if (!(o2 instanceof ParentNode)) {
            if (o2 instanceof Node) {
                element = (Element)((Node)o2).getParent();
            } else if (o2 instanceof XPathNamespace) {
                element = ((XPathNamespace)o2).getElement();
            }
        }
        if (element != null) {
            return element.getNamespaceURI(s2);
        }
        return null;
    }

    public XPath parseXPath(String s2) throws SAXPathException {
        return new BaseXPath(s2, this);
    }

    private boolean addNamespaceForElement(Element elt, String uri, String prefix, Map map2) {
        if (uri != null && uri.length() > 0 && !map2.containsKey(prefix)) {
            map2.put(prefix, new XPathNamespace(elt, uri, prefix));
            return true;
        }
        return false;
    }

    public Iterator getNamespaceAxisIterator(Object o2) {
        Element elt;
        if (!this.isElement(o2)) {
            return JaxenConstants.EMPTY_ITERATOR;
        }
        HashMap nsMap = new HashMap();
        Element parent = elt = (Element)o2;
        while (parent instanceof Element) {
            elt = parent;
            String uri = elt.getNamespaceURI();
            String prefix = elt.getNamespacePrefix();
            this.addNamespaceForElement(elt, uri, prefix, nsMap);
            int count2 = elt.getNamespaceDeclarationCount();
            for (int i2 = 0; i2 < count2; ++i2) {
                prefix = elt.getNamespacePrefix(i2);
                uri = elt.getNamespaceURI(prefix);
                this.addNamespaceForElement(elt, uri, prefix, nsMap);
            }
            parent = elt.getParent();
        }
        this.addNamespaceForElement(elt, "http://www.w3.org/XML/1998/namespace", "xml", nsMap);
        return nsMap.values().iterator();
    }

    private static class XPathNamespace {
        private Element element;
        private String uri;
        private String prefix;

        public XPathNamespace(Element elt, String uri, String prefix) {
            this.element = elt;
            this.uri = uri;
            this.prefix = prefix;
        }

        public Element getElement() {
            return this.element;
        }

        public String getNamespaceURI() {
            return this.uri;
        }

        public String getNamespacePrefix() {
            return this.prefix;
        }

        public String toString() {
            return "[xmlns:" + this.prefix + "=\"" + this.uri + "\", element=" + this.element.getLocalName() + "]";
        }
    }

    private static abstract class IndexIterator
    implements Iterator {
        private Object o = null;
        private int pos = 0;
        private int end = -1;

        public IndexIterator(Object o2, int pos, int end) {
            this.o = o2;
            this.pos = pos;
            this.end = end;
        }

        public boolean hasNext() {
            return this.pos < this.end;
        }

        public abstract Object get(Object var1, int var2);

        public Object next() {
            return this.get(this.o, this.pos++);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

