/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.jdom.Attribute;
import org.jdom.AttributeType;
import org.jdom.ImmutableAttribute;
import org.jdom.ImmutableElement;
import org.jdom.JDOMInterner;
import org.jdom.Namespace;
import org.jetbrains.annotations.NotNull;

final class ImmutableSameTypeAttributeList
implements List<Attribute> {
    private static final String[] EMPTY_STRING_ARRAY = ArrayUtilRt.EMPTY_STRING_ARRAY;
    private final String[] myNameValues;
    private final AttributeType myType;
    private final Namespace myNs;

    ImmutableSameTypeAttributeList(String @NotNull [] nameValues, AttributeType type, @NotNull Namespace ns) {
        if (ns == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(0);
        }
        if (nameValues == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(1);
        }
        this.myNameValues = nameValues.length == 0 ? EMPTY_STRING_ARRAY : nameValues;
        this.myType = type;
        this.myNs = ns;
    }

    @Override
    public Attribute get(int index2) {
        return new ImmutableAttribute(this.myNameValues[index2 * 2], this.myNameValues[index2 * 2 + 1], this.myType, this.myNs);
    }

    Attribute get(String name2, Namespace namespace) {
        if (!this.myNs.equals(namespace)) {
            return null;
        }
        for (int i2 = 0; i2 < this.myNameValues.length; i2 += 2) {
            String aname = this.myNameValues[i2];
            if (!aname.equals(name2)) continue;
            return this.get(i2 / 2);
        }
        return null;
    }

    String getValue(String name2, Namespace namespace, String def) {
        if (!this.myNs.equals(namespace)) {
            return def;
        }
        for (int i2 = 0; i2 < this.myNameValues.length; i2 += 2) {
            String aname = this.myNameValues[i2];
            if (!aname.equals(name2)) continue;
            return this.myNameValues[i2 + 1];
        }
        return def;
    }

    @Override
    public int size() {
        return this.myNameValues.length / 2;
    }

    public String toString() {
        return this.toList().toString();
    }

    @Override
    public int indexOf(Object o2) {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (!Comparing.equal(0, this.get(i2))) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o2) {
        for (int i2 = this.size() - 1; i2 >= 0; --i2) {
            if (!Comparing.equal(0, this.get(i2))) continue;
            return i2;
        }
        return -1;
    }

    @Override
    @NotNull
    public Iterator<Attribute> iterator() {
        if (this.isEmpty()) {
            Iterator<Attribute> iterator2 = Collections.emptyIterator();
            if (iterator2 == null) {
                ImmutableSameTypeAttributeList.$$$reportNull$$$0(2);
            }
            return iterator2;
        }
        return new Iterator<Attribute>(){
            int i;

            @Override
            public boolean hasNext() {
                return this.i < ImmutableSameTypeAttributeList.this.size();
            }

            @Override
            public Attribute next() {
                return ImmutableSameTypeAttributeList.this.get(this.i++);
            }

            @Override
            public void remove() {
                throw ImmutableElement.immutableError(ImmutableSameTypeAttributeList.this);
            }
        };
    }

    @Override
    @NotNull
    public List<Attribute> subList(int fromIndex, int toIndex) {
        List<Attribute> list2 = this.toList().subList(fromIndex, toIndex);
        if (list2 == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(3);
        }
        return list2;
    }

    private List<Attribute> toList() {
        ArrayList<Attribute> list2 = new ArrayList<Attribute>(this.size());
        for (int i2 = 0; i2 < this.size(); ++i2) {
            list2.add(this.get(i2));
        }
        return list2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof List) || this.size() != ((List)o2).size()) {
            return false;
        }
        if (this.size() == 0) {
            return true;
        }
        if (o2 instanceof ImmutableSameTypeAttributeList) {
            ImmutableSameTypeAttributeList io = (ImmutableSameTypeAttributeList)o2;
            return this.myType == io.myType && this.myNs.equals(io.myNs) && Arrays.equals(this.myNameValues, io.myNameValues);
        }
        List l2 = (List)o2;
        for (int i2 = 0; i2 < this.myNameValues.length; i2 += 2) {
            String name2 = this.myNameValues[i2];
            String value = this.myNameValues[i2 + 1];
            Attribute a2 = (Attribute)l2.get(i2 / 2);
            if (Objects.equals(name2, a2.getName()) && Objects.equals(value, a2.getValue()) && Comparing.equal(this.myType, a2.getAttributeType()) && Comparing.equal(this.myNs, a2.getNamespace())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result2 = 1;
        for (int i2 = 0; i2 < this.myNameValues.length; i2 += 2) {
            String name2 = this.myNameValues[i2];
            String value = this.myNameValues[i2 + 1];
            result2 = result2 * 31 + JDOMInterner.computeAttributeHashCode(name2, value);
        }
        return result2;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o2) {
        return this.indexOf(o2) != -1;
    }

    @Override
    public Object @NotNull [] toArray() {
        Object[] objectArray = this.toList().toArray(new Attribute[0]);
        if (objectArray == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    @Override
    public <T> T @NotNull [] toArray(T @NotNull [] a2) {
        if (a2 == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(5);
        }
        Object[] objectArray = this.toArray();
        if (objectArray == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(6);
        }
        return objectArray;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c2) {
        if (c2 == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(7);
        }
        for (Object o2 : c2) {
            if (this.contains(o2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(Attribute obj) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public void add(int index2, Attribute obj) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Attribute> collection) {
        if (collection == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(8);
        }
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean addAll(int index2, @NotNull Collection<? extends Attribute> collection) {
        if (collection == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(9);
        }
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public void clear() {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Attribute remove(int index2) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Attribute set(int index2, Attribute obj) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    @NotNull
    public ListIterator<Attribute> listIterator() {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    @NotNull
    public ListIterator<Attribute> listIterator(int index2) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean remove(Object o2) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c2) {
        if (c2 == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(10);
        }
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c2) {
        if (c2 == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(11);
        }
        throw ImmutableElement.immutableError(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ns";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameValues";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jdom/ImmutableSameTypeAttributeList";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jdom/ImmutableSameTypeAttributeList";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "subList";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "containsAll";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeAll";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "retainAll";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

