/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.util.Function;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.ExceptionsKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.CountDownConsumer;
import org.jetbrains.concurrency.DonePromise;
import org.jetbrains.concurrency.MessageError;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.ObsolescentConsumer;
import org.jetbrains.concurrency.ObsolescentFunction;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseValue;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.concurrency.Promises__PromiseKt;
import org.jetbrains.concurrency.ValueNodeAsyncFunction;

@Metadata(mv={1, 9, 0}, k=5, xi=48, d1={"\u0000\u0082\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a.\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0001\"\u0004\b\u0000\u0010\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0\u00010\u001f2\u0006\u0010 \u001a\u00020!\u001a\u0012\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0001\"\u0004\b\u0000\u0010\u001d\u001a\u001e\u0010#\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010$\u001a\u00020!2\b\b\u0002\u0010%\u001a\u00020\u0019H\u0007\u001a\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u0001\u001a\u001a\u0010'\u001a\b\u0012\u0004\u0012\u0002H\u001d0\r\"\u0004\b\u0000\u0010\u001d2\u0006\u0010$\u001a\u00020!\u001a\u0012\u0010(\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0001\"\u0004\b\u0000\u0010\u001d\u001a\u001a\u0010(\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0001\"\u0004\b\u0000\u0010\u001d2\u0006\u0010$\u001a\u00020!\u001a\u001c\u0010(\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0001\"\u0004\b\u0000\u0010\u001d2\b\u0010$\u001a\u0004\u0018\u00010)\u001a\u001f\u0010*\u001a\b\u0012\u0004\u0012\u0002H\u001d0\r\"\u0004\b\u0000\u0010\u001d2\u0006\u0010+\u001a\u0002H\u001d\u00a2\u0006\u0002\u0010,\u001a\u0012\u0010-\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0001\"\u0004\b\u0000\u0010\u001d\u001a\u001f\u0010-\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0001\"\u0004\b\u0000\u0010\u001d2\u0006\u0010+\u001a\u0002H\u001d\u00a2\u0006\u0002\u0010.\u001a(\u0010/\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0001\"\u0004\b\u0000\u0010\u001d2\u000e\b\u0004\u00100\u001a\b\u0012\u0004\u0012\u0002H\u001d01H\u0086\b\u00f8\u0001\u0000\u001a\u0018\u00102\u001a\u0006\u0012\u0002\b\u00030\u0001*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u001f\u001a9\u00102\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0001\"\u0004\b\u0000\u0010\u001d*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u001f2\u0006\u00103\u001a\u0002H\u001d2\b\b\u0002\u00104\u001a\u00020\u0019H\u0007\u00a2\u0006\u0002\u00105\u001a\u001c\u00106\u001a\b\u0012\u0004\u0012\u0002H\u001d0\r\"\u0004\b\u0000\u0010\u001d*\b\u0012\u0004\u0012\u0002H\u001d07\u001a\u001c\u00108\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0001\"\u0004\b\u0000\u0010\u001d*\b\u0012\u0004\u0012\u0002H\u001d07\u001a\u000e\u00108\u001a\u0006\u0012\u0002\b\u00030\u0001*\u000209\u001a8\u0010:\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0;0\u0001\"\b\b\u0000\u0010\u001d*\u00020\u0002*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0\u00010\u001f2\b\b\u0002\u00104\u001a\u00020\u0019H\u0007\u001a*\u0010<\u001a\u00020=\"\u0004\b\u0000\u0010\u001d*\b\u0012\u0004\u0012\u0002H\u001d0>2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H\u001d01H\u0086\b\u00f8\u0001\u0000\u001a\u0012\u0010?\u001a\u00020\u0019*\u00020@2\u0006\u0010A\u001a\u00020)\u001a:\u0010B\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010C\u001a\u00020D2\u0014\b\u0004\u0010E\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020=0FH\u0086\b\u00f8\u0001\u0000\u001a@\u0010G\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0001\"\u0004\b\u0000\u0010\u001d*\b\u0012\u0004\u0012\u0002H\u001d0\u00012\u0006\u0010C\u001a\u00020D2\u0014\b\u0004\u0010E\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u00020=0FH\u0086\b\u00f8\u0001\u0000\u001a4\u0010H\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010C\u001a\u00020D2\u000e\b\u0004\u0010E\u001a\b\u0012\u0004\u0012\u00020=01H\u0086\b\u00f8\u0001\u0000\u001a(\u0010I\u001a\u0006\u0012\u0002\b\u00030\u0001*\u0006\u0012\u0002\b\u00030\u00012\u000e\b\u0004\u0010E\u001a\b\u0012\u0004\u0012\u00020=01H\u0086\b\u00f8\u0001\u0000\u001aF\u0010J\u001a\b\u0012\u0004\u0012\u0002HK0\u0001\"\u0004\b\u0000\u0010\u001d\"\u0004\b\u0001\u0010K*\b\u0012\u0004\u0012\u0002H\u001d0\u00012\u0006\u0010L\u001a\u00020D2\u0014\b\u0004\u0010E\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002HK0FH\u0086\b\u00f8\u0001\u0000\u001aL\u0010M\u001a\b\u0012\u0004\u0012\u0002HK0\u0001\"\u0004\b\u0000\u0010\u001d\"\u0004\b\u0001\u0010K*\b\u0012\u0004\u0012\u0002H\u001d0\u00012\u0006\u0010C\u001a\u00020D2\u001a\b\u0004\u0010E\u001a\u0014\u0012\u0004\u0012\u0002H\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u0002HK0\u00010FH\u0086\b\u00f8\u0001\u0000\u001a>\u0010N\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001\"\u0004\b\u0000\u0010\u001d*\b\u0012\u0004\u0012\u0002H\u001d0\u00012\u0018\b\u0004\u0010E\u001a\u0012\u0012\u0004\u0012\u0002H\u001d\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010FH\u0086\b\u00f8\u0001\u0000\u001aF\u0010N\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001\"\u0004\b\u0000\u0010\u001d*\b\u0012\u0004\u0012\u0002H\u001d0\u00012\u0006\u0010C\u001a\u00020D2\u0018\b\u0004\u0010E\u001a\u0012\u0012\u0004\u0012\u0002H\u001d\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010FH\u0086\b\u00f8\u0001\u0000\u001a0\u0010O\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0001\"\u0004\b\u0000\u0010\u001d*\u0006\u0012\u0002\b\u00030\u00012\u000e\b\u0004\u0010E\u001a\b\u0012\u0004\u0012\u0002H\u001d01H\u0086\b\u00f8\u0001\u0000\u001a\u000e\u0010P\u001a\u00020Q*\u0006\u0012\u0002\b\u00030\u0001\u001a\u0012\u0010R\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001*\u00020Q\")\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0007\u0010\b\u0012\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\"\u001f\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\b\u001a\u0004\b\n\u0010\u0006\")\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\b\u0012\u0004\b\u000e\u0010\u0004\u001a\u0004\b\u000f\u0010\u0010\"\u001f\u0010\u0012\u001a\u00060\u0013j\u0002`\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\b\u001a\u0004\b\u0015\u0010\u0016\"\u0019\u0010\u0018\u001a\u00020\u0019*\u0006\u0012\u0002\b\u00030\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001a\"\u0019\u0010\u001b\u001a\u00020\u0019*\u0006\u0012\u0002\b\u00030\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001a\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006S"}, d2={"CANCELLED_PROMISE", "Lorg/jetbrains/concurrency/Promise;", "", "getCANCELLED_PROMISE$annotations$Promises__PromiseKt", "()V", "getCANCELLED_PROMISE$Promises__PromiseKt", "()Lorg/jetbrains/concurrency/Promise;", "CANCELLED_PROMISE$delegate", "Lkotlin/Lazy;", "REJECTED", "getREJECTED$Promises__PromiseKt", "REJECTED$delegate", "fulfilledPromise", "Lorg/jetbrains/concurrency/CancellablePromise;", "getFulfilledPromise$annotations$Promises__PromiseKt", "getFulfilledPromise$Promises__PromiseKt", "()Lorg/jetbrains/concurrency/CancellablePromise;", "fulfilledPromise$delegate", "obsoleteError", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "getObsoleteError$Promises__PromiseKt", "()Ljava/lang/RuntimeException;", "obsoleteError$delegate", "isPending", "", "(Lorg/jetbrains/concurrency/Promise;)Z", "isRejected", "any", "T", "promises", "", "totalError", "", "cancelledPromise", "createError", "error", "log", "nullPromise", "rejectedCancellablePromise", "rejectedPromise", "", "resolvedCancellablePromise", "result", "(Ljava/lang/Object;)Lorg/jetbrains/concurrency/CancellablePromise;", "resolvedPromise", "(Ljava/lang/Object;)Lorg/jetbrains/concurrency/Promise;", "runAsync", "runnable", "Lkotlin/Function0;", "all", "totalResult", "ignoreErrors", "(Ljava/util/Collection;Ljava/lang/Object;Z)Lorg/jetbrains/concurrency/Promise;", "asCancellablePromise", "Ljava/util/concurrent/CompletableFuture;", "asPromise", "Lkotlinx/coroutines/Job;", "collectResults", "", "compute", "", "Lorg/jetbrains/concurrency/AsyncPromise;", "errorIfNotMessage", "Lcom/intellij/openapi/diagnostic/Logger;", "e", "onError", "node", "Lorg/jetbrains/concurrency/Obsolescent;", "handler", "Lkotlin/Function1;", "onSuccess", "processed", "processedRun", "then", "SUB_RESULT", "obsolescent", "thenAsync", "thenAsyncAccept", "thenRun", "toActionCallback", "Lcom/intellij/openapi/util/ActionCallback;", "toPromise", "intellij.platform.concurrency"}, xs="org/jetbrains/concurrency/Promises")
final class Promises__PromiseKt {
    @NotNull
    private static final Lazy obsoleteError$delegate = LazyKt.lazy(obsoleteError.2.INSTANCE);
    @NotNull
    private static final Lazy REJECTED$delegate = LazyKt.lazy(REJECTED.2.INSTANCE);
    @NotNull
    private static final Lazy fulfilledPromise$delegate = LazyKt.lazy(fulfilledPromise.2.INSTANCE);
    @NotNull
    private static final Lazy CANCELLED_PROMISE$delegate = LazyKt.lazy(CANCELLED_PROMISE.2.INSTANCE);

    private static final RuntimeException getObsoleteError$Promises__PromiseKt() {
        Lazy lazy = obsoleteError$delegate;
        return (RuntimeException)lazy.getValue();
    }

    public static final boolean isRejected(@NotNull Promise<?> $this$isRejected) {
        Intrinsics.checkNotNullParameter($this$isRejected, "<this>");
        return $this$isRejected.getState() == Promise.State.REJECTED;
    }

    public static final boolean isPending(@NotNull Promise<?> $this$isPending) {
        Intrinsics.checkNotNullParameter($this$isPending, "<this>");
        return $this$isPending.getState() == Promise.State.PENDING;
    }

    private static final Promise<?> getREJECTED$Promises__PromiseKt() {
        Lazy lazy = REJECTED$delegate;
        return (Promise)lazy.getValue();
    }

    private static final CancellablePromise<Object> getFulfilledPromise$Promises__PromiseKt() {
        Lazy lazy = fulfilledPromise$delegate;
        return (CancellablePromise)lazy.getValue();
    }

    private static /* synthetic */ void getFulfilledPromise$annotations$Promises__PromiseKt() {
    }

    @NotNull
    public static final <T> Promise<T> resolvedPromise() {
        CancellablePromise<Object> cancellablePromise = Promises__PromiseKt.getFulfilledPromise$Promises__PromiseKt();
        Intrinsics.checkNotNull(cancellablePromise, "null cannot be cast to non-null type org.jetbrains.concurrency.Promise<T of org.jetbrains.concurrency.Promises__PromiseKt.resolvedPromise>");
        return cancellablePromise;
    }

    @NotNull
    public static final Promise<?> nullPromise() {
        return Promises__PromiseKt.getFulfilledPromise$Promises__PromiseKt();
    }

    @NotNull
    public static final <T> Promise<T> resolvedPromise(T result2) {
        return Promises.resolvedCancellablePromise(result2);
    }

    @NotNull
    public static final <T> CancellablePromise<T> resolvedCancellablePromise(T result2) {
        CancellablePromise cancellablePromise;
        if (result2 == null) {
            CancellablePromise cancellablePromise2 = Promises__PromiseKt.getFulfilledPromise$Promises__PromiseKt();
            cancellablePromise = cancellablePromise2;
            Intrinsics.checkNotNull(cancellablePromise2, "null cannot be cast to non-null type org.jetbrains.concurrency.CancellablePromise<T of org.jetbrains.concurrency.Promises__PromiseKt.resolvedCancellablePromise>");
        } else {
            cancellablePromise = new DonePromise<T>(PromiseValue.Companion.createFulfilled(result2));
        }
        return cancellablePromise;
    }

    @NotNull
    public static final <T> Promise<T> rejectedPromise() {
        Promise<?> promise = Promises__PromiseKt.getREJECTED$Promises__PromiseKt();
        Intrinsics.checkNotNull(promise, "null cannot be cast to non-null type org.jetbrains.concurrency.Promise<T of org.jetbrains.concurrency.Promises__PromiseKt.rejectedPromise>");
        return promise;
    }

    @NotNull
    public static final <T> Promise<T> rejectedPromise(@NotNull String error) {
        Intrinsics.checkNotNullParameter(error, "error");
        return Promises.rejectedCancellablePromise(error);
    }

    @NotNull
    public static final <T> Promise<T> rejectedPromise(@Nullable Throwable error) {
        Promise promise;
        if (error == null) {
            Promise promise2 = Promises__PromiseKt.getREJECTED$Promises__PromiseKt();
            promise = promise2;
            Intrinsics.checkNotNull(promise2, "null cannot be cast to non-null type org.jetbrains.concurrency.Promise<T of org.jetbrains.concurrency.Promises__PromiseKt.rejectedPromise>");
        } else {
            promise = new DonePromise(PromiseValue.Companion.createRejected(error));
        }
        return promise;
    }

    @NotNull
    public static final <T> CancellablePromise<T> rejectedCancellablePromise(@NotNull String error) {
        Intrinsics.checkNotNullParameter(error, "error");
        return new DonePromise(PromiseValue.Companion.createRejected(Promises.createError(error, true)));
    }

    private static final Promise<Object> getCANCELLED_PROMISE$Promises__PromiseKt() {
        Lazy lazy = CANCELLED_PROMISE$delegate;
        return (Promise)lazy.getValue();
    }

    private static /* synthetic */ void getCANCELLED_PROMISE$annotations$Promises__PromiseKt() {
    }

    @NotNull
    public static final <T> Promise<T> cancelledPromise() {
        Promise<Object> promise = Promises__PromiseKt.getCANCELLED_PROMISE$Promises__PromiseKt();
        Intrinsics.checkNotNull(promise, "null cannot be cast to non-null type org.jetbrains.concurrency.Promise<T of org.jetbrains.concurrency.Promises__PromiseKt.cancelledPromise>");
        return promise;
    }

    @NotNull
    public static final <T, SUB_RESULT> Promise<SUB_RESULT> then(@NotNull Promise<T> $this$then, @NotNull Obsolescent obsolescent, @NotNull Function1<? super T, ? extends SUB_RESULT> handler) {
        Intrinsics.checkNotNullParameter($this$then, "<this>");
        Intrinsics.checkNotNullParameter(obsolescent, "obsolescent");
        Intrinsics.checkNotNullParameter(handler, "handler");
        boolean $i$f$then = false;
        Promise promise = $this$then.then(new ObsolescentFunction<T, SUB_RESULT>(handler, obsolescent){
            final /* synthetic */ Function1<T, SUB_RESULT> $handler;
            final /* synthetic */ Obsolescent $obsolescent;
            {
                this.$handler = $handler;
                this.$obsolescent = $obsolescent;
            }

            public SUB_RESULT fun(T param) {
                return this.$handler.invoke(param);
            }

            public boolean isObsolete() {
                return this.$obsolescent.isObsolete();
            }
        });
        Intrinsics.checkNotNullExpressionValue(promise, "then(...)");
        return promise;
    }

    @NotNull
    public static final <T> Promise<T> onSuccess(@NotNull Promise<T> $this$onSuccess, @NotNull Obsolescent node, @NotNull Function1<? super T, Unit> handler) {
        Intrinsics.checkNotNullParameter($this$onSuccess, "<this>");
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(handler, "handler");
        boolean $i$f$onSuccess = false;
        Promise<T> promise = $this$onSuccess.onSuccess(new ObsolescentConsumer<T>(node, handler){
            final /* synthetic */ Function1<T, Unit> $handler;
            {
                this.$handler = $handler;
                super($node);
            }

            public void accept(T param) {
                this.$handler.invoke(param);
            }
        });
        Intrinsics.checkNotNullExpressionValue(promise, "onSuccess(...)");
        return promise;
    }

    @NotNull
    public static final Promise<Object> processed(@NotNull Promise<?> $this$processed, @NotNull Obsolescent node, @NotNull Function0<Unit> handler) {
        Intrinsics.checkNotNullParameter($this$processed, "<this>");
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(handler, "handler");
        boolean $i$f$processed = false;
        Promise<Object> promise = $this$processed.onProcessed((Consumer)new ObsolescentConsumer<Object>(node, handler){
            final /* synthetic */ Function0<Unit> $handler;
            {
                this.$handler = $handler;
                super($node);
            }

            public void accept(@Nullable Object param) {
                this.$handler.invoke();
            }
        });
        Intrinsics.checkNotNullExpressionValue(promise, "onProcessed(...)");
        return promise;
    }

    @NotNull
    public static final <T> Promise<T> thenRun(@NotNull Promise<?> $this$thenRun, @NotNull Function0<? extends T> handler) {
        Intrinsics.checkNotNullParameter($this$thenRun, "<this>");
        Intrinsics.checkNotNullParameter(handler, "handler");
        boolean $i$f$thenRun = false;
        Promise promise = $this$thenRun.then(new Function(handler){
            final /* synthetic */ Function0<T> $handler;
            {
                this.$handler = $handler;
            }

            public final T fun(@Nullable Object it) {
                return this.$handler.invoke();
            }
        });
        Intrinsics.checkNotNullExpressionValue(promise, "then(...)");
        return promise;
    }

    @NotNull
    public static final Promise<?> processedRun(@NotNull Promise<?> $this$processedRun, @NotNull Function0<Unit> handler) {
        Intrinsics.checkNotNullParameter($this$processedRun, "<this>");
        Intrinsics.checkNotNullParameter(handler, "handler");
        boolean $i$f$processedRun = false;
        Promise<?> promise = $this$processedRun.onProcessed(new Consumer(handler){
            final /* synthetic */ Function0<Unit> $handler;
            {
                this.$handler = $handler;
            }

            public final void accept(@Nullable Object it) {
                this.$handler.invoke();
            }
        });
        Intrinsics.checkNotNullExpressionValue(promise, "onProcessed(...)");
        return promise;
    }

    @NotNull
    public static final <T, SUB_RESULT> Promise<SUB_RESULT> thenAsync(@NotNull Promise<T> $this$thenAsync, @NotNull Obsolescent node, @NotNull Function1<? super T, ? extends Promise<SUB_RESULT>> handler) {
        Intrinsics.checkNotNullParameter($this$thenAsync, "<this>");
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(handler, "handler");
        boolean $i$f$thenAsync = false;
        Promise promise = $this$thenAsync.thenAsync(new ValueNodeAsyncFunction<T, SUB_RESULT>(node, handler){
            final /* synthetic */ Function1<T, Promise<SUB_RESULT>> $handler;
            {
                this.$handler = $handler;
                super($node);
            }

            @NotNull
            public Promise<SUB_RESULT> fun(T param) {
                return this.$handler.invoke(param);
            }
        });
        Intrinsics.checkNotNullExpressionValue(promise, "thenAsync(...)");
        return promise;
    }

    @NotNull
    public static final <T> Promise<Object> thenAsyncAccept(@NotNull Promise<T> $this$thenAsyncAccept, @NotNull Obsolescent node, @NotNull Function1<? super T, ? extends Promise<?>> handler) {
        Intrinsics.checkNotNullParameter($this$thenAsyncAccept, "<this>");
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(handler, "handler");
        boolean $i$f$thenAsyncAccept = false;
        Promise<Object> promise = $this$thenAsyncAccept.thenAsync(new ValueNodeAsyncFunction<T, Object>(node, handler){
            final /* synthetic */ Function1<T, Promise<?>> $handler;
            {
                this.$handler = $handler;
                super($node);
            }

            @NotNull
            public Promise<Object> fun(T param) {
                Promise<Object> promise = this.$handler.invoke(param);
                Intrinsics.checkNotNull(promise, "null cannot be cast to non-null type org.jetbrains.concurrency.Promise<kotlin.Any?>");
                return promise;
            }
        });
        Intrinsics.checkNotNullExpressionValue(promise, "thenAsync(...)");
        return promise;
    }

    @NotNull
    public static final <T> Promise<Object> thenAsyncAccept(@NotNull Promise<T> $this$thenAsyncAccept, @NotNull Function1<? super T, ? extends Promise<?>> handler) {
        Intrinsics.checkNotNullParameter($this$thenAsyncAccept, "<this>");
        Intrinsics.checkNotNullParameter(handler, "handler");
        boolean $i$f$thenAsyncAccept = false;
        Promise<Object> promise = $this$thenAsyncAccept.thenAsync(new Function(handler){
            final /* synthetic */ Function1<T, Promise<?>> $handler;
            {
                this.$handler = $handler;
            }

            public final Promise<Object> fun(T param) {
                Promise<Object> promise = this.$handler.invoke(param);
                Intrinsics.checkNotNull(promise, "null cannot be cast to non-null type org.jetbrains.concurrency.Promise<kotlin.Any?>");
                return promise;
            }
        });
        Intrinsics.checkNotNullExpressionValue(promise, "thenAsync(...)");
        return promise;
    }

    @NotNull
    public static final Promise<? extends Object> onError(@NotNull Promise<?> $this$onError, @NotNull Obsolescent node, @NotNull Function1<? super Throwable, Unit> handler) {
        Intrinsics.checkNotNullParameter($this$onError, "<this>");
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(handler, "handler");
        boolean $i$f$onError = false;
        Promise<?> promise = $this$onError.onError((Consumer<Throwable>)new ObsolescentConsumer<Throwable>(node, handler){
            final /* synthetic */ Function1<Throwable, Unit> $handler;
            {
                this.$handler = $handler;
                super($node);
            }

            public void accept(@NotNull Throwable param) {
                Intrinsics.checkNotNullParameter(param, "param");
                this.$handler.invoke(param);
            }
        });
        Intrinsics.checkNotNullExpressionValue(promise, "onError(...)");
        return promise;
    }

    @JvmOverloads
    @NotNull
    public static final <T> Promise<List<T>> collectResults(@NotNull Collection<? extends Promise<T>> $this$collectResults, boolean ignoreErrors) {
        Intrinsics.checkNotNullParameter($this$collectResults, "<this>");
        if ($this$collectResults.isEmpty()) {
            return Promises.resolvedPromise(CollectionsKt.emptyList());
        }
        AsyncPromise result2 = new AsyncPromise();
        AtomicInteger latch = new AtomicInteger($this$collectResults.size());
        List<Object> list2 = Collections.nCopies($this$collectResults.size(), null);
        Intrinsics.checkNotNullExpressionValue(list2, "nCopies(...)");
        List list3 = Collections.synchronizedList(CollectionsKt.toMutableList((Collection)list2));
        Iterator<Promise<T>> iterator2 = $this$collectResults.iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            int i2 = n2++;
            Promise<Object> promise = iterator2.next();
            promise.onSuccess(arg_0 -> Promises__PromiseKt.collectResults$lambda$1$Promises__PromiseKt(new Function1<T, Unit>(list3, i2, latch, ignoreErrors, result2){
                final /* synthetic */ List<T> $list;
                final /* synthetic */ int $i;
                final /* synthetic */ AtomicInteger $latch;
                final /* synthetic */ boolean $ignoreErrors;
                final /* synthetic */ AsyncPromise<List<T>> $result;
                {
                    this.$list = $list;
                    this.$i = $i;
                    this.$latch = $latch;
                    this.$ignoreErrors = $ignoreErrors;
                    this.$result = $result;
                    super(1);
                }

                public final void invoke(T it) {
                    this.$list.set(this.$i, it);
                    Promises__PromiseKt.access$collectResults$arrive(this.$latch, this.$ignoreErrors, this.$list, this.$result);
                }
            }, arg_0));
            promise.onError(arg_0 -> Promises__PromiseKt.collectResults$lambda$2$Promises__PromiseKt(new Function1<Throwable, Unit>(ignoreErrors, result2, latch, list3){
                final /* synthetic */ boolean $ignoreErrors;
                final /* synthetic */ AsyncPromise<List<T>> $result;
                final /* synthetic */ AtomicInteger $latch;
                final /* synthetic */ List<T> $list;
                {
                    this.$ignoreErrors = $ignoreErrors;
                    this.$result = $result;
                    this.$latch = $latch;
                    this.$list = $list;
                    super(1);
                }

                public final void invoke(Throwable it) {
                    if (this.$ignoreErrors) {
                        Promises__PromiseKt.access$collectResults$arrive(this.$latch, this.$ignoreErrors, this.$list, this.$result);
                    } else {
                        Intrinsics.checkNotNull(it);
                        this.$result.setError(it);
                    }
                }
            }, arg_0));
        }
        return result2;
    }

    public static /* synthetic */ Promise collectResults$default(Collection collection, boolean bl2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl2 = false;
        }
        return Promises.collectResults(collection, bl2);
    }

    @JvmOverloads
    @NotNull
    public static final RuntimeException createError(@NotNull String error, boolean log) {
        Intrinsics.checkNotNullParameter(error, "error");
        return new MessageError(error, log);
    }

    public static /* synthetic */ RuntimeException createError$default(String string2, boolean bl2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl2 = false;
        }
        return Promises.createError(string2, bl2);
    }

    public static final <T> void compute(@NotNull AsyncPromise<T> $this$compute, @NotNull Function0<? extends T> runnable) {
        T t2;
        Intrinsics.checkNotNullParameter($this$compute, "<this>");
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        boolean $i$f$compute = false;
        try {
            t2 = runnable.invoke();
        }
        catch (Throwable e2) {
            $this$compute.setError(e2);
            return;
        }
        T result2 = t2;
        $this$compute.setResult(result2);
    }

    @NotNull
    public static final <T> Promise<T> runAsync(@NotNull Function0<? extends T> runnable) {
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        boolean $i$f$runAsync = false;
        AsyncPromise promise = new AsyncPromise();
        AppExecutorUtil.getAppExecutorService().execute(new Runnable(runnable, promise){
            final /* synthetic */ Function0<T> $runnable;
            final /* synthetic */ AsyncPromise<T> $promise;
            {
                this.$runnable = $runnable;
                this.$promise = $promise;
            }

            public final void run() {
                T t2;
                try {
                    t2 = this.$runnable.invoke();
                }
                catch (Throwable e2) {
                    this.$promise.setError(e2);
                    return;
                }
                T result2 = t2;
                this.$promise.setResult(result2);
            }
        });
        return promise;
    }

    public static final boolean errorIfNotMessage(@NotNull Logger $this$errorIfNotMessage, @NotNull Throwable e2) {
        block5: {
            block3: {
                block4: {
                    Intrinsics.checkNotNullParameter($this$errorIfNotMessage, "<this>");
                    Intrinsics.checkNotNullParameter(e2, "e");
                    if (!(e2 instanceof MessageError)) break block3;
                    ThreeState log = ((MessageError)e2).getLog();
                    if (log == ThreeState.YES) break block4;
                    if (log != ThreeState.UNSURE) break block5;
                    Application application = ApplicationManager.getApplication();
                    boolean bl2 = application != null ? application.isUnitTestMode() : false;
                    if (!bl2) break block5;
                }
                $this$errorIfNotMessage.error(e2);
                return true;
            }
            if (!(e2 instanceof ControlFlowException) && !(e2 instanceof CancellationException)) {
                $this$errorIfNotMessage.error(e2);
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static final <T> Promise<T> asPromise(@NotNull CompletableFuture<T> $this$asPromise) {
        Intrinsics.checkNotNullParameter($this$asPromise, "<this>");
        AsyncPromise promise = new AsyncPromise();
        $this$asPromise.handle((arg_0, arg_1) -> Promises__PromiseKt.asPromise$lambda$3$Promises__PromiseKt(new Function2<T, Throwable, T>(promise){
            final /* synthetic */ AsyncPromise<T> $promise;
            {
                this.$promise = $promise;
                super(2);
            }

            public final T invoke(T result2, Throwable throwable) {
                if (throwable == null) {
                    this.$promise.setResult(result2);
                } else {
                    this.$promise.setError(throwable);
                }
                return result2;
            }
        }, arg_0, arg_1));
        return promise;
    }

    @NotNull
    public static final <T> CancellablePromise<T> asCancellablePromise(@NotNull CompletableFuture<T> $this$asCancellablePromise) {
        Intrinsics.checkNotNullParameter($this$asCancellablePromise, "<this>");
        AsyncPromise promise = new AsyncPromise();
        CompletableFuture<T> future2 = $this$asCancellablePromise;
        $this$asCancellablePromise.handle((arg_0, arg_1) -> Promises__PromiseKt.asCancellablePromise$lambda$4$Promises__PromiseKt(new Function2<T, Throwable, T>(promise){
            final /* synthetic */ AsyncPromise<T> $promise;
            {
                this.$promise = $promise;
                super(2);
            }

            public final T invoke(T result2, Throwable throwable) {
                if (throwable == null) {
                    this.$promise.setResult(result2);
                } else {
                    this.$promise.setError(throwable);
                }
                return result2;
            }
        }, arg_0, arg_1));
        promise.getF$intellij_platform_concurrency().handle((arg_0, arg_1) -> Promises__PromiseKt.asCancellablePromise$lambda$5$Promises__PromiseKt(new Function2<T, Throwable, T>(future2){
            final /* synthetic */ CompletableFuture<T> $future;
            {
                this.$future = $future;
                super(2);
            }

            public final T invoke(T result2, Throwable throwable) {
                if (Intrinsics.areEqual(throwable, AsyncPromise.CANCELED) && !this.$future.isDone()) {
                    this.$future.completeExceptionally(throwable);
                }
                return result2;
            }
        }, arg_0, arg_1));
        return promise;
    }

    @NotNull
    public static final Promise<?> asPromise(@NotNull Job $this$asPromise) {
        Intrinsics.checkNotNullParameter($this$asPromise, "<this>");
        AsyncPromise<Object> promise = new AsyncPromise<Object>();
        promise.onError(arg_0 -> Promises__PromiseKt.asPromise$lambda$6$Promises__PromiseKt(new Function1<Throwable, Unit>($this$asPromise){
            final /* synthetic */ Job $this_asPromise;
            {
                this.$this_asPromise = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter(throwable, "throwable");
                CancellationException cancellationException = throwable instanceof CancellationException ? (CancellationException)throwable : null;
                if (cancellationException == null) {
                    cancellationException = ExceptionsKt.CancellationException("Promise was completed exceptionally", throwable);
                }
                CancellationException cancellationException2 = cancellationException;
                this.$this_asPromise.cancel(cancellationException2);
            }
        }, arg_0));
        $this$asPromise.invokeOnCompletion((Function1<? super Throwable, Unit>)new Function1<Throwable, Unit>(promise){
            final /* synthetic */ AsyncPromise<Object> $promise;
            {
                this.$promise = $promise;
                super(1);
            }

            public final void invoke(@Nullable Throwable throwable) {
                if (throwable == null) {
                    this.$promise.setResult(null);
                } else {
                    this.$promise.setError(throwable);
                }
            }
        });
        return promise;
    }

    @NotNull
    public static final Promise<Object> toPromise(@NotNull ActionCallback $this$toPromise) {
        Intrinsics.checkNotNullParameter($this$toPromise, "<this>");
        AsyncPromise<Object> promise = new AsyncPromise<Object>();
        $this$toPromise.doWhenDone(() -> Promises__PromiseKt.toPromise$lambda$7$Promises__PromiseKt(promise)).doWhenRejected(arg_0 -> Promises__PromiseKt.toPromise$lambda$8$Promises__PromiseKt(new Function1<String, Unit>(promise){
            final /* synthetic */ AsyncPromise<Object> $promise;
            {
                this.$promise = $promise;
                super(1);
            }

            public final void invoke(String error) {
                String string2 = error;
                if (string2 == null) {
                    string2 = "Internal error";
                }
                this.$promise.setError(Promises.createError$default(string2, false, 2, null));
            }
        }, arg_0));
        return promise;
    }

    @NotNull
    public static final ActionCallback toActionCallback(@NotNull Promise<?> $this$toActionCallback) {
        Intrinsics.checkNotNullParameter($this$toActionCallback, "<this>");
        ActionCallback result2 = new ActionCallback();
        $this$toActionCallback.onSuccess(arg_0 -> Promises__PromiseKt.toActionCallback$lambda$9$Promises__PromiseKt(result2, arg_0));
        $this$toActionCallback.onError(arg_0 -> Promises__PromiseKt.toActionCallback$lambda$10$Promises__PromiseKt(new Function1<Throwable, Unit>(result2){
            final /* synthetic */ ActionCallback $result;
            {
                this.$result = $result;
                super(1);
            }

            public final void invoke(Throwable it) {
                this.$result.setRejected();
            }
        }, arg_0));
        return result2;
    }

    @NotNull
    public static final Promise<?> all(@NotNull Collection<? extends Promise<?>> $this$all) {
        Intrinsics.checkNotNullParameter($this$all, "<this>");
        return $this$all.size() == 1 ? (Promise)CollectionsKt.first((Iterable)$this$all) : Promises.all$default($this$all, null, false, 2, null);
    }

    @JvmOverloads
    @NotNull
    public static final <T> Promise<T> all(@NotNull Collection<? extends Promise<?>> $this$all, T totalResult, boolean ignoreErrors) {
        Intrinsics.checkNotNullParameter($this$all, "<this>");
        if ($this$all.isEmpty()) {
            return Promises.resolvedPromise();
        }
        AsyncPromise totalPromise = new AsyncPromise();
        CountDownConsumer done = new CountDownConsumer($this$all.size(), totalPromise, totalResult);
        Consumer<Throwable> rejected2 = ignoreErrors ? arg_0 -> Promises__PromiseKt.all$lambda$11$Promises__PromiseKt(done, arg_0) : arg_0 -> Promises__PromiseKt.all$lambda$12$Promises__PromiseKt(totalPromise, arg_0);
        for (Promise<?> promise : $this$all) {
            promise.onSuccess(done);
            promise.onError(rejected2);
        }
        return totalPromise;
    }

    public static /* synthetic */ Promise all$default(Collection collection, Object object, boolean bl2, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            bl2 = false;
        }
        return Promises.all(collection, object, bl2);
    }

    @NotNull
    public static final <T> Promise<T> any(@NotNull Collection<? extends Promise<T>> promises, @NotNull String totalError) {
        Intrinsics.checkNotNullParameter(promises, "promises");
        Intrinsics.checkNotNullParameter(totalError, "totalError");
        if (promises.isEmpty()) {
            return Promises.resolvedPromise();
        }
        if (promises.size() == 1) {
            return (Promise)CollectionsKt.first((Iterable)promises);
        }
        AsyncPromise totalPromise = new AsyncPromise();
        Consumer<Object> done = arg_0 -> Promises__PromiseKt.any$lambda$13$Promises__PromiseKt(totalPromise, arg_0);
        Consumer<Throwable> rejected2 = new Consumer<Throwable>(promises, totalPromise, totalError){
            @NotNull
            private final AtomicInteger toConsume;
            final /* synthetic */ AsyncPromise<T> $totalPromise;
            final /* synthetic */ String $totalError;
            {
                this.$totalPromise = $totalPromise;
                this.$totalError = $totalError;
                this.toConsume = new AtomicInteger($promises.size());
            }

            public void accept(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter(throwable, "throwable");
                if (this.toConsume.decrementAndGet() <= 0) {
                    this.$totalPromise.setError(this.$totalError);
                }
            }
        };
        for (Promise<Object> promise : promises) {
            promise.onSuccess(done);
            promise.onError(rejected2);
        }
        return totalPromise;
    }

    @JvmOverloads
    @NotNull
    public static final <T> Promise<List<T>> collectResults(@NotNull Collection<? extends Promise<T>> $this$collectResults) {
        Intrinsics.checkNotNullParameter($this$collectResults, "<this>");
        return Promises.collectResults$default($this$collectResults, false, 1, null);
    }

    @JvmOverloads
    @NotNull
    public static final RuntimeException createError(@NotNull String error) {
        Intrinsics.checkNotNullParameter(error, "error");
        return Promises.createError$default(error, false, 2, null);
    }

    @JvmOverloads
    @NotNull
    public static final <T> Promise<T> all(@NotNull Collection<? extends Promise<?>> $this$all, T totalResult) {
        Intrinsics.checkNotNullParameter($this$all, "<this>");
        return Promises.all$default($this$all, totalResult, false, 2, null);
    }

    private static final boolean collectResults$arrive$lambda$0$Promises__PromiseKt(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final <T> void collectResults$arrive$Promises__PromiseKt(AtomicInteger latch, boolean $ignoreErrors, List<T> list2, AsyncPromise<List<T>> result2) {
        if (latch.decrementAndGet() == 0) {
            if ($ignoreErrors) {
                list2.removeIf(arg_0 -> Promises__PromiseKt.collectResults$arrive$lambda$0$Promises__PromiseKt(collectResults.arrive.1.INSTANCE, arg_0));
            }
            Intrinsics.checkNotNull(list2, "null cannot be cast to non-null type kotlin.collections.List<T of org.jetbrains.concurrency.Promises__PromiseKt.collectResults$arrive>");
            result2.setResult(list2);
        }
    }

    private static final void collectResults$lambda$1$Promises__PromiseKt(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void collectResults$lambda$2$Promises__PromiseKt(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Object asPromise$lambda$3$Promises__PromiseKt(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return $tmp0.invoke(p0, p1);
    }

    private static final Object asCancellablePromise$lambda$4$Promises__PromiseKt(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return $tmp0.invoke(p0, p1);
    }

    private static final Object asCancellablePromise$lambda$5$Promises__PromiseKt(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return $tmp0.invoke(p0, p1);
    }

    private static final void asPromise$lambda$6$Promises__PromiseKt(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void toPromise$lambda$7$Promises__PromiseKt(AsyncPromise $promise) {
        Intrinsics.checkNotNullParameter($promise, "$promise");
        $promise.setResult(null);
    }

    private static final void toPromise$lambda$8$Promises__PromiseKt(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void toActionCallback$lambda$9$Promises__PromiseKt(ActionCallback $result, Object it) {
        Intrinsics.checkNotNullParameter($result, "$result");
        $result.setDone();
    }

    private static final void toActionCallback$lambda$10$Promises__PromiseKt(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void all$lambda$11$Promises__PromiseKt(CountDownConsumer $done, Throwable it) {
        Intrinsics.checkNotNullParameter($done, "$done");
        Intrinsics.checkNotNullParameter(it, "it");
        $done.accept((Object)null);
    }

    private static final void all$lambda$12$Promises__PromiseKt(AsyncPromise $totalPromise, Throwable it) {
        Intrinsics.checkNotNullParameter($totalPromise, "$totalPromise");
        Intrinsics.checkNotNull(it);
        $totalPromise.setError(it);
    }

    private static final void any$lambda$13$Promises__PromiseKt(AsyncPromise $totalPromise, Object result2) {
        Intrinsics.checkNotNullParameter($totalPromise, "$totalPromise");
        $totalPromise.setResult(result2);
    }

    public static final /* synthetic */ void access$collectResults$arrive(AtomicInteger latch, boolean $ignoreErrors, List list2, AsyncPromise result2) {
        Promises__PromiseKt.collectResults$arrive$Promises__PromiseKt(latch, $ignoreErrors, list2, result2);
    }

    public static final /* synthetic */ RuntimeException access$getObsoleteError() {
        return Promises__PromiseKt.getObsoleteError$Promises__PromiseKt();
    }
}

