/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.impl;

import com.intellij.util.containers.FilteringIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementCreator;
import org.jetbrains.jps.model.JpsElementType;
import org.jetbrains.jps.model.JpsTypedElement;
import org.jetbrains.jps.model.ex.JpsElementBase;

public final class JpsElementCollectionImpl<E extends JpsElement>
extends JpsElementBase<JpsElementCollectionImpl<E>>
implements JpsElementCollection<E> {
    private final List<E> myElements;
    private final Map<E, E> myCopyToOriginal;
    private final JpsElementChildRole<E> myChildRole;

    JpsElementCollectionImpl(JpsElementChildRole<E> role) {
        this.myChildRole = role;
        this.myElements = new ArrayList();
        this.myCopyToOriginal = null;
    }

    private JpsElementCollectionImpl(JpsElementCollectionImpl<E> original) {
        this.myChildRole = original.myChildRole;
        this.myElements = new ArrayList(original.myElements.size());
        this.myCopyToOriginal = new HashMap<E, E>(original.myElements.size());
        for (JpsElement e2 : original.myElements) {
            Object copy2 = e2.getBulkModificationSupport().createCopy();
            JpsElementCollectionImpl.setParent(copy2, this);
            this.myElements.add(copy2);
            this.myCopyToOriginal.put(copy2, e2);
        }
    }

    @Override
    public List<E> getElements() {
        return this.myElements;
    }

    @Override
    public <X extends JpsTypedElement<P>, P extends JpsElement> Iterable<X> getElementsOfType(@NotNull JpsElementType<P> type) {
        if (type == null) {
            JpsElementCollectionImpl.$$$reportNull$$$0(0);
        }
        return new JpsElementIterable(type);
    }

    @Override
    @NotNull
    public E addChild(@NotNull JpsElementCreator<E> creator) {
        if (creator == null) {
            JpsElementCollectionImpl.$$$reportNull$$$0(1);
        }
        E e2 = this.addChild(creator.create());
        if (e2 == null) {
            JpsElementCollectionImpl.$$$reportNull$$$0(2);
        }
        return e2;
    }

    @Override
    public <X extends E> X addChild(X element) {
        this.myElements.add(element);
        JpsElementCollectionImpl.setParent(element, this);
        return element;
    }

    @Override
    public void removeChild(@NotNull E element) {
        boolean removed;
        if (element == null) {
            JpsElementCollectionImpl.$$$reportNull$$$0(3);
        }
        if (removed = this.myElements.remove(element)) {
            JpsElementCollectionImpl.setParent(element, null);
        }
    }

    @Override
    public void removeAllChildren() {
        ArrayList<E> elements = new ArrayList<E>(this.myElements);
        for (JpsElement element : elements) {
            this.removeChild(element);
        }
    }

    @Override
    @NotNull
    public JpsElementCollectionImpl<E> createCopy() {
        return new JpsElementCollectionImpl<E>(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/impl/JpsElementCollectionImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/impl/JpsElementCollectionImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "addChild";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementsOfType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private final class JpsElementIterable<X extends JpsTypedElement<P>, P extends JpsElement>
    implements Iterable<X> {
        private final JpsElementType<? extends JpsElement> myType;

        JpsElementIterable(JpsElementType<P> type) {
            this.myType = type;
        }

        @Override
        public Iterator<X> iterator() {
            Iterator iterator2 = JpsElementCollectionImpl.this.myElements.iterator();
            return new FilteringIterator(iterator2, e2 -> e2.getType().equals(this.myType));
        }
    }
}

