/*
 * Decompiled with CFR 0.152.
 */
package org.kxml2.wap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class WbxmlParser
implements XmlPullParser {
    static final String HEX_DIGITS = "0123456789abcdef";
    public static final int WAP_EXTENSION = 64;
    private static final String UNEXPECTED_EOF = "Unexpected EOF";
    private static final String ILLEGAL_TYPE = "Wrong event type";
    private InputStream in;
    private int TAG_TABLE = 0;
    private int ATTR_START_TABLE = 1;
    private int ATTR_VALUE_TABLE = 2;
    private String[] attrStartTable;
    private String[] attrValueTable;
    private String[] tagTable;
    private byte[] stringTable;
    private Hashtable cacheStringTable = null;
    private boolean processNsp;
    private int depth;
    private String[] elementStack = new String[16];
    private String[] nspStack = new String[8];
    private int[] nspCounts = new int[4];
    private int attributeCount;
    private String[] attributes = new String[16];
    private int nextId = -2;
    private Vector tables = new Vector();
    private int version;
    private int publicIdentifierId;
    private String prefix;
    private String namespace;
    private String name;
    private String text;
    private Object wapExtensionData;
    private int wapCode;
    private int type;
    private boolean degenerated;
    private boolean isWhitespace;
    private String encoding;

    public boolean getFeature(String string2) {
        if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(string2)) {
            return this.processNsp;
        }
        return false;
    }

    public String getInputEncoding() {
        return this.encoding;
    }

    public void defineEntityReplacementText(String string2, String string3) throws XmlPullParserException {
    }

    public Object getProperty(String string2) {
        return null;
    }

    public int getNamespaceCount(int n2) {
        if (n2 > this.depth) {
            throw new IndexOutOfBoundsException();
        }
        return this.nspCounts[n2];
    }

    public String getNamespacePrefix(int n2) {
        return this.nspStack[n2 << 1];
    }

    public String getNamespaceUri(int n2) {
        return this.nspStack[(n2 << 1) + 1];
    }

    public String getNamespace(String string2) {
        if ("xml".equals(string2)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(string2)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        for (int i2 = (this.getNamespaceCount(this.depth) << 1) - 2; i2 >= 0; i2 -= 2) {
            if (!(string2 == null ? this.nspStack[i2] == null : string2.equals(this.nspStack[i2]))) continue;
            return this.nspStack[i2 + 1];
        }
        return null;
    }

    public int getDepth() {
        return this.depth;
    }

    public String getPositionDescription() {
        StringBuffer stringBuffer = new StringBuffer(this.type < XmlPullParser.TYPES.length ? XmlPullParser.TYPES[this.type] : "unknown");
        stringBuffer.append(' ');
        if (this.type == 2 || this.type == 3) {
            if (this.degenerated) {
                stringBuffer.append("(empty) ");
            }
            stringBuffer.append('<');
            if (this.type == 3) {
                stringBuffer.append('/');
            }
            if (this.prefix != null) {
                stringBuffer.append("{" + this.namespace + "}" + this.prefix + ":");
            }
            stringBuffer.append(this.name);
            int n2 = this.attributeCount << 2;
            for (int i2 = 0; i2 < n2; i2 += 4) {
                stringBuffer.append(' ');
                if (this.attributes[i2 + 1] != null) {
                    stringBuffer.append("{" + this.attributes[i2] + "}" + this.attributes[i2 + 1] + ":");
                }
                stringBuffer.append(this.attributes[i2 + 2] + "='" + this.attributes[i2 + 3] + "'");
            }
            stringBuffer.append('>');
        } else if (this.type != 7) {
            if (this.type != 4) {
                stringBuffer.append(this.getText());
            } else if (this.isWhitespace) {
                stringBuffer.append("(whitespace)");
            } else {
                String string2 = this.getText();
                if (string2.length() > 16) {
                    string2 = string2.substring(0, 16) + "...";
                }
                stringBuffer.append(string2);
            }
        }
        return stringBuffer.toString();
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    public boolean isWhitespace() throws XmlPullParserException {
        if (this.type != 4 && this.type != 7 && this.type != 5) {
            this.exception(ILLEGAL_TYPE);
        }
        return this.isWhitespace;
    }

    public String getText() {
        return this.text;
    }

    public char[] getTextCharacters(int[] nArray) {
        if (this.type >= 4) {
            nArray[0] = 0;
            nArray[1] = this.text.length();
            char[] cArray = new char[this.text.length()];
            this.text.getChars(0, this.text.length(), cArray, 0);
            return cArray;
        }
        nArray[0] = -1;
        nArray[1] = -1;
        return null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isEmptyElementTag() throws XmlPullParserException {
        if (this.type != 2) {
            this.exception(ILLEGAL_TYPE);
        }
        return this.degenerated;
    }

    public int getAttributeCount() {
        return this.attributeCount;
    }

    public String getAttributeType(int n2) {
        return "CDATA";
    }

    public boolean isAttributeDefault(int n2) {
        return false;
    }

    public String getAttributeNamespace(int n2) {
        if (n2 >= this.attributeCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attributes[n2 << 2];
    }

    public String getAttributeName(int n2) {
        if (n2 >= this.attributeCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attributes[(n2 << 2) + 2];
    }

    public String getAttributePrefix(int n2) {
        if (n2 >= this.attributeCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attributes[(n2 << 2) + 1];
    }

    public String getAttributeValue(int n2) {
        if (n2 >= this.attributeCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attributes[(n2 << 2) + 3];
    }

    public String getAttributeValue(String string2, String string3) {
        for (int i2 = (this.attributeCount << 2) - 4; i2 >= 0; i2 -= 4) {
            if (!this.attributes[i2 + 2].equals(string3) || string2 != null && !this.attributes[i2].equals(string2)) continue;
            return this.attributes[i2 + 3];
        }
        return null;
    }

    public int getEventType() throws XmlPullParserException {
        return this.type;
    }

    public int next() throws XmlPullParserException, IOException {
        this.isWhitespace = true;
        int n2 = 9999;
        block3: while (true) {
            String string2 = this.text;
            this.nextImpl();
            if (this.type < n2) {
                n2 = this.type;
            }
            if (n2 > 5) continue;
            if (n2 < 4) break;
            if (string2 != null) {
                this.text = this.text == null ? string2 : string2 + this.text;
            }
            switch (this.peekId()) {
                case 2: 
                case 3: 
                case 4: 
                case 68: 
                case 131: 
                case 132: 
                case 196: {
                    continue block3;
                }
            }
            break;
        }
        this.type = n2;
        if (this.type > 4) {
            this.type = 4;
        }
        return this.type;
    }

    public int nextToken() throws XmlPullParserException, IOException {
        this.isWhitespace = true;
        this.nextImpl();
        return this.type;
    }

    public int nextTag() throws XmlPullParserException, IOException {
        this.next();
        if (this.type == 4 && this.isWhitespace) {
            this.next();
        }
        if (this.type != 3 && this.type != 2) {
            this.exception("unexpected type");
        }
        return this.type;
    }

    public String nextText() throws XmlPullParserException, IOException {
        String string2;
        if (this.type != 2) {
            this.exception("precondition: START_TAG");
        }
        this.next();
        if (this.type == 4) {
            string2 = this.getText();
            this.next();
        } else {
            string2 = "";
        }
        if (this.type != 3) {
            this.exception("END_TAG expected");
        }
        return string2;
    }

    public void require(int n2, String string2, String string3) throws XmlPullParserException, IOException {
        if (n2 != this.type || string2 != null && !string2.equals(this.getNamespace()) || string3 != null && !string3.equals(this.getName())) {
            this.exception("expected: " + (n2 == 64 ? "WAP Ext." : XmlPullParser.TYPES[n2] + " {" + string2 + "}" + string3));
        }
    }

    public void setInput(Reader reader) throws XmlPullParserException {
        this.exception("InputStream required");
    }

    public void setInput(InputStream inputStream, String string2) throws XmlPullParserException {
        this.in = inputStream;
        try {
            int n2;
            block9: {
                block8: {
                    this.version = this.readByte();
                    this.publicIdentifierId = this.readInt();
                    if (this.publicIdentifierId == 0) {
                        this.readInt();
                    }
                    int n3 = this.readInt();
                    if (null != string2) break block8;
                    switch (n3) {
                        case 4: {
                            this.encoding = "ISO-8859-1";
                            break block9;
                        }
                        case 106: {
                            this.encoding = "UTF-8";
                            break block9;
                        }
                        default: {
                            throw new UnsupportedEncodingException("" + n3);
                        }
                    }
                }
                this.encoding = string2;
            }
            int n4 = this.readInt();
            this.stringTable = new byte[n4];
            for (int i2 = 0; i2 < n4 && (n2 = inputStream.read(this.stringTable, i2, n4 - i2)) > 0; i2 += n2) {
            }
            this.selectPage(0, true);
            this.selectPage(0, false);
        }
        catch (IOException iOException) {
            this.exception("Illegal input format");
        }
    }

    public void setFeature(String string2, boolean bl2) throws XmlPullParserException {
        if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(string2)) {
            this.processNsp = bl2;
        } else {
            this.exception("unsupported feature: " + string2);
        }
    }

    public void setProperty(String string2, Object object) throws XmlPullParserException {
        throw new XmlPullParserException("unsupported property: " + string2);
    }

    private final boolean adjustNsp() throws XmlPullParserException {
        String string2;
        int n2;
        String string3;
        int n3;
        boolean bl2 = false;
        for (n3 = 0; n3 < this.attributeCount << 2; n3 += 4) {
            string3 = this.attributes[n3 + 2];
            n2 = string3.indexOf(58);
            if (n2 != -1) {
                string2 = string3.substring(0, n2);
                string3 = string3.substring(n2 + 1);
            } else {
                if (!string3.equals("xmlns")) continue;
                string2 = string3;
                string3 = null;
            }
            if (!string2.equals("xmlns")) {
                bl2 = true;
                continue;
            }
            int n4 = this.depth;
            int n5 = this.nspCounts[n4];
            this.nspCounts[n4] = n5 + 1;
            int n6 = n5 << 1;
            this.nspStack = this.ensureCapacity(this.nspStack, n6 + 2);
            this.nspStack[n6] = string3;
            this.nspStack[n6 + 1] = this.attributes[n3 + 3];
            if (string3 != null && this.attributes[n3 + 3].equals("")) {
                this.exception("illegal empty namespace");
            }
            System.arraycopy(this.attributes, n3 + 4, this.attributes, n3, (--this.attributeCount << 2) - n3);
            n3 -= 4;
        }
        if (bl2) {
            for (n3 = (this.attributeCount << 2) - 4; n3 >= 0; n3 -= 4) {
                string3 = this.attributes[n3 + 2];
                n2 = string3.indexOf(58);
                if (n2 == 0) {
                    throw new RuntimeException("illegal attribute name: " + string3 + " at " + this);
                }
                if (n2 == -1) continue;
                string2 = string3.substring(0, n2);
                string3 = string3.substring(n2 + 1);
                String string4 = this.getNamespace(string2);
                if (string4 == null) {
                    throw new RuntimeException("Undefined Prefix: " + string2 + " in " + this);
                }
                this.attributes[n3] = string4;
                this.attributes[n3 + 1] = string2;
                this.attributes[n3 + 2] = string3;
                for (int i2 = (this.attributeCount << 2) - 4; i2 > n3; i2 -= 4) {
                    if (!string3.equals(this.attributes[i2 + 2]) || !string4.equals(this.attributes[i2])) continue;
                    this.exception("Duplicate Attribute: {" + string4 + "}" + string3);
                }
            }
        }
        if ((n3 = this.name.indexOf(58)) == 0) {
            this.exception("illegal tag name: " + this.name);
        } else if (n3 != -1) {
            this.prefix = this.name.substring(0, n3);
            this.name = this.name.substring(n3 + 1);
        }
        this.namespace = this.getNamespace(this.prefix);
        if (this.namespace == null) {
            if (this.prefix != null) {
                this.exception("undefined prefix: " + this.prefix);
            }
            this.namespace = "";
        }
        return bl2;
    }

    private final void setTable(int n2, int n3, String[] stringArray) {
        if (this.stringTable != null) {
            throw new RuntimeException("setXxxTable must be called before setInput!");
        }
        while (this.tables.size() < 3 * n2 + 3) {
            this.tables.addElement(null);
        }
        this.tables.setElementAt(stringArray, n2 * 3 + n3);
    }

    private final void exception(String string2) throws XmlPullParserException {
        throw new XmlPullParserException(string2, this, null);
    }

    private void selectPage(int n2, boolean bl2) throws XmlPullParserException {
        if (this.tables.size() == 0 && n2 == 0) {
            return;
        }
        if (n2 * 3 > this.tables.size()) {
            this.exception("Code Page " + n2 + " undefined!");
        }
        if (bl2) {
            this.tagTable = (String[])this.tables.elementAt(n2 * 3 + this.TAG_TABLE);
        } else {
            this.attrStartTable = (String[])this.tables.elementAt(n2 * 3 + this.ATTR_START_TABLE);
            this.attrValueTable = (String[])this.tables.elementAt(n2 * 3 + this.ATTR_VALUE_TABLE);
        }
    }

    private final void nextImpl() throws IOException, XmlPullParserException {
        if (this.type == 3) {
            --this.depth;
        }
        if (this.degenerated) {
            this.type = 3;
            this.degenerated = false;
            return;
        }
        this.text = null;
        this.prefix = null;
        this.name = null;
        int n2 = this.peekId();
        while (n2 == 0) {
            this.nextId = -2;
            this.selectPage(this.readByte(), true);
            n2 = this.peekId();
        }
        this.nextId = -2;
        switch (n2) {
            case -1: {
                this.type = 1;
                break;
            }
            case 1: {
                int n3 = this.depth - 1 << 2;
                this.type = 3;
                this.namespace = this.elementStack[n3];
                this.prefix = this.elementStack[n3 + 1];
                this.name = this.elementStack[n3 + 2];
                break;
            }
            case 2: {
                this.type = 6;
                char c2 = (char)this.readInt();
                this.text = "" + c2;
                this.name = "#" + c2;
                break;
            }
            case 3: {
                this.type = 4;
                this.text = this.readStrI();
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 128: 
            case 129: 
            case 130: 
            case 192: 
            case 193: 
            case 194: 
            case 195: {
                this.type = 64;
                this.wapCode = n2;
                this.wapExtensionData = this.parseWapExtension(n2);
                break;
            }
            case 67: {
                throw new RuntimeException("PI curr. not supp.");
            }
            case 131: {
                this.type = 4;
                this.text = this.readStrT();
                break;
            }
            default: {
                this.parseElement(n2);
            }
        }
    }

    public Object parseWapExtension(int n2) throws IOException, XmlPullParserException {
        switch (n2) {
            case 64: 
            case 65: 
            case 66: {
                return this.readStrI();
            }
            case 128: 
            case 129: 
            case 130: {
                return new Integer(this.readInt());
            }
            case 192: 
            case 193: 
            case 194: {
                return null;
            }
            case 195: {
                int n3;
                byte[] byArray = new byte[n3];
                for (n3 = this.readInt(); n3 > 0; n3 -= this.in.read(byArray, byArray.length - n3, n3)) {
                }
                return byArray;
            }
        }
        this.exception("illegal id: " + n2);
        return null;
    }

    public void readAttr() throws IOException, XmlPullParserException {
        int n2 = this.readByte();
        int n3 = 0;
        while (n2 != 1) {
            StringBuffer stringBuffer;
            while (n2 == 0) {
                this.selectPage(this.readByte(), false);
                n2 = this.readByte();
            }
            String string2 = this.resolveId(this.attrStartTable, n2);
            int n4 = string2.indexOf(61);
            if (n4 == -1) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer = new StringBuffer(string2.substring(n4 + 1));
                string2 = string2.substring(0, n4);
            }
            n2 = this.readByte();
            while (n2 > 128 || n2 == 0 || n2 == 2 || n2 == 3 || n2 == 131 || n2 >= 64 && n2 <= 66 || n2 >= 128 && n2 <= 130) {
                switch (n2) {
                    case 0: {
                        this.selectPage(this.readByte(), false);
                        break;
                    }
                    case 2: {
                        stringBuffer.append((char)this.readInt());
                        break;
                    }
                    case 3: {
                        stringBuffer.append(this.readStrI());
                        break;
                    }
                    case 64: 
                    case 65: 
                    case 66: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 192: 
                    case 193: 
                    case 194: 
                    case 195: {
                        stringBuffer.append(this.resolveWapExtension(n2, this.parseWapExtension(n2)));
                        break;
                    }
                    case 131: {
                        stringBuffer.append(this.readStrT());
                        break;
                    }
                    default: {
                        stringBuffer.append(this.resolveId(this.attrValueTable, n2));
                    }
                }
                n2 = this.readByte();
            }
            this.attributes = this.ensureCapacity(this.attributes, n3 + 4);
            this.attributes[n3++] = "";
            this.attributes[n3++] = null;
            this.attributes[n3++] = string2;
            this.attributes[n3++] = stringBuffer.toString();
            ++this.attributeCount;
        }
    }

    private int peekId() throws IOException {
        if (this.nextId == -2) {
            this.nextId = this.in.read();
        }
        return this.nextId;
    }

    protected String resolveWapExtension(int n2, Object object) {
        if (object instanceof byte[]) {
            StringBuffer stringBuffer = new StringBuffer();
            byte[] byArray = (byte[])object;
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                stringBuffer.append(HEX_DIGITS.charAt(byArray[i2] >> 4 & 0xF));
                stringBuffer.append(HEX_DIGITS.charAt(byArray[i2] & 0xF));
            }
            return stringBuffer.toString();
        }
        return "$(" + object + ")";
    }

    String resolveId(String[] stringArray, int n2) throws IOException {
        int n3 = (n2 & 0x7F) - 5;
        if (n3 == -1) {
            this.wapCode = -1;
            return this.readStrT();
        }
        if (n3 < 0 || stringArray == null || n3 >= stringArray.length || stringArray[n3] == null) {
            throw new IOException("id " + n2 + " undef.");
        }
        this.wapCode = n3 + 5;
        return stringArray[n3];
    }

    void parseElement(int n2) throws IOException, XmlPullParserException {
        this.type = 2;
        this.name = this.resolveId(this.tagTable, n2 & 0x3F);
        this.attributeCount = 0;
        if ((n2 & 0x80) != 0) {
            this.readAttr();
        }
        this.degenerated = (n2 & 0x40) == 0;
        int n3 = this.depth++ << 2;
        this.elementStack = this.ensureCapacity(this.elementStack, n3 + 4);
        this.elementStack[n3 + 3] = this.name;
        if (this.depth >= this.nspCounts.length) {
            int[] nArray = new int[this.depth + 4];
            System.arraycopy(this.nspCounts, 0, nArray, 0, this.nspCounts.length);
            this.nspCounts = nArray;
        }
        this.nspCounts[this.depth] = this.nspCounts[this.depth - 1];
        for (int i2 = this.attributeCount - 1; i2 > 0; --i2) {
            for (int i3 = 0; i3 < i2; ++i3) {
                if (!this.getAttributeName(i2).equals(this.getAttributeName(i3))) continue;
                this.exception("Duplicate Attribute: " + this.getAttributeName(i2));
            }
        }
        if (this.processNsp) {
            this.adjustNsp();
        } else {
            this.namespace = "";
        }
        this.elementStack[n3] = this.namespace;
        this.elementStack[n3 + 1] = this.prefix;
        this.elementStack[n3 + 2] = this.name;
    }

    private final String[] ensureCapacity(String[] stringArray, int n2) {
        if (stringArray.length >= n2) {
            return stringArray;
        }
        String[] stringArray2 = new String[n2 + 16];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    int readByte() throws IOException {
        int n2 = this.in.read();
        if (n2 == -1) {
            throw new IOException(UNEXPECTED_EOF);
        }
        return n2;
    }

    int readInt() throws IOException {
        int n2;
        int n3 = 0;
        do {
            n2 = this.readByte();
            n3 = n3 << 7 | n2 & 0x7F;
        } while ((n2 & 0x80) != 0);
        return n3;
    }

    String readStrI() throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl2 = true;
        while ((n2 = this.in.read()) != 0) {
            if (n2 == -1) {
                throw new IOException(UNEXPECTED_EOF);
            }
            if (n2 > 32) {
                bl2 = false;
            }
            byteArrayOutputStream.write(n2);
        }
        this.isWhitespace = bl2;
        String string2 = new String(byteArrayOutputStream.toByteArray(), this.encoding);
        byteArrayOutputStream.close();
        return string2;
    }

    String readStrT() throws IOException {
        String string2;
        int n2 = this.readInt();
        if (this.cacheStringTable == null) {
            this.cacheStringTable = new Hashtable();
        }
        if ((string2 = (String)this.cacheStringTable.get(new Integer(n2))) == null) {
            int n3;
            for (n3 = n2; n3 < this.stringTable.length && this.stringTable[n3] != 0; ++n3) {
            }
            string2 = new String(this.stringTable, n2, n3 - n2, this.encoding);
            this.cacheStringTable.put(new Integer(n2), string2);
        }
        return string2;
    }

    public void setTagTable(int n2, String[] stringArray) {
        this.setTable(n2, this.TAG_TABLE, stringArray);
    }

    public void setAttrStartTable(int n2, String[] stringArray) {
        this.setTable(n2, this.ATTR_START_TABLE, stringArray);
    }

    public void setAttrValueTable(int n2, String[] stringArray) {
        this.setTable(n2, this.ATTR_VALUE_TABLE, stringArray);
    }

    public int getWapCode() {
        return this.wapCode;
    }

    public Object getWapExtensionData() {
        return this.wapExtensionData;
    }
}

