/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.logcat;

import com.android.ddmlib.Log;
import com.android.ddmlib.logcat.LogCatHeaderKt;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u000bH\u00c6\u0003JE\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\u0005H\u00d6\u0001J\b\u0010\"\u001a\u00020\bH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Lcom/android/ddmlib/logcat/LogCatHeader;", "", "logLevel", "Lcom/android/ddmlib/Log$LogLevel;", "pid", "", "tid", "appName", "", "tag", "timestamp", "Ljava/time/Instant;", "(Lcom/android/ddmlib/Log$LogLevel;IILjava/lang/String;Ljava/lang/String;Ljava/time/Instant;)V", "getAppName", "()Ljava/lang/String;", "getLogLevel", "()Lcom/android/ddmlib/Log$LogLevel;", "getPid", "()I", "getTag", "getTid", "getTimestamp", "()Ljava/time/Instant;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "ddmlib"})
public final class LogCatHeader {
    @NotNull
    private final Log.LogLevel logLevel;
    private final int pid;
    private final int tid;
    @NotNull
    private final String appName;
    @NotNull
    private final String tag;
    @NotNull
    private final Instant timestamp;

    public LogCatHeader(@NotNull Log.LogLevel logLevel, int pid, int tid, @NotNull String appName, @NotNull String tag, @NotNull Instant timestamp) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        this.logLevel = logLevel;
        this.pid = pid;
        this.tid = tid;
        this.appName = appName;
        this.tag = tag;
        this.timestamp = timestamp;
    }

    @NotNull
    public final Log.LogLevel getLogLevel() {
        return this.logLevel;
    }

    public final int getPid() {
        return this.pid;
    }

    public final int getTid() {
        return this.tid;
    }

    @NotNull
    public final String getAppName() {
        return this.appName;
    }

    @NotNull
    public final String getTag() {
        return this.tag;
    }

    @NotNull
    public final Instant getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public String toString() {
        String epoch = LogCatHeaderKt.access$getEPOCH_TIME_FORMATTER$p().format(this.timestamp);
        char priority = this.logLevel.getPriorityLetter();
        return epoch + ": " + priority + '/' + this.tag + '(' + this.pid + ':' + this.tid + ") " + this.appName;
    }

    @NotNull
    public final Log.LogLevel component1() {
        return this.logLevel;
    }

    public final int component2() {
        return this.pid;
    }

    public final int component3() {
        return this.tid;
    }

    @NotNull
    public final String component4() {
        return this.appName;
    }

    @NotNull
    public final String component5() {
        return this.tag;
    }

    @NotNull
    public final Instant component6() {
        return this.timestamp;
    }

    @NotNull
    public final LogCatHeader copy(@NotNull Log.LogLevel logLevel, int pid, int tid, @NotNull String appName, @NotNull String tag, @NotNull Instant timestamp) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        return new LogCatHeader(logLevel, pid, tid, appName, tag, timestamp);
    }

    public static /* synthetic */ LogCatHeader copy$default(LogCatHeader logCatHeader, Log.LogLevel logLevel, int n, int n2, String string, String string2, Instant instant, int n3, Object object) {
        if ((n3 & 1) != 0) {
            logLevel = logCatHeader.logLevel;
        }
        if ((n3 & 2) != 0) {
            n = logCatHeader.pid;
        }
        if ((n3 & 4) != 0) {
            n2 = logCatHeader.tid;
        }
        if ((n3 & 8) != 0) {
            string = logCatHeader.appName;
        }
        if ((n3 & 0x10) != 0) {
            string2 = logCatHeader.tag;
        }
        if ((n3 & 0x20) != 0) {
            instant = logCatHeader.timestamp;
        }
        return logCatHeader.copy(logLevel, n, n2, string, string2, instant);
    }

    public int hashCode() {
        int result = this.logLevel.hashCode();
        result = result * 31 + Integer.hashCode(this.pid);
        result = result * 31 + Integer.hashCode(this.tid);
        result = result * 31 + this.appName.hashCode();
        result = result * 31 + this.tag.hashCode();
        result = result * 31 + this.timestamp.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LogCatHeader)) {
            return false;
        }
        LogCatHeader logCatHeader = (LogCatHeader)other;
        if (this.logLevel != logCatHeader.logLevel) {
            return false;
        }
        if (this.pid != logCatHeader.pid) {
            return false;
        }
        if (this.tid != logCatHeader.tid) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.appName, (Object)logCatHeader.appName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tag, (Object)logCatHeader.tag)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.timestamp, (Object)logCatHeader.timestamp);
    }
}

