/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.internal.jdwp.chunkhandler;

import com.android.ddmlib.ByteBufferUtil;
import com.android.ddmlib.Log;
import com.android.ddmlib.internal.ClientImpl;
import com.android.ddmlib.internal.MonitorThread;
import com.android.ddmlib.internal.jdwp.chunkhandler.JdwpPacket;
import com.android.ddmlib.jdwp.JdwpInterceptor;
import com.android.ddmlib.jdwp.JdwpPipe;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class ChunkHandler
extends JdwpInterceptor {
    public static final int CHUNK_HEADER_LEN = 8;
    public static final ByteOrder CHUNK_ORDER = ByteOrder.BIG_ENDIAN;
    public static final int CHUNK_FAIL = ChunkHandler.type("FAIL");
    public static final int DDMS_CMD_SET = 199;
    public static final int DDMS_CMD = 1;

    public abstract void clientReady(ClientImpl var1) throws IOException;

    public abstract void clientDisconnected(ClientImpl var1);

    public abstract void handleChunk(ClientImpl var1, int var2, ByteBuffer var3, boolean var4, int var5);

    protected void handleUnknownChunk(ClientImpl client, int type, ByteBuffer data, boolean isReply, int msgId) {
        if (type == CHUNK_FAIL) {
            int errorCode = data.getInt();
            int msgLen = data.getInt();
            String msg = ByteBufferUtil.getString(data, msgLen);
            Log.w("ddms", "WARNING: failure code=" + errorCode + " msg=" + msg);
        } else {
            Log.w("ddms", "WARNING: received unknown chunk " + ChunkHandler.name(type) + ": len=" + data.limit() + ", reply=" + isReply + ", msgId=0x" + Integer.toHexString(msgId));
        }
        Log.w("ddms", "         client " + client + ", handler " + this);
    }

    public static int type(String typeName) {
        int val = 0;
        if (typeName.length() != 4) {
            Log.e("ddms", "Type name must be 4 letter long");
            throw new RuntimeException("Type name must be 4 letter long");
        }
        for (int i = 0; i < 4; ++i) {
            val <<= 8;
            val |= (byte)typeName.charAt(i);
        }
        return val;
    }

    public static String name(int type) {
        char[] ascii = new char[]{(char)(type >> 24 & 0xFF), (char)(type >> 16 & 0xFF), (char)(type >> 8 & 0xFF), (char)(type & 0xFF)};
        return new String(ascii);
    }

    @VisibleForTesting
    public static ByteBuffer allocBuffer(int maxChunkLen) {
        ByteBuffer buf = ByteBuffer.allocate(19 + maxChunkLen);
        buf.order(CHUNK_ORDER);
        return buf;
    }

    @VisibleForTesting
    public static ByteBuffer getChunkDataBuf(ByteBuffer jdwpBuf) {
        assert (jdwpBuf.position() == 0);
        jdwpBuf.position(19);
        ByteBuffer slice = jdwpBuf.slice();
        slice.order(CHUNK_ORDER);
        jdwpBuf.position(0);
        return slice;
    }

    @VisibleForTesting
    public static void finishChunkPacket(JdwpPacket packet, int type, int chunkLen) {
        ByteBuffer buf = packet.getPayload();
        buf.putInt(0, type);
        buf.putInt(4, chunkLen);
        packet.finishPacket(199, 1, 8 + chunkLen);
    }

    public void handlePacket(ClientImpl client, JdwpPacket packet) {
        ByteBuffer buf = packet.getPayload();
        int type = buf.getInt();
        int length = buf.getInt();
        Log.d("ddms", "Calling handler for " + ChunkHandler.name(type) + " [" + this + "] (len=" + length + ")");
        ByteBuffer ibuf = buf.slice();
        ByteBuffer roBuf = ibuf.asReadOnlyBuffer();
        roBuf.order(CHUNK_ORDER);
        this.handleChunk(client, type, roBuf, packet.isReply(), packet.getId());
    }

    @Override
    public JdwpPacket intercept(JdwpPipe pipe, JdwpPacket packet) {
        if (pipe instanceof ClientImpl) {
            ClientImpl client = (ClientImpl)pipe;
            MonitorThread.getInstance().getDdmExtension().ddmSeen(client);
            if (packet.isError()) {
                client.packetFailed(packet);
            } else if (packet.isEmpty()) {
                Log.d("ddms", "Got empty reply for 0x" + Integer.toHexString(packet.getId()));
            } else {
                this.handlePacket(client, packet);
            }
            return null;
        }
        return packet;
    }
}

