/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api.interprocedural;

import com.android.tools.lint.detector.api.interprocedural.CallGraph;
import com.android.tools.lint.detector.api.interprocedural.CallGraphKt;
import com.android.tools.lint.detector.api.interprocedural.CallTarget;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001:\u0002\u0013\u0014J\u001e\u0010\u0007\u001a\u00020\b2\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH&J&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0016R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/detector/api/interprocedural/CallGraph;", "", "nodes", "", "Lcom/android/tools/lint/detector/api/interprocedural/CallGraph$Node;", "getNodes", "()Ljava/util/Collection;", "dump", "", "filter", "Lkotlin/Function1;", "Lcom/android/tools/lint/detector/api/interprocedural/CallGraph$Edge;", "", "getNode", "element", "Lorg/jetbrains/uast/UElement;", "outputToDotFile", "", "file", "Edge", "Node", "lint-api"})
public interface CallGraph {
    @NotNull
    public Collection<Node> getNodes();

    @NotNull
    public Node getNode(@NotNull UElement var1);

    @NotNull
    public String dump(@NotNull Function1<? super Edge, Boolean> var1);

    public void outputToDotFile(@NotNull String var1, @NotNull Function1<? super Edge, Boolean> var2);

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/detector/api/interprocedural/CallGraph$Node;", "", "edges", "", "Lcom/android/tools/lint/detector/api/interprocedural/CallGraph$Edge;", "getEdges", "()Ljava/util/Collection;", "likelyEdges", "getLikelyEdges", "target", "Lcom/android/tools/lint/detector/api/interprocedural/CallTarget;", "getTarget", "()Lcom/android/tools/lint/detector/api/interprocedural/CallTarget;", "lint-api"})
    public static interface Node {
        @NotNull
        public CallTarget getTarget();

        @NotNull
        public Collection<Edge> getEdges();

        @NotNull
        public Collection<Edge> getLikelyEdges();

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
        public static final class DefaultImpls {
            /*
             * WARNING - void declaration
             */
            @NotNull
            public static Collection<Edge> getLikelyEdges(@NotNull Node this_) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)this_, (String)"this");
                Iterable $this$filter$iv = this_.getEdges();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Edge it = (Edge)element$iv$iv;
                    if (!it.isLikely()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u001cB!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J+\u0010\u0015\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/detector/api/interprocedural/CallGraph$Edge;", "", "node", "Lcom/android/tools/lint/detector/api/interprocedural/CallGraph$Node;", "call", "Lorg/jetbrains/uast/UCallExpression;", "kind", "Lcom/android/tools/lint/detector/api/interprocedural/CallGraph$Edge$Kind;", "(Lcom/android/tools/lint/detector/api/interprocedural/CallGraph$Node;Lorg/jetbrains/uast/UCallExpression;Lcom/android/tools/lint/detector/api/interprocedural/CallGraph$Edge$Kind;)V", "getCall", "()Lorg/jetbrains/uast/UCallExpression;", "isLikely", "", "()Z", "getKind", "()Lcom/android/tools/lint/detector/api/interprocedural/CallGraph$Edge$Kind;", "getNode", "()Lcom/android/tools/lint/detector/api/interprocedural/CallGraph$Node;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "Kind", "lint-api"})
    public static final class Edge {
        @Nullable
        private final Node node;
        @Nullable
        private final UCallExpression call;
        @NotNull
        private final Kind kind;

        public Edge(@Nullable Node node, @Nullable UCallExpression call, @NotNull Kind kind) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)kind), (String)"kind");
            this.node = node;
            this.call = call;
            this.kind = kind;
        }

        @Nullable
        public final Node getNode() {
            return this.node;
        }

        @Nullable
        public final UCallExpression getCall() {
            return this.call;
        }

        @NotNull
        public final Kind getKind() {
            return this.kind;
        }

        public final boolean isLikely() {
            return this.kind.isLikely();
        }

        @Nullable
        public final Node component1() {
            return this.node;
        }

        @Nullable
        public final UCallExpression component2() {
            return this.call;
        }

        @NotNull
        public final Kind component3() {
            return this.kind;
        }

        @NotNull
        public final Edge copy(@Nullable Node node, @Nullable UCallExpression call, @NotNull Kind kind) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)kind), (String)"kind");
            return new Edge(node, call, kind);
        }

        public static /* synthetic */ Edge copy$default(Edge edge, Node node, UCallExpression uCallExpression, Kind kind, int n, Object object) {
            if ((n & 1) != 0) {
                node = edge.node;
            }
            if ((n & 2) != 0) {
                uCallExpression = edge.call;
            }
            if ((n & 4) != 0) {
                kind = edge.kind;
            }
            return edge.copy(node, uCallExpression, kind);
        }

        @NotNull
        public String toString() {
            return "Edge(node=" + this.node + ", call=" + this.call + ", kind=" + (Object)((Object)this.kind) + ')';
        }

        public int hashCode() {
            int result2 = this.node == null ? 0 : this.node.hashCode();
            result2 = result2 * 31 + (this.call == null ? 0 : this.call.hashCode());
            result2 = result2 * 31 + this.kind.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Edge)) {
                return false;
            }
            Edge edge = (Edge)other;
            if (!Intrinsics.areEqual((Object)this.node, (Object)edge.node)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.call, (Object)edge.call)) {
                return false;
            }
            return this.kind == edge.kind;
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/android/tools/lint/detector/api/interprocedural/CallGraph$Edge$Kind;", "", "(Ljava/lang/String;I)V", "isLikely", "", "()Z", "DIRECT", "UNIQUE", "TYPE_EVIDENCED", "BASE", "NON_UNIQUE_OVERRIDE", "INVOKE", "lint-api"})
        public static final class Kind
        extends Enum<Kind> {
            public static final /* enum */ Kind DIRECT = new Kind();
            public static final /* enum */ Kind UNIQUE = new Kind();
            public static final /* enum */ Kind TYPE_EVIDENCED = new Kind();
            public static final /* enum */ Kind BASE = new Kind();
            public static final /* enum */ Kind NON_UNIQUE_OVERRIDE = new Kind();
            public static final /* enum */ Kind INVOKE = new Kind();
            private static final /* synthetic */ Kind[] $VALUES;

            public final boolean isLikely() {
                boolean bl;
                Kind kind = this;
                int n = WhenMappings.$EnumSwitchMapping$0[kind.ordinal()];
                switch (n) {
                    case 1: 
                    case 2: 
                    case 3: {
                        bl = true;
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        bl = false;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return bl;
            }

            public static Kind[] values() {
                Kind[] kindArray = $VALUES;
                Kind[] kindArray2 = new Kind[kindArray.length];
                System.arraycopy(kindArray, 0, kindArray2, 0, kindArray.length);
                return kindArray2;
            }

            public static Kind valueOf(String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return Enum.valueOf(Kind.class, value);
            }

            static {
                Kind[] kindArray = new Kind[]{DIRECT, UNIQUE, TYPE_EVIDENCED, BASE, NON_UNIQUE_OVERRIDE, INVOKE};
                $VALUES = kindArray;
            }

            @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[Kind.values().length];
                    nArray[Kind.DIRECT.ordinal()] = 1;
                    nArray[Kind.UNIQUE.ordinal()] = 2;
                    nArray[Kind.TYPE_EVIDENCED.ordinal()] = 3;
                    nArray[Kind.BASE.ordinal()] = 4;
                    nArray[Kind.NON_UNIQUE_OVERRIDE.ordinal()] = 5;
                    nArray[Kind.INVOKE.ordinal()] = 6;
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
    public static final class DefaultImpls {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public static String dump(@NotNull CallGraph this_, @NotNull Function1<? super Edge, Boolean> filter) {
            Intrinsics.checkParameterIsNotNull((Object)this_, (String)"this");
            Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder receiver = stringBuilder;
            Iterable $this$sortedBy$iv = this_.getNodes();
            boolean $i$f$sortedBy = false;
            boolean bl5 = false;
            for (Node node : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Node it = (Node)a;
                    Comparable comparable = (Comparable)((Object)CallGraphKt.getShortName(it));
                    it = (Node)b;
                    Comparable comparable2 = comparable;
                    String string = CallGraphKt.getShortName(it);
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            })) {
                void $this$filterTo$iv$iv;
                Object $this$filter$iv = node.getEdges();
                boolean $i$f$filter22 = false;
                Object object = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    if (!((Boolean)filter.invoke(element$iv$iv)).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List callees = (List)destination$iv$iv;
                $this$filter$iv = receiver;
                String $i$f$filter22 = CallGraphKt.getShortName(node);
                boolean bl6 = false;
                StringBuilder stringBuilder2 = ((StringBuilder)$this$filter$iv).append($i$f$filter22);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder2);
                Iterable $this$forEach$iv = callees;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Edge it = (Edge)element$iv;
                    StringBuilder stringBuilder3 = receiver;
                    String string = "    " + CallGraphKt.getShortName(it.getNode()) + " [" + (Object)((Object)it.getKind()) + ']';
                    boolean bl7 = false;
                    StringBuilder stringBuilder4 = stringBuilder3.append(string);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder4);
                }
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        public static /* synthetic */ String dump$default(CallGraph callGraph2, Function1 function1, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: dump");
            }
            if ((n & 1) != 0) {
                function1 = dump.1.INSTANCE;
            }
            return callGraph2.dump((Function1<? super Edge, Boolean>)function1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void outputToDotFile(@NotNull CallGraph this_, @NotNull String file, @NotNull Function1<? super Edge, Boolean> filter) {
            Intrinsics.checkParameterIsNotNull((Object)this_, (String)"this");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
            Closeable closeable = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                PrintWriter writer = (PrintWriter)closeable;
                writer.println("digraph {");
                for (Node node : this_.getNodes()) {
                    for (Edge edge : node.getLikelyEdges()) {
                        Node callee = edge.component1();
                        writer.print("  \"" + CallGraphKt.getShortName(node) + "\" -> \"" + CallGraphKt.getShortName(callee) + '\"');
                    }
                }
                writer.println("}");
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        public static /* synthetic */ void outputToDotFile$default(CallGraph callGraph2, String string, Function1 function1, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: outputToDotFile");
            }
            if ((n & 2) != 0) {
                function1 = outputToDotFile.1.INSTANCE;
            }
            callGraph2.outputToDotFile(string, (Function1<? super Edge, Boolean>)function1);
        }
    }
}

