/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.helpers;

import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.helpers.DefaultJavaEvaluator;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.kotlin.KotlinStringTemplateUPolyadicExpression;
import org.jetbrains.uast.psi.UElementWithLocation;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 82\u00020\u0001:\u00018B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u0005H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0015H\u0016J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0015H\u0002J(\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010%\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010%\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0015H\u0016J\u0018\u0010&\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010&\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0015H\u0016J0\u0010'\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020*H\u0016J(\u0010'\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*2\u0006\u0010,\u001a\u00020*H\u0016J(\u0010'\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020*2\u0006\u0010,\u001a\u00020*H\u0016J0\u0010'\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020*H\u0016J\u0012\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010\u0013\u001a\u00020\u0015H\u0002J\u0012\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J*\u00101\u001a\u00020\u001d2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u0019032\b\u00104\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u000107H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/android/tools/lint/helpers/DefaultUastParser;", "Lcom/android/tools/lint/client/api/UastParser;", "project", "Lcom/android/tools/lint/detector/api/Project;", "ideaProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/android/tools/lint/detector/api/Project;Lcom/intellij/openapi/project/Project;)V", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "getEvaluator", "()Lcom/android/tools/lint/client/api/JavaEvaluator;", "getIdeaProject", "()Lcom/intellij/openapi/project/Project;", "javaEvaluator", "createEvaluator", "Lcom/android/tools/lint/helpers/DefaultJavaEvaluator;", "p", "createLocation", "Lcom/android/tools/lint/detector/api/Location;", "element", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/uast/UElement;", "findPsi", "getCallLocation", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "call", "Lorg/jetbrains/uast/UCallExpression;", "includeReceiver", "", "includeArguments", "getFile", "Ljava/io/File;", "file", "Lcom/intellij/psi/PsiFile;", "getFileContents", "", "getLocation", "getNameLocation", "getRangeLocation", "from", "fromDelta", "", "to", "toDelta", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "parse", "Lorg/jetbrains/uast/UFile;", "prepare", "contexts", "", "javaLanguageLevel", "Lcom/intellij/pom/java/LanguageLevel;", "kotlinLanguageLevel", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "Companion", "lint-api"})
public class DefaultUastParser
extends UastParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final com.intellij.openapi.project.Project ideaProject;
    @NotNull
    private final JavaEvaluator javaEvaluator;
    @NotNull
    private final JavaEvaluator evaluator;
    private static boolean warnedAboutLargeFiles;

    public DefaultUastParser(@Nullable Project project, @NotNull com.intellij.openapi.project.Project ideaProject) {
        Intrinsics.checkParameterIsNotNull((Object)ideaProject, (String)"ideaProject");
        this.ideaProject = ideaProject;
        this.javaEvaluator = this.createEvaluator(project, this.ideaProject);
        this.evaluator = this.javaEvaluator;
    }

    @NotNull
    public final com.intellij.openapi.project.Project getIdeaProject() {
        return this.ideaProject;
    }

    @NotNull
    protected DefaultJavaEvaluator createEvaluator(@Nullable Project project, @NotNull com.intellij.openapi.project.Project p) {
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        if (project == null) {
            Intrinsics.throwNpe();
        }
        return new DefaultJavaEvaluator(p, project);
    }

    @Override
    public boolean prepare(@NotNull List<? extends JavaContext> contexts, @Nullable LanguageLevel javaLanguageLevel, @Nullable LanguageVersionSettings kotlinLanguageLevel) {
        Intrinsics.checkParameterIsNotNull(contexts, (String)"contexts");
        return true;
    }

    @Override
    @NotNull
    public JavaEvaluator getEvaluator() {
        return this.evaluator;
    }

    @Override
    @Nullable
    public UFile parse(@NotNull JavaContext context2) {
        UFile uFile;
        String string;
        String absPath;
        String string2;
        String name;
        String string3;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        if (context2.getUastFile() != null) {
            return context2.getUastFile();
        }
        if (this.ideaProject.isDisposed()) {
            return null;
        }
        File file = context2.file;
        String string4 = file.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"file.path");
        String path2 = StringsKt.replace$default((String)string4, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
        int srcJarIndex = StringsKt.indexOf$default((CharSequence)path2, (String)"srcjar!/", (int)0, (boolean)false, (int)6, null);
        if (srcJarIndex != -1) {
            string3 = path2;
            int n = 0;
            int n2 = srcJarIndex + 8;
            boolean bl = false;
            String string5 = string3;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String jarFile = string6;
            String string7 = path2;
            n2 = srcJarIndex + 8;
            bl = false;
            String string8 = string7;
            if (string8 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string9 = string8.substring(n2);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
            name = string9;
            VirtualFile virtualFile = StandardFileSystems.jar().findFileByPath(jarFile);
            if (virtualFile == null) {
                return null;
            }
            VirtualFile virtualFile2 = virtualFile;
            VirtualFile root = virtualFile2;
            virtualFile2 = root.findFileByRelativePath(name);
            if (virtualFile2 == null) {
                return null;
            }
            string2 = virtualFile2;
        } else {
            name = file.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"file.absolutePath");
            absPath = StringsKt.replace$default((String)name, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
            name = StandardFileSystems.local().findFileByPath(absPath);
            if (name == null) {
                return null;
            }
            string2 = name;
        }
        String virtualFile = string = string2;
        name = PsiManager.getInstance((com.intellij.openapi.project.Project)this.ideaProject).findFile((VirtualFile)virtualFile);
        if (name == null) {
            return null;
        }
        absPath = name;
        String psiFile = absPath;
        if (Intrinsics.areEqual((Object)psiFile.getLanguage(), (Object)Language.ANY)) {
            absPath = file.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)absPath, (String)"file.path");
            if (StringsKt.endsWith$default((String)absPath, (String)".kt", (boolean)false, (int)2, null)) {
                context2.getClient().log(Severity.ERROR, null, "Could not process " + context2.getProject().getRelativePath(file) + ": Kotlin not configured correctly", new Object[0]);
                return null;
            }
        }
        if (psiFile instanceof PsiPlainTextFile) {
            if (!Companion.getWarnedAboutLargeFiles()) {
                Companion.setWarnedAboutLargeFiles(true);
                int max = FileUtilRt.getUserFileSizeLimit();
                long size = file.length() / (long)1024;
                double d = 2.0;
                double d2 = size;
                boolean bl = false;
                double d3 = Math.log10(d2);
                d2 = 2.0;
                bl = false;
                d2 = d3 / Math.log10(d2) + 0.2;
                bl = false;
                d2 = Math.ceil(d2);
                bl = false;
                int sizeRoundedUp = (int)Math.pow(d, d2);
                Context.report$default(context2, IssueRegistry.LINT_ERROR, Location.Companion.create(file), "Source file too large for lint to process (" + size + "KB); the current max size is " + max + "KB. You can increase the limit by setting this system property: `idea.max.intellisense.filesize=" + sizeRoundedUp + "` (or even higher)", null, 8, null);
            }
            return null;
        }
        string3 = UastFacade.INSTANCE.convertElementWithParent((PsiElement)psiFile, UFile.class);
        UFile uFile2 = uFile = string3 instanceof UFile ? (UFile)string3 : null;
        if (uFile == null) {
            return null;
        }
        return uFile;
    }

    @Override
    @NotNull
    public Location getLocation(@NotNull JavaContext context2, @NotNull PsiElement element) {
        CharSequence contents;
        File file;
        TextRange range;
        block15: {
            PsiFile containingFile;
            block14: {
                Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                range = null;
                if (element instanceof PsiCompiledElement) {
                    if (element instanceof LightElement) {
                        range = element.getTextRange();
                    }
                    if (range == null || Intrinsics.areEqual((Object)TextRange.EMPTY_RANGE, (Object)range)) {
                        VirtualFile virtualFile;
                        PsiFile containingFile2 = element.getContainingFile();
                        if (containingFile2 != null && (virtualFile = containingFile2.getVirtualFile()) != null) {
                            File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"virtualToIoFile(virtualFile)");
                            return Location.Companion.create(file2);
                        }
                        return Location.Companion.create(context2.file);
                    }
                } else {
                    range = element.getTextRange();
                }
                containingFile = UastLintUtils.Companion.getContainingFile(context2, element);
                file = context2.file;
                CharSequence charSequence = context2.getContents();
                CharSequence charSequence2 = contents = charSequence == null ? (CharSequence)"" : charSequence;
                if (containingFile == null || containingFile.isEquivalentTo((PsiElement)context2.getPsiFile()) || !Intrinsics.areEqual((Object)containingFile.getName(), (Object)((charSequence = context2.getPsiFile()) == null ? null : charSequence.getName()))) break block14;
                charSequence = containingFile.getClass().getSimpleName();
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"containingFile.javaClass.simpleName");
                if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)"fakeFile", (boolean)false, (int)2, null)) break block15;
            }
            if (containingFile != null && !Intrinsics.areEqual((Object)containingFile, (Object)context2.getPsiFile())) {
                File ioFile;
                if (context2.getDriver().getScope().size() == 1) {
                    return Location.NONE;
                }
                File file3 = this.getFile(containingFile);
                if (file3 == null) {
                    return Location.NONE;
                }
                file = ioFile = file3;
                contents = this.getFileContents(containingFile);
            }
        }
        if (range == null) {
            PsiElement parent;
            if (element instanceof LightElement && (parent = element.getParent()) != null) {
                return this.getLocation(context2, parent);
            }
            return Location.Companion.create(file);
        }
        return Location.Companion.create(file, contents, range.getStartOffset(), range.getEndOffset()).setSource(element);
    }

    @Override
    @NotNull
    public Location getLocation(@NotNull JavaContext context2, @NotNull UElement element) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (element instanceof UElementWithLocation) {
            String string;
            PsiElement psiElement;
            UFile uFile = UastUtils.getContainingUFile((UElement)element);
            if (uFile == null) {
                return Location.NONE;
            }
            UFile file = uFile;
            File file2 = UastUtils.getIoFile((UFile)file);
            if (file2 == null) {
                return Location.NONE;
            }
            File ioFile = file2;
            String string2 = file.getSourcePsi().getText();
            String text = string2 == null ? ((psiElement = file.getJavaPsi()) == null ? "" : ((string = psiElement.getText()) == null ? "" : string)) : string2;
            Location location = Location.Companion.create(ioFile, text, ((UElementWithLocation)element).getStartOffset(), ((UElementWithLocation)element).getEndOffset());
            location.setSource(element);
            return location;
        }
        if (element instanceof KotlinStringTemplateUPolyadicExpression && ((KotlinStringTemplateUPolyadicExpression)element).getOperands().size() == 1) {
            UExpression literal = (UExpression)((KotlinStringTemplateUPolyadicExpression)element).getOperands().get(0);
            return this.getLocation(context2, (UElement)literal).withSource(literal);
        }
        PsiElement psiElement = element.getSourcePsi();
        if (psiElement != null) {
            return this.getLocation(context2, psiElement).withSource(element);
        }
        UElement parent = element.getUastParent();
        if (parent != null) {
            return this.getLocation(context2, parent);
        }
        return Location.NONE;
    }

    @Override
    @NotNull
    public Location getCallLocation(@NotNull JavaContext context2, @NotNull UCallExpression call, boolean includeReceiver, boolean includeArguments) {
        UIdentifier methodIdentifier;
        UExpression uExpression;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        if (includeArguments && (uExpression = (UExpression)CollectionsKt.lastOrNull((List)call.getValueArguments())) != null) {
            Integer callEnds;
            UExpression uExpression2 = uExpression;
            boolean bl = false;
            boolean bl2 = false;
            UExpression lastArgument = uExpression2;
            boolean bl3 = false;
            PsiElement psiElement = lastArgument.getSourcePsi();
            Integer argumentsEnd = psiElement == null ? null : Integer.valueOf(PsiUtilsKt.getEndOffset((PsiElement)psiElement));
            PsiElement psiElement2 = call.getSourcePsi();
            Integer n = callEnds = psiElement2 == null ? null : Integer.valueOf(PsiUtilsKt.getEndOffset((PsiElement)psiElement2));
            if (argumentsEnd != null && callEnds != null && argumentsEnd > callEnds) {
                UExpression uExpression3;
                UExpression startElement = includeReceiver ? ((uExpression3 = call.getReceiver()) == null ? (UExpression)call : uExpression3) : (UExpression)call;
                PsiElement psiElement3 = lastArgument.getSourcePsi();
                KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = psiElement3 instanceof KtLiteralStringTemplateEntry ? (KtLiteralStringTemplateEntry)psiElement3 : null;
                PsiElement psiElement4 = ktLiteralStringTemplateEntry == null ? null : ktLiteralStringTemplateEntry.getNextSibling();
                TreeElement next = psiElement4 instanceof TreeElement ? (TreeElement)psiElement4 : null;
                int delta = next != null && Intrinsics.areEqual((Object)next.getElementType(), (Object)KtTokens.CLOSING_QUOTE) ? next.getTextLength() : 0;
                return this.getRangeLocation(context2, (UElement)startElement, 0, (UElement)lastArgument, delta);
            }
        }
        UExpression receiver = call.getReceiver();
        if (!includeReceiver || receiver == null) {
            if (includeArguments) {
                return this.getLocation(context2, (UElement)call);
            }
            methodIdentifier = call.getMethodIdentifier();
            if (methodIdentifier != null) {
                return this.getLocation(context2, (UElement)methodIdentifier);
            }
        } else {
            if (!includeArguments && (methodIdentifier = call.getMethodIdentifier()) != null) {
                return this.getRangeLocation(context2, (UElement)receiver, 0, (UElement)methodIdentifier, 0);
            }
            return this.getRangeLocation(context2, (UElement)receiver, 0, (UElement)call, 0);
        }
        return this.getLocation(context2, (UElement)call);
    }

    @Override
    @Nullable
    public File getFile(@NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        VirtualFile virtualFile = file.getVirtualFile();
        return virtualFile != null ? VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile) : null;
    }

    @Override
    @NotNull
    public CharSequence getFileContents(@NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String string = file.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.text");
        return string;
    }

    @Override
    @NotNull
    public Location createLocation(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        TextRange range = element.getTextRange();
        PsiFile containingFile = element.getContainingFile();
        CharSequence contents = null;
        Intrinsics.checkExpressionValueIsNotNull((Object)containingFile, (String)"containingFile");
        File file = this.getFile(containingFile);
        if (file == null) {
            return Location.NONE;
        }
        File file2 = file;
        contents = this.getFileContents(containingFile);
        return Location.Companion.create(file2, contents, range.getStartOffset(), range.getEndOffset()).setSource(element);
    }

    @Override
    @NotNull
    public Location createLocation(@NotNull UElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (element instanceof UElementWithLocation) {
            UFile uFile = UastUtils.getContainingUFile((UElement)element);
            if (uFile == null) {
                return Location.NONE;
            }
            UFile file = uFile;
            File file2 = UastUtils.getIoFile((UFile)file);
            if (file2 == null) {
                return Location.NONE;
            }
            File ioFile = file2;
            String text = file.getPsi().getText();
            Location location = Location.Companion.create(ioFile, text, ((UElementWithLocation)element).getStartOffset(), ((UElementWithLocation)element).getEndOffset());
            location.setSource(element);
            return location;
        }
        PsiElement psiElement = element.getPsi();
        if (psiElement != null) {
            return this.createLocation(psiElement).withSource(element);
        }
        UElement parent = element.getUastParent();
        if (parent != null) {
            return this.createLocation(parent);
        }
        return Location.NONE;
    }

    @Override
    @NotNull
    public Location getRangeLocation(@NotNull JavaContext context2, @NotNull PsiElement from, int fromDelta, @NotNull PsiElement to, int toDelta) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        CharSequence contents = context2.getContents();
        TextRange fromRange = from.getTextRange();
        int n = 0;
        int n2 = fromRange.getStartOffset() + fromDelta;
        int n3 = 0;
        int start = Math.max(n, n2);
        CharSequence charSequence = contents;
        int n4 = charSequence == null ? Integer.MAX_VALUE : (n3 = charSequence.length());
        n3 = to.getTextRange().getEndOffset() + toDelta;
        boolean bl = false;
        int end = Math.min(n4, n3);
        if (end <= start) {
            return Location.Companion.create(context2.file, contents, start, fromRange.getEndOffset()).setSource(from);
        }
        return Location.Companion.create(context2.file, contents, start, end).setSource(from);
    }

    private final TextRange getTextRange(UElement element) {
        if (element instanceof UElementWithLocation) {
            return new TextRange(((UElementWithLocation)element).getStartOffset(), ((UElementWithLocation)element).getEndOffset());
        }
        PsiElement psiElement = element.getPsi();
        if (psiElement != null) {
            return psiElement.getTextRange();
        }
        return null;
    }

    @Override
    @NotNull
    public Location getRangeLocation(@NotNull JavaContext context2, @NotNull UElement from, int fromDelta, @NotNull UElement to, int toDelta) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        CharSequence contents = context2.getContents();
        TextRange fromRange = this.getTextRange(from);
        TextRange toRange = this.getTextRange(to);
        File file = context2.file;
        PsiElement psi = this.findPsi(from);
        if (psi != null) {
            PsiFile containingFile = psi.getContainingFile();
            contents = context2.getContents();
            if (!Intrinsics.areEqual((Object)containingFile, (Object)context2.getPsiFile())) {
                File ioFile;
                if (context2.getDriver().getScope().size() == 1) {
                    return Location.NONE;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)containingFile, (String)"containingFile");
                File file2 = this.getFile(containingFile);
                if (file2 == null) {
                    return Location.NONE;
                }
                file = ioFile = file2;
                contents = this.getFileContents(containingFile);
            }
        }
        if (fromRange != null && toRange != null) {
            int ioFile = 0;
            int n = fromRange.getStartOffset() + fromDelta;
            int n2 = 0;
            int start = Math.max(ioFile, n);
            CharSequence charSequence = contents;
            int n3 = charSequence == null ? Integer.MAX_VALUE : (n2 = charSequence.length());
            n2 = toRange.getEndOffset() + toDelta;
            boolean bl = false;
            int end = Math.min(n3, n2);
            if (end <= start) {
                return Location.Companion.create(file, contents, start, fromRange.getEndOffset()).setSource(from);
            }
            return Location.Companion.create(file, contents, start, end).setSource(from);
        }
        return Location.Companion.create(file).setSource(from);
    }

    private final PsiElement findPsi(UElement element) {
        for (UElement currentElement = element; currentElement != null; currentElement = currentElement.getUastParent()) {
            PsiElement psi = currentElement.getPsi();
            if (psi == null) continue;
            return psi;
        }
        return null;
    }

    @Override
    @NotNull
    public Location getRangeLocation(@NotNull JavaContext context2, @NotNull PsiElement from, int fromDelta, int toDelta) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        return this.getRangeLocation(context2, from, fromDelta, from, -(from.getTextRange().getLength() - toDelta));
    }

    @Override
    @NotNull
    public Location getRangeLocation(@NotNull JavaContext context2, @NotNull UElement from, int fromDelta, int toDelta) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        TextRange fromRange = this.getTextRange(from);
        if (fromRange != null) {
            return this.getRangeLocation(context2, from, fromDelta, from, -(fromRange.getLength() - toDelta));
        }
        return Location.Companion.create(context2.file).setSource(from);
    }

    @Override
    @NotNull
    public Location getNameLocation(@NotNull JavaContext context2, @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        PsiElement namedElement = element;
        PsiElement nameNode = JavaContext.Companion.findNameElement(namedElement);
        if (nameNode != null) {
            namedElement = nameNode;
        }
        return this.getLocation(context2, namedElement);
    }

    @Override
    @NotNull
    public Location getNameLocation(@NotNull JavaContext context2, @NotNull UElement element) {
        PsiElement nameIdentifier;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        PsiElement sourcePsi = element.getSourcePsi();
        if (sourcePsi instanceof KtPropertyAccessor) {
            KtProperty ktProperty = ((KtPropertyAccessor)sourcePsi).getProperty();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktProperty, (String)"sourcePsi.property");
            return context2.getNameLocation((PsiElement)ktProperty);
        }
        UElement namedElement = element;
        UElement nameNode = JavaContext.Companion.findNameElement(namedElement);
        if (nameNode != null) {
            namedElement = nameNode;
        } else if (namedElement instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)namedElement).getNameIdentifier()) != null) {
            return this.getLocation(context2, nameIdentifier);
        }
        return this.getLocation(context2, namedElement);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/helpers/DefaultUastParser$Companion;", "", "()V", "warnedAboutLargeFiles", "", "getWarnedAboutLargeFiles", "()Z", "setWarnedAboutLargeFiles", "(Z)V", "lint-api"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getWarnedAboutLargeFiles() {
            return warnedAboutLargeFiles;
        }

        public final void setWarnedAboutLargeFiles(boolean bl) {
            warnedAboutLargeFiles = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

