/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.ConfigurationHierarchy;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.client.api.Vendor;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Constraint;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.LocationType;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.CharSequences;
import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 X2\u00020\u0001:\u0001XB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u00101\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002J\n\u00108\u001a\u0004\u0018\u00010\nH\u0016J\u001a\u00109\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u00106\u001a\u000207J\u000e\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=J\u000e\u0010>\u001a\u00020\u00152\u0006\u0010<\u001a\u00020=J\u0006\u0010?\u001a\u00020\u0015J\u0016\u0010@\u001a\u00020\u00152\u0006\u0010A\u001a\u00020 2\u0006\u0010<\u001a\u00020=J3\u0010B\u001a\u00020C2\b\u0010D\u001a\u0004\u0018\u00010E2\b\u0010F\u001a\u0004\u0018\u00010.2\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010H\"\u00020\u0001\u00a2\u0006\u0002\u0010IJ\u000e\u0010J\u001a\u00020C2\u0006\u0010K\u001a\u00020LJ\u0016\u0010J\u001a\u00020C2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NJ\u0016\u0010J\u001a\u00020C2\u0006\u0010K\u001a\u00020L2\u0006\u0010O\u001a\u00020PJ,\u0010J\u001a\u00020C2\u0006\u0010<\u001a\u00020=2\u0006\u0010Q\u001a\u0002032\u0006\u0010R\u001a\u00020.2\n\b\u0002\u0010S\u001a\u0004\u0018\u00010TH\u0017J\u001e\u0010U\u001a\u00020C2\u0006\u0010V\u001a\u00020W2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010%R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001eR\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0016\u0010-\u001a\u0004\u0018\u00010.8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u0006Y"}, d2={"Lcom/android/tools/lint/detector/api/Context;", "", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "project", "Lcom/android/tools/lint/detector/api/Project;", "main", "file", "Ljava/io/File;", "contents", "", "(Lcom/android/tools/lint/client/api/LintDriver;Lcom/android/tools/lint/detector/api/Project;Lcom/android/tools/lint/detector/api/Project;Ljava/io/File;Ljava/lang/CharSequence;)V", "client", "Lcom/android/tools/lint/client/api/LintClient;", "getClient", "()Lcom/android/tools/lint/client/api/LintClient;", "configuration", "Lcom/android/tools/lint/client/api/Configuration;", "getConfiguration", "()Lcom/android/tools/lint/client/api/Configuration;", "containsCommentSuppress", "", "Ljava/lang/Boolean;", "getDriver", "()Lcom/android/tools/lint/client/api/LintDriver;", "forbidMainAccess", "getForbidMainAccess", "()Z", "mainProject", "getMainProject", "()Lcom/android/tools/lint/detector/api/Project;", "phase", "", "getPhase", "()I", "getProject", "scope", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Scope;", "getScope", "()Ljava/util/EnumSet;", "sdkInfo", "Lcom/android/tools/lint/client/api/SdkInfo;", "getSdkInfo", "()Lcom/android/tools/lint/client/api/SdkInfo;", "suppressCommentPrefix", "", "getSuppressCommentPrefix", "()Ljava/lang/String;", "findConfiguration", "findNodeInProject", "Lcom/android/tools/lint/detector/api/Location;", "node", "Lorg/w3c/dom/Node;", "type", "Lcom/android/tools/lint/detector/api/LocationType;", "getContents", "getLocation", "getPartialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "isEnabled", "isGlobalAnalysis", "isSuppressedWithComment", "startOffset", "log", "", "exception", "", "format", "args", "", "(Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "report", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "constraint", "Lcom/android/tools/lint/detector/api/Constraint;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "location", "message", "quickfixData", "Lcom/android/tools/lint/detector/api/LintFix;", "requestRepeat", "detector", "Lcom/android/tools/lint/detector/api/Detector;", "Companion", "lint-api"})
@Beta
public class Context {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LintDriver driver;
    @NotNull
    private final Project project;
    @Nullable
    private final Project main;
    @JvmField
    @NotNull
    public final File file;
    @Nullable
    private CharSequence contents;
    @NotNull
    private final Configuration configuration;
    @Nullable
    private Boolean containsCommentSuppress;
    @NotNull
    public static final String SUPPRESS_XML_COMMENT_PREFIX = "<!--suppress ";
    @NotNull
    public static final String SUPPRESS_JAVA_COMMENT_PREFIX = "noinspection ";
    @Nullable
    private static Set<String> detectorsWarned;

    public Context(@NotNull LintDriver driver, @NotNull Project project, @Nullable Project main, @NotNull File file, @Nullable CharSequence contents) {
        Configuration configuration;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.driver = driver;
        this.project = project;
        this.main = main;
        this.file = file;
        this.contents = contents;
        Configuration configuration2 = this.getClient().getConfiguration(this.file);
        if (configuration2 == null) {
            Configuration configuration3 = this.project.getConfiguration(this.driver);
            Intrinsics.checkNotNullExpressionValue((Object)configuration3, (String)"project.getConfiguration(driver)");
            configuration = configuration3;
        } else {
            configuration = configuration2;
        }
        this.configuration = configuration;
    }

    public /* synthetic */ Context(LintDriver lintDriver, Project project, Project project2, File file, CharSequence charSequence, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            charSequence = null;
        }
        this(lintDriver, project, project2, file, charSequence);
    }

    @NotNull
    public final LintDriver getDriver() {
        return this.driver;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Configuration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final EnumSet<Scope> getScope() {
        return this.driver.getScope();
    }

    @NotNull
    public final Project getMainProject() {
        boolean forbidden;
        if (this.getForbidMainAccess() && (forbidden = Companion.checkForbidden("context.getMainProject()", this.file, this.driver))) {
            return this.project;
        }
        Project project = this.main;
        return project == null ? this.project : project;
    }

    @NotNull
    public final LintClient getClient() {
        return this.driver.getClient();
    }

    @Nullable
    public CharSequence getContents() {
        if (this.contents == null) {
            this.contents = this.driver.getClient().readFile(this.file);
        }
        return this.contents;
    }

    @NotNull
    public final SdkInfo getSdkInfo() {
        SdkInfo sdkInfo = this.project.getSdkInfo();
        Intrinsics.checkNotNullExpressionValue((Object)sdkInfo, (String)"project.getSdkInfo()");
        return sdkInfo;
    }

    @NotNull
    public final Location getLocation(@Nullable Object node, @NotNull LocationType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Object object = node;
        if (object == null) {
            return Location.NONE;
        }
        object = node;
        if (object instanceof UElement) {
            Location location;
            Object file;
            Object object2;
            JavaContext javaContext;
            if (this instanceof JavaContext) {
                javaContext = (JavaContext)this;
            } else {
                File file2;
                PsiFile psiFile;
                PsiElement psiElement = ((UElement)node).getSourcePsi();
                PsiFile psiFile2 = psiFile = psiElement == null ? null : psiElement.getContainingFile();
                if (psiFile == null) {
                    file2 = null;
                } else {
                    psiElement = psiFile.getVirtualFile();
                    if (psiElement == null) {
                        file2 = null;
                    } else {
                        PsiElement psiElement2 = psiElement;
                        boolean bl = false;
                        boolean bl2 = false;
                        PsiElement it = psiElement2;
                        boolean bl3 = false;
                        file2 = VfsUtilCore.virtualToIoFile((VirtualFile)it);
                    }
                }
                object2 = file2;
                File file3 = object2 == null ? this.file : object2;
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"node.sourcePsi?.containingFile?.virtualFile?.let {\n                        VfsUtilCore.virtualToIoFile(it)\n                    } ?: file");
                file = file3;
                javaContext = new JavaContext(this.driver, this.project, this.main, (File)file);
            }
            JavaContext context2 = javaContext;
            file = type;
            int n = WhenMappings.$EnumSwitchMapping$0[file.ordinal()];
            switch (n) {
                case 1: {
                    location = context2.getLocation((UElement)node);
                    break;
                }
                case 2: {
                    location = context2.getUastParser().getLocation(context2, (UElement)node);
                    break;
                }
                case 3: {
                    location = context2.getNameLocation((UElement)node);
                    break;
                }
                case 4: {
                    if (node == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
                    }
                    location = context2.getCallLocation((UCallExpression)node, false, true);
                    break;
                }
                case 5: {
                    if (node == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
                    }
                    location = context2.getCallLocation((UCallExpression)node, true, false);
                    break;
                }
                case 6: {
                    object2 = (Object)((Object)type) + " not supported for " + node.getClass();
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(object2.toString());
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return location;
        }
        if (object instanceof PsiElement) {
            Location location;
            Object file;
            Object object3;
            JavaContext javaContext;
            if (this instanceof JavaContext) {
                javaContext = (JavaContext)this;
            } else {
                File file4;
                PsiFile psiFile = ((PsiElement)node).getContainingFile();
                if (psiFile == null) {
                    file4 = null;
                } else {
                    VirtualFile virtualFile = psiFile.getVirtualFile();
                    if (virtualFile == null) {
                        file4 = null;
                    } else {
                        VirtualFile virtualFile2 = virtualFile;
                        boolean bl = false;
                        boolean bl4 = false;
                        VirtualFile it = virtualFile2;
                        boolean bl5 = false;
                        file4 = VfsUtilCore.virtualToIoFile((VirtualFile)it);
                    }
                }
                object3 = file4;
                File file5 = object3 == null ? this.file : object3;
                Intrinsics.checkNotNullExpressionValue((Object)file5, (String)"node.containingFile?.virtualFile?.let {\n                        VfsUtilCore.virtualToIoFile(it)\n                    } ?: file");
                file = file5;
                javaContext = new JavaContext(this.driver, this.project, this.main, (File)file);
            }
            JavaContext context3 = javaContext;
            file = type;
            int n = WhenMappings.$EnumSwitchMapping$0[file.ordinal()];
            switch (n) {
                case 1: {
                    location = context3.getLocation((PsiElement)node);
                    break;
                }
                case 2: {
                    location = context3.getLocation((PsiElement)node);
                    break;
                }
                case 3: {
                    location = context3.getNameLocation((PsiElement)node);
                    break;
                }
                case 4: {
                    if (node == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
                    }
                    location = context3.getCallLocation((UCallExpression)node, false, true);
                    break;
                }
                case 5: {
                    if (node == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
                    }
                    location = context3.getCallLocation((UCallExpression)node, true, false);
                    break;
                }
                case 6: {
                    object3 = (Object)((Object)type) + " not supported for " + node.getClass();
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(object3.toString());
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return location;
        }
        if (object instanceof Node) {
            Location location;
            Object object4;
            XmlContext xmlContext;
            com.android.utils.Pair<File, ? extends Node> source;
            Object context3;
            if (this.getClient().isMergeManifestNode((Node)node)) {
                if (Intrinsics.areEqual((Object)((Node)node).getNodeName(), (Object)"application") && Intrinsics.areEqual((Object)((context3 = ((Node)node).getParentNode()) == null ? null : context3.getNodeName()), (Object)"manifest")) {
                    return this.findNodeInProject((Node)node, type);
                }
                source = this.getClient().findManifestSourceNode((Node)node);
                if (source != null && source.getSecond() != node) {
                    if (Intrinsics.areEqual((Object)source.getFirst(), (Object)this.file)) {
                        return this.getLocation(source.getSecond(), type);
                    }
                    Document doc = ((Node)node).getOwnerDocument();
                    Object object5 = source.getFirst();
                    Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"source.first");
                    File file = (File)object5;
                    Intrinsics.checkNotNullExpressionValue((Object)doc, (String)"doc");
                    XmlContext xmlContext2 = new XmlContext(this.driver, this.project, this.main, file, null, null, doc);
                    return xmlContext2.getLocation(source.getSecond(), type);
                }
            }
            source = this.file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)source, (String)"file.path");
            if (!StringsKt.endsWith$default(source, (String)".xml", (boolean)false, (int)2, null)) {
                return this.findNodeInProject((Node)node, type);
            }
            if (this instanceof XmlContext) {
                xmlContext = (XmlContext)this;
            } else {
                Object object6;
                Document doc = ((Node)node).getOwnerDocument();
                Object object7 = doc.getUserData(File.class.getName());
                Object object8 = object4 = object7 instanceof File ? (File)object7 : null;
                if (object4 == null) {
                    VirtualFile virtualFile;
                    File file;
                    Object object9;
                    VirtualFile virtualFile3 = doc.getUserData(PsiFile.class.getName());
                    PsiFile psiFile = object9 = virtualFile3 instanceof PsiFile ? (PsiFile)virtualFile3 : null;
                    if (object9 == null) {
                        file = null;
                    } else {
                        virtualFile3 = object9.getVirtualFile();
                        if (virtualFile3 == null) {
                            file = null;
                        } else {
                            virtualFile = virtualFile3;
                            boolean bl = false;
                            boolean bl6 = false;
                            VirtualFile it = virtualFile;
                            boolean bl7 = false;
                            file = VfsUtilCore.virtualToIoFile(it);
                        }
                    }
                    object7 = file;
                    if (object7 == null) {
                        virtualFile = this.project.getManifestFiles();
                        Intrinsics.checkNotNullExpressionValue(virtualFile, (String)"project.getManifestFiles()");
                        virtualFile3 = (File)CollectionsKt.firstOrNull(virtualFile);
                        object9 = virtualFile3 == null ? this.project.dir : virtualFile3;
                        Intrinsics.checkNotNullExpressionValue((Object)object9, (String)"project.getManifestFiles().firstOrNull() ?: project.dir");
                        return Location.Companion.create((File)object9);
                    }
                    object6 = object7;
                } else {
                    object6 = object4;
                }
                File file = object6;
                Intrinsics.checkNotNullExpressionValue((Object)doc, (String)"doc");
                xmlContext = new XmlContext(this.driver, this.project, this.main, file, null, null, doc);
            }
            context3 = xmlContext;
            LocationType locationType = type;
            int n = WhenMappings.$EnumSwitchMapping$0[locationType.ordinal()];
            switch (n) {
                case 2: {
                    location = ((XmlContext)context3).getLocation((Node)node);
                    break;
                }
                case 1: {
                    if (node instanceof Element) {
                        location = ((XmlContext)context3).getElementLocation((Element)node);
                        break;
                    }
                    location = ((XmlContext)context3).getLocation((Node)node);
                    break;
                }
                case 3: {
                    location = ((XmlContext)context3).getNameLocation((Node)node);
                    break;
                }
                case 6: {
                    if (node instanceof Attr) {
                        location = ((XmlContext)context3).getValueLocation((Attr)node);
                        break;
                    }
                    location = ((XmlContext)context3).getLocation((Node)node);
                    break;
                }
                case 4: 
                case 5: {
                    object4 = (Object)((Object)type) + " not supported for " + node.getClass();
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(object4.toString());
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return location;
        }
        if (object instanceof ClassNode) {
            if (this instanceof ClassContext) {
                return ((ClassContext)this).getLocation((ClassNode)node);
            }
            String string = "Can only get ClassNode locations on a ClassContext";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (object instanceof AbstractInsnNode) {
            if (this instanceof ClassContext) {
                return ((ClassContext)this).getLocation((AbstractInsnNode)node);
            }
            String string = "Can only get AbstractInsnNode locations on a ClassContext";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (this instanceof GradleContext) {
            return ((GradleContext)this).getLocation(node);
        }
        return Location.Companion.create(this.file);
    }

    public static /* synthetic */ Location getLocation$default(Context context2, Object object, LocationType locationType, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getLocation");
        }
        if ((n & 2) != 0) {
            locationType = LocationType.DEFAULT;
        }
        return context2.getLocation(object, locationType);
    }

    /*
     * WARNING - void declaration
     */
    private final Location findNodeInProject(Node node, LocationType type) {
        Object object;
        Element element;
        Object object2 = node;
        Element element2 = object2 instanceof Element ? (Element)node : (element = object2 instanceof Attr ? ((Attr)node).getOwnerElement() : null);
        if (element != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            object = new Project[]{this.project};
            Sequence sequence = SequencesKt.sequenceOf((Object[])object);
            object = this.project.allLibraries;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.allLibraries");
            object = (Iterable)object;
            Sequence sequence2 = sequence;
            boolean $i$f$filter = false;
            Iterator<File> iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Project it = (Project)element$iv$iv;
                boolean bl = false;
                if (!(!it.isExternalLibrary())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            Sequence projects = SequencesKt.plus((Sequence)sequence2, (Iterable)list2);
            for (Project p : projects) {
                for (File manifest : p.getManifestFiles()) {
                    try {
                        Document document;
                        Node sourceNode;
                        XmlParser xmlParser = this.getClient().getXmlParser();
                        Intrinsics.checkNotNullExpressionValue((Object)manifest, (String)"manifest");
                        Document document2 = xmlParser.parseXml(manifest);
                        if (document2 == null || (sourceNode = (Node)Lint.matchXmlElement(element, document = document2)) == null || sourceNode == element) continue;
                        Document doc = node.getOwnerDocument();
                        Intrinsics.checkNotNullExpressionValue((Object)p, (String)"p");
                        Intrinsics.checkNotNullExpressionValue((Object)doc, (String)"doc");
                        XmlContext xmlContext = new XmlContext(this.driver, p, this.main, manifest, null, null, doc);
                        return xmlContext.getLocation(sourceNode, type);
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
        List<File> list3 = this.project.getManifestFiles();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"project.getManifestFiles()");
        object = (File)CollectionsKt.firstOrNull(list3);
        object2 = object == null ? this.project.dir : object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"project.getManifestFiles().firstOrNull() ?: project.dir");
        return Location.Companion.create((File)object2);
    }

    public final boolean isEnabled(@NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        return this.configuration.isEnabled(issue);
    }

    @JvmOverloads
    public void report(@NotNull Issue issue, @NotNull Location location, @NotNull String message2, @Nullable LintFix quickfixData) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Incident incident = new Incident(issue, location, message2, quickfixData);
        LintClient.report$default(this.driver.getClient(), this, incident, null, 4, null);
    }

    public static /* synthetic */ void report$default(Context context2, Issue issue, Location location, String string, LintFix lintFix, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: report");
        }
        if ((n & 8) != 0) {
            lintFix = null;
        }
        context2.report(issue, location, string, lintFix);
    }

    public final void report(@NotNull Incident incident) {
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        LintClient.report$default(this.driver.getClient(), this, incident, null, 4, null);
    }

    public final boolean isGlobalAnalysis() {
        return this.driver.isGlobalAnalysis();
    }

    public final void report(@NotNull Incident incident, @NotNull Constraint constraint) {
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
        this.getClient().report(this, incident, constraint);
    }

    public final void report(@NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        this.getClient().report(this, incident, map);
    }

    @NotNull
    public final PartialResult getPartialResults(@NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        return this.getClient().getPartialResults(this.project, issue);
    }

    @NotNull
    public final Configuration findConfiguration(@NotNull File file) {
        Configuration configuration;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ConfigurationHierarchy configurations = this.driver.getClient().getConfigurations();
        File dir = file.getParentFile();
        Configuration configuration2 = ConfigurationHierarchy.getConfigurationForFolder$default(configurations, dir, null, 2, null);
        if (configuration2 == null) {
            Context context2 = this;
            boolean bl = false;
            boolean bl2 = false;
            Context $this$findConfiguration_u24lambda_u2d4 = context2;
            boolean bl3 = false;
            Project project = $this$findConfiguration_u24lambda_u2d4.getDriver().findProjectFor(file);
            Project project2 = project;
            Configuration configuration3 = project2 == null ? null : project2.getConfiguration($this$findConfiguration_u24lambda_u2d4.getDriver());
            Configuration configuration4 = configuration3 == null ? $this$findConfiguration_u24lambda_u2d4.getConfiguration() : configuration3;
            Intrinsics.checkNotNullExpressionValue((Object)configuration4, (String)"project?.getConfiguration(driver) ?: configuration");
            configuration = configuration4;
        } else {
            configuration = configuration2;
        }
        return configuration;
    }

    public final void log(@Nullable Throwable exception, @Nullable String format, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        LintClient lintClient = this.driver.getClient();
        Object[] objectArray = new Object[args.length];
        System.arraycopy(args, 0, objectArray, 0, args.length);
        lintClient.log(exception, format, objectArray);
    }

    public final int getPhase() {
        return this.driver.getPhase();
    }

    public final void requestRepeat(@NotNull Detector detector, @Nullable EnumSet<Scope> scope) {
        Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
        this.driver.requestRepeat(detector, scope);
    }

    @Nullable
    protected String getSuppressCommentPrefix() {
        String path2 = this.file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
        if (StringsKt.endsWith$default((String)path2, (String)".java", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path2, (String)".gradle", (boolean)false, (int)2, null)) {
            return SUPPRESS_JAVA_COMMENT_PREFIX;
        }
        if (StringsKt.endsWith$default((String)path2, (String)".xml", (boolean)false, (int)2, null)) {
            return SUPPRESS_XML_COMMENT_PREFIX;
        }
        if (StringsKt.endsWith$default((String)path2, (String)".cfg", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path2, (String)".pro", (boolean)false, (int)2, null)) {
            return "#suppress ";
        }
        return null;
    }

    public final boolean containsCommentSuppress() {
        if (this.containsCommentSuppress == null) {
            CharSequence contents;
            this.containsCommentSuppress = false;
            String prefix = this.getSuppressCommentPrefix();
            if (prefix != null && (contents = this.getContents()) != null) {
                this.containsCommentSuppress = CharSequences.indexOf((CharSequence)contents, (CharSequence)prefix) != -1;
            }
        }
        Boolean bl = this.containsCommentSuppress;
        Intrinsics.checkNotNull((Object)bl);
        return bl;
    }

    public final boolean isSuppressedWithComment(int startOffset, @NotNull Issue issue) {
        CharSequence contents;
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        String string = this.getSuppressCommentPrefix();
        if (string == null) {
            return false;
        }
        String prefix = string;
        if (startOffset <= 0) {
            return false;
        }
        CharSequence charSequence = this.getContents();
        CharSequence charSequence2 = contents = charSequence == null ? (CharSequence)"" : charSequence;
        if (startOffset >= contents.length()) {
            return false;
        }
        int lineStart = StringsKt.lastIndexOf$default((CharSequence)contents, (char)'\n', (int)startOffset, (boolean)false, (int)4, null) + 1;
        if (lineStart <= 1) {
            return false;
        }
        int index = Context.Companion.findPrefixOnPreviousLine(contents, lineStart, prefix);
        if (index != -1 && index + prefix.length() < lineStart) {
            String line = ((Object)contents.subSequence(index + prefix.length(), lineStart)).toString();
            return Companion.isSuppressedWithComment(line, issue);
        }
        return false;
    }

    private final boolean getForbidMainAccess() {
        return this.driver.getMode() == LintDriver.DriverMode.ANALYSIS_ONLY;
    }

    @JvmOverloads
    public final void report(@NotNull Issue issue, @NotNull Location location, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Context.report$default(this, issue, location, message2, null, 8, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ$\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0018\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0012H\u0007J \u0010\u001e\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0014H\u0002J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010$\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/android/tools/lint/detector/api/Context$Companion;", "", "()V", "SUPPRESS_JAVA_COMMENT_PREFIX", "", "SUPPRESS_XML_COMMENT_PREFIX", "detectorsWarned", "", "checkForbidden", "", "methodName", "file", "Ljava/io/File;", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "findCallingDetector", "Lkotlin/Pair;", "", "Lcom/android/tools/lint/detector/api/Issue;", "findPrefixOnPreviousLine", "", "contents", "", "lineStart", "prefix", "isSuppressedWithComment", "line", "category", "Lcom/android/tools/lint/detector/api/Category;", "issue", "isWord", "word", "index", "isWordDelimiter", "c", "", "lineContainsId", "id", "lint-api"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public final boolean isSuppressedWithComment(@NotNull String line, @NotNull Issue issue) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
            return this.lineContainsId(line, issue.getId()) || this.lineContainsId(line, "all") || this.isSuppressedWithComment(line, issue.getCategory());
        }

        private final boolean isSuppressedWithComment(String line, Category category) {
            return this.lineContainsId(line, category.getName()) || this.lineContainsId(line, category.getFullName()) || category.getParent() != null && this.isSuppressedWithComment(line, category.getParent());
        }

        private final boolean lineContainsId(String line, String id) {
            for (int index = 0; index < line.length(); index += id.length()) {
                if ((index = StringsKt.indexOf((CharSequence)line, (String)id, (int)index, (boolean)true)) == -1) {
                    return false;
                }
                if (!this.isWord(line, id, index)) continue;
                return true;
            }
            return false;
        }

        private final boolean isWord(String line, String word, int index) {
            int end = index + word.length();
            if (end < line.length() && !this.isWordDelimiter(line.charAt(end))) {
                return false;
            }
            if (index > 0 && !this.isWordDelimiter(line.charAt(index - 1))) {
                int prefixStart = index - "AndroidLint".length();
                return index >= "AndroidLint".length() && StringsKt.regionMatches$default((String)line, (int)prefixStart, (String)"AndroidLint", (int)0, (int)"AndroidLint".length(), (boolean)false, (int)16, null) && (prefixStart == 0 || this.isWordDelimiter(line.charAt(prefixStart - 1)));
            }
            return true;
        }

        private final boolean isWordDelimiter(char c) {
            char c2 = c;
            boolean bl = false;
            return !Character.isJavaIdentifierPart(c2);
        }

        private final int findPrefixOnPreviousLine(CharSequence contents, int lineStart, String prefix) {
            char first = prefix.charAt(0);
            int offset = lineStart - 2;
            boolean seenNonWhitespace = false;
            while (offset >= 0) {
                char c = contents.charAt(offset);
                if (seenNonWhitespace && c == '\n') {
                    return -1;
                }
                if (!seenNonWhitespace && !Character.isWhitespace(c)) {
                    seenNonWhitespace = true;
                }
                if (c == first && CharSequences.regionMatches((CharSequence)contents, (int)offset, (CharSequence)prefix, (int)0, (int)prefix.length())) {
                    return offset;
                }
                int n = offset;
                offset = n + -1;
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean checkForbidden(@NotNull String methodName, @NotNull File file, @Nullable LintDriver driver) {
            Pair<String, List<Issue>> currentDriver;
            Pair<String, List<Issue>> pair;
            Pair<String, List<Issue>> pair2;
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Pair<String, List<Issue>> pair3 = driver;
            if (pair3 == null) {
                pair2 = (Pair<String, List<Issue>>)CollectionsKt.firstOrNull(LintDriver.Companion.getCurrentDrivers());
                if (pair2 == null) {
                    return true;
                }
                pair = pair2;
            } else {
                pair = currentDriver = pair3;
            }
            if (currentDriver.getMode() == LintDriver.DriverMode.ANALYSIS_ONLY) {
                Set warnings;
                Set set;
                Iterable it;
                pair2 = this.findCallingDetector((LintDriver)currentDriver);
                if (pair2 == null) {
                    return false;
                }
                pair3 = pair2;
                String detector = (String)pair3.component1();
                List issues = (List)pair3.component2();
                Set set2 = detectorsWarned;
                if (set2 == null) {
                    HashSet hashSet = new HashSet();
                    boolean bl = false;
                    boolean bl2 = false;
                    it = hashSet;
                    boolean bl3 = false;
                    detectorsWarned = it;
                    set = hashSet;
                } else {
                    set = warnings = set2;
                }
                if (warnings.add(detector)) {
                    LintClient lintClient;
                    String string;
                    void $this$sortedBy$iv;
                    void $this$mapNotNullTo$iv$iv322;
                    StringBuilder stack = new StringBuilder();
                    LintDriver.Companion.appendStackTraceSummary(new RuntimeException(), stack, 1, 20);
                    Iterable $this$mapNotNull$iv = issues;
                    boolean $i$f$mapNotNull = false;
                    it = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv322;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Vendor vendor;
                        IssueRegistry issueRegistry;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        Issue it2 = (Issue)element$iv$iv;
                        boolean bl4 = false;
                        Vendor vendor2 = it2.getVendor();
                        if ((vendor2 == null ? ((issueRegistry = it2.getRegistry()) == null ? null : issueRegistry.getVendor()) : vendor2) == null) continue;
                        vendor = vendor;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        Vendor it$iv$iv = vendor;
                        boolean bl7 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                    boolean $i$f$sortedBy22 = false;
                    boolean $this$mapNotNullTo$iv$iv322 = false;
                    List vendors = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                        public final int compare(T a, T b) {
                            boolean bl = false;
                            Vendor it = (Vendor)a;
                            boolean bl2 = false;
                            Comparable comparable = (Comparable)((Object)it.getIdentifier());
                            it = (Vendor)b;
                            Comparable comparable2 = comparable;
                            bl2 = false;
                            String string = it.getIdentifier();
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                        }
                    });
                    Collection $this$mapNotNullTo$iv$iv322 = issues;
                    boolean bl = false;
                    if (!$this$mapNotNullTo$iv$iv322.isEmpty()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("\nIssue Vendors:\n");
                        for (Vendor vendor : vendors) {
                            String it3;
                            boolean bl8;
                            String string2 = vendor.getVendorName();
                            if (string2 != null) {
                                String string3 = string2;
                                boolean bl9 = false;
                                bl8 = false;
                                it3 = string3;
                                boolean bl10 = false;
                                sb.append("Vendor: " + it3 + '\n');
                            }
                            string2 = vendor.getIdentifier();
                            if (string2 != null) {
                                String string4 = string2;
                                boolean bl11 = false;
                                bl8 = false;
                                it3 = string4;
                                boolean bl12 = false;
                                sb.append("Identifier: " + it3 + '\n');
                            }
                            string2 = vendor.getContact();
                            if (string2 != null) {
                                String string5 = string2;
                                boolean bl13 = false;
                                bl8 = false;
                                it3 = string5;
                                boolean bl14 = false;
                                sb.append("Contact: " + it3 + '\n');
                            }
                            string2 = vendor.getFeedbackUrl();
                            if (string2 != null) {
                                String string6 = string2;
                                boolean bl15 = false;
                                bl8 = false;
                                it3 = string6;
                                boolean bl16 = false;
                                sb.append("Feedback: " + it3 + '\n');
                            }
                            sb.append("\n");
                        }
                        string = sb.toString();
                    } else {
                        string = "";
                    }
                    String $i$f$sortedBy22 = string;
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$sortedBy22, (String)"if (issues.isNotEmpty()) {\n                        val sb = StringBuilder()\n                        sb.append(\"\\nIssue Vendors:\\n\")\n                        for (vendor in vendors) {\n                            vendor.vendorName?.let { sb.append(\"Vendor: $it\\n\") }\n                            vendor.identifier?.let { sb.append(\"Identifier: $it\\n\") }\n                            vendor.contact?.let { sb.append(\"Contact: $it\\n\") }\n                            vendor.feedbackUrl?.let { sb.append(\"Feedback: $it\\n\") }\n                            sb.append(\"\\n\")\n                        }\n                        sb.toString()\n                    } else {\n                        \"\"\n                    }");
                    String vendorString = $i$f$sortedBy22;
                    Object object = driver;
                    Object object2 = object == null ? null : ((lintClient = object.getClient()) == null ? null : lintClient.getClientDisplayName());
                    String message2 = StringsKt.trimIndent((String)("\n                        The lint detector\n                            `" + detector + "`\n                        called `" + methodName + "` during module analysis.\n\n                        This does not work correctly when running in " + (String)(object2 == null ? LintClient.Companion.getClientName() : object2) + ".\n\n                        In particular, there may be false positives or false negatives because\n                        the lint check may be using the minSdkVersion or manifest information\n                        from the library instead of any consuming app module.\n\n                        Contact the vendor of the lint issue to get it fixed/updated (if\n                        known, listed below), and in the meantime you can try to work around\n                        this by disabling the following issues:\n\n                        " + CollectionsKt.joinToString$default((Iterable)issues, (CharSequence)",", null, null, (int)0, null, (Function1)checkForbidden.message.1.INSTANCE, (int)30, null) + "\n                        ")) + '\n' + vendorString + "Call stack: " + stack;
                    object2 = currentDriver.getClient();
                    object = IssueRegistry.LINT_ERROR;
                    Location location = Location.Companion.create(file);
                    LintClient.Companion.report$default(LintClient.Companion, (LintClient)object2, object, message2, null, null, null, null, null, null, null, null, currentDriver, location, 2040, null);
                }
                return true;
            }
            return false;
        }

        private final Pair<String, List<Issue>> findCallingDetector(LintDriver driver) {
            StackTraceElement callerCaller;
            Throwable throwable = new Throwable().fillInStackTrace();
            StackTraceElement[] frames = throwable.getStackTrace();
            if (frames.length >= 4 && (Intrinsics.areEqual((Object)(callerCaller = frames[3]).getMethodName(), (Object)"beforeCheckEachProject") || Intrinsics.areEqual((Object)callerCaller.getMethodName(), (Object)"afterCheckEachProject"))) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"throwable");
            Pair<String, List<Issue>> result = LintDriver.Companion.getAssociatedDetector(throwable, driver);
            if (result != null) {
                return result;
            }
            Intrinsics.checkNotNullExpressionValue((Object)frames, (String)"frames");
            for (StackTraceElement element : frames) {
                String detectorClass = element.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)detectorClass, (String)"detectorClass");
                if (StringsKt.startsWith$default((String)detectorClass, (String)"com.android.tools.lint.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)detectorClass, (String)"com.android.tools.lint.checks.", (boolean)false, (int)2, null)) continue;
                return new Pair((Object)detectorClass, LintDriver.Companion.getDetectorIssues(detectorClass, driver));
            }
            return new Pair((Object)"unknown detector", (Object)CollectionsKt.emptyList());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LocationType.values().length];
            nArray[LocationType.DEFAULT.ordinal()] = 1;
            nArray[LocationType.ALL.ordinal()] = 2;
            nArray[LocationType.NAME.ordinal()] = 3;
            nArray[LocationType.CALL_WITH_ARGUMENTS.ordinal()] = 4;
            nArray[LocationType.CALL_WITH_RECEIVER.ordinal()] = 5;
            nArray[LocationType.VALUE.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

