/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.ConfigurationHierarchy;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\b\u0010\u001c\u001a\u00020\u0012H\u0016J\"\u0010\u001d\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u0018H\u0002J\u0010\u0010\"\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010#H\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00170#H\u0016J\u0010\u0010&\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010#H\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00170#H\u0016J\u0010\u0010(\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010#H\u0016J\u0010\u0010)\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010#H\u0016J\b\u0010*\u001a\u00020\u0012H\u0016J\u0018\u0010+\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0018H\u0014J\"\u0010,\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u0018H\u0016J*\u0010-\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0001H\u0016J*\u0010/\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\b\u00100\u001a\u0004\u0018\u00010\u00182\u0006\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u0018H\u0002J*\u00101\u001a\u00020\u00142\u0006\u00102\u001a\u0002032\u0006\u0010\u001e\u001a\u00020\u001f2\b\u00104\u001a\u0004\u0018\u00010\u00062\u0006\u00105\u001a\u00020\u0017H\u0016J\u0018\u00101\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00106\u001a\u00020\fH\u0016J\u0018\u00101\u001a\u00020\u00142\u0006\u00107\u001a\u00020\u00172\u0006\u00106\u001a\u00020\fH\u0016J\b\u00108\u001a\u00020\u0012H\u0016J\b\u00109\u001a\u00020\u0012H\u0016J\b\u0010:\u001a\u00020\u0012H\u0016J\u0010\u0010;\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001a\u0010<\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\b\u00100\u001a\u0004\u0018\u00010\u0018H\u0016J\u0012\u0010=\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u000e\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00170#H\u0016J\b\u0010?\u001a\u00020@H\u0002J*\u0010A\u001a\u00020\u00142\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\b\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J8\u0010A\u001a\u00020\u00142\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\b\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00170IH\u0004R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/android/tools/lint/client/api/FlagConfiguration;", "Lcom/android/tools/lint/client/api/Configuration;", "configurations", "Lcom/android/tools/lint/client/api/ConfigurationHierarchy;", "(Lcom/android/tools/lint/client/api/ConfigurationHierarchy;)V", "associatedLocation", "Lcom/android/tools/lint/detector/api/Location;", "getAssociatedLocation", "()Lcom/android/tools/lint/detector/api/Location;", "setAssociatedLocation", "(Lcom/android/tools/lint/detector/api/Location;)V", "baselineFile", "Ljava/io/File;", "getBaselineFile", "()Ljava/io/File;", "setBaselineFile", "(Ljava/io/File;)V", "validated", "", "addConfiguredIssues", "", "targetMap", "", "", "Lcom/android/tools/lint/detector/api/Severity;", "registry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "specificOnly", "allowSuppress", "computeSeverity", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "source", "visibleDefault", "disabledCategories", "", "Lcom/android/tools/lint/detector/api/Category;", "disabledIds", "enabledCategories", "enabledIds", "exactCategories", "exactCheckedIds", "fatalOnly", "getDefaultSeverity", "getDefinedSeverity", "getLocalIssueConfigLocation", "severityOnly", "getVisibleSeverity", "severity", "ignore", "context", "Lcom/android/tools/lint/detector/api/Context;", "location", "message", "file", "issueId", "isCheckAllWarnings", "isIgnoreWarnings", "isWarningsAsErrors", "neverEnabledImplicitly", "setSeverity", "severityOverride", "severityOverrides", "unsupported", "", "validateIssueIds", "client", "Lcom/android/tools/lint/client/api/LintClient;", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "project", "Lcom/android/tools/lint/detector/api/Project;", "ids", "", "lint-api"})
public class FlagConfiguration
extends Configuration {
    @Nullable
    private Location associatedLocation;
    @Nullable
    private File baselineFile;
    private boolean validated;

    public FlagConfiguration(@NotNull ConfigurationHierarchy configurations) {
        Intrinsics.checkNotNullParameter((Object)configurations, (String)"configurations");
        super(configurations);
        Configuration configuration = this.getParent();
        this.baselineFile = configuration == null ? null : configuration.getBaselineFile();
    }

    @Nullable
    public final Location getAssociatedLocation() {
        return this.associatedLocation;
    }

    public final void setAssociatedLocation(@Nullable Location location) {
        this.associatedLocation = location;
    }

    public boolean fatalOnly() {
        return false;
    }

    public boolean isWarningsAsErrors() {
        return false;
    }

    public boolean isIgnoreWarnings() {
        return false;
    }

    public boolean isCheckAllWarnings() {
        return false;
    }

    public boolean allowSuppress() {
        return true;
    }

    @NotNull
    public Set<String> disabledIds() {
        return SetsKt.emptySet();
    }

    @NotNull
    public Set<String> enabledIds() {
        return SetsKt.emptySet();
    }

    @Nullable
    public Set<String> exactCheckedIds() {
        return null;
    }

    @Nullable
    public Set<Category> disabledCategories() {
        return null;
    }

    @Nullable
    public Set<Category> enabledCategories() {
        return null;
    }

    @Nullable
    public Set<Category> exactCategories() {
        return null;
    }

    @Nullable
    public Severity severityOverride(@NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        return null;
    }

    @NotNull
    public Set<String> severityOverrides() {
        return SetsKt.emptySet();
    }

    @Override
    @Nullable
    public Severity getDefinedSeverity(@NotNull Issue issue, @NotNull Configuration source, @NotNull Severity visibleDefault) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)((Object)visibleDefault), (String)"visibleDefault");
        if (issue.getSuppressNames() != null) {
            return this.getDefaultSeverity(issue, visibleDefault);
        }
        Severity severity = this.computeSeverity(issue, source, visibleDefault);
        if (this.fatalOnly()) {
            if (severity == null) {
                Severity configuredSeverity = this.getClient().getConfigurations().getDefinedSeverityWithoutOverride(source, issue, visibleDefault);
                if (configuredSeverity != null && configuredSeverity == Severity.FATAL) {
                    return configuredSeverity;
                }
                if (configuredSeverity != null) {
                    return Severity.IGNORE;
                }
                if (issue.getDefaultSeverity() != Severity.FATAL) {
                    return Severity.IGNORE;
                }
            } else if (severity != Severity.FATAL) {
                return Severity.IGNORE;
            }
        }
        if (this.fatalOnly() && (severity == null && issue.getDefaultSeverity() != Severity.FATAL || severity != null && severity != Severity.FATAL)) {
            return Severity.IGNORE;
        }
        if (this.isWarningsAsErrors() || this.isIgnoreWarnings()) {
            Severity impliedSeverity;
            Severity severity2;
            Severity severity3 = severity;
            Severity severity4 = severity3 == null ? ((severity2 = this.getConfigurations().getDefinedSeverityWithoutOverride(source, issue, visibleDefault)) == null ? this.getDefaultSeverity(issue, visibleDefault) : severity2) : (impliedSeverity = severity3);
            if (this.isWarningsAsErrors() && impliedSeverity == Severity.WARNING) {
                if (issue == IssueRegistry.BASELINE) {
                    return severity;
                }
                severity = Severity.ERROR;
            }
            if (this.isIgnoreWarnings() && impliedSeverity == Severity.WARNING) {
                severity = Severity.IGNORE;
            }
        }
        return severity;
    }

    private final Void unsupported() {
        String string = "This method should not be invoked on a synthetic (non XML) configuration";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @Override
    public void ignore(@NotNull Context context2, @NotNull Issue issue, @Nullable Location location, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.unsupported();
        throw new KotlinNothingValueException();
    }

    @Override
    public void ignore(@NotNull Issue issue, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.unsupported();
        throw new KotlinNothingValueException();
    }

    @Override
    public void ignore(@NotNull String issueId, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)issueId, (String)"issueId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.unsupported();
        throw new KotlinNothingValueException();
    }

    @Override
    public void setSeverity(@NotNull Issue issue, @Nullable Severity severity) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        this.unsupported();
        throw new KotlinNothingValueException();
    }

    @Override
    @Nullable
    public File getBaselineFile() {
        return this.baselineFile;
    }

    @Override
    public void setBaselineFile(@Nullable File file) {
        this.baselineFile = file;
    }

    @Override
    @NotNull
    protected Severity getDefaultSeverity(@NotNull Issue issue, @NotNull Severity visibleDefault) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)((Object)visibleDefault), (String)"visibleDefault");
        return this.isCheckAllWarnings() ? (this.neverEnabledImplicitly(issue) ? super.getDefaultSeverity(issue, visibleDefault) : visibleDefault) : super.getDefaultSeverity(issue, visibleDefault);
    }

    private final boolean neverEnabledImplicitly(Issue issue) {
        return Intrinsics.areEqual((Object)issue.getId(), (Object)"WrongThreadInterprocedural");
    }

    private final Severity computeSeverity(Issue issue, Configuration source, Severity visibleDefault) {
        Category category;
        if (issue.getSuppressNames() != null && !this.allowSuppress()) {
            return this.getDefaultSeverity(issue, visibleDefault);
        }
        Configuration configuration = this.getParent();
        Severity severity = configuration == null ? null : configuration.getDefinedSeverity(issue, source, visibleDefault);
        String id = issue.getId();
        Set<String> suppress = this.disabledIds();
        if (suppress.contains(id)) {
            return Severity.IGNORE;
        }
        Set<Category> disabledCategories = this.disabledCategories();
        if (disabledCategories != null && (disabledCategories.contains(category = issue.getCategory()) || category.getParent() != null && disabledCategories.contains(category.getParent()))) {
            return Severity.IGNORE;
        }
        Severity manual = this.severityOverride(issue);
        if (manual != null) {
            return manual;
        }
        Set<String> enabled = this.enabledIds();
        Set<String> exact = this.exactCheckedIds();
        Set<Category> enabledCategories = this.enabledCategories();
        Set<Category> exactCategories = this.exactCategories();
        Category category2 = issue.getCategory();
        if (exact != null) {
            if (exact.contains(id)) {
                return this.getVisibleSeverity(issue, severity, source, visibleDefault);
            }
            if (category2 != Category.LINT) {
                return Severity.IGNORE;
            }
        }
        if (exactCategories != null) {
            Set<Category> set;
            if (exactCategories.contains(category2) || category2.getParent() != null && exactCategories.contains(category2.getParent())) {
                return this.getVisibleSeverity(issue, severity, source, visibleDefault);
            }
            if (category2 != Category.LINT || Intrinsics.areEqual((Object)((set = this.disabledCategories()) == null ? null : Boolean.valueOf(set.contains(Category.LINT))), (Object)true)) {
                return Severity.IGNORE;
            }
        }
        if (enabled.contains(id) || enabledCategories != null && (enabledCategories.contains(category2) || category2.getParent() != null && enabledCategories.contains(category2.getParent())) || severity != Severity.IGNORE && this.isCheckAllWarnings() && !this.neverEnabledImplicitly(issue)) {
            return this.getVisibleSeverity(issue, severity, source, visibleDefault);
        }
        return severity;
    }

    private final Severity getVisibleSeverity(Issue issue, Severity severity, Configuration source, Severity visibleDefault) {
        Severity configuredSeverity = this.getClient().getConfigurations().getDefinedSeverityWithoutOverride(source, issue, visibleDefault);
        if (configuredSeverity != null && configuredSeverity != Severity.IGNORE) {
            if (configuredSeverity == Severity.WARNING && this.isWarningsAsErrors()) {
                return Severity.ERROR;
            }
            return configuredSeverity;
        }
        Severity visibleSeverity = severity;
        if ((visibleSeverity == null || visibleSeverity == Severity.IGNORE) && (visibleSeverity = visibleDefault) == Severity.IGNORE) {
            visibleSeverity = this.isWarningsAsErrors() ? Severity.ERROR : Severity.WARNING;
        }
        return visibleSeverity;
    }

    @Override
    public void validateIssueIds(@NotNull LintClient client, @NotNull LintDriver driver, @Nullable Project project, @NotNull IssueRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Object object = this.getParent();
        if (object != null) {
            ((Configuration)object).validateIssueIds(client, driver, project, registry);
        }
        if (this.validated) {
            return;
        }
        this.validated = true;
        this.validateIssueIds(client, driver, project, registry, (Collection<String>)this.disabledIds());
        this.validateIssueIds(client, driver, project, registry, (Collection<String>)this.enabledIds());
        this.validateIssueIds(client, driver, project, registry, (Collection<String>)this.severityOverrides());
        object = this.exactCheckedIds();
        if (object != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            this.validateIssueIds(client, driver, project, registry, (Collection)it);
        }
    }

    protected final void validateIssueIds(@NotNull LintClient client, @NotNull LintDriver driver, @Nullable Project project, @NotNull IssueRegistry registry, @NotNull Collection<String> ids) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        for (String id : ids) {
            if (Intrinsics.areEqual((Object)id, (Object)"all") || registry.getIssue(id) != null || registry.isCategoryName(id)) continue;
            this.reportNonExistingIssueId(client, driver, registry, project, id);
        }
        Configuration configuration = this.getParent();
        if (configuration != null) {
            configuration.validateIssueIds(client, driver, project, registry);
        }
    }

    @Override
    public void addConfiguredIssues(@NotNull Map<String, Severity> targetMap, @NotNull IssueRegistry registry, boolean specificOnly) {
        Intrinsics.checkNotNullParameter(targetMap, (String)"targetMap");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Configuration configuration = this.getParent();
        if (configuration != null) {
            configuration.addConfiguredIssues(targetMap, registry, specificOnly);
        }
        Set<String> suppress = this.disabledIds();
        Set<Category> disabledCategories = this.disabledCategories();
        Set<String> enabled = this.enabledIds();
        Set<String> exact = this.exactCheckedIds();
        Set<Category> enabledCategories = this.enabledCategories();
        Set<Category> exactCategories = this.exactCategories();
        for (Issue issue : registry.getIssues()) {
            boolean bl;
            Category category;
            Object object;
            Map<String, Severity> map;
            if (issue.getSuppressNames() != null && !this.allowSuppress()) continue;
            String id = issue.getId();
            if (suppress.contains(id)) {
                Map<String, Severity> map2 = targetMap;
                map = issue.getId();
                object = Severity.IGNORE;
                boolean bl2 = false;
                map2.put((String)((Object)map), (Severity)((Object)object));
                continue;
            }
            if (disabledCategories != null && (disabledCategories.contains(category = issue.getCategory()) || category.getParent() != null && disabledCategories.contains(category.getParent()))) {
                map = targetMap;
                object = issue.getId();
                Severity severity = Severity.IGNORE;
                boolean bl3 = false;
                map.put((String)object, severity);
                continue;
            }
            Severity manual = this.severityOverride(issue);
            if (manual != null) {
                map = targetMap;
                object = issue.getId();
                boolean bl4 = false;
                map.put((String)object, manual);
                continue;
            }
            Category category2 = issue.getCategory();
            if (exact != null) {
                if (exact.contains(id)) {
                    object = targetMap;
                    String string = issue.getId();
                    Severity severity = issue.getDefaultSeverity();
                    bl = false;
                    object.put(string, severity);
                    continue;
                }
                if (category2 != Category.LINT) {
                    object = targetMap;
                    String string = issue.getId();
                    Severity severity = Severity.IGNORE;
                    bl = false;
                    object.put(string, severity);
                    continue;
                }
            }
            if (exactCategories != null) {
                if (exactCategories.contains(category2) || category2.getParent() != null && exactCategories.contains(category2.getParent())) {
                    object = targetMap;
                    String string = issue.getId();
                    Severity severity = issue.getDefaultSeverity();
                    bl = false;
                    object.put(string, severity);
                    continue;
                }
                if (category2 != Category.LINT || Intrinsics.areEqual((Object)((object = this.disabledCategories()) == null ? null : Boolean.valueOf(object.contains(Category.LINT))), (Object)true)) {
                    object = targetMap;
                    String string = issue.getId();
                    Severity severity = Severity.IGNORE;
                    bl = false;
                    object.put(string, severity);
                    continue;
                }
            }
            if (enabled.contains(id) || enabledCategories != null && (enabledCategories.contains(category2) || category2.getParent() != null && enabledCategories.contains(category2.getParent()))) {
                object = targetMap;
                String string = issue.getId();
                Severity severity = issue.getDefaultSeverity();
                bl = false;
                object.put(string, severity);
            }
            if ((object = this.getOverrides()) == null) continue;
            ((Configuration)object).addConfiguredIssues(targetMap, registry, specificOnly);
        }
    }

    @Override
    @Nullable
    public Location getLocalIssueConfigLocation(@NotNull String issue, boolean specificOnly, boolean severityOnly, @NotNull Configuration source) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (this.associatedLocation != null) {
            File file;
            object = this.associatedLocation;
            File file2 = file = object == null ? null : ((Location)object).getFile();
            if (file != null) {
                return Lint.guessGradleLocationForFile(this.getConfigurations().getClient(), file, issue);
            }
        }
        Location location = (object = this.getParent()) == null ? null : ((Configuration)object).getLocalIssueConfigLocation(issue, specificOnly, severityOnly, source);
        return location == null ? this.associatedLocation : location;
    }
}

