/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.support.AndroidxNameUtils;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.LintModelModuleLibraryProject;
import com.android.tools.lint.model.LintModelAndroidLibrary;
import com.android.tools.lint.model.LintModelDependency;
import com.android.utils.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0017\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\u0006\u0010\u0015\u001a\u00020\rH\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0016J\u0012\u0010\u001a\u001a\u00020\r*\u00020\b2\u0006\u0010\u001b\u001a\u00020\u000fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/lint/detector/api/LintModelModuleAndroidLibraryProject;", "Lcom/android/tools/lint/detector/api/LintModelModuleLibraryProject;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "dir", "Ljava/io/File;", "referenceDir", "dependency", "Lcom/android/tools/lint/model/LintModelDependency;", "androidLibrary", "Lcom/android/tools/lint/model/LintModelAndroidLibrary;", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;Ljava/io/File;Lcom/android/tools/lint/model/LintModelDependency;Lcom/android/tools/lint/model/LintModelAndroidLibrary;)V", "dependsOn", "", "artifact", "", "(Ljava/lang/String;)Ljava/lang/Boolean;", "getAssetFolders", "", "getBuildLibraryModel", "getJavaLibraries", "includeProvided", "getManifestFiles", "getPartialResultsDir", "getProguardFiles", "getResourceFolders", "hasDependency", "name", "lint-api"})
@SourceDebugExtension(value={"SMAP\nLintModelModuleLibraryProject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintModelModuleLibraryProject.kt\ncom/android/tools/lint/detector/api/LintModelModuleAndroidLibraryProject\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,245:1\n1#2:246\n*E\n"})
public class LintModelModuleAndroidLibraryProject
extends LintModelModuleLibraryProject {
    @NotNull
    private final LintModelAndroidLibrary androidLibrary;

    public LintModelModuleAndroidLibraryProject(@NotNull LintClient client, @NotNull File dir, @NotNull File referenceDir, @Nullable LintModelDependency dependency, @NotNull LintModelAndroidLibrary androidLibrary) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)referenceDir, (String)"referenceDir");
        Intrinsics.checkNotNullParameter((Object)androidLibrary, (String)"androidLibrary");
        super(client, dir, referenceDir, dependency);
        this.androidLibrary = androidLibrary;
        File manifest = this.androidLibrary.getManifest();
        boolean bl = false;
        if (manifest.exists()) {
            try {
                Document document;
                String xml = FilesKt.readText$default((File)manifest, null, (int)1, null);
                Document document2 = document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
                if (document2 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"document");
                    Document it = document;
                    boolean bl2 = false;
                    this.readManifest(it);
                }
            }
            catch (IOException e) {
                Object[] objectArray = new Object[]{manifest};
                client.log(e, "Could not read manifest %1$s", objectArray);
            }
        }
    }

    @Override
    @NotNull
    public LintModelAndroidLibrary getBuildLibraryModel() {
        return this.androidLibrary;
    }

    @Override
    @NotNull
    public List<File> getManifestFiles() {
        if (this.manifestFiles == null) {
            File manifest = this.androidLibrary.getManifest();
            this.manifestFiles = manifest.exists() ? CollectionsKt.listOf((Object)manifest) : CollectionsKt.emptyList();
        }
        List list2 = this.manifestFiles;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"manifestFiles");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getProguardFiles() {
        if (this.proguardFiles == null) {
            File proguardRules = this.androidLibrary.getProguardRules();
            this.proguardFiles = proguardRules.exists() ? CollectionsKt.listOf((Object)proguardRules) : CollectionsKt.emptyList();
        }
        List list2 = this.proguardFiles;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"proguardFiles");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getResourceFolders() {
        if (this.resourceFolders == null) {
            File folder = this.androidLibrary.getResFolder();
            this.resourceFolders = folder.exists() ? CollectionsKt.listOf((Object)folder) : CollectionsKt.emptyList();
        }
        List list2 = this.resourceFolders;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"resourceFolders");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getAssetFolders() {
        if (this.assetFolders == null) {
            File folder = this.androidLibrary.getAssetsFolder();
            this.assetFolders = folder.exists() ? CollectionsKt.listOf((Object)folder) : CollectionsKt.emptyList();
        }
        List list2 = this.assetFolders;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"assetFolders");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getJavaLibraries(boolean includeProvided) {
        List list2;
        if (!includeProvided && this.androidLibrary.getProvided()) {
            return CollectionsKt.emptyList();
        }
        List list3 = this.javaLibraries;
        if (list3 == null) {
            LintModelModuleAndroidLibraryProject $this$getJavaLibraries_u24lambda_u242 = this;
            boolean bl = false;
            ArrayList<File> list4 = new ArrayList<File>($this$getJavaLibraries_u24lambda_u242.androidLibrary.getJarFiles().size());
            for (File file : $this$getJavaLibraries_u24lambda_u242.androidLibrary.getJarFiles()) {
                if (!file.exists()) continue;
                list4.add(file);
            }
            $this$getJavaLibraries_u24lambda_u242.javaLibraries = list4;
            list2 = list4;
        } else {
            list2 = list3;
        }
        return list2;
    }

    public final boolean hasDependency(@NotNull LintModelDependency $this$hasDependency, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$hasDependency, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (Intrinsics.areEqual((Object)$this$hasDependency.getArtifactName(), (Object)name)) {
            return true;
        }
        for (LintModelDependency dependency : $this$hasDependency.getDependencies()) {
            if (!this.hasDependency(dependency, name)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Boolean dependsOn(@NotNull String artifact) {
        block6: {
            block7: {
                block8: {
                    block4: {
                        block5: {
                            Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
                            var3_3 = id = AndroidxNameUtils.getCoordinateMapping((String)artifact);
                            if (!Intrinsics.areEqual((Object)var3_3, (Object)"androidx.appcompat:appcompat")) break block4;
                            if (this.appCompat != null) break block5;
                            v0 = this.getDependency();
                            if (v0 != null ? this.hasDependency(v0, "androidx.appcompat:appcompat") : false) ** GOTO lbl-1000
                            v1 = this.getDependency();
                            v2 = v1 != null ? this.hasDependency(v1, "com.android.support:appcompat-v7") : false;
                            if (v2) lbl-1000:
                            // 2 sources

                            {
                                v3 = true;
                            } else {
                                v3 = false;
                            }
                            this.appCompat = v3;
                        }
                        v4 = this.appCompat;
                        break block6;
                    }
                    if (!Intrinsics.areEqual((Object)var3_3, (Object)"androidx.leanback:leanback")) break block7;
                    if (this.leanback != null) break block8;
                    v5 = this.getDependency();
                    if (v5 != null ? this.hasDependency(v5, "androidx.leanback:leanback") : false) ** GOTO lbl-1000
                    v6 = this.getDependency();
                    v7 = v6 != null ? this.hasDependency(v6, "com.android.support:leanback-v17") : false;
                    if (v7) lbl-1000:
                    // 2 sources

                    {
                        v8 = true;
                    } else {
                        v8 = false;
                    }
                    this.leanback = v8;
                }
                v4 = this.leanback;
                break block6;
            }
            v9 = this.getDependency();
            v4 = (v9 != null ? this.hasDependency(v9, artifact) : false) != false ? Boolean.valueOf(true) : super.dependsOn(id);
        }
        return v4;
    }

    @Override
    @Nullable
    public File getPartialResultsDir() {
        File file = this.androidLibrary.getPartialResultsDir();
        if (file == null) {
            file = super.getPartialResultsDir();
        }
        return file;
    }
}

