/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.ClassScanner;
import com.android.tools.lint.detector.api.Detector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

class AsmVisitor {
    private static final int TYPE_COUNT = 16;
    private final Map<String, List<ClassScanner>> methodNameToChecks = new HashMap<String, List<ClassScanner>>();
    private final Map<String, List<ClassScanner>> methodOwnerToChecks = new HashMap<String, List<ClassScanner>>();
    private final List<Detector> fullClassChecks = new ArrayList<Detector>();
    private final List<? extends Detector> allDetectors;
    private List<ClassScanner>[] nodeTypeDetectors;

    AsmVisitor(LintClient client, List<? extends Detector> classDetectors) {
        this.allDetectors = classDetectors;
        for (Detector detector : classDetectors) {
            int[] nArray;
            List<String> owners;
            ClassScanner scanner = (ClassScanner)((Object)detector);
            boolean checkFullClass = true;
            List<String> names = scanner.getApplicableCallNames();
            if (names != null) {
                checkFullClass = false;
                for (String string : names) {
                    List<ClassScanner> list2 = this.methodNameToChecks.get(string);
                    if (list2 == null) {
                        list2 = new ArrayList<ClassScanner>();
                        this.methodNameToChecks.put(string, list2);
                    }
                    list2.add(scanner);
                }
            }
            if ((owners = scanner.getApplicableCallOwners()) != null) {
                checkFullClass = false;
                for (String element2 : owners) {
                    List<ClassScanner> list3 = this.methodOwnerToChecks.get(element2);
                    if (list3 == null) {
                        list3 = new ArrayList<ClassScanner>();
                        this.methodOwnerToChecks.put(element2, list3);
                    }
                    list3.add(scanner);
                }
            }
            if ((nArray = scanner.getApplicableAsmNodeTypes()) != null) {
                checkFullClass = false;
                for (int type : nArray) {
                    List<ClassScanner> checks;
                    if (type < 0 || type >= 16) {
                        client.log(null, "Out of range node type %1$d from detector %2$s", type, scanner);
                        continue;
                    }
                    if (this.nodeTypeDetectors == null) {
                        this.nodeTypeDetectors = new List[16];
                    }
                    if ((checks = this.nodeTypeDetectors[type]) == null) {
                        this.nodeTypeDetectors[type] = checks = new ArrayList<ClassScanner>();
                    }
                    checks.add(scanner);
                }
            }
            if (!checkFullClass) continue;
            this.fullClassChecks.add(detector);
        }
    }

    void runClassDetectors(ClassContext context2) {
        ClassNode classNode = context2.getClassNode();
        for (Detector detector : this.allDetectors) {
            detector.beforeCheckFile(context2);
        }
        for (Detector detector : this.fullClassChecks) {
            ClassScanner scanner = (ClassScanner)((Object)detector);
            scanner.checkClass(context2, classNode);
            detector.afterCheckFile(context2);
        }
        if (!this.methodNameToChecks.isEmpty() || !this.methodOwnerToChecks.isEmpty() || this.nodeTypeDetectors != null && this.nodeTypeDetectors.length > 0) {
            List methodList = classNode.methods;
            for (Object m : methodList) {
                MethodNode method = (MethodNode)m;
                InsnList nodes = method.instructions;
                int n = nodes.size();
                for (int i = 0; i < n; ++i) {
                    List<ClassScanner> scanners;
                    AbstractInsnNode instruction = nodes.get(i);
                    int type = instruction.getType();
                    if (type == 5) {
                        String name;
                        MethodInsnNode call = (MethodInsnNode)instruction;
                        String owner = call.owner;
                        List<ClassScanner> scanners2 = this.methodOwnerToChecks.get(owner);
                        if (scanners2 != null) {
                            for (ClassScanner scanner : scanners2) {
                                scanner.checkCall(context2, classNode, method, call);
                            }
                        }
                        if ((scanners2 = this.methodNameToChecks.get(name = call.name)) != null) {
                            for (ClassScanner scanner : scanners2) {
                                scanner.checkCall(context2, classNode, method, call);
                            }
                        }
                    }
                    if (this.nodeTypeDetectors == null || type >= this.nodeTypeDetectors.length || (scanners = this.nodeTypeDetectors[type]) == null) continue;
                    for (ClassScanner scanner : scanners) {
                        scanner.checkInstruction(context2, classNode, method, instruction);
                    }
                }
            }
        }
        for (Detector detector : this.allDetectors) {
            detector.afterCheckFile(context2);
        }
    }
}

