/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.model;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.model.DefaultLintModelSourceProvider;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelSerialization;
import com.android.tools.lint.model.LintModelSourceProvider;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010H\u0004J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010H\u0004J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001c2\u0006\u0010\u0019\u001a\u00020\u0010H\u0004J\b\u0010\u001d\u001a\u00020\u0010H\u0004J\b\u0010\u001e\u001a\u00020\u0010H\u0004J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0019\u001a\u00020\u0010H\u0004J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020!H\u0004J\u001e\u0010$\u001a\u0004\u0018\u00010\u00052\u0006\u0010\"\u001a\u00020\u00102\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u0005H\u0004J\u0012\u0010&\u001a\u0004\u0018\u00010\u00052\u0006\u0010\"\u001a\u00020\u0010H\u0004J\u0010\u0010'\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0010H\u0004J\u001c\u0010(\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00102\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u0005H\u0004J \u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100\u001c2\u0006\u0010\u0019\u001a\u00020\u00102\b\b\u0002\u0010*\u001a\u00020\u0010H\u0004J\b\u0010+\u001a\u00020\u0018H\u0004J\u0012\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020\u0010H\u0004J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020-0\u001c2\u0006\u0010.\u001a\u00020\u0010H\u0004J\b\u00100\u001a\u00020\u0018H\u0004J\f\u00101\u001a\u00020!*\u00020\u0010H\u0002J\f\u00102\u001a\u000203*\u00020\u0010H\u0004J\u000e\u00104\u001a\u0004\u0018\u000105*\u00020\u0010H\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u00066"}, d2={"Lcom/android/tools/lint/model/LintModelReader;", "", "adapter", "Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;", "root", "Ljava/io/File;", "reader", "Ljava/io/Reader;", "(Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;Ljava/io/File;Ljava/io/Reader;)V", "getAdapter", "()Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;", "parser", "Lorg/kxml2/io/KXmlParser;", "getParser", "()Lorg/kxml2/io/KXmlParser;", "path", "", "getPath", "()Ljava/lang/String;", "getRoot", "()Ljava/io/File;", "setRoot", "(Ljava/io/File;)V", "expectTag", "", "name", "finishTag", "getFiles", "", "getLocation", "getName", "getOptionalAttribute", "getOptionalBoolean", "", "attribute", "default", "getOptionalFile", "relativeTo", "getOptionalOutputFile", "getRequiredAttribute", "getRequiredFile", "getStrings", "separator", "missingData", "readSourceProvider", "Lcom/android/tools/lint/model/LintModelSourceProvider;", "tag", "readSourceProviders", "unexpectedTag", "isNumber", "toApiVersion", "Lcom/android/sdklib/AndroidVersion;", "toMavenCoordinate", "Lcom/android/tools/lint/model/LintModelMavenName;", "lint-model"})
@SourceDebugExtension(value={"SMAP\nLintModelSerialization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintModelSerialization.kt\ncom/android/tools/lint/model/LintModelReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,2005:1\n1549#2:2006\n1620#2,3:2007\n*S KotlinDebug\n*F\n+ 1 LintModelSerialization.kt\ncom/android/tools/lint/model/LintModelReader\n*L\n1162#1:2006\n1162#1:2007,3\n*E\n"})
abstract class LintModelReader {
    @NotNull
    private final LintModelSerialization.LintModelSerializationAdapter adapter;
    @Nullable
    private File root;
    @NotNull
    private final KXmlParser parser;

    public LintModelReader(@NotNull LintModelSerialization.LintModelSerializationAdapter adapter, @Nullable File root, @NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.adapter = adapter;
        this.root = root;
        this.parser = new KXmlParser();
        this.parser.setInput(reader);
    }

    @NotNull
    protected final LintModelSerialization.LintModelSerializationAdapter getAdapter() {
        return this.adapter;
    }

    @Nullable
    protected final File getRoot() {
        return this.root;
    }

    protected final void setRoot(@Nullable File file) {
        this.root = file;
    }

    @NotNull
    protected abstract String getPath();

    @NotNull
    protected final KXmlParser getParser() {
        return this.parser;
    }

    private final boolean isNumber(String $this$isNumber) {
        return Character.isDigit(StringsKt.first((CharSequence)$this$isNumber));
    }

    @NotNull
    protected final AndroidVersion toApiVersion(@NotNull String $this$toApiVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$toApiVersion, (String)"<this>");
        if (!this.isNumber($this$toApiVersion)) {
            File file = this.adapter.getPathVariables().get("ANDROID_HOME");
            if (file != null) {
                int levelBegin;
                int levelEnd;
                String descriptor;
                int begin;
                File home = file;
                boolean bl = false;
                File descriptorFile = new File(home, "platforms" + File.separator + "android-" + $this$toApiVersion + File.separator + "package.xml");
                if (descriptorFile.isFile() && (begin = StringsKt.indexOf$default((CharSequence)(descriptor = FilesKt.readText$default((File)descriptorFile, null, (int)1, null)), (String)"<api-level>", (int)0, (boolean)false, (int)6, null)) != -1 && (levelEnd = StringsKt.indexOf$default((CharSequence)descriptor, (String)"</api-level>", (int)(levelBegin = StringsKt.indexOf$default((CharSequence)descriptor, (char)'>', (int)begin, (boolean)false, (int)4, null) + 1), (boolean)false, (int)4, null)) != -1) {
                    try {
                        String string = descriptor.substring(levelBegin, levelEnd);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        int apiLevel = Integer.parseInt(((Object)StringsKt.trim((CharSequence)string)).toString());
                        return new AndroidVersion(apiLevel, $this$toApiVersion);
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                }
            }
            String buildCode = SdkVersionInfo.getBuildCode((int)34);
            if (buildCode != null) {
                int delta = Character.toUpperCase(StringsKt.first((CharSequence)$this$toApiVersion)) - Character.toUpperCase(StringsKt.first((CharSequence)buildCode));
                boolean bl = 0 <= delta ? delta < 5 : false;
                if (bl) {
                    return new AndroidVersion(34 + delta - 1, $this$toApiVersion);
                }
            }
        }
        return new AndroidVersion($this$toApiVersion);
    }

    @Nullable
    protected final LintModelMavenName toMavenCoordinate(@NotNull String $this$toMavenCoordinate) {
        Intrinsics.checkNotNullParameter((Object)$this$toMavenCoordinate, (String)"<this>");
        return LintModelMavenName.Companion.parse($this$toMavenCoordinate);
    }

    @NotNull
    protected final String getLocation() {
        return this.getPath() + ":" + this.parser.getLineNumber();
    }

    protected final void expectTag(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!Intrinsics.areEqual((Object)name, (Object)this.parser.getName())) {
            throw new IllegalStateException(("Unexpected tag `<" + this.parser.getName() + ">` at " + this.getLocation() + "; expected `<" + name + ">`").toString());
        }
    }

    protected final void unexpectedTag() {
        throw new IllegalStateException(("Unexpected tag `<" + this.parser.getName() + ">` at " + this.getLocation()).toString());
    }

    protected final void missingData() {
        throw new IllegalStateException(("Missing data at " + this.getLocation()).toString());
    }

    protected final void finishTag(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        block4: while (this.parser.next() != 1) {
            int eventType = this.parser.getEventType();
            switch (eventType) {
                case 2: {
                    this.unexpectedTag();
                    continue block4;
                }
                case 3: {
                    this.expectTag(name);
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
    }

    @Nullable
    protected final String getOptionalAttribute(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.parser.getAttributeValue(null, name);
    }

    @NotNull
    protected final String getRequiredAttribute(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = this.parser.getAttributeValue(null, name);
        if (string == null) {
            throw new IllegalStateException(("Expected `" + name + "` attribute in <" + this.parser.getName() + "> tag at " + this.getLocation()).toString());
        }
        return string;
    }

    @NotNull
    protected final String getName() {
        return this.getRequiredAttribute("name");
    }

    @Nullable
    protected final File getOptionalFile(@NotNull String attribute, @Nullable File relativeTo) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        String string = this.getOptionalAttribute(attribute);
        if (string == null) {
            return null;
        }
        String path = string;
        return this.adapter.fromPathString(path, relativeTo);
    }

    public static /* synthetic */ File getOptionalFile$default(LintModelReader lintModelReader, String string, File file, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getOptionalFile");
        }
        if ((n & 2) != 0) {
            file = lintModelReader.root;
        }
        return lintModelReader.getOptionalFile(string, file);
    }

    @Nullable
    protected final File getOptionalOutputFile(@NotNull String attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        String string = this.getOptionalAttribute(attribute);
        if (string == null) {
            return null;
        }
        String path = string;
        File relativeTo = Intrinsics.areEqual((Object)path, (Object)"stderr") || Intrinsics.areEqual((Object)path, (Object)"stdout") ? null : this.root;
        return this.adapter.fromPathString(path, relativeTo);
    }

    @NotNull
    protected final File getRequiredFile(@NotNull String attribute, @Nullable File relativeTo) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        String path = this.getRequiredAttribute(attribute);
        return this.adapter.fromPathString(path, relativeTo);
    }

    public static /* synthetic */ File getRequiredFile$default(LintModelReader lintModelReader, String string, File file, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getRequiredFile");
        }
        if ((n & 2) != 0) {
            file = lintModelReader.root;
        }
        return lintModelReader.getRequiredFile(string, file);
    }

    protected final boolean getOptionalBoolean(@NotNull String attribute, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        String string = this.getOptionalAttribute(attribute);
        if (string == null) {
            return bl;
        }
        String value = string;
        return Intrinsics.areEqual((Object)value, (Object)"true");
    }

    @NotNull
    protected final List<String> getStrings(@NotNull String name, @NotNull String separator) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Object object = this.getOptionalAttribute(name);
        if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{separator}), (boolean)false, (int)0, (int)6, null)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public static /* synthetic */ List getStrings$default(LintModelReader lintModelReader, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getStrings");
        }
        if ((n & 2) != 0) {
            string2 = ",";
        }
        return lintModelReader.getStrings(string, string2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    protected final List<File> getFiles(@NotNull String name) {
        void $this$mapTo$iv$iv;
        List list;
        Object object;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                object = this.getOptionalAttribute(name);
                if (object == null) break block5;
                CharSequence charSequence = (CharSequence)object;
                String[] stringArray = new String[1];
                Intrinsics.checkNotNullExpressionValue((Object)File.pathSeparator, (String)"pathSeparator");
                object = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                if (object != null) break block6;
            }
            list = CollectionsKt.emptyList();
            return list;
        }
        Iterable $this$map$iv = (Iterable)object;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (true) {
            void path;
            if (!iterator.hasNext()) {
                list = (List)destination$iv$iv;
                return list;
            }
            Object item$iv$iv = iterator.next();
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = new File((String)path);
            collection.add(this.root != null && !file.isAbsolute() ? new File(this.root, (String)path) : file);
        }
    }

    @NotNull
    protected final LintModelSourceProvider readSourceProvider(@NotNull String tag) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.expectTag(tag);
        Collection collection2 = this.getFiles("manifests");
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = CollectionsKt.listOfNotNull((Object)LintModelReader.getOptionalFile$default(this, "manifest", null, 2, null));
        } else {
            collection = collection2;
        }
        List manifestFiles = (List)collection;
        List<File> javaDirectories = this.getFiles("javaDirectories");
        List<File> resDirectories = this.getFiles("resDirectories");
        List<File> assetsDirectories = this.getFiles("assetsDirectories");
        boolean androidTestOnly = this.getOptionalBoolean("androidTest", false);
        boolean unitTestOnly = this.getOptionalBoolean("unitTest", false);
        boolean debugOnly = this.getOptionalBoolean("debugOnly", false);
        boolean testFixture = this.getOptionalBoolean("testFixture", false);
        this.finishTag(tag);
        return new DefaultLintModelSourceProvider(manifestFiles, (Collection<? extends File>)javaDirectories, (Collection<? extends File>)resDirectories, (Collection<? extends File>)assetsDirectories, debugOnly, unitTestOnly, androidTestOnly, testFixture);
    }

    public static /* synthetic */ LintModelSourceProvider readSourceProvider$default(LintModelReader lintModelReader, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readSourceProvider");
        }
        if ((n & 1) != 0) {
            string = "sourceProvider";
        }
        return lintModelReader.readSourceProvider(string);
    }

    @NotNull
    protected final List<LintModelSourceProvider> readSourceProviders(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.expectTag(tag);
        List sourceProviders = new ArrayList();
        block4: while (this.parser.next() != 1) {
            int eventType = this.parser.getEventType();
            switch (eventType) {
                case 2: {
                    if (Intrinsics.areEqual((Object)this.parser.getName(), (Object)"sourceProvider")) {
                        sourceProviders.add(LintModelReader.readSourceProvider$default(this, null, 1, null));
                        continue block4;
                    }
                    this.unexpectedTag();
                    continue block4;
                }
                case 3: {
                    this.expectTag(tag);
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        return sourceProviders;
    }
}

