/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.android.ide.common.resources.FileResourceNameValidator;
import com.android.ide.common.resources.MergingException;
import com.android.ide.common.symbols.IdProvider;
import com.android.ide.common.symbols.ResourceDirectoryParseException;
import com.android.ide.common.symbols.ResourceExtraXmlParser;
import com.android.ide.common.symbols.ResourceValuesXmlParser;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolTable;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.utils.SdkUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import java.io.File;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u001a2\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u001a \u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a8\u0006\u0014"}, d2={"addIfNotExisting", "", "builder", "Lcom/android/ide/common/symbols/SymbolTable$Builder;", "symbol", "Lcom/android/ide/common/symbols/Symbol;", "getNameWithoutExtensions", "", "filename", "parseResourceDirectory", "resourceDirectory", "Ljava/io/File;", "idProvider", "Lcom/android/ide/common/symbols/IdProvider;", "documentBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "platformAttrSymbols", "Lcom/android/ide/common/symbols/SymbolTable;", "parseResourceSourceSetDirectory", "directory", "sdk-common"})
@JvmName(name="ResourceDirectoryParser")
public final class ResourceDirectoryParser {
    @NotNull
    public static final SymbolTable parseResourceSourceSetDirectory(@NotNull File directory, @NotNull IdProvider idProvider, @Nullable SymbolTable platformAttrSymbols) {
        Object[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)idProvider, (String)"idProvider");
        Preconditions.checkArgument((boolean)directory.isDirectory(), (String)"!directory.isDirectory()", (Object[])new Object[0]);
        SymbolTable.Builder builder = SymbolTable.Companion.builder();
        File[] fileArray = directory.listFiles();
        if (fileArray == null) {
            Intrinsics.throwNpe();
        }
        Object[] objectArray = $receiver$iv = (Object[])fileArray;
        Object object = new Comparator<T>(){

            public final int compare(T a, T b) {
                File it;
                File file = it = (File)a;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                it = (File)b;
                Comparable comparable = (Comparable)((Object)file.getName());
                File file2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it");
                String string = file2.getName();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
            }
        };
        List resourceDirectories = ArraysKt.sortedWith((Object[])objectArray, (Comparator)object);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            object = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw (Throwable)new ResourceDirectoryParseException("Failed to instantiate DOM parser", e);
        }
        Object documentBuilder = object;
        Iterator iterator = resourceDirectories.iterator();
        while (iterator.hasNext()) {
            File resourceDirectory;
            File file = resourceDirectory = (File)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"resourceDirectory");
            if (!file.isDirectory()) {
                throw (Throwable)new ResourceDirectoryParseException('\'' + resourceDirectory.getAbsolutePath() + "' is not a directory");
            }
            Object object2 = documentBuilder;
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"documentBuilder");
            ResourceDirectoryParser.parseResourceDirectory(resourceDirectory, builder, idProvider, (DocumentBuilder)object2, platformAttrSymbols);
        }
        return builder.build();
    }

    private static final void parseResourceDirectory(File resourceDirectory, SymbolTable.Builder builder, IdProvider idProvider, DocumentBuilder documentBuilder, SymbolTable platformAttrSymbols) {
        boolean bl = resourceDirectory.isDirectory();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        String directoryName = resourceDirectory.getName();
        ResourceFolderType folderResourceType = ResourceFolderType.getFolderType((String)directoryName);
        File[] fileArray = resourceDirectory.listFiles();
        if (fileArray == null) {
            Intrinsics.throwNpe();
        }
        Object[] $receiver$iv = fileArray;
        Object object = $receiver$iv;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                File it;
                File file = it = (File)a;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                it = (File)b;
                Comparable comparable = (Comparable)((Object)file.getName());
                File file2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it");
                String string = file2.getName();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
            }
        };
        List resourceFiles = ArraysKt.sortedWith((Object[])object, (Comparator)comparator);
        object = resourceFiles.iterator();
        while (object.hasNext()) {
            Object domTree;
            ResourceType resourceType;
            String fileName;
            Object element$iv2;
            File maybeResourceFile;
            File file = maybeResourceFile = (File)object.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"maybeResourceFile");
            if (file.isDirectory()) continue;
            if (!maybeResourceFile.isFile()) {
                throw (Throwable)new ResourceDirectoryParseException('\'' + maybeResourceFile.getAbsolutePath() + "' is not a file nor directory");
            }
            if (Intrinsics.areEqual((Object)folderResourceType, (Object)ResourceFolderType.VALUES)) {
                try {
                    Document domTree2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)documentBuilder.parse(maybeResourceFile), (String)"documentBuilder.parse(maybeResourceFile)");
                    SymbolTable parsedXml = ResourceValuesXmlParser.parseValuesResource(domTree2, idProvider, platformAttrSymbols);
                    ImmutableCollection immutableCollection = parsedXml.getSymbols().values();
                    Intrinsics.checkExpressionValueIsNotNull((Object)immutableCollection, (String)"parsedXml.symbols.values()");
                    Iterable $receiver$iv2 = (Iterable)immutableCollection;
                    for (Object element$iv2 : $receiver$iv2) {
                        Symbol s;
                        Symbol symbol = s = (Symbol)element$iv2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)symbol, (String)"s");
                        ResourceDirectoryParser.addIfNotExisting(builder, symbol);
                    }
                    continue;
                }
                catch (Exception e) {
                    throw (Throwable)new ResourceDirectoryParseException("Failed to parse XML resource file '" + maybeResourceFile.getAbsolutePath() + '\'', e);
                }
            }
            try {
                ResourceFolderType resourceFolderType = folderResourceType;
                if (resourceFolderType == null) {
                    Intrinsics.throwNpe();
                }
                FileResourceNameValidator.validate(maybeResourceFile, resourceFolderType);
            }
            catch (MergingException e) {
                throw (Throwable)new ResourceDirectoryParseException("Failed file name validation for file " + maybeResourceFile.getAbsolutePath(), e);
            }
            String string = fileName = maybeResourceFile.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileName");
            String symbolName = ResourceDirectoryParser.getNameWithoutExtensions(string);
            ResourceType resourceType2 = resourceType = FolderTypeRelationship.getNonIdRelatedResourceType((ResourceFolderType)folderResourceType);
            Intrinsics.checkExpressionValueIsNotNull((Object)resourceType2, (String)"resourceType");
            ResourceDirectoryParser.addIfNotExisting(builder, Symbol.Companion.createAndValidateSymbol(resourceType2, symbolName, idProvider));
            if (!FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderResourceType) || !SdkUtils.endsWithIgnoreCase((String)fileName, (String)".xml")) continue;
            try {
                element$iv2 = documentBuilder.parse(maybeResourceFile);
            }
            catch (Exception e) {
                throw (Throwable)new ResourceDirectoryParseException("Failed to parse XML file '" + maybeResourceFile.getAbsolutePath() + '\'', e);
            }
            Object object2 = domTree = element$iv2;
            Intrinsics.checkExpressionValueIsNotNull(object2, (String)"domTree");
            SymbolTable extraSymbols = ResourceExtraXmlParser.parseResourceForInlineResources(object2, idProvider);
            ImmutableCollection immutableCollection = extraSymbols.getSymbols().values();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableCollection, (String)"extraSymbols.symbols.values()");
            Iterable $receiver$iv3 = (Iterable)immutableCollection;
            for (Object element$iv3 : $receiver$iv3) {
                Symbol s;
                Symbol symbol = s = (Symbol)element$iv3;
                Intrinsics.checkExpressionValueIsNotNull((Object)symbol, (String)"s");
                ResourceDirectoryParser.addIfNotExisting(builder, symbol);
            }
        }
    }

    private static final String getNameWithoutExtensions(String filename) {
        String string;
        int dotIndex = StringsKt.indexOf$default((CharSequence)filename, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (dotIndex > 0) {
            String string2 = filename;
            int n = 0;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, dotIndex);
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = filename;
        }
        return string;
    }

    private static final void addIfNotExisting(SymbolTable.Builder builder, Symbol symbol) {
        if (!builder.contains(symbol)) {
            builder.add(symbol);
        }
    }
}

