/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.VdPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PathParser {
    private static final float[] EMPTY_FLOAT_ARRAY = new float[0];

    private PathParser() {
    }

    private static void extract(String s, int start, ExtractFloatResult result) {
        int currentIndex;
        boolean foundSeparator = false;
        result.mEndWithNegOrDot = false;
        boolean secondDot = false;
        boolean isExponential = false;
        for (currentIndex = start; currentIndex < s.length(); ++currentIndex) {
            boolean isPrevExponential = isExponential;
            isExponential = false;
            char currentChar = s.charAt(currentIndex);
            switch (currentChar) {
                case ' ': 
                case ',': {
                    foundSeparator = true;
                    break;
                }
                case '-': {
                    if (currentIndex == start || isPrevExponential) break;
                    foundSeparator = true;
                    result.mEndWithNegOrDot = true;
                    break;
                }
                case '.': {
                    if (!secondDot) {
                        secondDot = true;
                        break;
                    }
                    foundSeparator = true;
                    result.mEndWithNegOrDot = true;
                    break;
                }
                case 'E': 
                case 'e': {
                    isExponential = true;
                }
            }
            if (foundSeparator) break;
        }
        result.mEndPosition = currentIndex;
    }

    private static float[] getFloats(String s) {
        if (s.charAt(0) == 'z' || s.charAt(0) == 'Z') {
            return EMPTY_FLOAT_ARRAY;
        }
        try {
            float[] results = new float[s.length()];
            int count = 0;
            int startPosition = 1;
            ExtractFloatResult result = new ExtractFloatResult();
            int totalLength = s.length();
            while (startPosition < totalLength) {
                PathParser.extract(s, startPosition, result);
                int endPosition = result.mEndPosition;
                if (startPosition < endPosition) {
                    results[count++] = Float.parseFloat(s.substring(startPosition, endPosition));
                }
                if (result.mEndWithNegOrDot) {
                    startPosition = endPosition;
                    continue;
                }
                startPosition = endPosition + 1;
            }
            return Arrays.copyOfRange(results, 0, count);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Error in parsing \"" + s + "\"", e);
        }
    }

    private static void addNode(List<VdPath.Node> list, char cmd, float[] val) {
        list.add(new VdPath.Node(cmd, val));
    }

    private static int nextStart(String s, int end) {
        while (end < s.length()) {
            char c = s.charAt(end);
            if (((c - 65) * (c - 90) <= 0 || (c - 97) * (c - 122) <= 0) && c != 'e' && c != 'E') {
                return end;
            }
            ++end;
        }
        return end;
    }

    public static VdPath.Node[] parsePath(String value) {
        value = value.trim();
        ArrayList<VdPath.Node> list = new ArrayList<VdPath.Node>();
        int start = 0;
        int end = 1;
        while (end < value.length()) {
            end = PathParser.nextStart(value, end);
            String s = value.substring(start, end);
            float[] val = PathParser.getFloats(s);
            char currentCommand = s.charAt(0);
            if (start == 0 && currentCommand != 'M' && currentCommand != 'm') {
                PathParser.addNode(list, 'M', new float[2]);
            }
            PathParser.addNode(list, currentCommand, val);
            start = end++;
        }
        if (end - start == 1 && start < value.length()) {
            PathParser.addNode(list, value.charAt(start), EMPTY_FLOAT_ARRAY);
        }
        return list.toArray(new VdPath.Node[list.size()]);
    }

    private static class ExtractFloatResult {
        private int mEndPosition;
        private boolean mEndWithNegOrDot;

        private ExtractFloatResult() {
        }
    }
}

