/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceTable;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.resources.ResourceType;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public abstract class AbstractResourceRepository
implements ResourceRepository {
    public static final Object ITEM_MAP_LOCK = new Object();

    protected abstract ResourceTable getFullTable();

    protected abstract ListMultimap<String, ResourceItem> getMap(ResourceNamespace var1, ResourceType var2, boolean var3);

    protected final ListMultimap<String, ResourceItem> getMap(ResourceNamespace namespace, ResourceType type) {
        return this.getMap(namespace, type, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ResourceItem> getResources(ResourceNamespace namespace, ResourceType resourceType, String resourceName) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap<String, ResourceItem> map = this.getMap(namespace, resourceType, false);
            if (map != null) {
                return map.get((Object)resourceName);
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ResourceItem> getResources(ResourceNamespace namespace, ResourceType resourceType, Predicate<ResourceItem> filter2) {
        ArrayList<ResourceItem> result2 = null;
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap<String, ResourceItem> map = this.getMap(namespace, resourceType, false);
            if (map != null) {
                for (ResourceItem item : map.values()) {
                    if (!filter2.test(item)) continue;
                    if (result2 == null) {
                        result2 = new ArrayList<ResourceItem>();
                    }
                    result2.add(item);
                }
            }
        }
        return result2 == null ? Collections.emptyList() : result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMultimap<String, ResourceItem> getResources(ResourceNamespace namespace, ResourceType resourceType) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap<String, ResourceItem> map = this.getMap(namespace, resourceType, false);
            return map == null ? ImmutableListMultimap.of() : ImmutableListMultimap.copyOf(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(ResourceVisitor visitor) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (Map.Entry namespaceEntry : this.getFullTable().rowMap().entrySet()) {
                if (!visitor.shouldVisitNamespace((ResourceNamespace)namespaceEntry.getKey())) continue;
                for (Map.Entry typeEntry : ((Map)namespaceEntry.getValue()).entrySet()) {
                    if (!visitor.shouldVisitResourceType((ResourceType)typeEntry.getKey())) continue;
                    for (ResourceItem item : ((ListMultimap)typeEntry.getValue()).values()) {
                        if (visitor.visit(item) != ResourceVisitor.VisitResult.ABORT) continue;
                        return;
                    }
                }
            }
        }
    }

    @Override
    public Collection<ResourceItem> getPublicResources(ResourceNamespace namespace, ResourceType type) {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasResources(ResourceNamespace namespace, ResourceType resourceType, String resourceName) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap<String, ResourceItem> map = this.getMap(namespace, resourceType, false);
            if (map != null) {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl6 : MonitorExitStatement: MONITOREXIT : var4_4
                List itemList = map.get((Object)resourceName);
                return itemList != null && !itemList.isEmpty();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasResources(ResourceNamespace namespace, ResourceType resourceType) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap<String, ResourceItem> map = this.getMap(namespace, resourceType, false);
            if (map != null && !map.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ResourceType> getResourceTypes(ResourceNamespace namespace) {
        EnumSet<ResourceType> result2 = EnumSet.noneOf(ResourceType.class);
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (ResourceType resourceType : ResourceType.values()) {
                if (!this.hasResources(namespace, resourceType)) continue;
                result2.add(resourceType);
            }
        }
        return Sets.immutableEnumSet(result2);
    }
}

