/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.blame.Message;
import com.android.ide.common.resources.DataFile;
import com.android.ide.common.resources.DataItem;
import com.android.ide.common.resources.DataMap;
import com.android.ide.common.resources.DuplicateDataException;
import com.android.ide.common.resources.FileStatus;
import com.android.ide.common.resources.MergeConsumer;
import com.android.ide.common.resources.MergingException;
import com.android.ide.common.resources.NodeUtils;
import com.android.ide.common.resources.SourceSet;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class DataSet<I extends DataItem<F>, F extends DataFile<I>>
implements SourceSet,
DataMap<I> {
    static final String NODE_SOURCE = "source";
    static final String NODE_FILE = "file";
    static final String ATTR_CONFIG = "config";
    static final String ATTR_PATH = "path";
    static final String ATTR_NAME = "name";
    static final String ATTR_TIMESTAMP = "timestamp";
    static final String ATTR_IGNORE_PATTERN = "ignore_pattern";
    private final String mConfigName;
    private final boolean mValidateEnabled;
    private final List<File> mSourceFiles = new ArrayList<File>();
    private final ListMultimap<String, I> mItems = LinkedListMultimap.create();
    private final ListMultimap<File, F> mSourceFileToDataFilesMap = ArrayListMultimap.create();
    private final Map<File, F> mDataFileMap = new HashMap<File, F>();
    private Iterable<String> sIgnoredPatterns;

    public DataSet(String configName, boolean validateEnabled) {
        String patterns = System.getenv("ANDROID_AAPT_IGNORE");
        if (patterns == null || patterns.isEmpty()) {
            patterns = "!.svn:!.git:!.ds_store:!*.scc:.*:<dir>_*:!CVS:!thumbs.db:!picasa.ini:!*~";
        }
        this.setIgnoredPatterns(patterns);
        this.mConfigName = configName;
        this.mValidateEnabled = validateEnabled;
    }

    protected abstract DataSet<I, F> createSet(String var1);

    protected abstract F createFileAndItemsFromXml(File var1, Node var2) throws MergingException;

    protected abstract void readSourceFolder(File var1, ILogger var2) throws MergingException;

    protected abstract F createFileAndItems(File var1, File var2, ILogger var3) throws MergingException;

    public void addSources(Collection<File> files) {
        this.mSourceFiles.addAll(files);
    }

    public void addSource(File file) {
        this.mSourceFiles.add(file);
    }

    @Override
    public List<File> getSourceFiles() {
        return this.mSourceFiles;
    }

    public String getConfigName() {
        return this.mConfigName;
    }

    @Override
    public File findMatchingSourceFile(File file) {
        File matchingSourceFile = null;
        for (File sourceFile : this.mSourceFiles) {
            if (sourceFile.equals(file)) {
                return sourceFile;
            }
            if (!sourceFile.isDirectory()) continue;
            String sourcePath = sourceFile.getAbsolutePath() + File.separator;
            if (!file.getAbsolutePath().startsWith(sourcePath) || matchingSourceFile != null && matchingSourceFile.getAbsolutePath().length() >= sourceFile.getAbsolutePath().length()) continue;
            matchingSourceFile = sourceFile;
        }
        return matchingSourceFile;
    }

    @Override
    public int size() {
        return this.mItems.keySet().size();
    }

    public boolean isEmpty() {
        return this.mItems.isEmpty();
    }

    @Override
    public ListMultimap<String, I> getDataMap() {
        return this.mItems;
    }

    public void loadFromFiles(ILogger logger) throws MergingException {
        ArrayList<Message> errors = new ArrayList<Message>();
        for (File file : this.mSourceFiles) {
            if (file.isDirectory()) {
                try {
                    this.readSourceFolder(file, logger);
                }
                catch (MergingException e) {
                    errors.addAll(e.getMessages());
                }
                continue;
            }
            if (!file.isFile()) continue;
            this.loadFile(file, file, logger);
        }
        MergingException.throwIfNonEmpty(errors);
        this.checkItems();
    }

    public F loadFile(File sourceFolder, File dataFile, ILogger logger) throws MergingException {
        return this.handleNewFile(sourceFolder, dataFile, logger);
    }

    void appendToXml(Node setNode, Document document, MergeConsumer<I> consumer, boolean includeTimestamps) {
        NodeUtils.addAttribute(document, setNode, null, ATTR_CONFIG, this.mConfigName);
        NodeUtils.addAttribute(document, setNode, null, ATTR_IGNORE_PATTERN, this.getAaptStyleIgnoredPattern());
        for (File sourceFile : this.mSourceFiles) {
            Element sourceNode = document.createElement(NODE_SOURCE);
            setNode.appendChild(sourceNode);
            NodeUtils.addAttribute(document, sourceNode, null, ATTR_PATH, sourceFile.getAbsolutePath());
            List dataFiles = this.mSourceFileToDataFilesMap.get((Object)sourceFile);
            block5: for (DataFile dataFile : dataFiles) {
                if (!dataFile.hasNotRemovedItems()) {
                    if (!dataFile.mFile.exists()) continue;
                    this.createFileElement(document, sourceNode, dataFile, includeTimestamps);
                    continue;
                }
                Node fileNode = null;
                switch (dataFile.getType()) {
                    case GENERATED_FILES: 
                    case XML_VALUES: {
                        for (DataItem item : dataFile.getItems()) {
                            Node adoptedNode;
                            if (item.isRemoved() || consumer.ignoreItemInMerge(item)) continue;
                            if (fileNode == null) {
                                fileNode = this.createFileElement(document, sourceNode, dataFile, includeTimestamps);
                            }
                            if ((adoptedNode = item.getDetailsXml(document)) == null) continue;
                            fileNode.appendChild(adoptedNode);
                        }
                        continue block5;
                    }
                    case SINGLE_FILE: {
                        Object dataItem = dataFile.getItem();
                        if (consumer.ignoreItemInMerge((DataItem)dataItem)) continue block5;
                        fileNode = this.createFileElement(document, sourceNode, dataFile, includeTimestamps);
                        NodeUtils.addAttribute(document, fileNode, null, ATTR_NAME, ((DataItem)dataItem).getName());
                        ((DataItem)dataItem).addExtraAttributes(document, fileNode, null);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    private Node createFileElement(Document document, Node sourceNode, F dataFile, boolean includeTimestamps) {
        long timestamp;
        Element fileNode = document.createElement(NODE_FILE);
        sourceNode.appendChild(fileNode);
        NodeUtils.addAttribute(document, fileNode, null, ATTR_PATH, ((DataFile)dataFile).getFile().getAbsolutePath());
        if (includeTimestamps && (timestamp = ((DataFile)dataFile).getFile().lastModified()) != 0L) {
            NodeUtils.addAttribute(document, fileNode, null, ATTR_TIMESTAMP, Long.toString(timestamp));
        }
        ((DataFile)dataFile).addExtraAttributes(document, fileNode, null);
        return fileNode;
    }

    DataSet<I, F> createFromXml(Node dataSetNode) throws MergingException {
        Attr configNameAttr = (Attr)dataSetNode.getAttributes().getNamedItem(ATTR_CONFIG);
        if (configNameAttr == null) {
            return null;
        }
        DataSet<I, F> dataSet = this.createSet(configNameAttr.getValue());
        Attr ignoredPatternAttr = (Attr)dataSetNode.getAttributes().getNamedItem(ATTR_IGNORE_PATTERN);
        if (ignoredPatternAttr != null) {
            dataSet.setIgnoredPatterns(ignoredPatternAttr.getValue());
        }
        NodeList sourceNodes = dataSetNode.getChildNodes();
        int n = sourceNodes.getLength();
        for (int i = 0; i < n; ++i) {
            Attr pathAttr;
            Node sourceNode = sourceNodes.item(i);
            if (sourceNode.getNodeType() != 1 || !NODE_SOURCE.equals(sourceNode.getLocalName()) || (pathAttr = (Attr)sourceNode.getAttributes().getNamedItem(ATTR_PATH)) == null) continue;
            File sourceFolder = new File(pathAttr.getValue());
            dataSet.mSourceFiles.add(sourceFolder);
            NodeList fileNodes = sourceNode.getChildNodes();
            int m = fileNodes.getLength();
            for (int j = 0; j < m; ++j) {
                F dataFile;
                Node fileNode = fileNodes.item(j);
                if (fileNode.getNodeType() != 1 || !NODE_FILE.equals(fileNode.getLocalName()) || (pathAttr = (Attr)fileNode.getAttributes().getNamedItem(ATTR_PATH)) == null) continue;
                File actualFile = new File(pathAttr.getValue());
                Attr timestampAttr = (Attr)fileNode.getAttributes().getNamedItem(ATTR_TIMESTAMP);
                if (timestampAttr != null) {
                    try {
                        long blobDataFileTimestamp = Long.parseLong(timestampAttr.getValue());
                        long actualFileTimestamp = actualFile.lastModified();
                        if (actualFileTimestamp == 0L) continue;
                        if (blobDataFileTimestamp < actualFileTimestamp) {
                        }
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if ((dataFile = this.createFileAndItemsFromXml(actualFile, fileNode)) == null) continue;
                dataSet.processNewDataFile(sourceFolder, dataFile, false);
            }
        }
        return dataSet;
    }

    protected void checkItems() throws DuplicateDataException {
        if (!this.mValidateEnabled) {
            return;
        }
        ArrayList duplicateCollections = new ArrayList();
        for (Map.Entry entry : this.mItems.asMap().entrySet()) {
            Collection items = (Collection)entry.getValue();
            DataItem lastItem = null;
            for (DataItem item : items) {
                if (item.isRemoved()) continue;
                if (lastItem == null) {
                    lastItem = item;
                    continue;
                }
                duplicateCollections.add(items);
            }
        }
        if (!duplicateCollections.isEmpty()) {
            throw new DuplicateDataException(DuplicateDataException.createMessages(duplicateCollections));
        }
    }

    public boolean updateWith(File sourceFolder, File changedFile, FileStatus fileStatus, ILogger logger) throws MergingException {
        switch (fileStatus) {
            case NEW: {
                this.handleNewFile(sourceFolder, changedFile, logger);
                return true;
            }
            case CHANGED: {
                return this.handleChangedFile(sourceFolder, changedFile, logger);
            }
            case REMOVED: {
                return this.handleRemovedFile(changedFile);
            }
        }
        return false;
    }

    protected boolean handleRemovedFile(File removedFile) {
        F dataFile = this.getDataFile(removedFile);
        if (dataFile == null) {
            return false;
        }
        for (DataItem dataItem : ((DataFile)dataFile).getItems()) {
            dataItem.setRemoved();
        }
        return true;
    }

    protected boolean isValidSourceFile(File sourceFolder, File file) {
        return this.checkFileForAndroidRes(file);
    }

    protected F handleNewFile(File sourceFolder, File file, ILogger logger) throws MergingException {
        F dataFile = this.createFileAndItems(sourceFolder, file, logger);
        if (dataFile != null) {
            this.processNewDataFile(sourceFolder, dataFile, true);
        }
        return dataFile;
    }

    protected void processNewDataFile(File sourceFolder, F dataFile, boolean setTouched) throws MergingException {
        Collection dataItems = ((DataFile)dataFile).getItems();
        this.addDataFile(sourceFolder, dataFile);
        for (DataItem dataItem : dataItems) {
            this.mItems.put((Object)dataItem.getKey(), (Object)dataItem);
            if (!setTouched) continue;
            dataItem.setTouched();
        }
    }

    protected boolean handleChangedFile(File sourceFolder, File changedFile, ILogger logger) throws MergingException {
        DataFile dataFile = (DataFile)this.mDataFileMap.get(changedFile);
        for (DataItem item : dataFile.getItems()) {
            item.setTouched();
        }
        return true;
    }

    protected void addItem(I item, String key) throws MergingException {
        if (key == null) {
            key = ((DataItem)item).getKey();
        }
        this.mItems.put((Object)key, item);
    }

    protected F getDataFile(File file) {
        return (F)((DataFile)this.mDataFileMap.get(file));
    }

    void addDataFile(File sourceFile, F dataFile) {
        this.mSourceFileToDataFilesMap.put((Object)sourceFile, dataFile);
        this.mDataFileMap.put(((DataFile)dataFile).getFile(), dataFile);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).addValue((Object)this.mConfigName).add("sources", (Object)Arrays.toString(this.mSourceFiles.toArray())).toString();
    }

    protected boolean checkFileForAndroidRes(File file) {
        return !this.isIgnored(file);
    }

    public void setIgnoredPatterns(String aaptStylePattern) {
        this.sIgnoredPatterns = Splitter.on((char)':').splitToList((CharSequence)aaptStylePattern);
    }

    private String getAaptStyleIgnoredPattern() {
        return Joiner.on((char)':').join(this.sIgnoredPatterns);
    }

    public boolean isIgnored(File file) {
        String path = file.getPath();
        if (path.equals(".") || path.equals("..")) {
            return true;
        }
        boolean ignore = false;
        boolean isDirectory = file.isDirectory();
        int nameIndex = path.lastIndexOf(File.separatorChar) + 1;
        int nameLength = path.length() - nameIndex;
        for (String token : this.sIgnoredPatterns) {
            if (token.isEmpty()) continue;
            int tokenIndex = 0;
            if (token.charAt(tokenIndex) == '!') {
                ++tokenIndex;
            }
            if (token.regionMatches(tokenIndex, "<dir>", 0, 5)) {
                if (!isDirectory) continue;
                tokenIndex += 5;
            }
            if (token.regionMatches(tokenIndex, "<file>", 0, 6)) {
                if (isDirectory) continue;
                tokenIndex += 6;
            }
            int n = token.length() - tokenIndex;
            if (token.charAt(tokenIndex) == '*') {
                ++tokenIndex;
                if (--n <= nameLength) {
                    ignore = token.regionMatches(true, tokenIndex, path, nameIndex + nameLength - n, n);
                }
            } else if (n > 1 && token.charAt(token.length() - 1) == '*') {
                ignore = token.regionMatches(true, tokenIndex, path, nameIndex, n - 1);
            } else {
                boolean bl = ignore = token.length() - tokenIndex == path.length() - nameIndex && token.regionMatches(true, tokenIndex, path, nameIndex, path.length() - nameIndex);
            }
            if (!ignore) continue;
            break;
        }
        return ignore;
    }

    protected boolean getValidateEnabled() {
        return this.mValidateEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSet dataSet = (DataSet)o;
        return this.mValidateEnabled == dataSet.mValidateEnabled && Objects.equals(this.mConfigName, dataSet.mConfigName) && Objects.equals(this.mSourceFiles, dataSet.mSourceFiles) && Objects.equals(this.mItems, dataSet.mItems) && Objects.equals(this.mSourceFileToDataFilesMap, dataSet.mSourceFileToDataFilesMap) && Objects.equals(this.mDataFileMap, dataSet.mDataFileMap) && Objects.equals(this.sIgnoredPatterns, dataSet.sIgnoredPatterns);
    }

    public int hashCode() {
        return Objects.hash(this.mConfigName, this.mValidateEnabled, this.mSourceFiles, this.mItems, this.mSourceFileToDataFilesMap, this.mDataFileMap, this.sIgnoredPatterns);
    }
}

